<?php
// Version: 2.0; index

global $forum_copyright;

// Locale (strftime, pspell_new) and spelling.
// For more information see:
//   - https://www.php.net/function.pspell-new
//   - https://www.php.net/function.setlocale
$txt['lang_locale'] = 'UTC+8';
$txt['lang_dictionary'] = 'CN';
$txt['lang_spelling'] = 'chinese';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set and right to left?
$txt['lang_rtl'] = false;
// Capitalize day and month names?
$txt['lang_capitalize_dates'] = true;
// Number format.
$txt['number_format'] = '1,234.00';

$txt['sunday'] = '星期日';
$txt['monday'] = '星期一';
$txt['tuesday'] = '星期二';
$txt['wednesday'] = '星期三';
$txt['thursday'] = '星期四';
$txt['friday'] = '星期五';
$txt['saturday'] = '星期六';

$txt['sunday_short'] = '周日';
$txt['monday_short'] = '周一';
$txt['tuesday_short'] = '周二';
$txt['wednesday_short'] = '周三';
$txt['thursday_short'] = '周四';
$txt['friday_short'] = '周五';
$txt['saturday_short'] = '周六';

$txt['january'] = '一月';
$txt['february'] = '二月';
$txt['march'] = '三月';
$txt['april'] = '四月';
$txt['may'] = '五月';
$txt['june'] = '六月';
$txt['july'] = '七月';
$txt['august'] = '八月';
$txt['september'] = '九月';
$txt['october'] = '十月';
$txt['november'] = '十一月';
$txt['december'] = '十二月';

$txt['january_titles'] = '1月';
$txt['february_titles'] = '2月';
$txt['march_titles'] = '3月';
$txt['april_titles'] = '4月';
$txt['may_titles'] = '5月';
$txt['june_titles'] = '6月';
$txt['july_titles'] = '7月';
$txt['august_titles'] = '8月';
$txt['september_titles'] = '9月';
$txt['october_titles'] = '10月';
$txt['november_titles'] = '11月';
$txt['december_titles'] = '12月';

$txt['january_short'] = '1';
$txt['february_short'] = '2';
$txt['march_short'] = '3';
$txt['april_short'] = '4';
$txt['may_short'] = '5';
$txt['june_short'] = '6';
$txt['july_short'] = '7';
$txt['august_short'] = '8';
$txt['september_short'] = '9';
$txt['october_short'] = '10';
$txt['november_short'] = '11';
$txt['december_short'] = '12';

$txt['time_am'] = '上午';
$txt['time_pm'] = '下午';

// Let's get all the main menu strings in one place.
$txt['main_menu'] = 'Main Menu';
$txt['home'] = '首页';
$txt['community'] = '社区';
$txt['forum'] = '论坛';

// Sub menu labels
$txt['help'] = '帮助';
$txt['search'] = '搜索';
$txt['calendar'] = '日历';
$txt['members'] = '成员';
$txt['recent_posts'] = '最新文章';
$txt['recent_topics'] = '最近的话题';

$txt['admin'] = '管理员';
// Sub menu labels
$txt['errlog'] = '错误日志';
$txt['package'] = 'Add-on Manager';
$txt['edit_permissions'] = '权限';
$txt['modSettings_title'] = '功能和选项';
$txt['pwa_label'] = 'Web Application';

$txt['moderate'] = '审核';
// Sub menu labels
$txt['modlog_view'] = '审核日志';
$txt['mc_emailerror'] = '未审核的邮件';
$txt['mc_reported_posts'] = '举报';
$txt['mc_reported_pms'] = '举报人信息';
$txt['mc_unapproved_attachments'] = '未审核的附件';
$txt['mc_unapproved_poststopics'] = '未审核的帖子和话题';

$txt['pm_short'] = '我的消息';
// Sub menu labels
$txt['pm_menu_read'] = '查看消息';
$txt['pm_menu_send'] = '发送消息';

$txt['account_short'] = '我的账户';
// Sub menu labels
$txt['profile'] = '简介';
$txt['mydrafts'] = '我的草稿';
$txt['summary'] = '摘要';
$txt['theme'] = '外观和布局';
$txt['account'] = '账户设置';
$txt['forumprofile'] = '个人简介';

$txt['view_unread_category'] = '新的帖子';
$txt['view_replies_category'] = '新的回复';

$txt['login'] = '登录';
$txt['register'] = '注册';
$txt['logout'] = '退出';
// End main menu strings.

$txt['save'] = '保存';

$txt['modify'] = '修改';
$txt['forum_index'] = '%1$s - 首页';
$txt['board_name'] = '版块名称';
$txt['posts'] = '帖子';

$txt['member_postcount'] = '帖子';
$txt['no_subject'] = '(无主题)';
$txt['view_profile'] = '查看资料';
$txt['guest_title'] = '访客';
$txt['author'] = '作者';
$txt['on'] = '于';
$txt['remove'] = '移除';
$txt['start_new_topic'] = '创建话题';

// Use numeric entities in the below string.
$txt['username'] = '用户名';
$txt['password'] = '密码';

$txt['username_no_exist'] = '用户名不存在。';
$txt['no_user_with_email'] = '没有与电子邮件相关的用户名。';

$txt['board_moderator'] = '版主';
$txt['remove_topic'] = '移除';
$txt['topics'] = '话题';
$txt['modify_msg'] = '修改信息';
$txt['name'] = '名字';
$txt['email'] = '邮箱';
$txt['user_email_address'] = '邮箱地址';
$txt['subject'] = '主题';
$txt['message'] = '信息';
$txt['redirects'] = '重定向';

$txt['choose_pass'] = '输入密码';
$txt['verify_pass'] = '验证密码';
$txt['position'] = '会员组';
$txt['notify_announcements'] = '通过电子邮件接收重要的网站新闻';

$txt['profile_of'] = '查看个人资料';
$txt['total'] = '全部';
$txt['posts_made'] = '帖子';
$txt['topics_made'] = '话题';
$txt['website'] = '网站';
$txt['contact'] = '联系我们';
$txt['warning_status'] = '警告状态';
$txt['user_warn_watch'] = '版主监控的用户';
$txt['user_warn_moderate'] = '用户帖子加入批准队列';
$txt['user_warn_mute'] = '用户被禁止发帖';
$txt['warn_watch'] = '监控';
$txt['warn_moderate'] = '管理';
$txt['warn_mute'] = '不理';
$txt['warning_issue'] = '警告';

$txt['message_index'] = '返回版块首页';
$txt['news'] = '消息';
$txt['page'] = '页面';
$txt['prev'] = '上一个';
$txt['next'] = '下一个';

$txt['post'] = '发帖';
$txt['error_occurred'] = '发生错误';
$txt['send_error_occurred'] = 'An error has occurred, <a href="{href}">please click here to try again</a>.';
$txt['require_field'] = '必填字段。';
$txt['started_by'] = '作者';
$txt['topic_started_by'] = '作者是%1$s';
$txt['topic_started_by_in'] = '作者%1$s在%2$s发布';
$txt['replies'] = '回复';
$txt['last_post'] = '最新文章';
$txt['first_post'] = '首篇文章';
$txt['last_poster'] = '最新更新作者';

$txt['last_post_message'] = '<span class="lastpost_link">%2$s</span><span class="board_lastposter">by%1$s</span><span class="board_lasttime"><strong>最新文章: </strong>%3$s</span>';
$txt['boardindex_total_posts'] = '%1$s个帖子%2$s个主题由%3$s个用户创建';
$txt['show'] = '显示';
$txt['hide'] = '隐藏';
$txt['sort_by'] = '排序';
$txt['sort_asc'] = '升序';
$txt['sort_desc'] = '降序';

$txt['admin_login'] = '管理登录';
// Use numeric entities in the below string.
$txt['topic'] = '话题';
$txt['help'] = '帮助';
$txt['notify'] = '通知';
$txt['unnotify'] = '不通知';
$txt['notify_request'] = '如果有人回复此话题，你需要邮件通知吗？';
// Use numeric entities in the below string.
$txt['regards_team'] = "Regards,\nThe {forum_name_html_unsafe} Team.";
$txt['notify_replies'] = '通知回复';
$txt['move_topic'] = '移动';
$txt['move_to'] = '移动到';
$txt['pages'] = '页面';
$txt['users_active'] = '过去%1$d分钟内在线的会员';
$txt['personal_messages'] = '个人消息';
$txt['reply_quote'] = '引用回复';
$txt['reply'] = '回复';
$txt['reply_number'] = '回复 #%1$s';
$txt['approve'] = '审核';
$txt['unapprove'] = '撤销';
$txt['approve_all'] = '审核所有';
$txt['awaiting_approval'] = '等待审核';
$txt['attach_awaiting_approve'] = '附件等待审核';
$txt['post_awaiting_approval'] = '注意：此信息正等待版主审核。';
$txt['there_are_unapproved_topics'] = 'There are %1$s topics and %2$s posts awaiting approval in this board. <a href="%3$s">Click here to view them</a>.';
$txt['send_message'] = '发送信息';

$txt['msg_alert_no_messages'] = '你没有任何信息';
$txt['msg_alert_one_message'] = 'you have <a href="%1$s">1 message</a>';
$txt['msg_alert_many_message'] = 'you have <a href="%1$s">%2$d messages</a>';
$txt['msg_alert_one_new'] = '1 条新的';
$txt['msg_alert_many_new'] = '%1$d 条新的';
$txt['remove_message'] = '删除此信息';

$txt['topic_alert_none'] = '没有信息...';
$txt['pm_alert_none'] = '没有信息...';

$txt['online_users'] = '用户在线'; //Deprecated
$txt['online_now'] = '在线';
$txt['personal_message'] = '个人消息';
$txt['jump_to'] = '跳转到';
$txt['go'] = 'Go';
$txt['are_sure_remove_topic'] = '你确定要删除此主题吗？';
$txt['yes'] = '是';
$txt['no'] = '否';

// @todo this string seems a good candidate for deprecation
$txt['search_on'] = '于';

$txt['search'] = '搜索';
$txt['all'] = '全部';
$txt['search_entireforum'] = '整个论坛';
$txt['search_thisbrd'] = '该版块';
$txt['search_thistopic'] = '此话题';
$txt['search_members'] = '成员';

$txt['back'] = '返回';
$txt['continue'] = '继续';
$txt['password_reminder'] = '密码提示';
$txt['topic_started'] = '主题发帖人为';
$txt['title'] = '标题';
$txt['post_by'] = '作者';
$txt['welcome_newest_member'] = '欢迎新成员 %1$s.';
$txt['admin_center'] = '管理中心';
$txt['admin_session_active'] = '你有一个活跃的管理会话，当你完成管理任务后请  <strong><a class="strong" href="%1$s">结束会话</a></strong> .';
$txt['admin_maintenance_active'] = '论坛目前处于维护状态，只有管理员可以登录，当你完成管理任务后记得 <strong><a class="strong" href="%1$s">退出维护</a></strong> ';
$txt['query_command_denied'] = '发生以下MySQL错误，请检查你的设置：';
$txt['query_command_denied_guests'] = '似乎除了什么问题， 请稍后再试。 如果您继续看到此信息，请向管理员反馈以下信息：';
$txt['query_command_denied_guests_msg'] = '数据库拒绝此命令 %1$s ';
$txt['last_edit_by'] = '<span class="lastedit">最后编辑</span>: %1$s 由 %2$s';
$txt['notify_deactivate'] = '你要停用此话题的通知吗？';

$txt['date_registered'] = '注册日期';
$txt['date_joined'] = 'Joined';
$txt['date_joined_format'] = '%b %d, %Y';
$txt['last_seen'] = 'Last Seen';

$txt['recent_view'] = '查看最近所有的帖子。';
$txt['is_recent_updated'] = '%1$s 是最近更新的话题';

$txt['male'] = '男';
$txt['female'] = '女';

$txt['error_invalid_characters_username'] = '用户名中使用的字符无效。';

$txt['welcome_guest'] = 'Welcome, <strong>Guest</strong>. Please <a href="{login_url}" rel="nofollow">login</a>.';
$txt['welcome_guest_register'] = 'Welcome to <strong>{forum_name}</strong>. Please <a href="{login_url}" rel="nofollow">login</a> or <a href="{register_url}" rel="nofollow">register</a>.';
$txt['welcome_guest_activate'] = '<br />Did you miss your <a href="{activate_url}" rel="nofollow">activation email</a>?';
$txt['welcome_register'] = 'Don\'t have an account?';

// @todo the following to sprintf
$txt['hello_member'] = '嘿，';
// Use numeric entities in the below string.
$txt['hello_guest'] = '欢迎，';
$txt['select_destination'] = '请选择一个目的地';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = '发布 由';

$txt['icon_smiley'] = '微笑';
$txt['icon_angry'] = '生气';
$txt['icon_cheesy'] = '偷笑';
$txt['icon_laugh'] = '大笑';
$txt['icon_sad'] = '悲伤';
$txt['icon_wink'] = '眨眼';
$txt['icon_grin'] = '奸笑';
$txt['icon_shocked'] = '惊讶';
$txt['icon_cool'] = '酷';
$txt['icon_huh'] = '???';
$txt['icon_rolleyes'] = '转眼';
$txt['icon_tongue'] = '吐舌';
$txt['icon_embarrassed'] = '害羞';
$txt['icon_lips'] = '无话可说';
$txt['icon_undecided'] = '犹豫';
$txt['icon_kiss'] = '飞吻';
$txt['icon_cry'] = '哭泣';
$txt['icon_angel'] = '无辜';

$txt['moderator'] = '版主';
$txt['moderators'] = '版主';

$txt['views'] = '浏览';
$txt['new'] = '新';
$txt['no_redir'] = '重定向%1$s';

$txt['view_all_members'] = '查看全部会员';
$txt['view'] = '浏览';

$txt['viewing_members'] = '查看从%1$s到%2$s的会员';
$txt['of_total_members'] = '总共 %1$s 会员';

$txt['forgot_your_password'] = '忘记密码？';

$txt['date'] = '日期';
// Use numeric entities in the below string.
$txt['from'] = '发件人';
$txt['to'] = '收件人';

$txt['board_topics'] = '主题';
$txt['members_title'] = '会员';
$txt['members_list'] = '会员列表';
$txt['new_posts'] = '新帖';
$txt['old_posts'] = '没有新帖';
$txt['redirect_board'] = '板块重定向';
$txt['redirect_board_to'] = '重定向到%1$s';

$txt['sendtopic_send'] = '发送';
$txt['report_sent'] = '您的举报已成功发送。';
$txt['topic_sent'] = '您的邮件已成功发送。';

$txt['time_offset'] = '时区设定';
$txt['or'] = '或';

$txt['mention'] = '提到我的';
$txt['notifications'] = '通知';
$txt['unread_notifications'] = '自从上次登录以来你有%1$s条未读通知。';
$txt['new_from_last_notifications'] = '你有%1$s条新通知。';
$txt['forum_notification'] = '来自%1$s的通知。';

$txt['your_ban'] = 'Sorry %1$s, 您无权使用本论坛！';
$txt['your_ban_expires'] = '被禁截至时间到%1$s';
$txt['your_ban_expires_never'] = '永久禁止';
$txt['ban_continue_browse'] = '你可以继续以访客身份浏览论坛。';

$txt['mark_as_read'] = '标记所有消息为已读';
$txt['mark_as_read_confirm'] = '您确定要将所有消息标记为已读吗？';
$txt['mark_these_as_read'] = '标记这些消息为已读';
$txt['mark_these_as_read_confirm'] = '您确定要将这些消息标记为已读吗？';

$txt['locked_topic'] = '锁定主题';
$txt['normal_topic'] = '正常主题';
$txt['participation_caption'] = '你的主题已发布到';

$txt['print'] = '打印';
$txt['topic_summary'] = '主题摘要';
$txt['not_applicable'] = 'N/A';
$txt['name_in_use'] = '该用户名%1$s已被其他会员使用。';

$txt['total_members'] = '全部会员';
$txt['total_posts'] = '全部帖子';
$txt['total_topics'] = '全部主题';

$txt['mins_logged_in'] = '保持登录的时间';

$txt['preview'] = '预览';
$txt['always_logged_in'] = '始终保持登录';

$txt['logged'] = '已记录';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';

$txt['www'] = 'WWW';
$txt['link'] = 'Link';

$txt['by'] = 'by'; //Deprecated

$txt['hours'] = '小时';
$txt['minutes'] = '分钟';
$txt['seconds'] = '秒';

// Used upper case in Paid subscriptions management
$txt['hour'] = '小时';
$txt['days_word'] = '天';

$txt['newest_member'] = ',我们的新成员。'; //Deprecated

$txt['search_for'] = '搜索';
$txt['search_match'] = '匹配';

$txt['maintain_mode_on'] = '请记住，论坛处于“维护模式”。';

$txt['read'] = '阅读'; //Deprecated
$txt['times'] = '次'; //Deprecated
$txt['read_one_time'] = '阅读1次';
$txt['read_many_times'] = '阅读%1$d次';

$txt['forum_stats'] = '论坛统计';
$txt['latest_member'] = '最新成员';
$txt['total_cats'] = '全部类别';
$txt['latest_post'] = '最新帖子';

$txt['here'] = '此';
$txt['you_have_no_msg'] = '你没有任何信息…';
$txt['you_have_one_msg'] = 'You\'ve 1 message...<a href="%1$s">Click here to view it</a>';
$txt['you_have_many_msgs'] = '你有%2$d条信息...<a href="%1$s">点击这里查看</a>';

$txt['total_boards'] = '全部版块';

$txt['print_page'] = '打印页面';
$txt['print_page_text'] = '仅文字';
$txt['print_page_images'] = '文字与图片';

$txt['valid_email'] = '必须是有效的邮件地址。';

$txt['info_center_title'] = '%1$s - 信息中心';

$txt['send_topic'] = '分享';
$txt['unwatch'] = '无视';
$txt['watch'] = '关注';

$txt['allow_user_email'] = '允许用户给我发邮件';

$txt['check_all'] = '全选';

// Use numeric entities in the below string.
$txt['database_error'] = '数据库错误';
$txt['try_again'] = '请再试一次。如果再次出现错误,请向管理员反馈。';
$txt['file'] = '文件';
$txt['line'] = '行';

// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'ElkArte论坛系统已在数据库中发现错误, 并且修正完毕. 如果这个问题持续发生, 请联络您的主机系统管理员.';
$txt['database_error_versions'] = '<strong>注意:</strong>你的数据库版本是%1$s。';
$txt['template_parse_error'] = '主题模板执行错误!';
$txt['template_parse_error_message'] = 'It seems something has gone sour on the forum with the template system.  This problem should only be temporary, so please come back later and try again.  If you continue to see this message, please contact the administrator.<br /><br />You can also try <a href="javascript:location.reload();">refreshing this page</a>.';
$txt['template_parse_error_details'] = 'There was a problem loading the <span class="tt"><strong>%1$s</strong></span> template or language file.  Please check the syntax and try again - remember, single quotes (<span class="tt">\'</span>) often have to be escaped with a backslash (<span class="tt">\\</span>).  To see more specific error information from PHP, try <a href="%2$s%1$s">accessing the file directly</a>.<br /><br />You may want to try to <a href="javascript:location.reload();">refresh this page</a> or <a href="%3$s">use the default theme</a>.';
$txt['template_parse_undefined'] = '执行该主题风格时出现一个不明错误';

$txt['today'] = '今天%1$s';
$txt['yesterday'] = '昨天%1$s';

// Relative times
$txt['rt_now'] = '刚刚';
$txt['rt_minute'] = '1分钟前';
$txt['rt_minutes'] = '%s分钟前';
$txt['rt_hour'] = '1小时前';
$txt['rt_hours'] = '%s小时前';
$txt['rt_day'] = '1天前';
$txt['rt_days'] = '%s天前';
$txt['rt_week'] = '1周前';
$txt['rt_weeks'] = '%s周前';
$txt['rt_month'] = '1月前';
$txt['rt_months'] = '%s月前';
$txt['rt_year'] = '1年前';
$txt['rt_years'] = '%s年前';

$txt['new_poll'] = '新的投票';
$txt['poll_question'] = '问题';
$txt['poll_question_options'] = '问题选项';
$txt['poll_vote'] = '提交投票';
$txt['poll_total_voters'] = '投票总数';
$txt['draft_saved_on'] = '最新保存草稿';
$txt['poll_results'] = '查看结果';
$txt['poll_lock'] = '锁定投票';
$txt['poll_unlock'] = '解锁投票';
$txt['poll_edit'] = '编辑投票';
$txt['poll'] = '投票';
$txt['one_day'] = '1天';
$txt['one_week'] = '1周';
$txt['two_weeks'] = '2周';
$txt['one_month'] = '1个月';
$txt['two_months'] = '2个月';
$txt['forever'] = '永久';
$txt['quick_login_dec'] = '输入帐号、密码和预计在线时间';
$txt['one_hour'] = '1小时';
$txt['moved'] = '移动';
$txt['moved_why'] = '请输入为何您移动这篇主题的原因.';
$txt['board'] = '版块';
$txt['in'] = '在';
$txt['sticky_topic'] = '置顶话题';
$txt['split'] = '拆分';

$txt['delete'] = '删除';

$txt['byte'] = 'B';
$txt['kilobyte'] = 'KB';
$txt['megabyte'] = 'MB';
$txt['gigabyte'] = 'GB';

$txt['more_stats'] = '[详细统计资料]';

$txt['code'] = '代码';
$txt['code_select'] = '[选择]';
$txt['quote_from'] = '引自';
$txt['quote'] = '引用';
$txt['quick_quote'] = 'Quote Selected';
$txt['quote_new'] = '新主题';
$txt['follow_ups'] = 'Follow-ups';
$txt['topic_derived_from'] = '主题源自%1$s';
$txt['edit'] = '编辑';
$txt['quick_edit'] = '快速编辑';
$txt['post_options'] = 'More Options';
$txt['quote_expand'] = 'Show Quote';

$txt['set_sticky'] = '置顶';
$txt['set_nonsticky'] = '取消置顶';
$txt['set_lock'] = '锁定';
$txt['set_unlock'] = ' 解锁';

$txt['search_advanced'] = '显示高级选项';
$txt['search_simple'] = '隐藏高级选项';

$txt['security_risk'] = '重大安全隐患：';
$txt['not_removed'] = '您还没有删除 %1$s';
$txt['not_removed_extra'] = '%1$s is a backup of %2$s that was not generated by ElkArte. It can be accessed directly and used to gain unauthorised access to your forum. You should delete it immediately.';
$txt['generic_warning'] = '警告';
$txt['agreement_missing'] = 'You are requiring new users to accept a registration agreement, however the file (in sources/ElkArte/Languages/Agreement/) doesn\'t exist.';
$txt['agreement_accepted'] = '您刚刚接受了协议。';
$txt['privacypolicy_accepted'] = 'You have just accepted the forum privacy policy.';

$txt['new_version_updates'] = '你刚刚更新！';
$txt['new_version_updates_text'] = '<a href="{admin_url};area=credits#latest_updates">Click here to see what\'s new in this version of ElkArte!</a>!';

$txt['cache_writable'] = '缓存目录不可写-这会影响你的论坛的性能。';

$txt['page_created_full'] = 'Page created in %1$.3f seconds with %2$d queries.';

$txt['report_to_mod_func'] = 'Use this function to inform the moderators and administrators of an abusive or wrongly posted message.';

$txt['online'] = '在线';
$txt['member_is_online'] = '%1$s 在线';
$txt['offline'] = '离线';
$txt['member_is_offline'] = '%1$s 离线';
$txt['pm_online'] = '个人消息 ( 在线 )';
$txt['pm_offline'] = '个人消息 ( 离线 )';
$txt['status'] = '状态';

$txt['skip_nav'] = '返回主页内容';
$txt['go_up'] = '向上';
$txt['go_down'] = '向下';

$forum_copyright = '<a href="https://www.elkarte.net" title="ElkArte Forum" target="_blank" class="new_win">Powered by %1$s</a> | <a href="{credits_url}" title="Credits" target="_blank" class="new_win" rel="nofollow">Credits</a>';

$txt['birthdays'] = '生日：';
$txt['events'] = '活动：';
$txt['birthdays_upcoming'] = '近期生日：';
$txt['events_upcoming'] = '近期活动：';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = '假期：';
$txt['calendar_month'] = '月：';
$txt['calendar_year'] = '年：';
$txt['calendar_day'] = '天：';
$txt['calendar_event_title'] = '活动标题';
$txt['calendar_event_options'] = '活动方案';
$txt['calendar_post_in'] = '发布在：';
$txt['calendar_edit'] = '编辑活动';
$txt['event_delete_confirm'] = '删除此活动？';
$txt['event_delete'] = '删除活动';
$txt['calendar_post_event'] = '发表活动';
$txt['calendar'] = '日历';
$txt['calendar_link'] = '链接到日程';
$txt['calendar_upcoming'] = '即将开始的日程';
$txt['calendar_today'] = '今天的日程';
$txt['calendar_week'] = '周';
$txt['calendar_week_title'] = 'Week %1$d of %2$d';
$txt['calendar_numb_days'] = '天数：';
$txt['calendar_how_edit'] = '你如何编辑这些活动？';
$txt['calendar_link_event'] = 'Link Event To Post:';
$txt['calendar_confirm_delete'] = '你确定要删除此活动吗？';
$txt['calendar_linked_events'] = 'Linked Events';
$txt['calendar_click_all'] = '点击查看所有 %1$s';

$txt['moveTopic1'] = '发布定向话题';
$txt['moveTopic2'] = '改变话题的主题';
$txt['moveTopic3'] = '新主题';
$txt['moveTopic4'] = '更改所有信息的主题';
$txt['move_topic_unapproved_js'] = 'Warning! This topic has not yet been approved.\\n\\nIt is not recommended that you create a redirection topic unless you intend to approve the post immediately following the move.';
$txt['movetopic_auto_board'] = '[版块]';
$txt['movetopic_auto_topic'] = '[话题链接]';
$txt['movetopic_default'] = 'This topic has been moved to [BOARD] - [TOPIC LINK]';
$txt['movetopic_redirect'] = '重定向到移动的话题';
$txt['movetopic_expires'] = '自动删除重定向主题';

$txt['merge_to_topic_id'] = '目标话题的ID';
$txt['split_topic'] = '拆分';
$txt['merge'] = '合并';
$txt['subject_new_topic'] = '新话题的主题';
$txt['split_this_post'] = '只拆分这个帖子。';
$txt['split_after_and_this_post'] = '拆分话题包括帖子。';
$txt['select_split_posts'] = '选中帖子拆分。';

$txt['splittopic_notification'] = '拆分话题时发送信息';
$txt['splittopic_default'] = 'One or more of the messages of this topic have been moved to [BOARD] - [TOPIC LINK]';
$txt['splittopic_move'] = '将新话题移动到其他版块';

$txt['new_topic'] = '新话题';
$txt['split_successful'] = '话题成功分为2个主题。';
$txt['origin_topic'] = '源话题';
$txt['please_select_split'] = '请选择要拆分的帖子。';
$txt['merge_successful'] = '话题成功合并。';
$txt['new_merged_topic'] = '新合并的话题';
$txt['topic_to_merge'] = '合并的话题';
$txt['target_board'] = '目标版块';
$txt['target_topic'] = '目标主题';
$txt['merge_confirm'] = '你确定要合并';
$txt['with'] = '同';
$txt['merge_desc'] = 'This function will merge the messages of two topics into one topic. The messages will be sorted according to the time of posting. Therefore the earliest posted message will be the first message of the merged topic.';

$txt['theme_template_error'] = '无法加载 \'%1$s\' 的模板。';
$txt['theme_language_error'] = '无法加载 \'%1$s\' 的语言文件。';

$txt['parent_boards'] = '子版块';

$txt['smtp_no_connect'] = '无法连接到SMTP主机';
$txt['smtp_port_ssl'] = 'SMTP port setting incorrect; it should be 465 for SSL servers.';
$txt['smtp_bad_response'] = '无法获取邮件服务器响应代码';
$txt['smtp_error'] = 'Ran into problems sending Mail. Error: ';
$txt['mail_send_unable'] = 'Unable to send mail to the email address \'%1$s\'';

$txt['mlist_search'] = '搜索成员';
$txt['mlist_search_email'] = 'Search by email';
$txt['mlist_search_group'] = '按位置搜索';
$txt['mlist_search_name'] = '按名称搜索';
$txt['mlist_search_website'] = '按网站搜索';
$txt['mlist_search_results'] = '搜索结果';
$txt['mlist_search_by'] = '搜索 %1$s';

$txt['attach_downloaded'] = '下载 %1$d 次';
$txt['attach_viewed'] = '查看 %1$d 次';

$txt['settings'] = '设置';
$txt['never'] = '从不';
$txt['more'] = '更多';

$txt['hostname'] = '主机名称';
$txt['you_are_post_banned'] = '对不起 %1$s,你被禁止在本论坛发布任何信息。';
$txt['ban_reason'] = '原因';

$txt['add_poll'] = '添加投票';
$txt['poll_options6'] = '你只能选择 %1$s 个选项。';
$txt['poll_remove'] = '删除投票';
$txt['poll_remove_warn'] = '你确定要删除这项投票吗？';
$txt['poll_results_expire'] = '投票结束时显示结果';
$txt['poll_expires_on'] = '投票结束';
$txt['poll_expired_on'] = '投票结束';
$txt['poll_change_vote'] = '删除调查';
$txt['poll_return_vote'] = '投票选项';
$txt['poll_cannot_see'] = '此刻你无法看到这项投票的结果。';

$txt['quick_mod_approve'] = '审核选定';
$txt['quick_mod_remove'] = '删除选定';
$txt['quick_mod_lock'] = '锁定/解锁 所选';
$txt['quick_mod_sticky'] = '置顶/取消置顶 所选';
$txt['quick_mod_move'] = '移动所选到';
$txt['quick_mod_merge'] = '合并所选';
$txt['quick_mod_markread'] = '所选标记已读';
$txt['quick_mod_go'] = 'Go';
$txt['quickmod_confirm'] = '你确定要这么做吗？';

$txt['quick_reply'] = '快速回复';
$txt['quick_reply_warning'] = '警告！本主题目前被锁定，只有管理员和版主可以回复。';
$txt['quick_reply_verification'] = '文章提交后，你将被引导到版块主页，以验证您的文章 %1$s。';
$txt['quick_reply_verification_guests'] = '(required for all guests)';
$txt['quick_reply_verification_posts'] = '(required for all users with less than %1$d posts)';
$txt['wait_for_approval'] = 'Note: this post will not display until it\'s been approved by a moderator.';

$txt['notification_enable_board'] = 'Are you sure you wish to enable notification of new topics for this board?';
$txt['notification_disable_board'] = '您确定要禁用此版块新话题的通知吗？';
$txt['notification_enable_topic'] = '您确定要为此话题启用新回复的通知吗？';
$txt['notification_disable_topic'] = '您确定要禁用此主题的新回复通知吗？';

$txt['report_to_mod'] = '举报';
$txt['issue_warning'] = 'Issue a Warning';
$txt['issue_warning_post'] = '由于此消息而发出警告';

$txt['like_post'] = '喜欢';
$txt['unlike_post'] = '不喜欢';
$txt['likes'] = '喜欢';
$txt['liked_by'] = '喜欢：';
$txt['liked_you'] = 'You';
$txt['liked_more'] = '更多';
$txt['likemsg_are_you_sure'] = 'You already liked this message, are you sure you want to remove your like?';

$txt['unread_topics_visit'] = '最近未读的话题';
$txt['unread_topics_visit_none'] = 'No unread topics found since your last visit. <a href="{unread_all_url}" class="linkbutton">Try all unread topics</a>';
$txt['unread_topics_all'] = '所有未读的话题';
$txt['unread_replies'] = '更新话题';

$txt['who_title'] = '谁在线';
$txt['who_and'] = '和';
$txt['who_viewing_topic'] = '正在查看这个话题。';
$txt['who_viewing_board'] = '正在查看此版块。';
$txt['who_member'] = '成员';

// Current footer strings
$txt['valid_html'] = 'Valid HTML 5';
$txt['rss'] = 'RSS聚合内容';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = '访客';
$txt['guests'] = '游客';
$txt['user'] = '会员';
$txt['users'] = '用户';
$txt['hidden'] = '隐藏';
// Plural form of hidden for languages other than English
$txt['hidden_s'] = '隐藏';
$txt['buddy'] = '好友';
$txt['buddies'] = '朋友';
$txt['most_online_ever'] = '最高在线人数';
$txt['most_online_today'] = '今天在线人数';

$txt['merge_select_target_board'] = '选择合并话题的目标版块';
$txt['merge_select_poll'] = '投票选择要合并的话题';
$txt['merge_topic_list'] = '选择要合并的话题';
$txt['merge_select_subject'] = '合并话题选择主题';
$txt['merge_custom_subject'] = '自定义主题';
$txt['merge_enforce_subject'] = '改变所有信息的主题';
$txt['merge_include_notifications'] = '包括通知？';
$txt['merge_check'] = '合并？';
$txt['merge_no_poll'] = '没有投票';

$txt['response_prefix'] = '回复：';
$txt['current_icon'] = '当前图标';
$txt['message_icon'] = '信息图标';

$txt['smileys_current'] = 'Current Smiley Set';
$txt['smileys_none'] = 'No Smileys';
$txt['smileys_forum_board_default'] = '论坛/板块 默认';

$txt['search_results'] = '搜索结果';

$txt['totalTimeLogged2'] = '天,';
$txt['totalTimeLogged3'] = '小时和';
$txt['totalTimeLogged4'] = '分钟';
$txt['totalTimeLogged5'] = '天';
$txt['totalTimeLogged6'] = '时';
$txt['totalTimeLogged7'] = '分';

$txt['approve_thereis'] = 'There is'; //Deprecated
$txt['approve_thereare'] = 'There are'; //Deprecated
$txt['approve_member'] = '1个成员'; //Deprecated
$txt['approve_members'] = '成员'; //Deprecated
$txt['approve_members_waiting'] = '等待审核。'; //Deprecated
$txt['approve_one_member_waiting'] = 'There is <a href="%1$s">one member</a> awaiting approval.';
$txt['approve_many_members_waiting'] = 'There are <a href="%1$s">%2$d members</a> awaiting approval.';

$txt['notifyboard_turnon'] = '当有人在此版块发表新话题时，需要邮件通知？';
$txt['notifyboard_turnoff'] = '你确定此板块有新话题时不需通知？';

$txt['notify_unsubscribed_generic'] = 'specified';
$txt['notify_board_unsubscribed'] = 'The email, %2$s, has been successfully unsubscribed and will no longer be sent notifications from the %1$s board.';
$txt['notify_topic_unsubscribed'] = 'The email, %2$s, has been successfully unsubscribed and will no longer be sent notifications on the %1$s topic.';
$txt['notify_mention_unsubscribed'] = 'The email, %2$s, has been successfully unsubscribed and will no longer be sent "%1$s" notifications.';
$txt['notify_default_unsubscribed'] = 'Your request has been successfully processed.';

$txt['find_members'] = '查找会员';
$txt['find_username'] = '名字、用户名或者邮箱';
$txt['find_buddies'] = '只显示好友？';
$txt['find_wildcards'] = '允许通配符: *, ?';
$txt['find_no_results'] = '未发现';
$txt['all_caught_up'] = 'Your all caught up!';
$txt['find_results'] = '结果';
$txt['find_close'] = '关闭';

$txt['quickmod_delete_selected'] = '删除所选';
$txt['quickmod_split_selected'] = '分离选定';

$txt['show_personal_messages_heading'] = '新信息';
$txt['show_personal_messages'] = 'You have <strong>%1$s</strong> unread personal messages in your inbox.<br /><br /><a href="%2$s">Go to your inbox</a>';

$txt['help_popup'] = '有点疑惑？ 让我来解释：';

$txt['previous_next_back'] = '上一个话题';
$txt['previous_next_forward'] = '下一个话题';

$txt['upshrink_description'] = '缩小或展开标题。';

$txt['mark_unread'] = '标记未读';

$txt['ssi_not_direct'] = '请不要直接通过URL访问SSI.php; 你可能想要使用路径 (%1$s) 或添加 ?ssi_function=something.';
$txt['ssi_session_broken'] = 'SSI.php无法加载会话！这可能会导致注销和其他功能出现问题 - 请确保在*所有*脚本中之前包含SSI.php！';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = '预览帖子';
$txt['preview_fetch'] = '读取预览...';
$txt['pm_error_while_submitting'] = '发送此消息时出现以下错误：';
$txt['warning_while_submitting'] = '发生了一些事，在这里回顾：';
$txt['error_while_submitting'] = '信息有以下错误，必须纠正后再继续：';
$txt['error_old_topic'] = '注意：此话题至少有 %1$d 天未被回帖，<br />除非您确定要回复，否则请考虑发表一个新话题。';

$txt['split_selected_posts'] = '选定的帖子';
$txt['split_selected_posts_desc'] = '下面的帖子将在分割后形成一个新的话题。';
$txt['split_reset_selection'] = '重置选择';

$txt['modify_cancel'] = '撤销';
$txt['mark_read_short'] = '标记阅读';

$txt['hello_member_ndt'] = '您好';

$txt['unapproved_posts'] = '未审核的帖子 (话题: %1$d, Posts: %2$d)';

$txt['ajax_in_progress'] = '载入中...';
$txt['ajax_bad_response'] = '响应无效。';

$txt['mod_reports_waiting'] = 'There are currently %1$d moderator reports open.';
$txt['pm_reports_waiting'] = 'There are currently %1$d personal message reports open.';

$txt['new_posts_in_category'] = '点击查看在 %1$s 的新帖子';
$txt['verification'] = '验证';
$txt['visual_verification_hidden'] = '请保留此框为空';
$txt['visual_verification_description'] = '输入验证码';
$txt['visual_verification_request_new'] = '点击更换';

// @todo Send email strings - should move?
$txt['send_email'] = '发送邮件';
$txt['send_email_disclosed'] = 'Note this will be visible to the recipient.';
$txt['send_email_subject'] = '邮件主题';

$txt['ignoring_user'] = '忽略此用户。';
$txt['show_ignore_user_post'] = '<em>[显示帖子]</em>';

$txt['spider'] = '蜘蛛';
$txt['spiders'] = '蜘蛛';

$txt['downloads'] = '下载';
$txt['filesize'] = '文件大小';

// Restore topic
$txt['restore_topic'] = '还原话题';
$txt['restore_message'] = '还原';
$txt['quick_mod_restore'] = '还原选定';

// Editor prompt.
$txt['prompt_text_email'] = '请输入邮箱地址。';
$txt['prompt_text_ftp'] = '请输入FTP地址';
$txt['prompt_text_url'] = '请输入您要连接的网址';
$txt['prompt_text_img'] = '输入图像位置';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = '删除项目';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = '模板:';
$txt['debug_sub_templates'] = '子模板: ';
$txt['debug_language_files'] = '语言文件：';
$txt['debug_sheets'] = '样式表：';
$txt['debug_javascript'] = '脚本：';
$txt['debug_files_included'] = '文件包括：';
$txt['debug_kb'] = 'KB.';
$txt['debug_show'] = '显示';
$txt['debug_cache_hits'] = '缓存命中:';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s bytes';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss for %2$s bytes';
$txt['debug_queries_used'] = 'Queries used: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Queries used: %1$d, %2$d warnings.';
$txt['debug_query_in_line'] = 'in <em>%1$s</em> line <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'which took %1$s seconds.';
$txt['debug_query_which_took_at'] = 'which took %1$s seconds at %2$s into request.';
$txt['debug_show_queries'] = '[显示查询]';
$txt['debug_hide_queries'] = '[隐藏查询]';
$txt['debug_tokens'] = 'Tokens: ';
$txt['debug_browser'] = '浏览器 ID: ';
$txt['debug_hooks'] = 'Hooks called: ';
$txt['debug_system_type'] = '系统: ';
$txt['debug_server_load'] = '服务器负载:';
$txt['debug_script_mem_load'] = 'Script Memory Usage: ';
$txt['debug_script_cpu_load'] = 'Script CPU Time (user/system): ';

// Video embedding
$txt['preview_image'] = '视频预览图像';
$txt['ctp_video'] = 'Click to play video';
$txt['hide_video'] = '显示/隐藏 视频';
$txt['youtube'] = 'YouTube:';
$txt['vimeo'] = 'Vimeo:';
$txt['dailymotion'] = 'Dailymotion:';
$txt['tiktok'] = 'TikTok:';
$txt['twitter'] = 'X/Twitter:';
$txt['facebook'] = 'Facebook:';
$txt['instagram'] = 'Instagram:';

// Spoiler BBC
$txt['spoiler'] = '遮挡板（点击显示/隐藏）';

$txt['ok_uppercase'] = 'OK';

// Title of box for warnings that admins should see
$txt['admin_warning_title'] = '警告';

$txt['via'] = '通过';

$txt['like_post_stats'] = 'Like stats';

$txt['otp_token'] = 'One-time Password';
$txt['otp_enabled'] = '启用双因素认证';
$txt['invalid_otptoken'] = '基于时间的一次性密码无效';
$txt['otp_used'] = '已使用基于时间的一次性密码。<br /> 请稍等并使用下一个代码。';
$txt['otp_generate'] = '生成';
$txt['otp_show_qr'] = '显示二维码';

$txt['other'] = 'Other';

$txt['offline'] = '离线';
$txt['retry'] = 'RETRY';
$txt['check_connection'] = 'Please check your internet connection';
