<?php
// Version: 2.0; ManageSettings

$txt['modSettings_desc'] = 'This page allows you to change the settings of features and basic options in your forum.  Please see the <a href="%1$s">theme settings</a> for more options.  Click the help icons for more information about a setting.';
$txt['security_settings_desc'] = 'This page allows you to set options specifically related to the security and moderation of your forum, including anti-spam options.';
$txt['modification_settings_desc'] = 'This page contains settings added by any modifications to your forum';

$txt['modification_no_misc_settings'] = 'There are no add-ons installed that have added any settings to this area yet.';

$txt['allow_guestAccess'] = 'Allow guests to browse the forum';
$txt['userLanguage'] = 'Enable user-selectable language support';
$txt['allow_editDisplayName'] = 'Allow users to edit their displayed name';
$txt['allow_hideOnline'] = 'Allow non-administrators to hide their online status';
$txt['titlesEnable'] = 'Enable custom titles';
$txt['enable_buddylist'] = 'Enable buddy/ignore lists';
$txt['default_personal_text'] = 'Default personal text';
$txt['default_personal_text_note'] = 'Personal text to assign to newly registered members.';
$txt['time_format'] = 'Default time format';
$txt['setting_time_offset'] = 'Overall time offset';
$txt['setting_time_offset_note'] = '(added to the member specific option)';
$txt['setting_default_timezone'] = 'Server timezone';
$txt['failed_login_threshold'] = 'Failed login threshold';
$txt['loginHistoryDays'] = 'Days to keep login history';
$txt['lastActive'] = 'User online time threshold';
$txt['trackStats'] = 'Track daily statistics';
$txt['hitStats'] = 'Track daily page views (must have stats enabled)';
$txt['enableCompressedOutput'] = 'Enable compressed output';
$txt['databaseSession_enable'] = 'Use database driven sessions';
$txt['databaseSession_loose'] = 'Allow browsers to go back to cached pages';
$txt['databaseSession_lifetime'] = 'Seconds before an unused session timeout';
$txt['enableErrorLogging'] = 'Enable error logging';
$txt['enableErrorQueryLogging'] = 'Include database query in the error log';
$txt['pruningOptions'] = 'Enable pruning of log entries';
$txt['pruneErrorLog'] = 'Remove error log entries older than';
$txt['pruneModLog'] = 'Remove moderation log entries older than';
$txt['pruneBanLog'] = 'Remove ban hit log entries older than';
$txt['pruneReportLog'] = 'Remove report to moderator log entries older than';
$txt['pruneScheduledTaskLog'] = 'Remove scheduled task log entries older than';
$txt['pruneSpiderHitLog'] = 'Remove search engine hit logs older than';
$txt['cookieTime'] = 'Default login cookies length';
$txt['localCookies'] = 'Enable local storage of cookies';
$txt['localCookies_note'] = '(SSI won\'t work well with this on)';
$txt['globalCookies'] = 'Use subdomain independent cookies';
$txt['globalCookies_note'] = '(turn off local cookies first!)';
$txt['globalCookiesDomain'] = 'Main domain used for subdomain independent cookies';
$txt['globalCookiesDomain_note'] = '(enable subdomain independent cookies first!<br />The domain could be for example: "website.com" or "website.co.uk" without http:// or slashes)';
$txt['invalid_cookie_domain'] = 'The domain introduced seems to be invalid, please check it and save again.';
$txt['secureCookies'] = 'Force cookies to be secure';
$txt['secureCookies_note'] = '(This only applies if you are using HTTPS - don\'t use otherwise!)';
$txt['httponlyCookies'] = 'Force cookies to be made accessible only through the HTTP protocol';
$txt['httponlyCookies_note'] = '(Cookies won\'t be accessible by scripting languages, such as JavaScript. This setting can help to reduce identity theft through XSS attacks.)';
$txt['admin_session_lifetime'] = 'Number of minutes an admin session stays active';
$txt['auto_admin_session'] = 'Automatically start an admin session on logon';
$txt['securityDisable'] = 'Disable administration security';
$txt['securityDisable_moderate'] = 'Disable moderation security';
$txt['enableOTP'] = 'Enable two factor authentication (Time-based One-time Passwords)';
$txt['send_validation_onChange'] = 'Require reactivation after email change';
$txt['approveAccountDeletion'] = 'Require admin approval when member deletes account';
$txt['autoOptMaxOnline'] = 'Maximum users online when optimizing';
$txt['autoFixDatabase'] = 'Automatically fix broken tables';
$txt['allow_disableAnnounce'] = 'Allow users to disable announcements';
$txt['metadata_enabled'] = 'Enable the creation of Open Graph and Schema.org microdata';
$txt['disallow_sendBody'] = 'Don\'t allow post text in notifications';
$txt['jquery_source'] = 'Source for the jQuery Library';
$txt['jquery_local'] = 'Local';
$txt['jquery_cdn'] = 'Google CDN';
$txt['jquery_auto'] = 'Auto';
$txt['minify_css_js'] = 'Minify Javascript and CSS files';
$txt['clean_hives'] = 'Reset Asset Cache';
$txt['clean_hives_success'] = 'CSS and JS hives successfully deleted.';
$txt['clean_hives_failed'] = 'A problem occurred, hives have not been deleted.';
$txt['enable_contactform'] = 'Enable contact form';
$txt['contact_form_disabled'] = 'Vypnout';
$txt['contact_form_registration'] = 'Show only at registration';
$txt['contact_form_menu'] = 'Show in the menu';
$txt['enableReportPM'] = 'Enable reporting of personal messages';
$txt['antispam_PM'] = 'Personal Message Limits';
$txt['max_pm_recipients'] = 'Maximum number of recipients allowed in a personal message';
$txt['max_pm_recipients_note'] = '(0 for no limit, admins are exempt)';
$txt['compactTopicPagesEnable'] = 'Limit number of displayed page links';
$txt['compactTopicPagesContiguous'] = 'Contiguous pages to display';
$txt['to_display'] = 'to display';
$txt['todayMod'] = 'Enable shorthand date display';
$txt['today_disabled'] = 'Vypnout';
$txt['today_only'] = 'Only Today';
$txt['yesterday_today'] = 'Today &amp; Yesterday';
$txt['relative_time'] = 'Relative Time';
$txt['onlineEnable'] = 'Show online/offline in posts and PMs';
$txt['enableVBStyleLogin'] = 'Show a quick login on every page';
$txt['defaultMaxMembers'] = 'Members per page in member list';
$txt['displayMemberNames'] = 'Display the member\'s name instead of "My Account" on the profile account button';
$txt['timeLoadPageEnable'] = 'Display time taken to create every page';
$txt['disableHostnameLookup'] = 'Disable hostname lookups';
$txt['who_enabled'] = 'Enable who\'s online list';
$txt['settings_error'] = 'Warning: Updating of Settings.php failed, the settings cannot be saved.';
$txt['core_settings_saved'] = 'The settings were successfully saved';
$txt['action'] = 'Current Action';

$txt['karmaMode'] = 'Karma mode';
$txt['karma_options'] = 'Disable karma|Enable karma total|Enable karma positive/negative';
$txt['karmaMinPosts'] = 'Set the minimum posts needed to modify karma';
$txt['karmaWaitTime'] = 'Set wait time in hours';
$txt['karmaTimeRestrictAdmins'] = 'Restrict administrators to wait time';
$txt['karmaDisableSmite'] = 'Disable the ability for members to smite';
$txt['karmaLabel'] = 'Karma label';
$txt['karmaApplaudLabel'] = 'Karma applaud label';
$txt['karmaSmiteLabel'] = 'Karma smite label';

$txt['likes_enabled'] = 'Enable Likes';
$txt['likeMinPosts'] = 'Set the minimum number of posts a member needs in order to like a post';
$txt['likeWaitTime'] = 'Set wait time period in minutes';
$txt['likeWaitCount'] = 'Set the maximum number of likes/unlikes the member can do in the above time period';
$txt['likeRestrictAdmins'] = 'Restrict administrators to limits';
$txt['likeAllowSelf'] = 'Allow members to like their own posts';
$txt['likeDisplayLimit'] = 'Set the maximum number of "liked by" names to display in the topic view, 0 for no limit, -1 to disable';

$txt['caching_information'] = 'ElkArte supports caching of user data (such as query results) through the use of accelerators. The currently supported accelerators include: {supported_accelerators}
Caching will work best if you have PHP compiled with one of the above optimizers, or have memcache available. If you do not have any optimizer installed file based caching will be used.';
$txt['detected_accelerators'] = 'The following accelerators have been detected: <strong class="success">%1$s</strong>';

$txt['cache_enable'] = 'Caching Level';
$txt['cache_off'] = 'No caching';
$txt['cache_level1'] = 'Level 1 Caching (Recommended)';
$txt['cache_level2'] = 'Level 2 Caching';
$txt['cache_level3'] = 'Level 3 Caching (Not Recommended)';
$txt['cache_memcached'] = 'Memcached Server(s)';
$txt['cache_memcache'] = 'Memcache Server(s)';
$txt['cache_memcached_servers'] = '<br />Added servers:<ul class="bbc_list"><li>';
$txt['cache_redis'] = 'Redis Server';
$txt['cache_redis_servers'] = '<br />Connected servers:<ul class="bbc_list"><li>';
$txt['cache_accelerator'] = 'Caching Accelerator';
$txt['cache_uid'] = 'Cache Accelerator Userid';
$txt['cache_password'] = 'Cache Accelerator Password';

$txt['loadavg_warning'] = '<span class="error">Please note: the settings below are to be edited with care. Setting any of them too low may render your forum <strong>unusable</strong>! The current load average is <strong>%01.2f</strong></span>';
$txt['loadavg_enable'] = 'Enable load management by load averages';
$txt['loadavg_auto_opt'] = 'Threshold to disabling automatic database optimization';
$txt['loadavg_search'] = 'Threshold to disabling search';
$txt['loadavg_allunread'] = 'Threshold to disabling all unread topics';
$txt['loadavg_unreadreplies'] = 'Threshold to disabling unread replies';
$txt['loadavg_show_posts'] = 'Threshold to disabling showing user posts';
$txt['loadavg_userstats'] = 'Threshold to disabling showing user statistics';
$txt['loadavg_bbc'] = 'Threshold to disabling BBC formatting when showing posts';
$txt['loadavg_forum'] = 'Threshold to disabling the forum <strong>completely</strong>';
$txt['loadavg_disabled_windows'] = '<span class="error">Load management is not available on Windows.</span>';
$txt['loadavg_disabled_conf'] = '<span class="error">Load reporting is disabled by your host configuration.</span>';

$txt['setting_password_strength'] = 'Required strength for user passwords';
$txt['setting_password_strength_low'] = 'Low - 4 character minimum';
$txt['setting_password_strength_medium'] = 'Medium - cannot contain user name';
$txt['setting_password_strength_high'] = 'High - mixture of different characters';
$txt['setting_enable_password_conversion'] = 'Allow password hash conversion';

$txt['antispam_Settings'] = 'Anti-Spam Verification';
$txt['antispam_Settings_desc'] = 'This section allows you to setup verification checks to ensure the user is a human (and not a bot), and tweak how and where these apply.';
$txt['setting_reg_verification'] = 'Require verification on registration page';
$txt['posts_require_captcha'] = 'Post count under which users must pass verification to make a post';
$txt['posts_require_captcha_desc'] = '(0 for no limit, moderators are exempt)';
$txt['search_enable_captcha'] = 'Require verification on all guest searches';
$txt['setting_guests_require_captcha'] = 'Guests must pass verification when making a post';
$txt['setting_guests_require_captcha_desc'] = '(Automatically set if you specify a minimum post count below)';
$txt['guests_report_require_captcha'] = 'Guests must pass verification when reporting a post';

$txt['badbehavior_accept_header'] = 'Require Accept header';
$txt['badbehavior_httpbl_key'] = 'Honey Pot http:BL Access Key';
$txt['badbehavior_httpbl_key_invalid'] = 'The supplied Access Key is not valid';
$txt['badbehavior_httpbl_threat'] = 'Threat Level';
$txt['badbehavior_httpbl_threat_desc'] = '(default 25)';
$txt['badbehavior_httpbl_maxage'] = 'Maximum Age';
$txt['badbehavior_httpbl_maxage_desc'] = '(default 30)';

$txt['configure_emptyfield'] = 'Verification Empty Field';
$txt['configure_emptyfield_desc'] = '<span class="smalltext">Below you can enable the empty field verification method.  This will insert a hidden field that should stay empty which will be used to trick spam bots into erroneously posting information. Although this can be used alone, it\'s best enabled with the CAPTCHA verification.</span>';
$txt['enable_emptyfield'] = 'Enable empty field verification';
$txt['configure_verification_means'] = 'Configure Verification Methods';
$txt['setting_qa_verification_number'] = 'Number of verification questions user must answer';
$txt['setting_qa_verification_number_desc'] = '(0 to disable; questions are set below)';
$txt['configure_verification_means_desc'] = '<span class="smalltext">Below you can set which anti-spam features you wish to have enabled whenever a user needs to verify they are a human. Note that the user will have to pass <em>all</em> verification so if you enable both a verification image and a question/answer test they need to complete both to proceed.</span>';
$txt['setup_verification_questions'] = 'Verification Questions';
$txt['setup_verification_questions_desc'] = '<span class="smalltext">If you want users to answer verification questions in order to stop spam bots you should setup a number of questions in the table below. You should pick relatively simple questions; answers are not case sensitive. You may use BBC in the questions for formatting, to remove a question simply delete the contents of that line.</span>';
$txt['setup_verification_question'] = 'Question';
$txt['setup_verification_answer'] = 'Answer';
$txt['setup_verification_add_more'] = 'Add another question';
$txt['setup_verification_add_more_answers'] = 'Add another answer';

$txt['recaptcha_desc'] = 'To enable ReCAPTHCA on your forum you must create a <a href="https://www.google.com/recaptcha/admin">Google reCaptcha API key pair</a> for your site.';
$txt['recaptcha_enable'] = 'Enable ReCaptcha verification';
$txt['recaptcha_verification'] = 'Verification ReCaptcha';
$txt['recaptcha_site_key'] = 'ReCaptcha Site Key';
$txt['recaptcha_secret_key'] = 'ReCaptcha Secret Key';

$txt['hcaptcha_desc'] = 'To enable hCAPTHCA on your forum you must create a <a href="https://www.hcaptcha.com">hCapthca API key pair</a> for your site.';
$txt['hcaptcha_enable'] = 'Enable hCaptcha verification';
$txt['hcaptcha_verification'] = 'Verification hCaptcha';
$txt['hcaptcha_site_key'] = 'hCaptcha Site Key';
$txt['hcaptcha_secret_key'] = 'hCaptcha Secret Key';

$txt['keycaptcha_desc'] = 'To enable KeyCAPTHCA on your forum you must create a <a href="https://keycaptcha.com">KeyCAPTCHA.com API</a> for your site.';
$txt['keycaptcha_enable'] = 'Enable KeyCaptcha verification';
$txt['keycaptcha_verification'] = 'Verification KeyCaptcha';
$txt['keycaptcha_secret_key'] = 'KeyCaptcha Private key';

$txt['turnstile_desc'] = 'To enable Turnstile on your forum you must create a <a href="https://www.cloudflare.com/products/turnstile/">Turnstile API</a> for your site.';
$txt['turnstile_language'] = 'Enter language code, leave empty to for automatic detection';
$txt['turnstile_language_desc'] = 'Find <a href="https://developers.cloudflare.com/turnstile/reference/supported-languages/">language codes here</a>';
$txt['turnstile_enable'] = 'Enable Turnstile verification';
$txt['turnstile_verification'] = 'Validation Turnstile';
$txt['turnstile_site_key'] = 'Turnstile Site Key';
$txt['turnstile_secret_key'] = 'Turnstile Secret Key';

$txt['moderation_settings'] = 'Moderation Settings';
$txt['setting_warning_enable'] = 'Enable User Warning System';
$txt['warning_enable'] = '<strong>User Warning System</strong><br />This feature enables members of the admin and moderation team to issue warnings to members - and to use a members warning level to determine the actions available to them on the forum. Upon enabling this feature a permission will be available within the permissions section to define which groups may assign warnings to members. Warning levels can be adjusted from a member\'s profile.';
$txt['setting_warning_watch'] = 'Warning level for user watch';
$txt['setting_warning_watch_note'] = 'The user warning level after which a user watch is put in place - 0 to disable.';
$txt['setting_warning_moderate'] = 'Warning level for post moderation';
$txt['setting_warning_moderate_note'] = 'The user warning level after which a user has all posts moderated - 0 to disable.';
$txt['setting_warning_mute'] = 'Warning level for user muting';
$txt['setting_warning_mute_note'] = 'The user warning level after which a user cannot post any further - 0 to disable.';
$txt['setting_user_limit'] = 'Maximum user warning points per day';
$txt['setting_user_limit_note'] = 'This value is the maximum amount of warning points a single moderator can assign to a user in a 24 hour period - 0 for no limit.';
$txt['setting_warning_decrement'] = 'Warning points that are decreased every 24 hours';
$txt['setting_warning_decrement_note'] = 'Only applies to users not warned within last 24 hours - set to 0 to disable.';
$txt['setting_warning_show'] = 'Users who can see warning status';
$txt['setting_warning_show_note'] = 'Determines who can see the warning level of users on the forum.';
$txt['setting_warning_show_mods'] = 'Moderators Only';
$txt['setting_warning_show_user'] = 'Moderators and Warned Users';
$txt['setting_warning_show_all'] = 'All Users';

$txt['signature_settings'] = 'Signature Settings';
$txt['signature_settings_desc'] = 'Use the settings on this page to decide how member signatures should be treated.';
$txt['signature_settings_warning'] = 'Note that settings are not applied to existing signatures by default.<br /><a class="button_submit" href="%1$s">Run the process now</a>';
$txt['signature_settings_applied'] = 'The updated rules have been applied to the existing signatures.';
$txt['signature_enable'] = 'Enable signatures';
$txt['signature_repetition_guests'] = 'Show signatures to guests:';
$txt['signature_repetition_members'] = 'Show signatures to members:';
$txt['signature_always'] = 'Vždy';
$txt['signature_onlyfirst'] = 'Only the first of each member';
$txt['signature_never'] = 'Nikdy';
$txt['signature_max_length'] = 'Maximum allowed characters';
$txt['signature_max_lines'] = 'Maximum amount of lines';
$txt['signature_max_images'] = 'Maximum image count';
$txt['signature_max_images_note'] = '(0 for no max - excludes smileys)';
$txt['signature_allow_smileys'] = 'Allow smileys in signatures';
$txt['signature_max_smileys'] = 'Maximum smiley count';
$txt['signature_max_image_width'] = 'Maximum width of signature images (pixels)';
$txt['signature_max_image_height'] = 'Maximum height of signature images (pixels)';
$txt['signature_max_font_size'] = 'Maximum font size allowed in signatures (pixels)';
$txt['signature_bbc'] = 'Enabled BBC tags';

$txt['pwa_settings'] = 'Web App';
$txt['pwa_settings_desc'] = 'PWA (Progressive Web App) when configured allows your users to install your site as a web app on their device. <a class="linkbutton" href="https://developer.mozilla.org/en-US/docs/Web/Progressive_web_apps">Read More</a>.  When this is enabled it will create a manifest.json file for the site using the below settings.  Note the description will be your site slogan (if any) and name will be your forum name.';
$txt['pwa_enabled'] = 'Enable progressive web app support';
$txt['pwa_disabled'] = 'PWA requires that the server be using SSL (HTTPS)';
$txt['pwa_manifest_enabled'] = 'Enable webmanifest support.';
$txt['pwa_manifest_enabled_desc'] = 'This will provide a "webmanifest" file for your website.  This file is required when PWA is enabled, otherwise it is optional.';
$txt['pwa_short_name'] = 'Short Name';
$txt['pwa_short_name_desc'] = 'The name of the web application displayed to the user when there is not enough space to display the site name (e.g., as a label for an icon on the phone home screen)';
$txt['pwa_description'] = 'App Description';
$txt['pwa_theme_color'] = 'Theme Color';
$txt['pwa_theme_color_desc'] = 'This sets the theme color used for PWA installations, as well as the address bar color on Chrome for Android.';
$txt['pwa_background_color'] = 'Background Color';
$txt['pwa_background_color_desc'] = 'Defines the color that appears in the application window before your app\'s stylesheets have loaded, this should be your background-color CSS property.';
$txt['pwa_small_icon'] = 'Icon URL (192 x 192)';
$txt['pwa_small_icon_desc'] = 'The url to your small application icon image. This should be a 192x192 image, PNG or SVG recommended. See /themes/default/images/logos/icon_pwa_small.png for an example';
$txt['pwa_large_icon'] = 'Icon URL (512 x 512)';
$txt['pwa_large_icon_desc'] = 'The url to your large application icon image. This should be a 512x512 image, PNG or SVG recommended.  See /themes/default/images/logos/icon_pwa_large.png for an example';
$txt['favicon_icon'] = 'Favicon URL';
$txt['favicon_icon_desc'] = 'The URL location to the favicon.<br />The preferred location is your sites base directory to ensure all browsers find the file.  The file should be called favicon.ico.<br />If you choose to use another filename & location, such as mobile.png, be sure you still place a favicon.ico in your sites base directory.';
$txt['apple_touch_icon'] = 'Apple Touch URL';
$txt['apple_touch_icon_desc'] = 'The url to your apple touch icon image. This should be a 180x180 image, PNG or SVG recommended. See /themes/default/images/apple-touch-icon.png for an example';
$txt['other_icons_title'] = 'Additional Icons';

$txt['groups_pm_send'] = 'Member groups allowed to send personal messages';
$txt['pm_posts_verification'] = 'Post count under which users must pass verification when sending personal messages';
$txt['pm_posts_verification_note'] = '(0 for no limit, admins are exempt)';
$txt['pm_posts_per_hour'] = 'Number of personal messages a user may send in an hour';
$txt['pm_posts_per_hour_note'] = '(0 for no limit, moderators are exempt)';

$txt['custom_profile_title'] = 'Custom Profile Fields';
$txt['custom_profile_desc'] = 'From this page you can create your own custom profile fields that fit in with your own forums requirements';
$txt['custom_profile_active'] = 'Active';
$txt['custom_profile_order'] = 'Field Order';
$txt['custom_profile_fieldname'] = 'Field Name';
$txt['custom_profile_fieldtype'] = 'Field Type';
$txt['custom_profile_make_new'] = 'New Field';
$txt['custom_profile_none'] = 'You have not created any custom profile fields yet!';
$txt['custom_profile_icon'] = 'Icon';
$txt['custom_profile_sort'] = 'To change the order of the custom fields, simply drag and drop it to the location you want.';

$txt['custom_profile_type_text'] = 'Text';
$txt['custom_profile_type_url'] = 'URL';
$txt['custom_profile_type_date'] = 'Datum';
$txt['custom_profile_type_email'] = 'E-mail';
$txt['custom_profile_type_color'] = 'Color';
$txt['custom_profile_type_textarea'] = 'Large Text';
$txt['custom_profile_type_select'] = 'Select Box';
$txt['custom_profile_type_radio'] = 'Radio Button';
$txt['custom_profile_type_check'] = 'Checkbox';
$txt['custom_profile_reordered'] = 'Profile fields successfully reordered';

$txt['custom_add_title'] = 'Add Profile Field';
$txt['custom_edit_title'] = 'Edit Profile Field';
$txt['custom_edit_general'] = 'Display Settings';
$txt['custom_edit_input'] = 'Input Settings';
$txt['custom_edit_advanced'] = 'Advanced Settings';
$txt['custom_edit_name'] = 'Jméno';
$txt['custom_edit_desc'] = 'Description';
$txt['custom_edit_profile'] = 'Profile Section';
$txt['custom_edit_profile_desc'] = 'Section of profile this is edited in.';
$txt['custom_edit_profile_none'] = 'None';
$txt['custom_edit_registration'] = 'Show on Registration';
$txt['custom_edit_registration_disable'] = 'Ne';
$txt['custom_edit_registration_allow'] = 'Ano';
$txt['custom_edit_registration_require'] = 'Yes, and require entry';
$txt['custom_edit_display'] = 'Show on Topic View';
$txt['custom_edit_memberlist'] = 'Show on Member List View';
$txt['custom_edit_picktype'] = 'Field Type';

$txt['custom_edit_max_length'] = 'Maximum Length';
$txt['custom_edit_max_length_desc'] = '(Pro žádné omezení nastavte 0)';
$txt['custom_edit_dimension'] = 'Dimensions';
$txt['custom_edit_dimension_row'] = 'Rows';
$txt['custom_edit_dimension_col'] = 'Columns';
$txt['custom_edit_bbc'] = 'Allow BBC';
$txt['custom_edit_options'] = 'Options';
$txt['custom_edit_options_desc'] = 'Leave option box blank to remove. Radio button selects default option.';
$txt['custom_edit_options_more'] = 'Více';
$txt['custom_edit_options_no_default'] = 'Do not set a default value.';
$txt['custom_edit_default'] = 'Default State';
$txt['custom_edit_default_value'] = 'Default Value';
$txt['custom_edit_active'] = 'Active';
$txt['custom_edit_active_desc'] = 'If not selected this field will not be shown to anyone.';
$txt['custom_edit_privacy'] = 'Privacy';
$txt['custom_edit_privacy_desc'] = 'Who can see and edit this field.';
$txt['custom_edit_privacy_all'] = 'Users can see this field; owner can edit it';
$txt['custom_edit_privacy_see'] = 'Users can see this field; only admins can edit it';
$txt['custom_edit_privacy_owner'] = 'Users cannot see this field; owner and admins can edit it';
$txt['custom_edit_privacy_none'] = 'This field is only visible to admins';
$txt['custom_edit_can_search'] = 'Searchable';
$txt['custom_edit_can_search_desc'] = 'Can this field be searched from the members list?';
$txt['custom_edit_mask'] = 'Input Mask';
$txt['custom_edit_mask_desc'] = 'For text fields an input mask can be selected to validate the data.';
$txt['custom_edit_mask_email'] = 'Valid Email';
$txt['custom_edit_mask_number'] = 'Numeric';
$txt['custom_edit_mask_nohtml'] = 'No HTML';
$txt['custom_edit_mask_regex'] = 'Regex (Advanced)';
$txt['custom_edit_enclose'] = 'Wrap user input in text (Optional)';
$txt['custom_edit_enclose_desc'] = 'We <strong>strongly</strong> recommend to use an input mask to validate the input supplied by the user.';

$txt['custom_edit_placement'] = 'Choose Placement';
$txt['custom_edit_placement_standard'] = 'Standard (with title)';
$txt['custom_edit_placement_withicons'] = 'With Icons';
$txt['custom_edit_placement_abovesignature'] = 'Above Signature';
$txt['custom_edit_placement_aboveicons'] = 'Above Icons (no title)';
$txt['custom_profile_placement'] = 'Placement';
$txt['custom_profile_placement_standard'] = 'Standardní';
$txt['custom_profile_placement_withicons'] = 'With Icons';
$txt['custom_profile_placement_abovesignature'] = 'Above Signature';
$txt['custom_profile_placement_aboveicons'] = 'Above Icons';

// Use numeric entities in the string below!
$txt['custom_edit_delete_sure'] = 'Are you sure you wish to delete this field? All related user data will be lost!';

$txt['standard_profile_title'] = 'Standard Profile Fields';
$txt['standard_profile_field'] = 'Pole';

$txt['core_settings_welcome_msg'] = 'Welcome to Your New Forum';
$txt['core_settings_welcome_msg_desc'] = 'To get you started we suggest you select which of ElkArte\'s core features you want to enable. We\'d recommend only enabling those features you actually need.'; // don't scream from the beginning :P
$txt['core_settings_item_cd'] = 'Kalendář';
$txt['core_settings_item_cd_desc'] = 'Enabling this feature will open up a selection of options to enable your users to view the calendar, add and review events, see users birthdays on a calendar and much, much more.';
$txt['core_settings_item_dr'] = 'Koncepty';
$txt['core_settings_item_dr_desc'] = 'Povolení této funkce umožní uživatelům ukládat koncepty svých příspěvků, aby se mohli později vrátit.';
$txt['core_settings_item_cp'] = 'Rozšířená profilová pole';
$txt['core_settings_item_cp_desc'] = 'Zapnutím této funkce získáte možnost skrýt standardní profilová pole, přidat nová profilová pole k registraci nebo vytvořit nová profilová pole pro vaše fórum.';
$txt['core_settings_item_ih'] = 'Integration Hooks Management';
$txt['core_settings_item_ih_desc'] = 'Tato funkce umožňuje povolit nebo zakázat integraci háků a kotev přidaných pomocí dodatků. Změna háků a kotev může zabránit správnému fungování fóra, proto tuto funkci použijte pouze, pokud víte, co děláte.';
$txt['core_settings_item_k'] = 'Karma';
$txt['core_settings_item_k_desc'] = 'Karma je vlastnost, která zobrazuje popularitu člena. Pokud je povoleno, mohou členové hodnotit "kladně" nebo "záporně" ostatní členy, což je následně jejich osobní vizitka.';
$txt['core_settings_item_pe'] = 'Odesílání zpráv pomocí správy e-mailu';
$txt['core_settings_item_pe_desc'] = 'Toto umožní uživatelům vašeho fóra odpovědět na e-maily s upozorněním a osobními zprávami a nechat je poslat přímo jako odpověď na příslušné vlákno nebo PM. Toto poskytuje známý pocit adresáře. Použití této funkce vyžaduje dodatečné kroky instalace u poskytovatele hostingu.';
$txt['core_settings_item_l'] = 'Likes';
$txt['core_settings_item_l_desc'] = 'Likes je funkce, která umožňuje členům, aby si oblíbili určitý příspěvek, nebo aby ukázali svůj souhlas, případně nesouhlas a popularitu daného obsahu.';
$txt['core_settings_item_ml'] = 'Moderation, Administration and User Logs';
$txt['core_settings_item_ml_desc'] = 'Povolte tyto protokoly administrace a moderování, abyste měli přehled o všech klíčových akcích, které jste provedli na vašem fóru. Umožňuje také administrátorům a moderátorům fóra zobrazit historii klíčových změn, které uživatel provedl na svém profilu.';
$txt['core_settings_item_pm'] = 'Moderování příspěvků';
$txt['core_settings_item_pm_desc'] = 'Posouzení moderování umožňuje vybrat skupiny a diskuze, v jejichž rámci musí být příspěvky schváleny dříve, než se stanou veřejnými. Po povolení této funkce nezapomeňte navštívit sekci oprávnění pro nastavení příslušných oprávnění.';
$txt['core_settings_item_ps'] = 'Placené odběry';
$txt['core_settings_item_ps_desc'] = 'Placené odběry umožňují uživatelům platit předplatné pro změnu skupin členů ve fóru, a tím změnit jejich přístupová práva.';
$txt['core_settings_item_rg'] = 'Generování zpráv';
$txt['core_settings_item_rg_desc'] = 'Tato funkce správy umožňuje vytvářet přehledy (které lze vytisknout) a prezentovat aktuální nastavení fóra snadno a přehledně - obzvláště užitečné pro velké fóra.';
$txt['core_settings_item_sp'] = 'Sledování vyhledávačů';
$txt['core_settings_item_sp_desc'] = 'Povolení této funkce umožní administrátorům sledovat vyhledávače při indexování vašeho fóra.';
$txt['core_settings_item_w'] = 'Systém varování';
$txt['core_settings_item_w_desc'] = 'Tento systém umožňuje administrátorům a moderátorům vydávat varování uživatelům a automaticky ruší uživatelská práva, protože jejich úroveň varování se zvyšuje. Chcete-li tento systém plně využít, je třeba povolit funkci "Moderování příspěvků".';
$txt['core_settings_switch_on'] = 'Kliknutím zapnete';
$txt['core_settings_switch_off'] = 'Kliknutím vypnete';
$txt['core_settings_enabled'] = 'Enabled';
$txt['core_settings_disabled'] = 'Vypnout';

$txt['languages_lang_name'] = 'Language Name';
$txt['languages_locale'] = 'Locale';
$txt['languages_default'] = 'Výchozí';
$txt['languages_users'] = 'Uživatelé';
$txt['language_settings_writable'] = 'Warning: Settings.php is not writable so the default language setting cannot be saved.';
$txt['edit_languages'] = 'Upravit jazyk';
$txt['lang_file_not_writable'] = '<strong>Warning:</strong> The primary language file (%1$s) is not writable. You must make this writable before you can make any changes.';
$txt['lang_entries_not_writable'] = '<strong>Warning:</strong> The language file you wish to edit (%1$s) is not writable. You must make this writable before you can make any changes.';
$txt['languages_ltr'] = 'Right to Left';

$txt['add_language'] = 'Přidat jazyk';
$txt['add_language_elk'] = 'Download from ElkArte Languages Repository';
$txt['add_language_elk_browse'] = 'Type name of language to search for or leave blank to search for all.';
$txt['add_language_elk_install'] = 'Install';
$txt['add_language_elk_found'] = 'The following languages were found. Click the install link next to the language you wish to install, you will then be taken to the package manager to install.';
$txt['add_language_error_no_response'] = 'The ElkArte site is not responding. Please try again later.';
$txt['add_language_error_no_files'] = 'No files could be found.';
$txt['add_language_elk_desc'] = 'Description';
$txt['add_language_elk_utf8'] = 'UTF-8';
$txt['add_language_elk_version'] = 'Verze';

$txt['edit_language_entries_primary'] = 'Below are the primary language settings for this language pack.';
$txt['edit_language_entries'] = 'Edit Language Entries';
$txt['edit_language_entries_file'] = 'Select entries to edit';
$txt['languages_dictionary'] = 'Dictionary';
$txt['languages_spelling'] = 'Spelling';
$txt['languages_for_pspell'] = 'This is for <a href="http://www.php.net/function.pspell-new" target="_blank" class="new_win">pSpell</a> - if installed';
$txt['languages_rtl'] = 'Is &quot;Right to Left&quot;';

$txt['lang_file_desc_index'] = 'General Strings';
$txt['lang_file_desc_EmailTemplates'] = 'Email Templates';

$txt['languages_download'] = 'Download Language Pack';
$txt['languages_download_note'] = 'This page lists all the files that are contained within the language pack and some useful information about each one. All files that have their associated check box marked will be copied.';
$txt['languages_download_info'] = '<strong>Note:</strong>
	<ul class="normallist">
		<li>The file status &quot;Not Writable&quot; means the system will not be able to copy this file to the directory at the present and you must make the destination writable either using an FTP client or by filling in your details at the bottom of the page.</li>
		<li>The Version information for a file displays the last forum version which it was updated for. If it is indicated in green then this is a newer version than you have at current, amber indicates it\'s the same version number as at current, red indicates you have a newer version installed than contained in the pack.</li>
		<li>In case a file already exists on your forum, the &quot;Already Exists&quot; column will have one of two values: &quot;Identical&quot; indicates that the file already exists in an identical form and does not need to be overwritten. &quot;Different&quot; means that the contents vary in some way and overwriting is probably the optimum solution.</li>
	</ul>';

$txt['languages_download_main_files'] = 'Primary Files';
$txt['languages_download_theme_files'] = 'Theme-related Files';
$txt['languages_download_filename'] = 'Název souboru';
$txt['languages_download_dest'] = 'Destination';
$txt['languages_download_writable'] = 'Writable';
$txt['languages_download_version'] = 'Verze';
$txt['languages_download_older'] = 'You have a newer version of this file installed, overwriting is not recommended.';
$txt['languages_download_exists'] = 'Already Exists';
$txt['languages_download_exists_same'] = 'Identical';
$txt['languages_download_exists_different'] = 'Different';
$txt['languages_download_copy'] = 'Kopírovat';
$txt['languages_download_not_chmod'] = 'You cannot proceed with the installation until all files selected to be copied are writable.';
$txt['languages_download_illegal_paths'] = 'Package contains illegal paths - please contact ElkArte';
$txt['languages_download_complete'] = 'Installation Complete';
$txt['languages_download_complete_desc'] = 'Language pack installed successfully. Please <a href="%1$s">click here to return to the languages page</a>';
$txt['languages_delete_confirm'] = 'Are you sure you want to delete this language?';

$txt['setting_frame_security'] = 'Frame Security Options';
$txt['setting_frame_security_SAMEORIGIN'] = 'Allow Same Origin';
$txt['setting_frame_security_DENY'] = 'Deny all frames';
$txt['setting_frame_security_DISABLE'] = 'Vypnout';
