<?php
// Version: 2.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
// Additionally do not translate the @additional_params: line or the variable names in the lines that follow it.  You may
// translate the description of the variable.  Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

$txt['scheduled_approval_email_topic'] = 'Følgende emner afventer godkendelse:';
$txt['scheduled_approval_email_msg'] = 'Følgende indlæg afventer godkendelse:';
$txt['scheduled_approval_email_attach'] = 'Følgende vedhæftninger afventer godkendelse:';
$txt['scheduled_approval_email_event'] = 'Følgende begivenheder afventer godkendelse:';

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Velkommen til {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Tak for at registrere dig hos {FORUMNAME}. Dit brugernavn er {USERNAME}. Hvis du glemmer dit kodeord, kan du nulstille det ved at besøge {FORGOTPASSWORDLINK}.

Før du kan logge ind, skal du først aktivere din konto ved at klikke på følgende link:

{ACTIVATIONLINK}

Skulle du opleve problemer med aktiveringen, besøg da {ACTIVATIONLINKWITHOUTCODE} og indskriv koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Velkommen til {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Hej {REALNAME}, din registrering hos {FORUMNAME} er modtaget.

Brugernavnet du registrerede dig som er {USERNAME}.

Før du kan logge ind og starte med at bruge forum, skal din registrering godkendes.  Når dette sker, vil du modtage endnu en email fra denne adresse.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Godkendelse af gruppemedlemsskab';
$txt['mc_group_approve_body'] = '{USERNAME},

vi er glade for at kunne fortælle dig at din ansøgning om optagelse i gruppen "{GROUPNAME}" på {FORUMNAME} er blevet accepteret, og din konto er blevet opdateret til at inkludere denne nye medlemsgruppe.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Gruppemedlemsskab afvisning';
$txt['mc_group_reject_body'] = '{USERNAME},

Vi beklager at måtte meddele dig at din ansøgning om optagelse i gruppen "{GROUPNAME}" på {FORUMNAME} er blevet afvist.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Gruppemedlemsskab afvisning';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

Vi beklager at måtte meddele dig at din ansøgning om optagelse i gruppen "{GROUPNAME}" på {FORUMNAME} er blevet afvist.

Grunden til dette er: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Velkommen, {NAME}

Din konto er blevet aktiveret manuelt af en administrator og du kan nu logge ind og deltage i aktiviteter. Dit brugernavn er: {USERNAME}. Hvis du glemmer dit kodeord, kan du ændre det på følgende link {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Velkommen, {USERNAME}!

Din konto hos {FORUMNAME} er blevet godkendt af en forum administrator. Før du kan logge ind, skal du først aktivere din konto ved at besøge følgende link:

{ACTIVATIONLINK}

Skulle du opleve problemer med aktiveringen, besøg da {ACTIVATIONLINKWITHOUTCODE} og indskriv koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Registrering Afvist';
$txt['admin_approve_reject_body'] = '{USERNAME},

Beklageligvis er din ansøgning om optagelse på {FORUMNAME} blevet afvist.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Konto Slettet';
$txt['admin_approve_delete_body'] = '{USERNAME},

Din konto på {FORUMNAME} er blevet slettet.  Dette kan skyldes at du aldrig aktiverede din konto, i hvilket tilfælde du bør kunne registrere dig igen.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Registrerings Påmindelse';
$txt['admin_approve_remind_body'] = '{USERNAME},
Du har stadig ikke aktivering din konto på {FORUMNAME}.

Besøg følgende link herunder for at aktivere din konto: 
{ACTIVATIONLINK}

Skulle du opleve problemer med aktiveringen, besøg da {ACTIVATIONLINKWITHOUTCODE} og indskriv koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Tak for at registrere dig på {FORUMNAME}. Dit brugernavn er {USERNAME} og dit kodeord er {PASSWORD}.

Før du kan logge ind, skal du først aktivere din konto ved at besøge det følgende link:

{ACTIVATIONLINK}

Skulle du opleve problemer med aktiveringen, besøg da {ACTIVATIONLINKWITHOUTCODE} og indskriv koden "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Tak for at registrere dig på {FORUMNAME}. Dit brugernavn er {USERNAME} og dit kodeord er {PASSWORD}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
	@description:
*/
$txt['new_announcement_subject'] = 'Ny annoncering: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

For at afmelde disse annonceringer, log ind på forum og fjern afkrydsning "Modtag forum annonceringer og vigtige meddelelser via email." i din profil.

Du kan se den fulde annoncering på følgende link:
{TOPICLINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Nyt emne: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Et nyt emne, \'{TOPICSUBJECT}\', er blevet oprettet på et board du overvåger.

Du kan læse det på dette link:
{TOPICLINK}

Flere emner kan være oprettet, men du vil ikke modtage flere email meddelelser, før du har besøgt boardet og læst nogle af dem.

Teksten fra emnet er vist herunder:
{MESSAGE}

Afmeld nye emner fra dette board ved at besøge det følgende link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Nyt emne: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Et nyt emne, \'{TOPICSUBJECT}\', er blevet oprettet på et board du overvåger.

Du kan læse det på dette link:
{TOPICLINK}

Flere emner kan være oprettet, men du vil ikke modtage flere email meddelelser, før du har besøgt boardet og læst nogle af dem.

Afmeld nye emner fra dette board ved at besøge det følgende link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Nyt emne: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Et nyt emne, \'{TOPICSUBJECT}\', er blevet oprettet på et board du overvåger.

Du kan læse det på dette link:
{TOPICLINK}

Teksten fra emnet er vist herunder:
{MESSAGE}

Afmeld nye emner fra dette board ved at besøge det følgende link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Nyt emne: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Et nyt emne, \'{TOPICSUBJECT}\', er blevet oprettet på et board du overvåger.

Du kan læse det på dette link:
{TOPICLINK}

Afmeld nye emner fra dette board ved at besøge det følgende link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Ny gruppe ansøgning';
$txt['request_membership_body'] = '{RECPNAME},

{APPYNAME} har anmodet om medlemsskab til gruppen "{GROUPNAME}". Brugeren har givet den følgende grund:

{REASON}

Du kan godkende eller afvise denne ansøgning ved at klikke på link herunder:

{MODLINK}

{REGARDS}';

/**
	@additional_params: scheduled_approval
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Abonnement nær udløb på {FORUMNAME}';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Et aktivt abonnement på {FORUMNAME} er nær udløb. Hvis du ved oprettelse af dette abonnement valgte automatisk fornyelse, vil det snarligt blive fornyet og du behøver ikke at foretage dig noget - ellers kan du overveje at abonnemere igen. Detaljer herunder:

Abonnement Navn: {SUBSCRIPTION}
Udløbsdato: {END_DATE}

For at redigere dine abonnementer, besøg følgende link: 
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The url link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Velkommen tilbage til {FORUMNAME}';
$txt['activate_reactivate_body'] = 'For at genvalidere din email adresse, er din konto blevet deaktiveret.  Klik på følgende link for at genaktivere den:
{ACTIVATIONLINK}

Skulle du opleve problemer med aktiveringen, besøg da {ACTIVATIONLINKWITHOUTCODE} og indskriv koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Nyt kodeord til {FORUMNAME}';
$txt['forgot_password_body'] = 'Kære {REALNAME},

Denne mail var sendt fordi \'glemt kodeord\' funktionen var brugt på din knoto. For at sætte et nyt kodeord, klik på følgende link:
{REMINDLINK}

IP: {IP}
Brugernavn: {MEMBERNAME}

Hvis du ikke har bedt om kodeord-assistance, er det sandsynligvis fordi en anden bruger skrev din email adresse ved en fejl.  Bare rolig, din konto er stadig sikker og der er ingen grund til at foretage dig yderligere.
Dit privatliv og sikkerhed er ikke kompromitteret af denne email.

{REGARDS}';

/**
	@additional_params: scheduled_approval
		REALNAME: The real (display) name of the person receiving the email.
		BODY: The generated body of the mail.
	@description:
*/
$txt['scheduled_approval_subject'] = 'Oversigt over indlæg der afventer godkendelse på {FORUMNAME}';
$txt['scheduled_approval_body'] = '{REALNAME},

Denne email indeholder en oversigt over alle elementer der afventer godkendelse på {FORUMNAME}.

{BODY}

Log ind på forum for at gennemgå disse elementer.
{SCRIPTURL}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The report post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The url of the post that is being reported.
		REPORTLINK: The url of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Rapporteret indlæg: {TOPICSUBJECT} af {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Det følgende indlæg, "{TOPICSUBJECT}" af {POSTERNAME} er blevet rapporteret af {REPORTERNAME} på et board du er moderator:

Emne: {TOPICLINK}
Moderationscenter: {REPORTLINK}

Personen der rapporterede dette har lavet den følgende kommentar:
{COMMENT}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Detaljer for nyt kodeord';
$txt['change_password_body'] = 'Kære {USERNAME},

Dine logind detaljer på {FORUMNAME} er blevet ændret og dit kodeord nulstillet. Nedenstående er dine nye login detaljer.

Dit brugernavn er "{USERNAME}" og dit kodeord er "{PASSWORD}".

Du kan ændre dette efter login ved at gå til profil siden, eller manuelt at indskrive denne adresse efter login:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The url link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_activate_body'] = 'Tak for at registrere dit på {FORUMNAME}. Dit brugernavn er {USERNAME}. Hvis du glemmer dit kodeord, kan du nulstille det ved at besøge {FORGOTPASSWORDLINK}.

Før du kan logge ind, skal du først aktivere din konto ved at følge dette link:

{ACTIVATIONLINK}

Skulle der opstå problemer med aktiveringen, besøg da {ACTIVATIONLINKWITHOUTCODE} og indskriv koden "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The url link to the coppa form.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_coppa_body'] = 'Tak for at registrere dig på {FORUMNAME}. Dit brugernavn er {USERNAME}. Hvis du glemmer din kode, kan du ændre den her {FORGOTPASSWORDLINK}

Før du kan logge ind, skal du godkendes af forælder/værge. Du kan få mere information på følgende link:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_immediate_body'] = 'Tak for at registrere dig på {FORUMNAME}. Dit brugernavn er {USERNAME}. Hvis du glemmer din kode, kan du ændre den her {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Velkommen til {FORUMNAME}';
$txt['register_pending_body'] = 'Hej {REALNAME}, din registrerings anmodning på {FORUMNAME} er blevet modtaget.

Brugernavnet du har registreret med er {USERNAME}. Hvis du glemmer din kode, kan du ændre den her {FORGOTPASSWORDLINK}.

Før du kan logge ind og starte med at bruge forum, skal din anmodning godkendes. Når dette sker, vil du modtage endnu en email fra denne adresse.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Emne svar: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Et svar er blevet indrykket på et emne du følger af {POSTERNAME}.

Vis svaret her: {TOPICLINK}

Du kan afmelde underretninger for dette emne her: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Emne svar: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'Et svar er blevet indrykket på et emne du følger af {POSTERNAME}.

Vis svaret her: {TOPICLINK}

Du kan afmelde underretninger for dette emne her: {UNSUBSCRIBELINK}

Svaret er vist herunder:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Emne svar: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'Et svar er blevet indrykket på et emne du følger af {POSTERNAME}.

Vis svaret her: {TOPICLINK}

Du kan afmelde underretninger for dette emne her: {UNSUBSCRIBELINK}

Der kan være indrykket flere svar, men du modtager ikke flere underretninger før du har læst emnet.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Emne svar: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'Et svar er blevet indrykket på et emne du følger af {POSTERNAME}.

Vis svaret her: {TOPICLINK}

Du kan afmelde underretninger for dette emne her: {UNSUBSCRIBELINK}

Svaret er vist herunder:
{MESSAGE}

Der kan være indrykket flere svar, men du modtager ikke flere underretninger før du har læst emnet.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Topic fremhævet: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Et emne du følger er blevet fremhævet af {POSTERNAME}.

Vis emnet her: {TOPICLINK}

Du kan afmelde underretninger for dette emne her: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Emne låst: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Et emne du følger er blevet låst af {POSTERNAME}.

Vis emnet her: {TOPICLINK}

Du kan afmelde underretninger for dette emne her: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Emne låst op: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Et emne du følger er blevet låst op af {POSTERNAME}.

Vis emnet her: {TOPICLINK}

Du kan afmelde underretninger for dette emne her: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Emne fjernet: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Et emne du følger er blevet fjernet af {POSTERNAME}.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Emne flyttet: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Et emne du følger er blevet flyttet til et andet board af {POSTERNAME}.

Vis emnet her: {TOPICLINK}

Du kan afmelde underretninger for dette emne her: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Emne flettet: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Et emne du følger er blevet flettet med et andet emne af {POSTERNAME}.

Vis det nye flettede emne her: {TOPICLINK}

Du kan afmelde underretninger for dette emne her: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Emne opdelt: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Et emne du følger er blevet opdelt til to eller flere emner af {POSTERNAME}.

Vis hvad der er tilbage af emnet her: {TOPICLINK}

Du kan afmelde underretninger for dette emne her: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'En ny bruger har tilsluttet sig';
$txt['admin_notify_body'] = '{USERNAME} har lige oprettet en ny bruger på dit forum. Klik på dette link for at vise deres profil.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'En ny bruger har tilsluttet sig';
$txt['admin_notify_approval_body'] = '{USERNAME} har lige oprettet en ny bruger på dit forum. Klik på dette link for at vise deres profil.
{PROFILELINK}

Før denne bruger kan begynde at skrive indlæg, skal deres konto godkendes. Klik på følgende link for at gå til godkeldelses skærmen.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Vigtigt! Vedhæftningsmappe er næsten fuld';
$txt['admin_attachments_full_body'] = '{REALNAME},

Vedhæftningsmappen på {FORUMNAME} er næsten fuld. Besøg forum for at rette dette problem.

Hvis vedhæftningsmappen når maksimum størrelsen, vil brugere ikke længere kunne vedhæfte filer eller avatars (hvis aktiveret).

{REGARDS}';

/**
	@additional_params: admin_backup_database
		BAK_REALNAME: the name of the user doing the backup
	@description:
*/
$txt['admin_backup_database_subject'] = 'En database backup er blevet udført';
$txt['admin_backup_database_body'] = '{REALNAME},

Denne email er for at informere dig om at {BAK_REALNAME} lige har downloaded en backup af databasen for {FORUMNAME}.

{REGARDS}';

/**
	@additional_params: editing_theme
		EDIT_REALNAME: the name of the user doing the backup
		FILE_EDITED: the name of the file being modified
		THEME_NAME: the name of the theme
	@description:
*/
$txt['editing_theme_subject'] = 'Redigering af et tema';
$txt['editing_theme_body'] = '{REALNAME},

Denne email er for at informere dig om at {EDIT_REALNAME} er ved at redigere skabelon filen:
{FILE_EDITED}
for temaet {THEME_NAME} på {FORUMNAME}.

Hvis du ved at dette ikke er tilfældet, bedes du undersøge dette.

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Refunderede betalte abonnementer';
$txt['paid_subscription_refund_body'] = '{REALNAME},

En bruger har modtaget en refundering af et betalt abonnement. Nedenstående er detaljer omkring dette abonnement:

	Abonnement: {NAME}
	Bruger Navn: {REFUNDNAME} ({REFUNDUSER})
	Dato: {DATE}

Du kan vise profilen til denne bruger ved at klikke på følgende link:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Nyt betalt abonnement';
$txt['paid_subscription_new_body'] = '{REALNAME},

En bruger har tegnet et nyt betalt abonnement. Nedenstående er detaljer omkring dette abonnement:

	Abonnement: {NAME}
	Bruger Navn: {SUBNAME} ({SUBUSER})
	Bruger Email: {SUBEMAIL}
	Pris: {PRICE}
	Dato: {DATE}

Du kan vise profilen til denne bruger ved at klikke på følgende link:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Betalt abonnement fejl opstået';
$txt['paid_subscription_error_body'] = 'Dear {REALNAME},

Den følgende fejl opstod under bearbejdning af et betalt abonnement
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Ny Personlig Besked: {SUBJECT}';
$txt['new_pm_body'] = 'Du har modtaget en personlig besked fra {SENDER} på {FORUMNAME}

VIGTIGT: Husk at, dette er kun en underretning. Svar venligst ikke på denne email.

Læs denne Personlige Besked her: {READLINK}

Svar på denne Personlige Besked her: {REPLYLINK}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Ny Personlig Besked: {SUBJECT}';
$txt['new_pm_body_body'] = 'Du har modtaget en personlig besked fra {SENDER} på {FORUMNAME}

VIGTIGT: Husk at, dette er kun en underretning. Svar venligst ikke på denne email.

Beskeden de sendte til dig var:

{MESSAGE}

Svar på denne Personlige Besked her: {REPLYLINK}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Ny Personlig Besked: {SUBJECT}';
$txt['new_pm_tolist_body'] = '{TOLIST} har modtaget en personlig besked fra {SENDER} på {FORUMNAME}

VIGTIGT: Husk at, dette er kun en underretning. Svar venligst ikke på denne email.

Læs denne Personlige Besked her: {READLINK}

Svar på denne Personlige Besked (kun til afsender) her: {REPLYLINK}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Ny Personlig Besked: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = '{TOLIST} har modtaget en personlig besked fra {SENDER} på {FORUMNAME}

VIGTIGT: Husk at, dette er kun en underretning. Svar venligst ikke på denne email.

Beskeden de sendte var:

{MESSAGE}

Svar på denne Personlige Besked (kun til afsender) her: {REPLYLINK}';

/**
	@additional_params: notify_new_buddy
		ACTIONNAME:  The user name of the member adding as buddy.
	@description: A notification email sent to the members that are set as buddy by someone
*/
$txt['notify_new_buddy_subject'] = '{ACTIONNAME} har tilføjet dig som ven';
$txt['notify_new_buddy_body'] = '{REALNAME},

Vi ville bare lige informere dig om at {ACTIONNAME} lige har tilføjet dig som en ven på {FORUMNAME}.

{REGARDS}


Du kan afmelde for flere "ny ven" notifikationer ved at bruge dette link: 
{UNSUBSCRIBELINK}
';
$txt['notify_new_buddy_digest'] = 'Du er blevet tilføjet som ven af:';
$txt['notify_new_buddy_snippet'] = '{ACTIONNAME}';

/**
	@additional_params: notify_new_likemsg
		ACTIONNAME:  The user name of the member that liked the message.
		MSGLINK:  The url to the message liked.
		SUBJECT: The subject of the message
	@description: A notification email sent to the members whose message has been liked
*/
$txt['notify_new_likemsg_subject'] = 'Et indlæg modtog en like';
$txt['notify_new_likemsg_body'] = '{REALNAME},

Vi ville bare lige informere dig om at {ACTIONNAME} lige har givet dit indlæg en like i emnet "{SUBJECT}" på {FORUMNAME}. 
Du kan vise det indlæg ved at følge dette link:
{MSGLINK}

{REGARDS}


Du kan afmelde for flere "like" notifikationer ved at bruge dette link: 
{UNSUBSCRIBELINK}
';
$txt['notify_new_likemsg_digest'] = 'De følgende indlæg har modtaget likes:';
$txt['notify_new_likemsg_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_mentionmem
		ACTIONNAME:  The user name of the member that mentioned someone.
		MSGLINK:  The url to the message where someone has been mentioned.
		SUBJECT: The subject of the message
	@description: A notification email sent to the members mentioned by someone else in a message
*/
$txt['notify_mentionmem_subject'] = 'Du er blevet omtalt';
$txt['notify_mentionmem_body'] = '{REALNAME},

Vi ville bare lige informere dig om at {ACTIONNAME} lige har omtalt dig i et indlæg i emnet "{SUBJECT}" på {FORUMNAME}. 
Du kan vise det indlæg ved at følge dette link:
{MSGLINK}

{REGARDS}


Du kan afmelde for flere "omtalenser" notifikationer ved at bruge dette link: 
{UNSUBSCRIBELINK}
';
$txt['notify_mentionmem_digest'] = 'Du er blevet omtalt i de følgende indlæg:';
$txt['notify_mentionmem_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_quotedmem
		ACTIONNAME:  The user name of the member that quoted someone's message.
		MSGLINK:  The url to the message where someone has been quoted.
		SUBJECT: The subject of the message
  		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description: A notification email sent to the members quoted in someone else message
*/
$txt['notify_quotedmem_subject'] = 'Dit indlæg er blevet citeret';
$txt['notify_quotedmem_body'] = '{REALNAME},

Vi ville bare lige informere dig om at {ACTIONNAME} på {FORUMNAME} lige har citeret dit indlæg i emnet "{SUBJECT}". Du kan vise det indlæg ved at følge dette link:
{MSGLINK}

{REGARDS}


Du kan afmelde for flere "citat" notifikationer ved at bruge dette link: 
{UNSUBSCRIBELINK}
';
$txt['notify_quotedmem_digest'] = 'Dine indlæg er blevet citeret i:';
$txt['notify_quotedmem_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_html_email
		FORUMNAMESHORT: Short or nickname for the forum
		TOPICSUBJECT: The subject of the message.
		MESSAGE: This is the body of the message.
		EMAILCSS: The location of the stylesheet.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description: A basic HTML wrapper to place around a prepared HTML email
 */
$txt['notify_html_email_subject'] = '';
$txt['notify_html_email_body'] = '<!DOCTYPE html>
<html>
<head>
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title>{TOPICSUBJECT}</title>
	<style>
		{EMAILCSS}
	</style>
</head>
<body>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="body">
	<tr>
		<td class="container">
			<div class="content">
				<table role="presentation" class="main">
					<tr>
						<td class="wrapper">
							<table role="presentation" border="0" cellpadding="0" cellspacing="0">
								<tr>
									<td>
										<p>{MESSAGE}</p>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<div class="footer">
					<table role="presentation" border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td class="content-block">
								<span class="apple-link">{FORUMNAMESHORT}</span>
								<br>
								Dont like these emails? <a href="{UNSUBSCRIBELINK}">Unsubscribe</a>.
							</td>
						</tr>
						<tr>
							<td>
								<span class="key-holder">[]</span>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</td>
	</tr>
</table>
</body>
</html>
';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/

$txtBirthdayEmails['happy_birthday_subject'] = 'Happy birthday from {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Dear {REALNAME},

We here at {FORUMNAME} would like to wish you a happy birthday.  May this day and the year to follow be full of joy.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'On your Birthday...';
$txtBirthdayEmails['karlbenson1_body'] = 'We could have sent you a birthday card.  We could have sent you some flowers or a cake.

But we didn\'t.

We could have even sent you one of those automatically generated messages to wish you happy birthday where we don\'t even have to replace INSERT NAME.

But we didn\'t

We wrote this birthday greeting just for you.

We would like to wish you a very special birthday.

{REGARDS}

//:: This message was automatically generated :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Happy Birthday!';
$txtBirthdayEmails['nite0859_body'] = 'Your friends at {FORUMNAME} would like to take a moment of your time to wish you a happy birthday, {REALNAME}. If you have not done so recently, please visit our community in order for others to have the opportunity to pass along their warm regards.

Even though today is your birthday, {REALNAME}, we would like to remind you that your membership in our community has been the best gift to us thus far.

Best Wishes,
The Staff of {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Birthday Wishes to {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Dear {REALNAME},

Another year in your life has passed.  We at {FORUMNAME} hope it has been filled with happiness, and wish you luck in the coming one.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Happy birthday, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Do you know who\'s having a birthday today, {REALNAME}?

We know... YOU!

Happy birthday!

You\'re now a year older but we hope you\'re a lot happier than last year.

Enjoy your day today, {REALNAME}!

- From your {FORUMNAME} family';
$txtBirthdayEmails['geezmo_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Your Birthday Greeting';
$txtBirthdayEmails['karlbenson2_body'] = 'We hope your birthday is the best ever cloudy, sunny or whatever the weather.
Have lots of birthday cake and fun, and tell us what you have done.

We hope this message brought you cheer, and make it last, until same time same place, next year.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';
