<?php
// Version: 2.0; Help

global $helptxt;

$txt['close_window'] = 'Close window';

$helptxt['manage_boards'] = '
	<strong>Rediger Boards</strong><br />
	I denne menu kan du oprette/sortere/fjerne boards og kategorier
	over dem. For eksempel, hvis du har en vidt-rækkende
	side som har indhold om &quot;Sport&quot; og &quot;Biler&quot; og &quot;Musik&quot;, disse
	ville være top-niveau Kategorier du ville oprette. Under hver af disse
	kategorier ville du sandsynligvis oprette et hierarki af &quot;under-kategorier&quot;,
	eller &quot;Boards&quot; for emner inden i hver. Det er et simpelt hirarki med følgende struktur: <br />
	<ul class="normallist">
		<li>
			<strong>Sport</strong>
			&nbsp;- En &quot;kategori&quot;
			<ul class="normallist">
				<li>
					<strong>Baseball</strong>
					&nbsp;- Et board under kategorien &quot;Sport&quot;
					<ul class="normallist">
						<li>
							<strong>Statistikker</strong>
							&nbsp;- Et under-board under boardet &quot;Baseball&quot;
						</li>
					</ul>
				</li>
				<li><strong>Fodbold</strong>
				&nbsp;- Et board under kategorien &quot;Sport&quot;</li>
			</ul>
		</li>
	</ul>
	Kategorier tillader dig at dele boardet til brede emner (&quot;Biler,
	&quot;Sport&quot;), og &quot;Boards&quot; under dem er faktiske emner som
	brugere kan skrive indlæg i. En bruger interesseret i Pintos
	ville skrive et indlæg under &quot;Biler&rarr;Pinto&quot;. Kategorier gør at folk
	hurtigt kan finde hvad deres interesse er: Istedet for en &quot;Butik&quot; har du
	&quot;Hardware&quot; og &quot;Tøj&quot; butikker du kan gå til. Dette simplificerer
	din søgning for &quot;rørledende forbindelse&quot; fordi du kan gå til Hardware
	Butikken &quot;kategorien&quot; i stedet for Tøj Butikken (hvor det er usandsynligt
	at du finder rørledende forbindelser).<br />
	Som anført ovenfor, et Board er et nøgle emne under en bred kategori.
	Hvis du vil diskuttere &quot;Pintoer&quot; ville du gå til &quot;Biler&quot; kategorien og
	hoppe ind i &quot;Pinto&quot; boardet for at skrive dine meninger i det board.<br />
	Administrative funktioner for denne menu er at oprette nye boards
	under hver kategori, for at sortere dem (put &quot;Pinto&quot; bagved &quot;Chevy&quot;), eller
	for at slette boardet fuldstændig.';

$helptxt['edit_news'] = '<ul class="normallist">
<li>
<strong>Nyheder</strong><br />
Denne sektion tillader dig at bestemme teksten for nyhedsemner som skal vises i Boardindekset.
Tilføj enhver nyhed som du synes (f.eks, &quot;Gå ikke glip af konferencen på tirsdag&quot;). Hver nyhed bør være i en separat boks, og vil blive vist i vilkårlig rækkefølge.
</li>
<li>
<strong>Nyhedsbreve</strong><br />
Denne sektion tillader sig at udsende nyhedsbreve til medlemmer i forummet via personlige beskeder eller e-mail. Først vælger du grupperne du ønsker at sende nyhedsbrevet til, samt de grupper der ikke skal modtage nyhedsbrevet. Hvis du ønsker det, kan du også tilføje yderligere medlemmer og e-mail-adresser som vil modtage nyhedsbrevet. Som sidste trin skriver du meddelelsen du ønsker at sende, såvel som vælger hvorvidt du ønsker at sende meddelelsen som en personlig besked eller som en e-mail.
</li>
<li>
<strong>Indstillinger</strong><br />
Denne sektion indeholder nogle få indstillinger som relaterer til nyheder og nyhedsbreve, udover at du kan vælge hvilke grupper der kan redigere forumnyheder samt udsende nyhedsbreve. Der er også en indstilling til at konfigurere om du vil aktivere nyhedsfeederen i forummet, så vel som indstillinger til at konfigurere længden (hvor mange karakterer der skal vises) for hver nyhedspost i et nyhedsfeed.
</li>
</ul>';

$helptxt['view_members'] = '
	<ul class="normallist">
		<li>
			<strong>Vis alle medlemmer</strong><br />
			Vis alle medlemmer på boardet. Du er præsenteret med en hyperlinket liste over medlemsnavne. Du kan klikke
			på ethvert navn for at finde detaljer på medlemmer (hjemmeside, alder, etc.),
			og som Administrator kan du modificere disse parametre. Du har fuld kontrol over medlemmer,
			inklusiv muligheden for at slette dem fra forum.<br /><br />
		</li>
		<li>
			<strong>Afventer Godkendelse</strong><br />
			Denne sektion er kun vist, hvis du har aktiveret admin godkendelse af alle nye registreringer. Enhver som registrerer sig på dit
			forum vil kun blive fuldbyrdede medlemmer når de er blevet godkendt af en admin. Sektionen viser alle disse medlemmer som
			stadig afventer godkendelse, samt deres email og IP adresse. Du kan vælge enten at acceptere eller afvise (slette)
			enhver medlem på listen ved at sætte hak i boksen til siden for medlemmet og vælge handlingen fra drop-down boksen i bunden
			af skærmen. Når du afviser et medlem kan du vælge at slette dem med eller uden notifikation til dem om din afgørelse.
		</li>
		<li>
			<strong>Afventer Aktivering<br />
			Denne sektion er kun vist hvis du har aktivering af medlemmer slået til på forum. Denne sektion viser alle
			medlemmer som stadig ikke har aktiveret deres konto. Fra denne skærm kan du vælge enten at acceptere, afslå eller påminde
			medlemmer med udestående aktiveringer. Som ovenfor kan du også vælge at sende email til medlemmer for at informere dem
			om hvilken handling du har taget.<br /><br />
		</li>
	</ul>';

$helptxt['ban_members'] = '<strong>Forbyd Medlemmer</strong><br />
	Dette giver muligheden for at &quot;forbyde&quot; brugere, for at forhindre folk som ikke har overholdt reglerne på dit forum
	enten ved at spamme, trolling, etc. Dette tillader dig at forbyde disse brugere som er skadelig for dit forum. Som en admin,
	når du læser beskeder, kan du se hver brugers IP adresse som blev brugt på tidspunktet for indlægget.
	På forbuds listen kan du skrive den IP adresse ind og gemme og de vil ikke længere kunne skrive fra den adresse.<br />
	Du kan også forbyde folk igennem deres email adresse.';

$helptxt['featuresettings'] = '<strong>Funktioner og Indstillinger</strong><br />
Der er mange forskellige funktioner i denne sektion der kan tilpasses dine præferencer.';

$helptxt['securitysettings'] = '<strong>Sikkerhed og Moderation</strong><br />
Denne sektion indeholder indstillinger der relaterer til sikkerhed og moderation af dit forum.';

$helptxt['addonsettings'] = '<strong>Tilføjelses indstillinger</strong><br />
	Denne sektion indeholder alle indstillinger fra tilføjelser installeret på dit forum.';

$helptxt['time_format'] = '<strong>Tids Format</strong><br />
	Du har muligheden for at justere hvordan tid og dato ser ud for dig selv. Der er mange små karakterer, men det er ret simpelt.
	Konventionen følger PHP\'s strftime funktion og er beskrevet som nedenunder (flere detaljer kan findes på <a href="http://www.php.net/manual/function.strftime.php" target="_blank" class="new_win">php.net</a>).<br />
	<br />
	Følgende karakterer er anerkendt i formatet streng:<br />
	<span class="smalltext">
	&nbsp;&nbsp;%a - forkortet ugedags navn
	&nbsp;&nbsp;%A - fuld ugedags navn<br />
	&nbsp;&nbsp;%b - forkortet måneds navn<br />
	&nbsp;&nbsp;%B - fuld måneds navn<br />
	&nbsp;&nbsp;%d - dag på måneden (01 til 31) <br />
	&nbsp;&nbsp;%D<strong>*</strong> - samme som %m/%d/%y <br />
	&nbsp;&nbsp;%e<strong>*</strong> - dag på måneden (1 til 31) <br />
	&nbsp;&nbsp;%H - time ved brug af 24-timers ur (fra 00 til 23) <br />
	&nbsp;&nbsp;%I - time ved brug af 12-timers ur (fra 01 til 12) <br />
	&nbsp;&nbsp;%m - måned som et nummer (01 til 12) <br />
	&nbsp;&nbsp;%M - minut som et nummer <br />
	&nbsp;&nbsp;%p - enten &quot;am&quot; eller &quot;pm&quot; ifølge den givne tid<br />
	&nbsp;&nbsp;%R<strong>*</strong> - tid i 24 timers notation <br />
	&nbsp;&nbsp;%S - sekunder som et decimal nummer <br />
	&nbsp;&nbsp;%T<strong>*</strong> - nuværende tid, svarende til %H:%M:%S <br />
	&nbsp;&nbsp;%y - 2 cifre år (00 til 99) <br />
	&nbsp;&nbsp;%Y - 4 cifre år<br />
	&nbsp;&nbsp;%% - et bogstaveligt \'%\' tegn <br />
	<br />
	<em>* Virker ikke på Windows-baserede servere.</em></span>';

$helptxt['deleteAccount_posts'] = 'Kun Svar: Dette fjerner alle indlæg som denne bruger indrykkede som svar til andre indlæg<br />
	Emner og Svar: Dette vil gøre det samme som ovenfor, og samtidig slette alle emner startet af denne bruger.';

$helptxt['live_news'] = '<strong>Live meddelelser</strong><br />
	Denne boks viser nyligt opdaterede meddelelser fra <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>.
	Du bør tjekke her af og til for opdateringer, nye udgivelser, samt vigtig information fra ElkArte.';

$helptxt['registrations'] = '<strong>Registrationsstyring</strong><br />
	Denne sektion indeholder alle funktioner der er nødvendige for at administrere nye registreringer i forummet. Den indeholder op til fire
	sektioner som er synlige afhængigt af dine forumindstillinger. Disse er:<br /><br />
	<ul class="normallist">
		<li>
			<strong>Registrer ny bruger</strong><br />
			Fra denne skærm kan du vælge at registrere nye brugere på deres vegne. Dette kan være nyttigt hvis registrering er lukket
			for nye brugere, eller i tilfælde hvor en administrator ønsker at oprette en test konto. Hvis funktionen påkræv aktivering
		 er aktiv vil den valgte bruger få en email med aktiverings link, som skal klikkes før de kan bruge kontoen. Samtidig kan du
			vælge at sende brugerens nye kode til den indtastede email adresse.<br /><br />
		</li>
		<li>
			<strong>Rediger Registreringsaftale</strong><br />
			Her kan du skrive den tekst der vises til nye brugere når de oprettes på dit forum.
			Du kan tilføje eller slette tekst fra standard aftalen inkluderet med ElkArte, som du ønsker.<br /><br />
		</li>
		<li>
			<strong>Indstil reserverede navne</strong><br />
			Her kan du angive ord og navne som brugere ikke kan anvende.<br /><br />
		</li>
		<li>
			<strong>Indstillinger</strong><br />
			Denne sektion er kun synlig hvis du har rettigheder til at administrere forum. Fra denne skærm kan du vælge hvilken registrerings metode der skal benyttes,
			 såvel som registrerings relaterede indstillinger.
		</li>
	</ul>';

$helptxt['requireAgreement'] = 'This setting is recommended to be enabled in order to comply with the rules of the <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';

$helptxt['modlog'] = '<strong>Logbog over moderatorændringer:</strong><br />
Denne sektion tillader medlemmer af administrationsteamet at følge alle moderationsændringer som forummoderatorer har udført. For at sikre at
moderatorer ikke kan fjerne referencer til de handlinger de har udført, kan handlinger ikke slettes før 24 timer efter de er foretaget.';
$helptxt['adminlog'] = '<strong>Administrationslog</strong><br />
Denne sektion tillader medlemmer af administrationsteamet at spore nogle af de administrative handlinger der er foregået i forummet. For at sikre at administratorer ikke kan fjerne referencer til de handlinger de har foretaget, kan registreringer ikke slettes før der er gået 24 timer efter handlingen er blevet udført.';
$helptxt['warning_enable'] = '<strong>Bruger Advarsler</strong><br />
	Her kan administratorer og moderatorer udstede advarsler til brugere - og at afgøre hvilke funktioner er tilgængelige for dem baseret på deres advarselsniveau.
	Ved aktivering af denne funktion vil en ny tilladelse blive tilgængelig i tilladelses sektionen som definerer
	hvilke grupper kan udstede advarsler til brugere. Advarselsniveauer kan justeres i en brugers profil. De følgende indstillinger er tilgængelige:';
$helptxt['watch_enable'] = '<strong>Advarselsniveau for bruger overvågning</strong><br />Denne indstilling definerer advarselsniveau i procent en bruger skal opnå for automatisk at blive &quot;overvåget&quot;. Enhver bruger som er under overvågning vil fremgå i det relevante område af moderations centret.';
$helptxt['moderate_enable'] = '<strong>Advarselsniveau for indlæg moderation</strong><br />Enhver bruger der passerer værdien af denne indstilling, vil finde at alle deres indlæg kræver godkendelse af en moderator før de bliver indrykket på forum	Dette vil ignorere enhver lokal indlæg moderations board tilladelse som kan eksistere.';
$helptxt['mute_enable'] = '<strong>Advarselsniveau for indlæg ban</strong><br />Hvis dette advarselsniveau er passeret af en bruger vil de ikke længere være i stand til at indrykke indlæg eller oprette emner.';
$helptxt['perday_limit'] = '<strong>Maksimal advarsels point per dag</strong><br />Denne indstilling begrænser antallet af point en moderator kan tilføje/fjerne til en bestemt bruger i en 24 timers periode. Dette kan bruges til at begrænse hvad en moderator kan gøre over en kort periode. Denne indstilling kan deaktiveres ved at indstille værdien til nul. Bemærk at enhver bruger med administrator rettigheder er ikke påvirket af denne indstilling.';
$helptxt['error_log'] = '<strong>Fejl Log</strong><br />
	Fejl log sporer enhver kritisk fejl brugere har oplevet på forum. Disse fejl vil blive vist efter datoen de opstod som kan sorteres
	ved at klikke på den sorte pil ved siden af hver dato. Ydermere kan du filtrere fejl ved at klikke på billedet ved siden af fejl statistik. Dette
	tillader dig at sortere, f.eks efter en bestemt bruger. Når et filter er aktivt vil kun fejl der matcher det valgte filter blive vist.';
$helptxt['theme_settings'] = '<strong>Temaindstillinger:</strong><br />
Dette skærmbillede tillader dig at ændre indstillingerne, specifikt for et bestemt tema. Disse indstillinger inkluderer valg af temaets mappe- og adresseinformation, men også andre valg der har effekt på temaerne i dit forum. De fleste temaer vil have forskellige brugerindstillinger, hvilket tillader dig at tilpasse et tema til dine behov.';
$helptxt['smileys'] = '<strong>Smileys</strong><br />
	Her kan du filføje og fjerne smileys og smiley sæt.  Bemærk at hvis en smiley eksisterer i et sæt, vil den eksistere i alle sæt - ellers ville det muligvis
	blive forvirrende for brugere af forskellige sæt.<br /><br />

	Du kan også redigere beskeds ikoner herfra, hvis de er slået til på indstillings siden.';

$helptxt['calendar'] = '<strong>Kalender</strong><br />
Her kan du rette i den aktuelle kalender, såvel som tilføje og fjerne feriedage og helligdage der vises i kalenderen.';
$helptxt['calendar_settings'] = 'Kalenderen kan bruges for at vise fødselsdage eller vigtige begivenheder på dit forum.<br /><br />Husk at brug af kalenderen (indrykning af begivenheder, visning af begivenheder, etc.) er kontrolleret af tilladelse sæt på tilladelses skærmen.';
$helptxt['cal_days_for_index'] = 'Maks antal fremtidige dage på board indeks:<br />Hvis dette er sat til 7, vil hele næste uges begivenheder blive vist.';
$helptxt['cal_showevents'] = 'Aktiverer fremhævning af aktiviteter i Mini Kalenderen, Hoved Kalenderen, begge steder, eller slå fremhævning fra.';
$helptxt['cal_showholidays'] = 'Denne indstilling tillader dig at fremhæve helligdage i Mini Kalenderen, Hoved Kalenderen, begge steder, eller at slå fremhævning fra.';
$helptxt['cal_showbdays'] = 'Denne indstilling tillader dig at fremhæve fødselsdage i Mini Kalenderen, Hoved Kalenderen, begge steder, eller slå fremhævning fra.';
$helptxt['cal_export'] = 'Eksporter en tekst fil i iCal formatet for importering til andre kalender applikationer.';
$helptxt['cal_daysaslink'] = 'Vis dage som et link til \'Indsæt Begivenhed\':<br />Dette tillader brugere at indrykke begivenheder for den dag når de klikker på den dato.';
$helptxt['cal_allow_unlinked'] = 'Tillad begivenheder ikke linked til indlæg:<br />Tillad brugere at indrykke begivenheder uden at kræve at den er linked til et indlæg på board.';
$helptxt['cal_defaultboard'] = 'Standard Board der skal indrykkes til:<br />Indtast standard board begivenheder bliver indrykket til.';
$helptxt['cal_showInTopic'] = 'Vis linkede begivenheder i emne visning:<br />Afkryds for at vise et link til begivenheden i toppen af emne visning.';
$helptxt['cal_allowspan'] = 'Tillad begivenheder strækkende over flere dage:<br />Afkryds for at tillade begivenheder at strække over flere dage.';
$helptxt['cal_maxspan'] = 'Maksimal antal dage en begivenhed kan strække sig over:<br />Indtast maksimal antal dage en enkel begivenhed kan strække sig over.';
$helptxt['cal_minyear'] = 'Minimum år:<br />Vælg det &quot;første&quot; år i kalendar listen.';
$helptxt['cal_maxyear'] = 'Maksimum år:<br />Vælg det &quot;sidste&quot; år i kalender listen<br />';

$helptxt['serversettings'] = '<strong>Server Indstillinger</strong><br />
	Her kan du udføre kerne konfiguration for dit forum. Denne sektion inkluderer databasen og URL indstillinger såvel som andre
	vigtige konfigurationer så som mail indstillinger og caching. Tænk omhyggeligt når du redigerer disse, da en fejl kan
	gøre forum ubrugeligt';
$helptxt['manage_files'] = '
	<ul class="normallist">
		<li>
			<strong>Gennemse Filer</strong><br />
			Gennemse alle vedhæftelser, avatars og miniaturer gemt på systemet.<br /><br />
		</li><li>
			<strong>Vedhæftnings Indstillinger</strong><br />
			Konfigurer hvor vedhæftninger er gemt og indstil restriktioner på typer af vedhæftninger.<br /><br />
		</li><li>
			<strong>Avatar Indstillinger</strong><br />
			Konfigurer hvor avatars er gemt og administrer skalering af avatars.<br /><br />
		</li><li>
			<strong>Fil Vedligeholdelse</strong><br />
			Check og reparer eventuelle fejl i vedhæftnings mappen og slet valgte vedhæftninger.<br /><br />
		</li>
	</ul>';

$helptxt['topicSummaryPosts'] = 'Dette tillader dig at indstille antallet af tidligere indlæg vist i emneoversigten i svar visning.';
$helptxt['enableAllMessages'] = 'Sæt denne indstilling til det <em>maksimale</em> antal indlæg et emne kan have for at vise linket &quot;Vis alle&quot; .  Sættes denne til mindre end &quot;Antallet af indlæg per side på emnesider&quot; betyder simpelthen at denne aldrig bliver vist, og sættes den for højt, kan det gå ud over performancen af dit forum.';
$helptxt['allow_guestAccess'] = 'Låses denne boks, stoppes gæster i at gøre andet end meget basale handlinger - logge ind, registere, bruge kodeordshusker o.s.v - i dit forum.  Dette er ikke det samme som at udelukke gæster fra boards.';
$helptxt['userLanguage'] = 'Aktivering af denne funktion vil tillade brugere at vælge hvilken sprog fil de vil benytte. Det har ingen indflydelse på standard valget.';
$helptxt['trackStats'] = 'Statistik:<br />Dette vil tillade brugere at se seneste indlæg og mest populære emner på dit forum.
		Det vil også vise adskillige statistikker såsom flest brugere online, nye brugere og nye emner.<hr />
		Side visninger:<br />Tilføjer en ny kolonne til statistik siden med antal af side visninger på dit forum.';
$helptxt['enable_unwatch'] = 'Aktivering af denne funktion vil tillade brugere at vælge eller fravælge nye svar notifikationer for emner som de tidligere har skrevet i.';
$helptxt['titlesEnable'] = 'Aktivering af brugerdefinerede titler vil lade brugere med den relevante tilladelse oprette en speciel titel for dem selv.
		Denne vil blive vist under navnet.<br /><em>Eksempel:</em><br />Jeff<br />Fed Fyr';
$helptxt['onlineEnable'] = 'Dette vil vise et ikon der indikerer om et medlem er online eller offline';
$helptxt['todayMod'] = 'Dette kan ændre visning af &quot;Idag&quot; eller &quot;Igår&quot; på en række måder istedet for den fulde dato.<br /><br />
		<strong>Eksempler:</strong><br /><br />
		<dl class="settings">
			<dt>Deaktiveret</dt>
			<dd>3 Oktober, 2009 kl. 12:59:18 am</dd>
			<dt>Relativ</dt>
			<dd>2 Timer Siden</dd>
			<dt>Kun Idag</dt>
			<dd>Idag kl. 12:59:18 am</dd>
			<dt>Idag &amp; Igår</dt>
			<dd>Igår kl. 09:36:55 pm</dd>
		</dl>';
$helptxt['disableCustomPerPage'] = 'Marker denne valgmulighed for at forhindre brugere i at ændre antallet af indlæg og emner der vises respektivt per side i emneindekset og emnevisning.';
$helptxt['enablePreviousNext'] = 'Dette vil vise et link til forrige og næste emne.';
$helptxt['pollMode'] = 'Dette vælger om afstemninger er aktiveret eller ej. Hvis afstemninger er deaktiveret, vil de regulære emner uden afstemning blive vist.
<br /><br />For at vælge hvem der kan oprette afstemninger, vise afstemninger m.m. kan du tilføje/fjerne disse tilladelser. Husk dette hvis afstemninger ikke virker.';
$helptxt['enableVBStyleLogin'] = 'Dette vil vise et mere kompakt login for gæster på alle sider i forummet.';
$helptxt['enableCompressedOutput'] = 'Denne funktion vil komprimere output for at formindske båndbredde, men det kræver at zlib er installeret.';
$helptxt['databaseSession_enable'] = 'Denne funktion gør brug af databasen til sessionslager - dette er bedst for load balanced servere, men hjælper med alle timeout problemer og kan gøre forummet hurtigere.';
$helptxt['databaseSession_loose'] = 'Aktivering af dette vil formindske båndbredden for dine brugere, og gøre at klikken tilbage vil ikke reloade siden - ulempen er at blandt andet nye ikoner og billeder ikke vil blive opdateret. (med mindre du klikker dig ind på siden, i stedet for at gå tilbage til den.)';
$helptxt['databaseSession_lifetime'] = 'Dette er antallet af sekunder sessioner lever i, efter de ikke er blevet anvendt. Hvis en session ikke benyttes i en længere periode, udløber der en såkaldt &quot;timeout&quot;. Alt højere end 2400 er anbefalet.';
$helptxt['cache_enable'] = 'ElkArte udøver caching på forskellige niveauer. Jo højere niveau, jo højere CPU tid vil der blive brugt på at hente cachede informationer. Hvis caching er tilgængelig på din maskine er det anbefalet at du forsøger niveau 1 først.';
$helptxt['cache_memcached'] = 'Hvis du bruger memcached skal du angive nogle server detaljer. Dette skal indtastes som en komma separeret liste som vist i det nedenstående eksempel:<br /><br/>	&quot;server1,server2,server3:port,server4&quot;<br /><br />Bemærk at hvis ingen port er specificeret vil softwaren bruge port 11211, sæt denne til 0 hvis du bruger UNIX domain sockets. Systemet vil også forsøge at lave en overfladisk/tilfældig load balancering udover de specificerede servere.';
$helptxt['cache_redis'] = 'If you are using redis you need to provide the server details. This should be entered as a comma separated list as shown in this example:<br /><br/>&quot;server1,server2,server3:port,server4&quot;<br /><br />Note that if no port is specified the software will use port 6379, set this to 0 when using UNIX domain sockets.';
$helptxt['cache_cachedir'] = 'Denne indstilling er kun for filsystem baseret cache. Det angiver stien til cache mappen. Det er anbefalet at du placerer denne i /tmp/ hvis du vil bruge dette, dog vil det virke i enhver mappe.';
$helptxt['cache_uid'] = 'Some cache systems, for example Redis, may require a user ID to allow ElkArte access the cache.';
$helptxt['cache_password'] = 'Some cache systems, for example Redis, may require a password to allow ElkArte access the cache.';

$helptxt['enableErrorLogging'] = 'Dette vil logge enhver fejl, såsom forfejlede login, så du kan se hvad der gik galt.';
$helptxt['enableErrorQueryLogging'] = 'Dette vil inkludere den fulde forespørgsel sendt til databasen med tilhørende databasefejl. Fejllog skal være aktiveret.<br /><br /><strong>Bemærk: Dette vil påvirke evnen til at sortere fejlloggen efter fejlmeddelelsen.</strong> ';
$helptxt['allow_disableAnnounce'] = 'This will allow users to opt out of notification of topics you announce by checking the &quot;Announce Topic&quot; checkbox when posting. Disabling this option violates the rules of the <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a> and many other countries\' privacy and anti-spam laws.';
$helptxt['metadata_enabled'] = 'Dette vil generere OG (Open Graph) og Schema.org mikrodata egnet til HTML indlejring (kræver tema support). Det tillader søge maskiner at bedre forstå informationen på dine sider, og opretter en bedre link deling oplevelse på sociale sider. Når aktiveret vil metadata være tilgængeligt fra board visning, emne visning samt emne visnings områder på din side.';
$helptxt['disallow_sendBody'] = 'Denne indstilling fjerner muligheden for at modtage teksten på svar, indlæg og personlige beskeder i notifikations emails.<br /><br />Mange gange vil brugere svare på disse emails, som i de fleste tilfælde vil sende deres svar til webmaster.';
$helptxt['enable_contactform'] = 'Denne indstilling tilføjer et Kontakt Os knap til registrerings skærmen';
$helptxt['jquery_source'] = 'Dette afgør hvor jQuery Library skal hentes fra.  Auto vil bruge CDN først og hvis ikke tilgængelig falde tilbage på lokal kilde.  Kun lokal vil kun bruge lokal kilde, CDN vil kun hente fra Google\'s Content Delivery Network';
$helptxt['jquery_default'] = 'If you want to use a version of jQuery different than the one that came with ElkArte, select this box and enter the version number X.XX.X The local file must follow the naming conventing of jquery-X.XX.X.min.js for it to be loaded.';
$helptxt['jqueryui_default'] = 'If you want to use a version of jQueryUI different than the one that came with ElkArte, select this box and enter the version number X.XX.X The local file must follow the naming conventing of jquery-ui-X.XX.X.min.js for it to be loaded.';
$helptxt['minify_css_js'] = 'This will remove unnecessary whitespace and comments from the files to reduce their size.  The minimized files are saved so further requests can instantly serve those files.<br />Note that the first time a compilation is needed/created, there may be a slight delay on that page load in order to create the file (this will also happen after the cache is cleared)';
$helptxt['combine_css_js'] = 'This will combine multiple CSS or JavaScript files per page as needed.  The combined files are saved so further requests can instantly serve those files.';
$helptxt['compactTopicPagesEnable'] = 'Dette vil vise det givne antal af omgivende sider.<br /><em>Eksempel:</em>
		&quot;3&quot; for at vise: 1 ... 4 [5] 6 ... 9 <br />
		&quot;5&quot; for at vise: 1 ... 3 4 [5] 6 7 ... 9';
$helptxt['timeLoadPageEnable'] = 'Dette vil vise i bunden af siden den tid i sekunder det tog at indlæse siden.';
$helptxt['removeNestedQuotes'] = 'Dette vil fjerne, eller begrænse antallet af, indlejrede citater i et svar når svar citeres via citat link.';
$helptxt['heightBeforeShowMore'] = 'Dette vil begrænse højden af en citat blok. Citater der overskrider denne størrelse vil have en "læs mere" mulighed tilføjet for at tillade at se hele citatet.';
$helptxt['search_dropdown'] = 'Dette vil vise en søge dropdown boks ved siden af hurtig søg boksen. Herfra kan du vælge om du vil søge hele siden, nuværende board (hvis i et board) nuværende emne (hvis i et emne) eller søge efter brugere.';
$helptxt['max_image_width'] = 'Dette tillader dig at indstille en maksimum størrelse for vedhæftede billeder. Billeder der er mindre end maksimum er ikke berørt. Dette afgør også hvordan vedhæftede billeder er vist når der klikkes på en miniature.';
$helptxt['mail_type'] = 'Denne indstilling giver dig mulighed for enten at vælge PHP standard indstillinger, eller at definere dine egne SMTP indstillinger.  PHP understøtter ikke autentificering med SMTP (som mange udbydere kræver nu) så hvis du vil benytte dette skal du vælge SMTP.  Bemærk at  SMTP kan være langsommere, og nogle servere vil ikke benytte brugernavne og koder.<br /><br />Du behøver ikke indskrive SMTP indstillinger hvis du vælger PHP standard indstillinger.';
$helptxt['mail_batch_size'] = 'Denne indstilling afgør hvor mange emails der vil blive sendt per side visning og kan ikke sættes større end maksimalt tilladt per minut.<br />Ved at angive 0 vil systemet automatisk bestemme antallet for at jævnt fordele byrden og fylde kvoten.<br />Hvis du angiver dine egne værdier, er det anbefalet at sætte disse til samme værdi som din lavere per minut grænse, eller 1/6 af højere per minut grænse.';
$helptxt['smtp_client'] = 'Brugt til at identificere denne klient til SMTP serveren. <br />Dette felt skal indeholde fuldt kvalificeret domæne navn (FQDN) af SMTP klienten. I tilfælde hvor klient systemet ikke har et betydningsfuldt domæne navn, kan du i stedet bruge en adresse literær formateret som [IPv4] eller [IPv6:ipv6 adresse]. <br />Hvis blankt vil systemet forsøge at detektere denne værdi for dig.';

$helptxt['attachmentEnable'] = 'Aktiver/Deaktiver vedhæftnings system eller deaktiver kun nye vedhæftninger og lade eksisterende være tilgængelige.';
$helptxt['automanage_attachments'] = 'Dette vil oprette en mappe struktur baseret på valgte muligheder.  Dette kan være indlæg dato (deling af vedhæftninger per år, eller per år og måned eller per år, måned og dag) eller bare oprette en ny mappe når størrelsen når grænsen.  Hver oprettet mappe vil have den samme begrænsning for antal filer og total størrelse.  Dette vil hjælpe til at forhindre mapper i at opnå fil eller størrelse begrænsning.';
$helptxt['use_sub-directories_for_attachments'] = 'Dette vil oprette nye mapper som undermapper under hovedmappen for vedhæftninger.';
$helptxt['attachmentDirSizeLimit'] = 'Indstil hvor stor vedhæftninger mappen skal være.';
$helptxt['attachmentDirFileLimit'] = 'Indstil maksimal antal af filer en individuel vedhæftnings mappe kan indeholde';
$helptxt['attachmentPostLimit'] = 'Angiv hvor stor et enkelt indlæg total upload størrelse kan være (i KiB), dette er den akkumulerede størrelse på alle vedhæftninger i det samme indlæg.';
$helptxt['attachmentSizeLimit'] = 'Angiv den maksimale størrelse på en enkel vedhæftning et indlæg kan have.';
$helptxt['attachmentNumPerPostLimit'] = 'Angiv antal af vedhæftninger en bruger kan tilføje per indlæg.';

$helptxt['attachment_image_resize_enabled'] = 'Master on/off switch for this function.  Enabling this will 
	resize attachment images (.jpg, .png, .gif, .bmp, .webp) to fit within the specified bounds.  The image format 
	will be maintained unless the resized image is over the specified max allowed file size.  In this event, if 
	change format is enabled, the system may convert the image to WebP or JPEG for better compression.';
$helptxt['attachment_image_resize_reformat'] = '
	Selecting this option will allow the system to change images into WebP, if available, or JPEG ONLY
	when necessary.  The system will try to maintain the existing format unless the resized image is in
	excess of the maximum allowed file size.  It will not reencode JPG or change a PNG with transparency to JPG';
$helptxt['attachment_image_resize_width'] = 'This allows you to set a maximum width for attachment images. 
	Pictures smaller than the maximum will not be affected, larger images will be resized proportionately. 
	This allows you to accept a larger image on upload and have it resized to save space. The maximum 
	filesize parameter is still enforced.';
$helptxt['attachment_image_resize_height'] = 'This allows you to set a maximum height for attachment images. 
	Pictures smaller than the maximum will not be affected, larger images will be resized proportionately. 
	This allows you to accept a larger image on upload and have it resized to save space. 
	The maximum filesize parameter is still enforced.';

$helptxt['attachmentCheckExtensions'] = 'Afkryds denne boks for at aktivere vedhæftnings filtrering, hvilket kun vil tillade filer der har de angivne filtypenavne at blive uploadet.';
$helptxt['attachmentExtensions'] = 'Angiv hvilke vedhæftnings typer er tilladt, for eksempel: jpg,png,gif  Husk at være varsom hvad du tillader da visse filtypenavne kan være en sikkerhedsrisiko for dit website.';
$helptxt['attachment_autorotate'] = 'Vælges denne mulighed vil det være muligt for systemet at detektere roterede billeder, typisk fra telefon kameraer, og automatisk rotere orientering så billedets top er orienteret opad. Dette kræver enten ImageMagick eller både GD og Exif moduler tilgængelige.';
$helptxt['attachmentShowImages'] = 'If the uploaded file is a picture, this will automatically display it underneath the post.  If not enabled you will only see a filename and its dsize';
$helptxt['attachmentThumbnails'] = 'Aktiver dette for at vise indlægsbilleder som mindre miniature billeder, som når de vælges vil udvide til billedets fulde størrelse.';
$helptxt['attachment_webp_enable'] = 'Enabling this will allow the system to create/save thumbnails and avatars 
	in WebP format.  It will also allow the image resize function, when enabled, to save an attachment as Webp when
 	necessary.';
$helptxt['attachmentThumbWidth'] = 'Kun brugt med &quot;Skaler billeder når de vises under indlæg&quot; muligheden, maksimal bredde at skalere vedhæftninger ned fra.  De vil blive skaleret proportionalt.';
$helptxt['attachmentThumbHeight'] = 'Kun brugt med &quot;Skaler billeder når de vises under indlæg&quot; muligheden,maksimal højde at skalere vedhæftninger ned fra.  De vil blive skaleret proportionalt.';
$helptxt['attachment_image_reencode'] = 'Selecting this option will enable the re-encode of uploaded image attachments. Image re-encoding offers better security, however it will also render all animated images static.';
$helptxt['max_image_height'] = 'Maksimal vist højde på et vedhæftnings billede.';
$helptxt['max_image_width'] = 'Dette tillader dig at indstille en maksimum størrelse for vedhæftede billeder. Billeder der er mindre end maksimum er ikke berørt. Dette afgør også hvordan vedhæftede billeder er vist når der klikkes på en miniature.';
$helptxt['attachmentUploadDir'] = 'Vælg hvor du vil gemme uploadede filer på din server. Dette kan være uden for offentlig html adgang for yderligere sikkerhed.';
$helptxt['attachment_transfer_empty'] = 'Aktivering af dette vil flytte alle filer fra kilde mappen til den nye lokation, ellers vil kun det maksimal tilladte antal af filer i henhold til per-mappe indstilling blive flyttet.';
$helptxt['avatar_reencode'] = 'Selecting this option will enable the re-encode of uploaded avatars. Image re-encoding offers better security, however it will also render all animated images static.';
$helptxt['karmaMode'] = 'Karma en funktion der viser populariteten på et medlem. Hvis et medlem har tilladelse til det, kan vedkommende give \'god\' eller \'dårlig\' karma til andre brugere, på denne måde måles brugeres popularitet. Du kan ændre antallet af indlæg behøvet for at kunne have en  &quot;karma&quot;, tiden mellen \'god\' eller \'dårlig\', samt hvorvidt administratorer også er berørt af tidsbegrænsningen.<br /><br />Hvorvidt medlemsgrupper kan give andre karma, er kontrolleret af en tilladelse. Hvis du har problemer med at få dette til at virke for alle, så dobbeltcheck tilladelserne.';
$helptxt['localCookies'] = 'Systemet bruger cookies for at gemme login information på de besøgendes computere.
	Cookies kan gemmes globalt (myserver.com) eller lokalt (myserver.com/sti/til/forum).<br />
	Afkryds denne funktion hvis du oplever problemer med brugere der bliver logget ud automatisk.<hr />
	Globale cookies er mindre sikre når brugt på en delt webserver (såsom Tripod).<hr />
	Lokale cookies virker ikke uden for forum mappen, så hvis dit forum er gemt på www.myserver.com/forum, sider såsom www.myserver.com/index.php vil ikke kunne tilgå login informationerne.
	Specielt ved brug af SSI.php, er globale cookies anbefalet.';
$helptxt['enableBBC'] = 'Denne indstilling tillader dine medlemmer at anvende Bulletin Board Kode (BBC) i hele forummet, som f.eks at indsætte billeder i deres indlæg, formatere teksten m.m.';
$helptxt['time_offset'] = 'Ikke alle forumadministratorer ønsker at deres forum anvender samme tidsformat som serveren, systemet kører på. Anvend denne indstilling til at angive forskudt tid (i timer), i forhold til serverens tidsindstilling. Negative tal samt decimaltal er tilladt.';
$helptxt['default_timezone'] = 'Serverens tidszone fortæller PHP hvor den server er lokaliseret. Du bør sikre at dette er indstillet korrekt, helst til den by/land hvor din server er lokaliseret. Du kan finde mere information på <a href="http://www.php.net/manual/en/timezones.php" target="_blank">PHP Siden</a>.';
$helptxt['spamWaitTime'] = 'Her kan du indstille den tid der skal gå imellem oprettelse af indlæg. Dette kan anvendes til at hindre brugere i at "spamme" dit forum, ved at bestemme hvor ofte de kan oprette nye indlæg.';

$helptxt['enablePostHTML'] = 'Dette vil tillade brug af nogle basale HTML tags:
	<ul class="normallist enablePostHTML">
		<li>&lt;b&gt;, &lt;u&gt;, &lt;i&gt;, &lt;s&gt;, &lt;em&gt;, &lt;ins&gt;, &lt;del&gt;</li>
		<li>&lt;a href=&quot;&quot;&gt;</li>
		<li>&lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;</li>
		<li>&lt;br /&gt;, &lt;hr /&gt;</li>
		<li>&lt;pre&gt;, &lt;blockquote&gt;</li>
	</ul>';

$helptxt['enablePostMarkdown'] = 'This will allow the use of some basic Markdown tags when posting:
	<ul class="normallist enablePostMarkdown">
		<li>**Text** or __Text__ => [b]Text[/b]</li>
		<li>*Text* or _Text_ => [i]Text[/i]</li>
		<li>~~Text~~ => [s]Text[/s]</li>
		<li>`Text` => [icode]Text[/icode]</li>
		<li>```Text``` => [code]Text[/code]</li>
		<li>> Text => [quote]Text[/quote]</li>
		<li>--- or *** or ___ => [hr]</li>
	</ul>';

// Initial theme settings - Manage and Install
$helptxt['themes'] = 'Her kan du vælge hvorvidt standard temaet kan vælges, hvilket tema gæster vil bruge, og andre indstillinger. Klik på et tema til højre for at ændre indstillinger for det.';
$helptxt['theme_install'] = 'Denne sektion tillader dig at installere nye tema. Du gør dette ved at uploade en pakket fil for det tema fra din computer, installering fra en tema mappe på serveren eller ved at kopiere standard tema og omdøbe den kopierede fil.<br /><br />Husk at: den pakkede fil eller mappe skal have en <span style="color:red">theme_info.xml</span> definitions fil som del af den pakkede fil eller mappe.';
$helptxt['theme_forum_theme'] = 'Ændring af forum standard har ingen indflydelse på brugere der har valgt et andet tema. Du skal også \'Nulstil\' alle brugere for at tvinge dem til at at bruge det nye forum standard. Du kan også sætte et forum standard tema som er brugt af gæster og så nulstille brugere til at andet tema. <br /><br />Husk at når det er tilladt brugere at sætte deres eget tema, kan de bruge et andet tema end det du vælger.';

// Theme Management and Options - Theme settings
$helptxt['themeadmin_list_reset'] = 'Ved sjældne lejligheder kan stien til tema blive glemt og dit forum vil ikke vises ordentligt. Dette kan være grundet en fejl fra en administrator, database fejl, software fejl i opdateringer, installerede mods eller et andet tilfælde. Nulstilling af tema URLs og mapper vil for det meste løse dette problem.';
$helptxt['themeadmin_delete_help'] = 'Standard tema kan ikke slettes da dette ville bryde dit forum og ville bryde andre temaer. Men, du kan slette ethvert tema som har et rødt \'X\' ved siden af det ved at klikke på det \'X\'. <br /><br /> Husk: Sletning af et tema, sletter ikke filerne fra din server, det fjerner kun muligheden for at bruge det på forum. Du skal FTP ind til din server eller bruge panelet stillet til rådighed af din udbyder for at slette temaet fra din server. Slet aldrig temaet kaldet \'default\'.';

$helptxt['enableVideoEmbeding'] = 'This allows automatic conversion of standard URLs into an embedded video when the post is viewed.  Currently supports YouTube, Vimeo, TikTok, Twitter, Facebook, Instagram and Dailymotion links';
$helptxt['enableCodePrettify'] = 'Dette vil indlæse Prettify script som vil lave farve fremhævning af kode brugt i kode tags. Det tilføjer stilarter til kodestykker sådan at tokens udskiller sig og dine brugere lettere kan læse koden.';
// @todo Add more information about how to use them here.
$helptxt['xmlnews_enable'] = 'Tillader folk at linke til <a href="%1$s?action=.xml;sa=news" target="_blank" class="new_win">Seneste nyheder</a>
	og lignende data.  Det er også anbefalet at du begrænser antallet af seneste posteringer/nyheder fordi, når RSS data
	er vist i visse klienter, såsom Trillian, forventes det at blive afkortet.';
$helptxt['hotTopicPosts'] = 'Juster antallet af indlæg for at et emne opnår status som &quot;varmt&quot; eller
	&quot;meget varmt&quot; emne.  Vælg like funktionen for at basere denne status på antallet af likes i stedet for antallet af indlæg';
$helptxt['globalCookies'] = 'Gør login cookies tilgængelige på under-domæner.  For eksempel, hvis...<br />
	Din side er på http://www.myserver.com/,<br />
	og dit forum er på http://forum.myserver.com/,<br />
	Ved brug af denne funktion vil du kunne tilgå forum cookie fra din side.  Aktiver ikke dette hvis der er andre under-domæner (såsom hacker.elkarte.net) som ikke kontrolleres af dig.<br />
	Denne indstilling fungerer ikke hvis lokale cookies er aktiveret.';
$helptxt['globalCookiesDomain'] = 'Definer hoved-domæne som skal bruges når login cookies er tilgængelig på under-domæner';
$helptxt['httponlyCookies'] = 'Når denne indstilling er til, vil cookies ikke være tilgængelige fra scripting sprog, såsom JavaScript. Denne indstilling kan hjælpe med at reducere identitetstyveri igennem XSS angreb. Dette kan lave nogle problemer for tredje parts scripts, men er anbefalet at være slået til såvidt muligt.';
$helptxt['secureCookies'] = 'Aktivering af denne valgmulighed vil tvinge cookies oprettet til brugere i dit forum, at blive markeret som sikre. Aktiver kun denne valgmulighed hvis du anvender HTTPS overalt på din hjemmeside, da det ellers vil ødelægge behandlingen af cookies!';
$helptxt['admin_session_lifetime'] = 'Dette kontrollerer længden en admin session kan være aktiv. Når denne timer udløber vil sessionen slutte, og kræve at du skriver dine admin informationer igen for at fortsætte med at bruge admin området. Minimums tiden er 5 minutter, den maksimalt tilladte tid er 14400 minutter (svarer til en dag). Det er anbefalet at du bruger en værdi på mindre end 60 minutter af sikkerhedsgrunde.';
$helptxt['auto_admin_session'] = 'Dette angiver hvorvidt en administrativ session er aktiveret ved login eller ej.';
$helptxt['securityDisable'] = 'Dette <em>deaktiverer</em> ekstra kodeordscheck for administrator-sektionen. Dette er ikke anbefalet!';
$helptxt['securityDisable_why'] = 'Dette er dit aktuelle kodeord. (det samme du anvender til at logge ind.)<br /><br />At du skal skrive dette, hjælper dig med at sikre at den administrering der foretages også bliver udført af <strong>dig</strong>.';
$helptxt['securityDisable_moderate'] = 'Dette<em>deaktiverer</em> ekstra kodetjek for moderations sektionen. Dette er ikke anbefalet!';
$helptxt['securityDisable_moderate_why'] = 'Dette er din nuværende kode. (den samme som du brugte til at logge ind.)<br /><br />Ved at skrive denne hjælper med at sikre at du rent faktisk ønsker at udføre den moderation du udfører, og at det rent faktisk er <strong>dig</strong> der udfører den.';
$helptxt['enableOTP'] = 'Aktivering af denne funktion tillader endnu et lag af sikkerhed for bruger konti. To-vejs autentifikation, eller 2FA, er en måde at logge ind på websider som kræver mere end bare en kode. Brugen af kode til at logge ind på en webside er modtagelig for sikkerheds trusler, fordi et repræsenterer et enkelt stykke information en ondsindet person behøver at skaffe. Den sikkerhed som 2FA tilføjer er at kræve yderligere information for at logge ind.<br /><br />En tids-baseret Engangskode (TOTP) applikation såsom Google Authenticator eller Authy genererer automatisk en autentifikations kode som ændrer sig efter et stykke tid.';
$helptxt['emailmembers'] = 'I denne meddelelse kan du benytte forskellige &quot;variabler&quot;. Disse er:<br />
	{$board_url} - Webadressen til dit forum.<br />
	{$current_time} - Aktuel tid og dato.<br />
	{$member.email} - Email for aktuel bruger.<br />
	{$member.link} - Link til aktuel bruger.<br />
	{$member.id} - ID for aktuel bruger.<br />
	{$member.name} - Navn for aktuel bruger.  (til personliggørelse)<br />
	{$latest_member.link} - Link til den nyeste registrerede bruger.<br />
	{$latest_member.id} - ID for den nyeste registrerede bruger.<br />
	{$latest_member.name} - Navn på den nyeste registrerede bruger.';
$helptxt['attachmentEncryptFilenames'] = 'Kryptering af vedhæftnings fil navne gør at du kan have mere end en vedhæftning med det samme navn og forhøjer sikkerhed.  Det kan dog gøre det mere vanskeligt at genskabe din database hvis noget drastisk hændte.';

$helptxt['failed_login_threshold'] = 'Sæt antallet af forfejlede loginforsøg, før brugeren viderestilles til skærmbilledet autentificeringspåminder.';
$helptxt['loginHistoryDays'] = 'Antallet af dage login historik skal gemmes under bruger profil historik. Standard er 30 dage.';
$helptxt['oldTopicDays'] = 'Hvis denne indstilling er valgt, vil brugeren få en advarsel hvis vedkommende svarer i et emne, der ikke er blevet skrevet i i den angivne tid i dage, specificeret i denne indstilling. Sæt værdien til 0 for at deaktivere funktionen.';
$helptxt['edit_wait_time'] = 'Antal sekunder et indlæg kan redigeres, før seneste redigeringsdato vil blive ændret.';
$helptxt['edit_disable_time'] = 'Antal minutter der skal gå, før en bruger ikke længere kan redigere et indlæg denne selv har oprettet. Sæt til 0 for at deaktivere. <br /><br /><em>Bemærk: Dette vil ikke berøre brugere der har tilladelse til at redigere i andre folks indlæg.</em>';
$helptxt['preview_characters'] = 'Denne indstilling definerer antallet af karakterer for første og sidste besked på emne forhåndsvisning. <strong>Bemærk</strong> dette gør kun informationen tilgængelig for tema, temaet skal understøtte &quot;Vis indlæg forhåndsvisning på beskeds indeks&quot; indstilling';
$helptxt['posts_require_captcha'] = 'Denne indstilling vil tvinge brugere til at skulle gennemgå en anti-spam bot verificering hver gang de opretter et indlæg i et board. Kun brugere med et antal af poster mindre end nummeret angivet er nødt til at skulle skrive koden - dette skal hjælpe i kampen mod automatiserede spammingscripts.';
$helptxt['lastActive'] = 'Indstil antallet af minutter siden sidste aktivitet for at vise folk som aktive på board indeks. Standard er 15 minutter.';

$helptxt['hide_post_group'] = 'Enabling this will not display a member\'s post group title on the message view if they are assigned to a non-post based group.';

$helptxt['customoptions'] = 'Denne sektion definerer valgene en bruger kan vælge fra en drop-down liste. Der er nogle få nøglepunkter der skal bemærkes i denne sektion:
<ul>
<li><strong>Standard valg:</strong> Uanset hvilken valgboks der har &quot;radioknappen&quot; ved siden af sig, vil være standardvalget for brugerne når de går ind i deres profil.</li>
<li><strong>Fjern valg:</strong> For at fjerne et valg skal du blot slette indholdet tekstboksen for den pågældende valgmulighed - alle brugere der har haft brugt den valgmulighed vil få denne slettet.</li>
<li><strong>Reorganisere valgmuligheder:</strong> Du kan reorganisere valgene ved at flytte teksten rundt imellem boksene. Imidlertidigt - en vigtig bemærkning - du skal sikre dig at du <strong>ikke</strong> ændrer teksten når du reorganiserer valgmulighederne, ellers vil data gå tabt.</li>
</ul>';

$helptxt['autoOptDatabase'] = 'Denne indstilling optimerer din database for hver det antal dage der er angivet. Sættes værdien til 1, optimeres din database hver dag. Du kan også angive det maksimale antal brugere der må være online, så du ikke belaster serveren eller generer for mange brugere.';
$helptxt['autoFixDatabase'] = 'Dette vil automatisk reparere ødelagte tabeller og fortsætte som intet var hændt. Dette kan være meget brugbart, da den eneste måde til at fikse den, er at REPARERE tabellen. På denne måde vil dit forum ikke være nede, indtil du erfarer der har været fejl. Du modtager en mail, hvis dette sker.';

$helptxt['enableParticipation'] = '<b>Vis deltagerikoner:</b><br />Dette viser et lille ikon i emnet, brugeren har postet i.';
$helptxt['enableFollowup'] = 'Dette gør det muligt for medlemmerne at starte nye emner med citater fra enhver besked.';

$helptxt['db_persist'] = 'Holder forbindelsen til serveren i live for at øge ydelsen. Hvis du ikke er hostet på en dedikeret server, kan dette give dig problemer med din host.';
$helptxt['ssi_db_user'] = 'Valgfri indstilling til at anvende et andet database brugernavn og kodeord når du anvender SSI.php';

$helptxt['countChildPosts'] = 'Afkrydsning af dette felt betyder at indlæg og emner på et board\'s under-board vil tælle mod dens total på index siden.<br /><br />Dette vil lave ting betydeligt langsommere, men betyder at et board der ikke har nogen indlæg direkte under sig, ikke vil vise \'0\'.';
$helptxt['allow_ignore_boards'] = 'Markering af denne valgmulighed vil tillade brugere at vælge boards de vil ignorere.';
$helptxt['deny_boards_access'] = 'Afkrydsning af dette felt vil give mulighed for at nægte adgang til visse boards baseret på brugergruppe adgang';

$helptxt['who_enabled'] = 'Denne valgmulighed tillader dine brugere at kunne se hvem der browser forummet, samt hvad de foretager sig.';

$helptxt['recycle_enable'] = '<b>Aktiver genetablering af slettede emner:</b><br />Muliggør &quot;genetablering&quot; af slettede emner og indlæg. Emner og indlæg der slettes, flyttes til boardet angivet herunder.';

$helptxt['enableReportPM'] = '<b>Aktiver anmeldelse af personlige beskeder:</b><br />Denne indstilling tillader dine brugere at anmelde personlige beskeder de modtager, til administrationsteamet. Dette kan være hjælpsom til at spore misbrug af det personlige beskedcenter.';
$helptxt['max_pm_recipients'] = '<b>Det maksimale antal modtagere tilladt i personlige beskeder:</b><br />Denne indstilling tillader dig at kontrollere det maksimale antal modtagere en bruger kan sende en besked til ved afsendelse af personlige beskeder. Dette er meget brugbart til at stoppe spamudnyttelse af det personlige beskedcenter. Bemærk at brugere der er tilladt at sende nyhedsbreve, ikke er berørt af denne begrænsning. Sæt værdien til nul for at fjerne begrænsningen.';
$helptxt['pm_posts_verification'] = '<b>Det maksimale antal beskeder brugere må sende, før de skal kvittere med godkendelseskode:</b><br />Denne indstilling tvinger brugere til at skrive en kode vist i et verifikationsbillede, hvergang de sender en personlig besked. Kun brugere der sender et større antal beskeder end det angivede nummer, er nødt til at skulle skrive koden - dette burde hjælpe mod automatiske spammingscripts.';
$helptxt['pm_posts_per_hour'] = 'Dette vil begrænse antallet af personlige beskeder som kan afsendes af en bruger indenfor en 1-times periode. Indstillingen påvirker ikke administratorer og moderatorer.';

$helptxt['default_personal_text'] = 'Indstiller standard tekst en ny bruger vil have som deres &quot;personlig tekst.&quot; Denne mulighed er ikke tilgængelig hvis personlig tekst er deaktiveret, eller hvis brugere kan indstille personlig tekst selv ved registrering.';

$helptxt['modlog_enabled'] = '<b>Log moderatorændringer:</b><br />Logger alle moderatorers handlinger';
$helptxt['userlog_enabled'] = 'Logs all key changes a user makes to their profile.';

$helptxt['registration_method'] = 'Denne indstilling bestemmer hvilken registreringsmetode skal bruges for folk der ønsker at registrere sig på dit forum. Du kan vælge imellem:<br /><br />
	<ul class="normallist">
		<li>
			<strong>Registrering Deaktiveret</strong><br />
				Deaktiverer registrering, hvilket betyder at ingen nye brugere kan registrere sig på dit forum.<br />
		</li><li>
			<strong>Øjeblikkelig Registrering</strong><br />
				Nye brugere kan logge ind og skrive indlæg øjeblikkeligt efter registrering på dit forum.<br />
		</li><li>
			<strong>Email Aktivering</strong><br />
				Når denne indstilling er valgt vil nye brugere der registrerer sig på dit forum modtage en email med et aktiverings link som de skal klikke på for at blive fuldgyldige brugere.<br />
		</li><li>
			<strong>Administrations Godkendelse</strong><br />
				Denne indstilling gør at nye brugere der registrerer sig på dit forum først skal godkendes af en administrator før de kan blive fuldgyldige brugere.
		</li>
	</ul>';

$helptxt['send_validation_onChange'] = 'Hvis dette er aktiveret vil alle brugere som ændrer deres email adresse i deres profil blive krævet at genaktivere deres konto fra en aktiverings email som bliver sendt til den nye adresse.';
$helptxt['send_welcomeEmail'] = '<b>Send velkomstmail til nye medlemmer:</b><br />Hvis denne indstilling er sat, får alle nye medlemmer en e-mail som byder dem velkommen til dit forum';
$helptxt['password_strength'] = 'Denne indstilling bestemmer krævet kompleksitet af bruger kodeord. Jo stærkere adgangskoden er, desto sværere bør det være at kompromittere brugerens konto.
	De følgende valgmuligheder er tilgængelige:
	<ul class="normallist">
		<li><strong>Lav:</strong> Koden skal være mindst 4 karakterer lang.</li>
		<li><strong>Medium:</strong> Koden skal være mindst 8 karakterer lang, og kan ikke indeholde dele af bruger navn eller email adresse.</li>
		<li><strong>Høj:</strong> Samme som medium, plus en kode skal også indeholde en blanding af store og små bogstaver, og mindst et tal.</li>
	</ul>';
$helptxt['enable_password_conversion'] = 'Ved at aktivere denne indstilling, vil ElkArte forsøge at detektere koder som er gemt i andre formater og konvertere dem til denne software.  Typisk dette er brugt for konverterede forums, men kan også have andre anvendelser.  Ved at deaktivere dette vil en bruger ikke være i stand til at logge ind efter en konvertering, og ville være nødsaget til at nulstille deres kode.';

$helptxt['coppaAge'] = 'Værdien i denne boks vil fastsætte minimumsalderen for nye medlemmer, for at disse får øjeblikkelig adgang til forummet.
Ved registrering, vil nye medlemmer skulle bekræfte om de er over denne alder og hvis ikke, enten får deres optagelse afvist eller suspenderet, indtil en forælder/værge-godkendelse falder på plads - afhængigt af typen af registrering.
Hvis værdien \'0\' er valgt, bliver alle andre aldersrestriktioner tilsidesat.';
$helptxt['coppaType'] = 'Hvis aldersbegrænsning er aktiveret, vil denne indstilling definere hvad der sker hvis en bruger under minimumsalderen forsøger at registrere sig i dit forum. Der er to mulige valg:
<ul class="normallist">
<li>
<strong>Afvis deres registrering:</strong><br />
Nye medlemmer under minimumsalderen, bliver øjeblikkelig afvist.<br />
</li><li>
<strong>Forlang forælder/værge godkendelse:</strong><br />
Alle  medlemmer som forsøger at registrere sig og som er under minimumsalderen, vil have deres konto markeret som &quot;afventer godkendelse&quot;, og vil blive præsenteret for en formular hvor deres forældre skal give tilladelse til at blive medlem i forummet.
De vil også blive præsenteret med kontaktdetaljer som du har angivet i indstillingerne, således at de kan sende formularen til administratoren med mail eller fax.
</li>
</ul>';
$helptxt['coppaPost'] = 'Kontaktboksen er krævet for at formularer til at give adgangstilladelse for mindreårige kan sendes til forum administratoren. Disse detaljer vil blive vist til alle nye mindreårige, de er påkrævet for forældre/værge godkendelse. Som minimum skal en postadresse eller fax nummer være angivet.';

$helptxt['allow_hideOnline'] = 'Med denne indstilling vil alle brugere være i stand til at skjule deres online status fra andre brugere (undtaget administratorer). Hvis deaktiveret vil kun brugere med moderator adgang være i stand til at skjule deres status. Bemærk at de-aktivering af denne indstilling ikke vil ændre brugeres nuværende status - det forhindrer dem blot i at skjule deres status i fremtiden.';

$helptxt['latest_support'] = 'Dette panel viser dig nogle af de mest almindelige problemer og spørgsmål vedrørende din server konfiguration. Bare rolig, disse informationer er ikke logget eller noget.<br /><br />Hvis der bliver ved med at stå &quot;Henter support information...&quot;, kan din computer højest sandsynligt ikke forbinde til websiden.';
$helptxt['latest_packages'] = 'Her kan du se nogle af de mest populære og nogle tilfældige pakker, med hurtig og nem installation.<br /><br />Hvis denne sektion ikke dukker op, kan din computer højest sandsynligt ikke forbinde til <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>.';
$helptxt['latest_themes'] = 'Dette område viser et par af de nyeste og mest populære temaer fra <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>.  Det vises muligvis ikke ordentligt, hvis din computer ikke kan forbinde til <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>.';

$helptxt['secret_why_blank'] = 'For din sikkerhed, vil din kode og svar på hemmelige spørgsmål være krypteret så ElkArte kan aldrig fortælle dig, eller nogen andre, hvad de er.';
$helptxt['moderator_why_missing'] = 'Siden moderation er foretaget på et board-til-board basis, skal du lave brugere moderator fra <a href="%1$s?action=admin;area=manageboards" target="_blank" class="new_win">board administrationsinterface</a>.';

$helptxt['permissions'] = 'Tilladelser er hvordan du enten tillader eller nægter medlemsgrupper, at gøre specifikke ting.<br /><br />Du kan ændre flere boards på en gang med checkboksene, eller se tilladelserne for en specifik gruppe ved at klikke på \'Rediger.\'';
$helptxt['permissions_board'] = 'Hvis et board sættes til \'global,\' betyder det at boardet ikke vil have nogle specielle tilladelser. \'Lokal\' betyder det vil have dets egne tilladelser - separat fra de globale. Dette gør dig i stand til at have et board som har flere eller færre tilladelser end andre, uden at du er nødt til at ændre dem for hvert eneste board.';
$helptxt['permissions_quickgroups'] = 'Dette tillader dig hurtigt at sætte nogle &quot;standard&quot; tilladelser - standard betyder \'ingen specielle rettigheder\', begrænset betyder \'som en gæst\', moderator betyder \'rettigheder som moderator\', og til sidst betyder \'Vedligeholder\' rettigheder tæt på dem en administrator har.';
$helptxt['permission_enable_deny'] = 'At nægte tilladelser kan være brugbart hvis du vil fjerne tilladelser fra visse medlemmer. Du kan tilføje en medlemsgruppe med en \'nægt\'-tilladelse til de medlemmer du vil fjerne rettigheder fra.<br /><br />Brug dette med forsigtighed da en nægtet tilladelse vil forblive nægtet, uanset hvilke andre medlemsgruppper medlemmet er en del af.';
$helptxt['permission_enable_postgroups'] = 'Aktivering af tilladelser for grupper baseret på antallet af indlæg, giver dig mulighed for at give tilladelse til medlemmer der har oprettet et vis antal indlæg. Tilladelserne der gives af denne vej, <em>tilføjes</em> til rettighederne fra standard medlemsgrupperne.';
$helptxt['membergroup_guests'] = 'Medlemsgruppen Gæster er alle brugere der ikke er logget ind.';
$helptxt['membergroup_regular_members'] = 'Almindelige medlemmer er alle medlemmer der er logget ind, men ikke er med i nogen primær medlemsgruppe.';
$helptxt['membergroup_administrator'] = 'Administratorer kan per definition gøre alt og se alle boards. Der findes derfor ikke nogen tilladelses indstillinger for administratorer.';
$helptxt['membergroup_moderator'] = 'Moderator bruger gruppe er en speciel bruger gruppe. Tilladelser og indstillinger for denne gruppe, gælder kun <em>på de boards de modererer</em>. Udenfor disse boards, vil de være lige som andre brugere.';
$helptxt['membergroups'] = 'Der er to typer af grupper dine brugere kan være en del af. Disse er:
	<ul class="normallist">
		<li><strong>Regulære Grupper:</strong> En normal gruppe som brugere ikke automatisk er puttet ind i. For at tildele en gruppe til en bruger, gå til deres profil og klik på &quot;Konto Indstillinger&quot;. Herfra kan du tilføje dem til enhver regulær gruppe de skal være del af.</li>
		<li><strong>Grupper baseret på indlæg:</strong> I modsætning til regulære grupper, kan indlæg baserede grupper ikke blive tildelt. I stedet vil brugere automatisk blive tildelt en indlægsgruppe når de opnår det krævede antal indlæg for den gruppe.</li>
	</ul>';

$helptxt['calendar_how_edit'] = 'Du kan redigere disse begivenheder ved at klikke på det røde asterisk (*) ved siden af navnet.';

$helptxt['maintenance_backup'] = 'Dette område tillader dig at gemme en kopi af alle indlæg, indstillinger, medlemmer og anden information fra dit forum, til en meget stor fil.<br /><br />Det er anbefalet at du af sikkerhedsgrunde ofte gør dette, måske en gang om ugen.';
$helptxt['maintenance_rot'] = 'Dette tillader dig <strong>fuldstændig</strong> og <strong>uigenkaldeligt</strong> at fjerne emner.  Det er anbefalet at du først tager en backup, som sikkerhed for at du skulle komme til at slette noget du ikke ville have slettet.<br /><br />Brug denne mulighed med forsigtighed.';
$helptxt['maintenance_members'] = 'Dette tillader dig <strong>komplet</strong> og <strong>uigenkaldelig</strong> at fjerne medlemskonti fra dit forum. Det anbefales <strong>p';

$helptxt['avatar_default'] = 'With this option enabled, a default avatar is shown for all users without their own avatar. The file named \'default_avatar.png\' is located in the images folder inside the themes directory.  If you also enable "Use a default gravatar image for all users without their own avatar.", then a gravatar generated image will be used instead.';
$helptxt['avatar_server_stored'] = 'Dette tillader brugere at vælge en avatar iblandt avatars som er gemt på din server.  De er generelt i det samme sted som forum under avatars mappen.<br />Som et tip, hvis du opretter undermapper i den mappe, kan du lave &quot;kategorier&quot; af avatars.';
$helptxt['avatar_external'] = 'Med dette aktiveret, kan dine medlemmer angive en webadresse til deres egen avatar. Ulempen ved dette kan i visse tilfælde være, at de benytter overdrevent store portrætbilleder du ikke ønsker i dit forum.';
$helptxt['avatar_download_external'] = 'Med denne indstilling aktiveret, vil den webadresse som brugeren angiver, blive brugt til at downloade avataren fra den lokation. Hvis dette er sucessfuldt, vil denne blive behandlet som en avatar der kan uploades.';
$helptxt['avatar_upload'] = 'Denne valgmulighed er meget lig &quot;Tillad medlemmer at vælge en ekstern avatar&quot; bortset at du har bedre kontrol over avatarerne, bedre tid til at reducere dem, og dine medlemmer har ikke behov for at at have et sted at opbevare avatars.<br /><br />Ulempen er at det kan tage en masse plads på din server.';
$helptxt['avatar_resize_options'] = 'Denne vifte af indstillinger gælder alle avatars brugere gemmer til serveren, enten som uploadet eller hentet fra en ekstern URL.';
$helptxt['avatar_download_png'] = 'PNGs are larger, but offer higher quality.  If this is unchecked, JPEG will be used instead, which is often smaller, but also removes transparency and is of lesser or blurry quality.';
$helptxt['gravatar'] = 'Gravatar (globale avatars) er en service for at udbyde globale unikke avatars. For flere detaljer, besøg <a href="http://www.gravatar.com" target="_blank"><strong>Gravatar webside</strong>.</a>';
$helptxt['gravatar_rating'] = 'Gravatar giver brugerne mulighed for selv at vurdere deres billeder, så de kan vurdere om et billede er passende for et bestemt publikum. Som standard er kun \'G\' vurderede billeder vist, med mindre du angiver at du vil se billeder med højere vurdering. <br /><br /><ul><li><strong>g:</strong> egnet til visning på alle hjemmesider med enhver publikationstype.</li><li><strong>pg:</strong> kan indeholde uhøflige gestus, provokerende klædt individer, mindre sværge ord eller mild vold.</li><li><strong>r:</strong> kan indeholde sådanne ting som hård skændsel, intens vold, nøgenhed eller hård narkotika brug.</li><li><strong>x:</strong> kan indeholde hardcore seksuelle billeder eller ekstremt forstyrrende vold.</li></ul>';
$helptxt['disableHostnameLookup'] = 'Dette deaktiverer opslag af hostnavn, hvilket på nogle servere er meget langsom. Bemærk at dette gør bandlysning mindre effektiv.';
$helptxt['url_format'] = 'The UrlGenerator subsystem builds forum links in three interchangeable styles<br /><br />Standard: classic query parameters (default style), e.g. ?topic=123.45;action=print.<br />Semantic: "pretty url" human‑readable URLs with slugs in the path, e.g. ?t/some-topic-title-123/page-45;other=param.<br />Queryless: path and extension based (no normal query string), e.g. ?topic,123.45.html;other=param.';

$helptxt['search_weight_commonheader'] = 'Faktorerne på søgevægten bruges til at fastslå relevansen at et søgeresultat. Ret disse faktorer til at gøre søgningen mere relevant for dit forum. F.eks er søgerelevansen på en nyheds side vægtet meget højt for \'alder af sidste matchende besked\'. Alle værdier er relative i forhold til hinanden, og skal bestå af positive heltal.<br /><br />';
$helptxt['search_weight_frequency'] = 'Denne faktor tæller mængden af matchende meddelelser og deler dem med det samlede antal beskeder inden for et emne.';
$helptxt['search_weight_age'] = 'Denne faktor angiver alderen af den sidste matchende meddelelse inden for et emne. Jo nyere denne besked er, desto højere er resultatet.';
$helptxt['search_weight_length'] = 'Denne faktor er baseret på emnestørrelsen. Jo flere beskeder er inden for emnet, desto højere er resultatet.';
$helptxt['search_weight_subject'] = 'Denne faktor leder efter om et søgeord kan findes inden for området af et emne.';
$helptxt['search_weight_first_message'] = 'Denne faktor leder efter om en match kan findes i den første besked af et emne.';
$helptxt['search_weight_sticky'] = 'Denne faktor leder efter om et emne er pinned og øger relevans score, hvis det er.';
$helptxt['search_weight_likes'] = 'Denne faktor kikker på hvorvidt et emne har Likes og forøger relevans score baseret på dette nummer.';
$helptxt['search'] = 'Juster alle indstillinger der vedrører søgefunktionerne her.';
$helptxt['search_why_use_index'] = 'Et søgeindeks kan kraftigt forbedre ydelsen af søgninger på dit forum. Specielt når antallet af indlæg på dit forum bliver større, søgning uden en indeks kan tage lang tid og vil øge presset på din database. Hvis du har flere end 50,000 indlæg, bør du oprette en søgeindeks for at sikre høj ydelse på dit forum.<br /><br />Bemærk at en søgeindeks kan optage en del plads. En fuld-tekst indeks er en indbygget indeks i databasen. Den er relativ kompakt (omkring samme størrelse som indlægs tabellen), men en del almindelige ord er ikke indekseret og den kan i visse tilfælde vise sig at være langsom. Den brugerdefinerede indeks er større (alt efter din konfiguration kan den være op til 3 gange størrelsen af indlægs tabellen) men ydelsen er ofte bedre end fuld-tekst og indekserer de fleste ord.';

$helptxt['see_admin_ip'] = 'IP-adresser bliver vist til administratorer og moderatorer for at lette moderation af forummet og for at gøre det lettere at spore folk der laver ballade. Husk på at IP-adresser ikke altid er identificererende , og at de flestes IP-adresse skifter periodisk.<br /><br />Medlemmer er også tilladt at se deres egne IP-adresser.';
$helptxt['see_member_ip'] = 'Din Ip-adresse vises kun til dig og moderatorer. Husk at denne information ikke er identificerende, og at de flestes IP-adresse skifter periodisk.<br /><br />Du kan ikke se andre medlemmers IP-adresser, og de kan ikke se din.';
$helptxt['whytwoip'] = 'Forskellige metoder er brugt for at opspore brugerens IP adresse. Normalt vil disse to metoder resultere i den samme adresse, men i visse tilfælde vil mere end en adresse blive fundet. I dette tilfælde vil begge adresser blive logget, og begge vil blive brugt for ban checks (etc). Du kan klikke på begge adresser for at spore den IP og ban hvis nødvendigt.';

$helptxt['ban_cannot_post'] = '\'Kan ikke poste\' restriktionen gør forummet til read-only tilstand for den bannede bruger. Brugeren kan ikke oprette nye emner eller svare på eksisterende emner, sende personlige beskeder eller stemme i afstemninger. Det bandlyste medlem kan dog stadig læse personlige beskeder og emner.<br /><br />En advarsel vises på denne måde til de medlemmer der er bandlyste.';

$helptxt['posts_and_topics'] = '
	<ul class="normallist">
		<li>
			<strong>Post Settings</strong><br />
			Modify the settings related to the posting of messages and the way messages are shown.
		</li><li>
			<strong>Censored Words</strong>
			In order to keep the language on your forum under control, you can censor certain words. This function allows you to convert forbidden words into innocent versions.
		</li><li>
			<strong>Topic Settings</strong>
			Modify the settings related to topics. The number of topics per page, whether pinned topics are enabled or not, the number of messages needed for a topic to be hot, etc.
		</li>
	</ul>';
$helptxt['allow_no_censored'] = 'When checked, this global setting allows members to disable word censoring in their User Profile through the Look and Layout settings. The members\' ability to disable word censoring is still limited by their permission profile.';
$helptxt['spider_mode'] = 'Definerer logging niveau.<br />
Standard - Logger minimal spider aktivitet.<br />
Moderat - Givere mere korrekt statistik.<br />
Aggressiv - Samme som &quot;Moderat&quot; men logger også data om hver enkelt besøgt side.';

$helptxt['spider_group'] = 'Ved at vælge en restriktiv gruppe, når en gæst er sporet til at være en søgerobot, vil den automatisk blive tildelt alle &quot;nægt&quot; tilladelser i den gruppe i forhold til de normale tilladelser for gæster. Du kan anvende dette til at give mere restriktiv adgang til søgerobotter end du ville give til en normal gæst. Du kan f.eks oprette en ny gruppe kaldet &quot;Søgemaskiner&quot; og vælge den her. Du kan så nægte den gruppe at se profiler for at forhindre søgerobotter i at indeksere dine medlemmers profiler.<br />Bemærk: sporing af søgerobotter virker ikke perfekt og kan blive simuleret af brugere, så denne funktion garanterer ikke at kun søgemaskiners adgang indskrænkes.';
$helptxt['show_spider_online'] = 'Denne indstilling tillader dig at vælge hvorvidt søgerobotter skal listes i hvem er online listen på boardindekset og &quot;Hvem er Online&quot; siden. Valgene er:
<ul class="normallist">
<li><strong>Slet Ikke</strong>
<br />Søgerobotter vil simpelthen blive vist som gæster til alle brugere. </li><li> <strong>Vis søgerobot-mængde</strong><br /> Boardindekset vil vise antallet af søgerobotter som i øjeblikket gæster forummet. </li><li> <strong>Vis navne på søgerobotter</strong><br /> Hvert søgerobot navn vil blive afsløret, så brugere kan se hvor mange af hver søgerobot der i øjeblikket besøger forummet - dette tager effekt i både Boardindekset og Hvem er Online siden. </li><li> <strong>Vis navne på søgerobotter - Kun Admin</strong><br /> Som ovenfor bortset fra at kun Administratorer kan se status på søgerobotter - for alle andre brugere optræder søgerobotter som gæster. </li> </ul>';
$helptxt['spider_no_guest'] = 'By selecting this, the spider will only be a member of the restrictive group and have the permissions and board access of that group (no guest access). You can use this to provide lesser access to a search engine than you would a normal guest. You might for example wish to remove spiders from indexing certain boards while still allowing guest viewing.';

$helptxt['birthday_email'] = 'Vælg indekset for den fødselsdags-e-mail der skal benyttes. En forhåndsvisning vil blive vist i e-mailens Emne og Beskedfelt.<br /><strong>Bemærk:</strong> Indstilling af denne valgmulighed aktiverer ikke automatisk e-mails til fødselsdage. For at aktivere e-mails til fødselsdage skal du bruge siden <a href="%1$s?action=admin;area=scheduledtasks;%3$s=%2$s" target="_blank" class="new_win">Planlagte opgaver</a> og aktivere opgaven til fødslesdags-e-mail.';
$helptxt['pm_bcc'] = 'Når du sender en personlig besked kan du vælge at tilføje en modtager som BCC eller &quot;Blind Carbon Copy&quot;. BCC modtagere får ikke deres identitet afsløret for andre modtagere af beskeden.';

$helptxt['move_topics_maintenance'] = 'Dette vil tillade dig at flytte alle indlæggene fra et board til et andet.';
$helptxt['maintain_reattribute_posts'] = 'Du kan benytte denne funktion til at tildele gæsteindlæg i dit board til et registreret medlem. Dette er brugbart hvis f.eks et medlem slettede sin konto, fortrød det og ønsker sine gamle indlæg associeret til sin konto igen.';
$helptxt['chmod_flags'] = 'Du kan manuelt sætte rettigheder du ønsker at tildele de valgte filer. For at gøre dette, indtast chmod værdien som en numerisk (oktet) værdi. Bemærk at disse flag ingen effekt vil have på Microsoft Windows baserede operativ systemer.';

$helptxt['postmod'] = 'Denne sektion tillader medlemmer af moderationsteamet (med tilstrækkelige rettigheder) at godkende indlæg og emner før de vises.';

$helptxt['field_show_enclosed'] = 'Indkapsler bruger input mellem tekst og HTML kode. Dette tillader dig at tilføje flere instant messaging udbydere, billeder eller indlejring, osv. For eksempel:<br /><br />
		&lt;a href="http://website.com/{INPUT}"&gt;&lt;img src="{DEFAULT_IMAGES_URL}/icon.png" alt="{INPUT}" /&gt;&lt;/a&gt;<br /><br />
		Du kan bruge følgende variabler:<br />
		<ul class="normallist">
			<li>{INPUT} - Input angivet af brugeren.</li>
			<li>{KEY} - Nøglen specificeret for en vis værdi af select box eller radio knapper i admin panelet. Som regel til brug ved lokalisering eller til CSS af Javascript elementer (f.eks et class navn).</li>
			<li>{SCRIPTURL} - Webadresse på forum.</li>
			<li>{IMAGES_URL} - Webadresse på billede mappen for brugerens nuværende tema.</li>
			<li>{DEFAULT_IMAGES_URL} - Webadresse på billede mappen for standard temaet.</li>
		</ul>';

$helptxt['custom_mask'] = 'The input mask is important for your forum\'s security. Validating the input from a user can help to ensure that data is not used in a way you do not expect. We have provided some simple regular expressions as hints.<br /><br />
	<div class="smalltext custom_mask">
		&quot;~[A-Za-z]+~&quot; - Match all upper and lower case alphabet characters.<br />
		&quot;~[0-9]+~&quot; - Match all numeric characters.<br />
		&quot;~[A-Za-z0-9]{7}~&quot; - Match all upper and lower case alphabet and numeric characters seven times.<br />
		&quot;~[^0-9]?~&quot; - Forbid any number from being matched.<br />
		&quot;~^([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$~&quot; - Only allow 3 or 6 character hexcodes.<br />
	</div><br /><br />
	Additionally, special metacharacters ?+*^$ and {xx} can be defined.
	<div class="smalltext custom_mask">
		? - None or one match of previous expression.<br />
		+ - One or more of previous expression.<br />
		* - None or more of previous expression.<br />
		{xx} - An exact number of the previous expression.<br />
		{xx,} - An exact number or more of the previous expression.<br />
		{,xx} - An exact number or less of the previous expression.<br />
		{xx,yy} - An exact match between the two numbers from previous expression.<br />
		^ - Start of string.<br />
		$ - End of string.<br />
		\ - Escapes the next character.<br />
	</div><br /><br />
	More information and advanced techniques may be found on the internet.';

$helptxt['badbehavior_httpbl_maxage'] = 'Dette er antallet af dage siden mistænkelig aktivitet sidst blev observeret fra en specifik IP adresse af Projekt Honey Pot. Bad Behavior vil blokere anmodninger med en maksimal alder lig med eller mindre end denne indstilling.';
$helptxt['badbehavior_httpbl_threat'] = 'Denne værdi angivet et skøn af hvor mistænkelig en specifik IP adresse er, baseret på aktivitet observeret af Projekt Honey Pot. Bad Behavior vil blokere anmodninger med et trussels niveau lig med eller højere end denne indstilling. Projekt Honey Pot har <a href="http://www.projecthoneypot.org/threat_info.php" target="_blank">mere information om denne parameter</a>.';
$helptxt['badbehavior_httpbl_key'] = 'Bad Behavior er i stand til at bruge data fra <a href="http://www.projecthoneypot.org/faq.php#g" target="_blank">http:BL</a> service udbudt af <a href="http://www.projecthoneypot.org/" target="_blank">Projekt Honey Pot</a> for at screene anmodninger.<br /><br />Dette er valgfrit; men ønsker du at benytte det, skal du <a href="http://www.projecthoneypot.org/httpbl_configure.php" target="_blank">tilmelde dig tjenesten</a> og modtage en API nøgle. For at deaktivere brugen af http:BL, fjern API nøglen fra dine indstillinger.';
$helptxt['badbehavior_accept_header'] = 'This enforces that a proper Accept header be send with requests.  All browsers due this by default, but many scrappers/harvesters do not and will be blocked.';

$helptxt['filter_to'] = 'Erstat funden tekst med dette, efterlad blankt for at erstatte den fundne tekst med ingenting (altså fjerne det)';
$helptxt['filter_from'] = 'Indtast tekst du vil finde/erstatte.  Hvis type er sat til regex skal dette være en korrekt almindelig udtryk, inklusiv afgrænser.  Hvis det ikke er regex hvil den lave en simpel tekst match og erstatte den med erstatnings tekst';
$helptxt['filter_type'] = 'Standard vil søge efter den nøjagtige indtastning og erstatte den med tekst i erstat feltet. Almindelig Udtryk er en wildcard mulighed, men skal være i gyldig regex format.';
$helptxt['pbe_post_enabled'] = 'Aktiver dette for at tillade brugere at svare på email notifikationer og have dem indrykket som et svar.  De skal stadig have rettigheder til at lave indlæg.';
$helptxt['pbe_pm_enabled'] = 'Aktiver dette for at tillade brugere at svare på Personlige Beskeder email notifikationer.  De skal stadig have rettigheder til at sende Personlige Beskeder, denne indstilling tillader dem kun at modtage og svare på notifikationer.';
$helptxt['maillist_group_mode'] = 'Hvis dette er aktivt, vil udgående indlæg/emne emails se ud til at komme fra navnet på dem der skrev dem, ellers vil de komme fra side navnet.  Dette er blot en kuvert som kun vil påvirke hvordan "Fra navn" vises i modtagerens mailbakke, den faktuelle email adresse ændrer sig ikke.';
$helptxt['maillist_newtopic_change'] = 'Dette vil tillade en bruger at ændre emnet på en email notifikation og indrykke den som et nyt emne.  Det nye emne vil blive startet på samme board som svaret ville være gået til.';
$helptxt['maillist_sitename_address'] = 'Dette skal være adressen, der er knyttet til emailpost.php filen eller adressen til IMAP postkassen';
$helptxt['maillist_help_short'] = 'Denne funktion tillader brugere af dit forum at svare på email notifikationer de modtager fra siden og have disse svar indrykket på forum.  Besøg Wiki for fulde instruktioner.';

$helptxt['frame_security'] = 'X-Frame-Options HTTP svar header kan bruges til at indikere om en browser er tilladt at loade en side i en frame eller iframe. Du kan bruge denne yderligere sikkerheds restriktion på din side imod såkaldt "clickjacking" angreb, for at sikre at indholdet på din side ikke er indlemmet ind i andre sider.
	<br />
	Mere information om denne header kan findes på internettet.';

$helptxt['attachment_inline_title'] = '<b>Tilføj en in line vedhæftning</b><br />
		Eksempel:
		<br /><b>[attach align=left width=400]123[/attach]</b>
		<br />Dette vil vise et venstre orienteret billede skaleret til 400 pixels bredde med indlægstekst flydende omkring det. Undtaget for vedhæftnings tag og vedhæftnings id er alle parametre valgfri
		<br /><b>[attach]123[/attach]</b>
		<br />Dette vil vise en vedhæftning som en miniature hvis tilgængelig, hvis ingen miniature er tilgængelig vil det fuld størrelse billede blive vist. Billedet vil være på linje med teksten på dit indlæg.
		<br /><br />
		<br /><b>Muligheder:</b>
		<br />hvor x er vedhæftnings id
		<br />align=left, center, right
		<br />width=### (hvor # er antal af pixels)
		<br />height=### (hvor # er antal af pixels)
		<br />
		<h3>Tilstande tilgængelige</h3>
		<p>
			Du kan vælge den in line tilstand du vil for din vedhæftning:
			<ul>
				<li>Miniature [attach]x[/attach] : Dit billede vil blive vist som en miniature</li>
				<li>Tekst Link [attachurl]x[/attachurl] : Kun et link er vist med størrelse og vis detaljer. Ved at klikke på det, vil selve billedet blive vist.</li>
			</ul>
		</p><br />
		<p>
			Du kan vælge hvordan du vil orientere dit in line billede:
			<ul>
				<li>align=left : Billedet bliver orienteret til venstre og teksten vil flyde omkring det</li>
				<li>align=right : Billedet bliver orienteret til højre og teksten vil flyde omkring det</li>
				<li>align=center : Billedet bliver centreret og teksten vil være under det</li>
			</ul>
		</p><br />
		<p>
			Du kan vælge hvor bredt du vil vise billedet:
			<ul>
				<li>width=123 : Billedet er vist 123 pixels bredt</li>
				<li>Hvis den angivne bredde er større end billedet eller den tilladte bredde på forum, vil den størst tilladte bredde blive brugt</li>
				<li>Kan bruges til at formindske en miniature også [attach width=50]x[/attach] vil vise en 50px bred miniature</li>
			</ul>
		</p><br />
		<p>
			Du kan vælge hvor højt du vil vise billedet:
			<ul>
				<li>height=123 : Billedet er vist 123 pixels højt</li>
				<li>Hvis den angivne højde er større end billedet eller den tilladte højde på forum, vil den højest tilladte højde blive brugt</li>
				<li>Kan bruges til at formindske en miniature også [attach height=50]x[/attach] vil vise en 50px høj miniature</li>
			</ul>
		</p>';
