<?php
// Version: 2.0; index

global $forum_copyright;

// Locale (strftime, pspell_new) and spelling.
// For more information see:
//   - https://www.php.net/function.pspell-new
//   - https://www.php.net/function.setlocale
$txt['lang_locale'] = 'da_DK.utf8';
$txt['lang_dictionary'] = 'da';
$txt['lang_spelling'] = 'danish';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set and right to left?
$txt['lang_rtl'] = false;
// Capitalize day and month names?
$txt['lang_capitalize_dates'] = true;
// Number format.
$txt['number_format'] = '1.234,00';

$txt['sunday'] = 'Søndag';
$txt['monday'] = 'Mandag';
$txt['tuesday'] = 'Tirsdag';
$txt['wednesday'] = 'Onsdag';
$txt['thursday'] = 'Torsdag';
$txt['friday'] = 'Fredag';
$txt['saturday'] = 'Lørdag';

$txt['sunday_short'] = 'Søn';
$txt['monday_short'] = 'Man';
$txt['tuesday_short'] = 'Tir';
$txt['wednesday_short'] = 'Ons';
$txt['thursday_short'] = 'Tor';
$txt['friday_short'] = 'Fre';
$txt['saturday_short'] = 'Lør';

$txt['january'] = 'Januar';
$txt['february'] = 'Februar';
$txt['march'] = 'Marts';
$txt['april'] = 'April';
$txt['may'] = 'Maj';
$txt['june'] = 'Juni';
$txt['july'] = 'Juli';
$txt['august'] = 'August';
$txt['september'] = 'September';
$txt['october'] = 'Oktober';
$txt['november'] = 'November';
$txt['december'] = 'December';

$txt['january_titles'] = 'Januar';
$txt['february_titles'] = 'Februar';
$txt['march_titles'] = 'Marts';
$txt['april_titles'] = 'April';
$txt['may_titles'] = 'Maj';
$txt['june_titles'] = 'Juni';
$txt['july_titles'] = 'Juli';
$txt['august_titles'] = 'August';
$txt['september_titles'] = 'September';
$txt['october_titles'] = 'Oktober';
$txt['november_titles'] = 'November';
$txt['december_titles'] = 'December';

$txt['january_short'] = 'Jan';
$txt['february_short'] = 'Feb';
$txt['march_short'] = 'Mar';
$txt['april_short'] = 'Apr';
$txt['may_short'] = 'Maj';
$txt['june_short'] = 'Jun';
$txt['july_short'] = 'Jul';
$txt['august_short'] = 'Aug';
$txt['september_short'] = 'Sep';
$txt['october_short'] = 'Okt';
$txt['november_short'] = 'Nov';
$txt['december_short'] = 'Dec';

$txt['time_am'] = 'am';
$txt['time_pm'] = 'pm';

// Let's get all the main menu strings in one place.
$txt['main_menu'] = 'Hovedmenu';
$txt['home'] = 'Hjem';
$txt['community'] = 'Forum';
$txt['forum'] = 'Forum';

// Sub menu labels
$txt['help'] = 'Hjælp';
$txt['search'] = 'Søg';
$txt['calendar'] = 'Kalender';
$txt['members'] = 'Medlemmer';
$txt['recent_posts'] = 'Nylige indlæg';
$txt['recent_topics'] = 'Seneste Emner';

$txt['admin'] = 'Admin';
// Sub menu labels
$txt['errlog'] = 'Fejllog';
$txt['package'] = 'Tilføjelsesprogram';
$txt['edit_permissions'] = 'Tilladelser';
$txt['modSettings_title'] = 'Funktioner og indstillinger';
$txt['pwa_label'] = 'Webapplikation';

$txt['moderate'] = 'Moderer';
// Sub menu labels
$txt['modlog_view'] = 'Moderationslog';
$txt['mc_emailerror'] = 'Ikke-godkendte Emails';
$txt['mc_reported_posts'] = 'Rapporterede indlæg';
$txt['mc_reported_pms'] = 'Rapporterede Personlige Beskeder';
$txt['mc_unapproved_attachments'] = 'Ikke-godkendte vedhæftninger';
$txt['mc_unapproved_poststopics'] = 'Ikke-godkendte indlæg og emner';

$txt['pm_short'] = 'Mine beskeder';
// Sub menu labels
$txt['pm_menu_read'] = 'Læs dine beskeder';
$txt['pm_menu_send'] = 'Send en besked';

$txt['account_short'] = 'Min Konto';
// Sub menu labels
$txt['profile'] = 'Profil';
$txt['mydrafts'] = 'Mine Kladder';
$txt['summary'] = 'Oversigt';
$txt['theme'] = 'Udseende og layout';
$txt['account'] = 'Kontorelaterede indstillinger';
$txt['forumprofile'] = 'Forumprofil';

$txt['view_unread_category'] = 'Nye indlæg';
$txt['view_replies_category'] = 'Nye Svar';

$txt['login'] = 'Log ind';
$txt['register'] = 'Registrer';
$txt['logout'] = 'Log ud';
// End main menu strings.

$txt['save'] = 'Gem';

$txt['modify'] = 'Rediger';
$txt['forum_index'] = '%1$s - indeks';
$txt['board_name'] = 'Board navn';
$txt['posts'] = 'Indlæg';

$txt['member_postcount'] = 'Indlæg';
$txt['no_subject'] = '(Intet emne)';
$txt['view_profile'] = 'Vis profil';
$txt['guest_title'] = 'Gæst';
$txt['author'] = 'Ophavsmand';
$txt['on'] = 'dato';
$txt['remove'] = 'Fjern';
$txt['start_new_topic'] = 'Opret nyt emne';

// Use numeric entities in the below string.
$txt['username'] = 'Brugernavn';
$txt['password'] = 'Kodeord';

$txt['username_no_exist'] = 'Det brugernavn eksisterer ikke.';
$txt['no_user_with_email'] = 'Der er ikke noget brugernavn associeret med den e-mail-adresse.';

$txt['board_moderator'] = 'Moderator';
$txt['remove_topic'] = 'Fjern';
$txt['topics'] = 'Emner';
$txt['modify_msg'] = 'Rediger indlæg';
$txt['name'] = 'Navn';
$txt['email'] = 'E-mail';
$txt['user_email_address'] = 'E-mail-adresse';
$txt['subject'] = 'Emne';
$txt['message'] = 'Besked';
$txt['redirects'] = 'Redirigeringer';

$txt['choose_pass'] = 'Vælg kodeord';
$txt['verify_pass'] = 'Bekræft kodeord';
$txt['position'] = 'Position';
$txt['notify_announcements'] = 'Tilmeld for at modtage vigtige side nyheder på email';

$txt['profile_of'] = 'Vis profilen for';
$txt['total'] = 'Total';
$txt['posts_made'] = 'Indlæg';
$txt['topics_made'] = 'Emner';
$txt['website'] = 'Webside';
$txt['contact'] = 'Kontakt Os';
$txt['warning_status'] = 'Advarselsstatus';
$txt['user_warn_watch'] = 'Brugeren er på moderatorernes overvågningsliste';
$txt['user_warn_moderate'] = 'Brugerens indlæg bliver lagt i godkendelseskøen';
$txt['user_warn_mute'] = 'Brugeren er udelukket fra at poste';
$txt['warn_watch'] = 'Overvåget';
$txt['warn_moderate'] = 'Moderat';
$txt['warn_mute'] = 'Dæmpet';
$txt['warning_issue'] = 'Advar';

$txt['message_index'] = 'Emneindeks';
$txt['news'] = 'Nyheder';
$txt['page'] = 'Side';
$txt['prev'] = 'forrige';
$txt['next'] = 'næste';

$txt['post'] = 'Gem';
$txt['error_occurred'] = 'Der er opstået en fejl!';
$txt['send_error_occurred'] = 'Der er opstået en fejl, <a href="{href}">Klik her for at forsøge igen</a>.';
$txt['require_field'] = 'Dette felt er påkrævet.';
$txt['started_by'] = 'Startet af forfatter';
$txt['topic_started_by'] = 'Startet af %1$s';
$txt['topic_started_by_in'] = 'Startet af %1$s i %2$s';
$txt['replies'] = 'Svar';
$txt['last_post'] = 'Nyeste indlæg';
$txt['first_post'] = 'Første indlæg';
$txt['last_poster'] = 'Seneste indlæg forfatter';

$txt['last_post_message'] = '<span class="lastpost_link">%2$s </span><span class="board_lastposter">af %1$s</span><span class="board_lasttime"><strong>Seneste indlæg: </strong>%3$s</span>';
$txt['boardindex_total_posts'] = '%1$s Indlæg i %2$s Emner af %3$s Brugere';
$txt['show'] = 'Vis';
$txt['hide'] = 'Skjul';
$txt['sort_by'] = 'Sorter efter';
$txt['sort_asc'] = 'Sorter stigende';
$txt['sort_desc'] = 'Sorter faldende';

$txt['admin_login'] = 'Administrator log ind';
// Use numeric entities in the below string.
$txt['topic'] = 'Emne';
$txt['notify'] = 'Abonner';
$txt['unnotify'] = 'Fjern abonnement';
$txt['notify_request'] = 'Vil du have en meddelelsesmail hvis nogen svarer på dette emne?';
// Use numeric entities in the below string.
$txt['regards_team'] = "Med venlig hilsen,\nTeamet fra {forum_name_html_unsafe}.";
$txt['notify_replies'] = 'Besked ved svar';
$txt['move_topic'] = 'Flyt';
$txt['move_to'] = 'Flyt til';
$txt['pages'] = 'Sider';
$txt['users_active'] = 'Aktive i de seneste %1$d minutter';
$txt['personal_messages'] = 'Personlige beskeder';
$txt['reply_quote'] = 'Svar med citat';
$txt['reply'] = 'Svar';
$txt['reply_number'] = 'Svar #%1$s';
$txt['approve'] = 'Godkend';
$txt['unapprove'] = 'Fjern godkendelse';
$txt['approve_all'] = 'godkend alle';
$txt['awaiting_approval'] = 'Afventer godkendelse';
$txt['attach_awaiting_approve'] = 'Vedhæftninger der afventer godkendelse';
$txt['post_awaiting_approval'] = 'Bemærk: Dette indlæg afventer godkendelse fra en moderator.';
$txt['there_are_unapproved_topics'] = 'Der er %1$s emner og %2$s indlæg der afventer godkendelse i dette board. <a href="%3$s">Klik her for at vise dem</a>.';
$txt['send_message'] = 'Send besked';

$txt['msg_alert_no_messages'] = 'du har ikke nogen beskeder';
$txt['msg_alert_one_message'] = 'du har <a href="%1$s">1 besked</a>';
$txt['msg_alert_many_message'] = 'du har <a href="%1$s">%2$d beskeder</a>';
$txt['msg_alert_one_new'] = '1 er ny';
$txt['msg_alert_many_new'] = '%1$d er nye';
$txt['remove_message'] = 'Fjern denne meddelelse';

$txt['topic_alert_none'] = 'Ingen indlæg...';
$txt['pm_alert_none'] = 'Ingen indlæg...';

$txt['online_users'] = 'Brugere online'; //Deprecated
$txt['online_now'] = 'Online nu';
$txt['personal_message'] = 'Personlig besked';
$txt['jump_to'] = 'Gå til';
$txt['go'] = 'Start';
$txt['are_sure_remove_topic'] = 'Er du sikker på du vil fjerne dette emne?';
$txt['yes'] = 'Ja';
$txt['no'] = 'Nej';

// @todo this string seems a good candidate for deprecation
$txt['search_on'] = 'dato';

$txt['all'] = 'Vis alle';
$txt['search_entireforum'] = 'Hele Forum';
$txt['search_thisbrd'] = 'Dette board';
$txt['search_thistopic'] = 'Dette emne';
$txt['search_members'] = 'Medlemmer';

$txt['back'] = 'Tilbage';
$txt['continue'] = 'Fortsæt';
$txt['password_reminder'] = 'Kodeordspåmindelse';
$txt['topic_started'] = 'Emne startet af';
$txt['title'] = 'Titel';
$txt['post_by'] = 'Indlæg af';
$txt['welcome_newest_member'] = 'Velkommen til %1$s, vores nyeste bruger.';
$txt['admin_center'] = 'Administrationscenter';
$txt['admin_session_active'] = 'Du har en aktiv admin session i gang. Vi anbefaler at du <strong><a class="strong" href="%1$s">slutter denne session</a></strong> når du er færdig med de administrative opgaver.';
$txt['admin_maintenance_active'] = 'Dit forum er i øjeblikket i vedligeholdelses tilstand, kun admins kan logge ind.  Husk at <strong><a class="strong" href="%1$s">slutte vedligeholdelse</a></strong> når du er færdig med de administrative opgaver.';
$txt['query_command_denied'] = 'De følgende MySQL fejl opstod, kontroller din setup:';
$txt['query_command_denied_guests'] = 'Det ser ud til at der er gået noget galt på forum med databasen. Dette problem skulle kun være midlertidigt, så kom tilbage senere og prøv igen. Hvis du fortsætter med at se denne besked, så rapporter den følgende besked til administratoren:';
$txt['query_command_denied_guests_msg'] = 'kommandoen %1$s blev nægtet af databasen';
$txt['last_edit_by'] = '<span class="lastedit">Seneste Redigering</span>: %1$s by %2$s';
$txt['notify_deactivate'] = 'Vil du deaktivere meddelelser fra dette emne?';

$txt['date_registered'] = 'Dato for registrering';
$txt['date_joined'] = 'Sluttet til';
$txt['date_joined_format'] = '%b %d, %Y';
$txt['last_seen'] = 'Sidst set';

$txt['recent_view'] = 'Vis alle nylige indlæg';
$txt['is_recent_updated'] = '%1$s er det seneste opdaterede emne';

$txt['male'] = 'Mand';
$txt['female'] = 'Kvinde';

$txt['error_invalid_characters_username'] = 'Ugyldig karakter i brugernavn.';

$txt['welcome_guest'] = 'Velkommen, <strong>Gæst</strong>. Venligst <a href="{login_url}" rel="nofollow">log ind</a>.';
$txt['welcome_guest_register'] = 'Velkommen til <strong>{forum_name}</strong>. Venligst <a href="{login_url}" rel="nofollow">log ind</a> eller <a href="{register_url}" rel="nofollow">registrer</a>.';
$txt['welcome_guest_activate'] = '<br />Har du savnet din <a href="{activate_url}" rel="nofollow">aktiverings-e-mail</a>?';
$txt['welcome_register'] = 'Har du ikke en konto?';

// @todo the following to sprintf
$txt['hello_member'] = 'Hej,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Velkommen,';
$txt['select_destination'] = 'Vælg venligst en destination';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Postet af';

$txt['icon_smiley'] = 'Smiley';
$txt['icon_angry'] = 'Vred';
$txt['icon_cheesy'] = 'Humørgrin';
$txt['icon_laugh'] = 'Grin';
$txt['icon_sad'] = 'Ked af det';
$txt['icon_wink'] = 'Blink';
$txt['icon_grin'] = 'Grin';
$txt['icon_shocked'] = 'Chokeret';
$txt['icon_cool'] = 'Cool';
$txt['icon_huh'] = 'Spørgsmål';
$txt['icon_rolleyes'] = 'Rullende øjne';
$txt['icon_tongue'] = 'Tunge';
$txt['icon_embarrassed'] = 'Forlegen';
$txt['icon_lips'] = 'Forseglede Læber';
$txt['icon_undecided'] = 'Tvær';
$txt['icon_kiss'] = 'Kys';
$txt['icon_cry'] = 'Græder';
$txt['icon_angel'] = 'Uskyldig';

$txt['moderator'] = 'Moderator';
$txt['moderators'] = 'Moderator';

$txt['views'] = 'Visninger';
$txt['new'] = 'Ny';
$txt['no_redir'] = 'Omdirigeret fra %1$s';

$txt['view_all_members'] = 'Se alle medlemmer';
$txt['view'] = 'Se';

$txt['viewing_members'] = 'Viser medlemmerne %1$s til %2$s';
$txt['of_total_members'] = 'af i alt %1$s medlemmer';

$txt['forgot_your_password'] = 'Glemt dit kodeord?';

$txt['date'] = 'Dato';
// Use numeric entities in the below string.
$txt['from'] = 'Fra';
$txt['to'] = 'Til';

$txt['board_topics'] = 'Emner';
$txt['members_title'] = 'Medlemmer';
$txt['members_list'] = 'Medlemsliste';
$txt['new_posts'] = 'Nye indlæg';
$txt['old_posts'] = 'Ingen nye indlæg';
$txt['redirect_board'] = 'Redirigeret board';
$txt['redirect_board_to'] = 'Omdirigerer til %1$s';

$txt['sendtopic_send'] = 'Send';
$txt['report_sent'] = 'Din rapportering blev afsendt.';
$txt['topic_sent'] = 'Din email er blevet sendt.';

$txt['time_offset'] = 'Tidsforskydning';
$txt['or'] = 'eller';

$txt['mention'] = 'Omtalelser';
$txt['notifications'] = 'Abonnementer';
$txt['unread_notifications'] = 'Du har %1$s ulæste underretninger siden dit sidste besøg.';
$txt['new_from_last_notifications'] = 'Du har %1$s nye underretninger.';
$txt['forum_notification'] = 'Underretninger fra %1$s.';

$txt['your_ban'] = 'Beklager %1$s, du er udelukket fra at bruge dette forum!';
$txt['your_ban_expires'] = 'Denne bandlysning er sat til at udløbe %1$s.';
$txt['your_ban_expires_never'] = 'Denne bandlysning er ikke sat til at udløbe.';
$txt['ban_continue_browse'] = 'Du kan fortsætte med at bruge forummet som gæst.';

$txt['mark_as_read'] = 'Marker ALLE indlæg som læst';
$txt['mark_as_read_confirm'] = 'Er du sikker på du vil markere ALLE beskeder som læst?';
$txt['mark_these_as_read'] = 'Marker DISSE beskeder som læst';
$txt['mark_these_as_read_confirm'] = 'Er du sikker på du vil markere DISSE beskeder som læst?';

$txt['locked_topic'] = 'Låst emne';
$txt['normal_topic'] = 'Normal emne';
$txt['participation_caption'] = 'Emne du har postet i';

$txt['print'] = 'Udskriv';
$txt['topic_summary'] = 'Emneresume';
$txt['not_applicable'] = 'N/A';
$txt['name_in_use'] = 'Navnet %1$s er allerede i brug af en anden bruger.';

$txt['total_members'] = 'Total antal medlemmer';
$txt['total_posts'] = 'Antal indlæg i alt';
$txt['total_topics'] = 'Total antal emner';

$txt['mins_logged_in'] = 'Antal minutter at være logget ind';

$txt['preview'] = 'Udkast';
$txt['always_logged_in'] = 'Forbliv logget ind';

$txt['logged'] = 'Logget';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';

$txt['www'] = 'WWW';
$txt['link'] = 'Link';

$txt['by'] = 'af'; //Deprecated

$txt['hours'] = 'timer';
$txt['minutes'] = 'minutter';
$txt['seconds'] = 'sekunder';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Time';
$txt['days_word'] = 'dage';

$txt['newest_member'] = ', vores nyeste medlem.'; //Deprecated

$txt['search_for'] = 'Søg efter';
$txt['search_match'] = 'Match';

$txt['maintain_mode_on'] = 'Husk, dette forum er i \'Vedligeholdelsesmode\'.';

$txt['read'] = 'Læs'; //Deprecated
$txt['times'] = 'gange'; //Deprecated
$txt['read_one_time'] = 'Læst 1 gang';
$txt['read_many_times'] = 'Læst %1$d gange';

$txt['forum_stats'] = 'Forum stats';
$txt['latest_member'] = 'Nyeste medlem';
$txt['total_cats'] = 'Kategorier i alt';
$txt['latest_post'] = 'Nyeste indlæg';

$txt['here'] = 'her';
$txt['you_have_no_msg'] = 'Du har ingen nye beskeder...';
$txt['you_have_one_msg'] = 'Du har 1 besked...<a href="%1$s">Klik her for at læse den</a>';
$txt['you_have_many_msgs'] = 'Du har %2$d beskeder...<a href="%1$s">Klik her for at læse dem</a>';

$txt['total_boards'] = 'Antal boards i alt';

$txt['print_page'] = 'Udskriv side';
$txt['print_page_text'] = 'Kun tekst';
$txt['print_page_images'] = 'Tekst med billeder';

$txt['valid_email'] = 'Dette skal være en gyldig mailadresse.';

$txt['info_center_title'] = '%1$s - Info-center';

$txt['send_topic'] = 'Del';
$txt['unwatch'] = 'Stop med at følge';
$txt['watch'] = 'Følg';

$txt['allow_user_email'] = 'Tillad brugere at e-maile mig';

$txt['check_all'] = 'Marker alle';

// Use numeric entities in the below string.
$txt['database_error'] = 'Databasefejl';
$txt['try_again'] = 'Prøv venligst igen. Hvis du bliver sendt tilbage til denne fejlmeddelelse, skal du rapportere fejlen til en administrator.';
$txt['file'] = 'Fil';
$txt['line'] = 'Linie';

// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'ElkArte har opdaget og automatisk forsøgt at rette en fejl i din database. Hvis du fortsat har problemer, eller fortsætter med at få disse emails, så kontakt din host.';
$txt['database_error_versions'] = '<strong>Bemærk:</strong> Din database version er %1$s.';
$txt['template_parse_error'] = 'Skabelon afviklingsfejl!';
$txt['template_parse_error_message'] = 'Det ser ud til at noget er gået galt med skabelonsystemet i forummet.  Dette problem bør kun være midlertidigt, så kom venligst tilbage senere og prøv igen. Hvis du fortsat oplever denne fejlmeddelelse, bedes du kontakte administratoren.<br /><br />Du kan også prøve at <a href="javascript:location.reload();">opdatere denne side</a>.';
$txt['template_parse_error_details'] = 'Der opstod et problem med at indlæse  <span class="tt"><strong>%1$s</strong></span> skabelon eller sprog fil.  Check syntaks og prøv igen - husk, single quotes (<span class="tt">\'</span>) skal ofte have en backslash (<span class="tt">\</span>) før dem.  For at se en mere specifik fejl besked fra PHP, prøv <a href="%2$s%1$s">indlæs filen direkte</a>.<br /><br />Du kan muligvis prøve at <a href="javascript:location.reload();">genindlæse denne side</a> eller <a href="%3$s">brug standard tema</a>.';
$txt['template_parse_undefined'] = 'En ukendt fejl opstod under behandling af denne skabelon';

$txt['today'] = 'Idag kl. %1$s';
$txt['yesterday'] = 'Igår kl. %1$s';

// Relative times
$txt['rt_now'] = 'for lidt siden';
$txt['rt_minute'] = 'Et minut siden';
$txt['rt_minutes'] = '%s minutter siden';
$txt['rt_hour'] = 'En time siden';
$txt['rt_hours'] = '%s timer siden';
$txt['rt_day'] = 'En dag siden';
$txt['rt_days'] = '%s dage siden';
$txt['rt_week'] = 'En uge siden';
$txt['rt_weeks'] = '%s uger siden';
$txt['rt_month'] = 'En måned siden';
$txt['rt_months'] = '%s måneder siden';
$txt['rt_year'] = 'Et år siden';
$txt['rt_years'] = '%s år siden';

$txt['new_poll'] = 'Ny afstemning';
$txt['poll_question'] = 'Spørgsmål';
$txt['poll_question_options'] = 'Spørgsmål og optioner';
$txt['poll_vote'] = 'Afgiv stemme';
$txt['poll_total_voters'] = 'Totale antal stemmeafgivende';
$txt['draft_saved_on'] = 'Kladde sidst gemt';
$txt['poll_results'] = 'Se resultater';
$txt['poll_lock'] = 'Lås afstemning';
$txt['poll_unlock'] = 'Oplås afstemning';
$txt['poll_edit'] = 'Rediger afstemning';
$txt['poll'] = 'Afstemning';
$txt['one_day'] = '1 dag';
$txt['one_week'] = '1 uge';
$txt['two_weeks'] = '2 Uger';
$txt['one_month'] = '1 måned';
$txt['two_months'] = '2 Måneder';
$txt['forever'] = 'Altid';
$txt['quick_login_dec'] = 'Log ind med brugernavn, kodeord og sessionslængde';
$txt['one_hour'] = '1 Time';
$txt['moved'] = 'FLYTTET';
$txt['moved_why'] = 'Skriv venligst en kort beskrivelse på<br />hvorfor dette emne bliver flyttet.';
$txt['board'] = 'Board';
$txt['in'] = 'da';
$txt['sticky_topic'] = 'Fremhævet Emne';
$txt['split'] = 'OPDEL';

$txt['delete'] = 'Slet';

$txt['byte'] = 'B';
$txt['kilobyte'] = 'KB';
$txt['megabyte'] = 'MB';
$txt['gigabyte'] = 'GB';

$txt['more_stats'] = '[Flere Stats]';

$txt['code'] = 'Kode';
$txt['code_select'] = '[Vælg]';
$txt['quote_from'] = 'Citat fra';
$txt['quote'] = 'Citer';
$txt['quick_quote'] = 'Citer Valgte';
$txt['quote_new'] = 'Nyt emne';
$txt['follow_ups'] = 'Opfølgninger';
$txt['topic_derived_from'] = 'Emne udsprunget fra %1$s';
$txt['edit'] = 'Rediger';
$txt['quick_edit'] = 'Hurtig Redigering';
$txt['post_options'] = 'Flere muligheder';
$txt['quote_expand'] = 'Vis citat';

$txt['set_sticky'] = 'Fastgør';
$txt['set_nonsticky'] = 'Fjern fastgørelse';
$txt['set_lock'] = 'Lås';
$txt['set_unlock'] = 'Lås op';

$txt['search_advanced'] = 'Vis avancerede indstillinger';
$txt['search_simple'] = 'Skjul avancerede indstillinger';

$txt['security_risk'] = 'STOR SIKKERHEDSRISIKO:';
$txt['not_removed'] = 'Du har ikke fjernet %1$s';
$txt['not_removed_extra'] = '%1$s er en backup af %2$s som ikke blev genereret af ElkArte. Den kan tilgås direkte og kan misbruges til at få uautoriseret adgang til dit forum. Du bør slette den med det samme.';
$txt['generic_warning'] = 'Advarsel';
$txt['agreement_missing'] = 'Du kræver, at nye brugere accepterer en registreringsaftale, men filen (i sources/ElkArte/Languages/Agreement/) eksisterer ikke.';
$txt['agreement_accepted'] = 'Du har lige accepteret aftalen.';
$txt['privacypolicy_accepted'] = 'Du har lige accepteret privatlivsaftalen for forum.';

$txt['new_version_updates'] = 'Du har lige opdateret!';
$txt['new_version_updates_text'] = '<a href="{admin_url};area=credits#latest_updates">Klik her for at se hvad der er nyt i denne version af ElkArte!</a>!';

$txt['cache_writable'] = 'Den cachede mappe er ikke skrivbar - dette vil have betragtelig indflydelse på dit forum.';

$txt['page_created_full'] = 'Side oprettet på %1$.3f sekunder med %2$d forespørgsler.';

$txt['report_to_mod_func'] = 'Brug denne funktion til at informere moderatorer og administratorer om en krænkende eller forkert postet besked.';

$txt['online'] = 'Online';
$txt['member_is_online'] = '%1$s er online';
$txt['offline'] = 'Offline';
$txt['member_is_offline'] = '%1$s er offline';
$txt['pm_online'] = 'Personlig besked (Online)';
$txt['pm_offline'] = 'Personlig besked (Offline)';
$txt['status'] = 'Status';

$txt['skip_nav'] = 'Spring til hovedindholdet';
$txt['go_up'] = 'Gå Op';
$txt['go_down'] = 'Gå ned';

$forum_copyright = '<a href="https://www.elkarte.net" title="ElkArte Forum" target="_blank" class="new_win">Powered by %1$s</a> | <a href="{credits_url}" title="Credits" target="_blank" class="new_win" rel="nofollow">Credits</a>';

$txt['birthdays'] = 'Fødselsdage:';
$txt['events'] = 'Begivenheder:';
$txt['birthdays_upcoming'] = 'Kommende fødselsdage:';
$txt['events_upcoming'] = 'Kommende begivenheder:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Helligdage:';
$txt['calendar_month'] = 'Måned:';
$txt['calendar_year'] = 'År:';
$txt['calendar_day'] = 'Dag:';
$txt['calendar_event_title'] = 'Titel på begivenhed';
$txt['calendar_event_options'] = 'Indstillinger for begivenheden';
$txt['calendar_post_in'] = 'Opret i:';
$txt['calendar_edit'] = 'Rediger begivenhed';
$txt['event_delete_confirm'] = 'Slet denne begivenhed?';
$txt['event_delete'] = 'Slet begivenhed';
$txt['calendar_post_event'] = 'Tilføj begivenhed';
$txt['calendar_link'] = 'Link til kalender';
$txt['calendar_upcoming'] = 'Kommende kalender';
$txt['calendar_today'] = 'Dagens kalender';
$txt['calendar_week'] = 'Uge';
$txt['calendar_week_title'] = 'Uge %1$d af %2$d';
$txt['calendar_numb_days'] = 'Antal dage:';
$txt['calendar_how_edit'] = 'hvordan redigerer du disse begivenheder?';
$txt['calendar_link_event'] = 'Link begivenhed til indlæg:';
$txt['calendar_confirm_delete'] = 'Er du sikker på du vil slette denne begivenhed?';
$txt['calendar_linked_events'] = 'Linkede begivenheder';
$txt['calendar_click_all'] = 'klik for at se alle %1$s';

$txt['moveTopic1'] = 'Opret et emne til omdirigering';
$txt['moveTopic2'] = 'Ændre emnets overskrift';
$txt['moveTopic3'] = 'Nyt emne';
$txt['moveTopic4'] = 'Ændrer overskriften på alle indlæggene';
$txt['move_topic_unapproved_js'] = 'Advarsel! Dette emne er endnu ikke blevet godkendt.\n\nDet anbefales ikke at du opretter et omdirigeringsemne, med mindre du har i sinde at godkende indlægget nu med denne handling.';
$txt['movetopic_auto_board'] = '[BRÆT]';
$txt['movetopic_auto_topic'] = '[EMNE LINK]';
$txt['movetopic_default'] = 'Dette emne er flyttet til [BOARD]

[TOPIC LINK]';
$txt['movetopic_redirect'] = 'Omdiriger til det flyttede emne';
$txt['movetopic_expires'] = 'Slet automatisk det omdirigerede emne';

$txt['merge_to_topic_id'] = 'ID på målemnet';
$txt['split_topic'] = 'Opdel';
$txt['merge'] = 'Flet';
$txt['subject_new_topic'] = 'Tema for nyt emne';
$txt['split_this_post'] = 'Opdel kun dette indlæg.';
$txt['split_after_and_this_post'] = 'Del emnet efter, og inklusive dette indlæg.';
$txt['select_split_posts'] = 'Udvælg indlæg der skal deles.';

$txt['splittopic_notification'] = 'Indsæt en besked når emnet er opdelt';
$txt['splittopic_default'] = 'En eller flere af beskederne i dette emne er blevet flyttet til [BOARD]

[TOPIC LINK]';
$txt['splittopic_move'] = 'Flyt det nye emne til et andet board';

$txt['new_topic'] = 'Nyt emne';
$txt['split_successful'] = 'Emnet er succesfuldt delt op i to emner.';
$txt['origin_topic'] = 'Oprindeligt emne';
$txt['please_select_split'] = 'Vælg venligst hvilke indlæg du ønsker at dele.';
$txt['merge_successful'] = 'Emner flettet.';
$txt['new_merged_topic'] = 'Nyligt flettet emne';
$txt['topic_to_merge'] = 'Emne der skal flettes';
$txt['target_board'] = 'Målboard';
$txt['target_topic'] = 'Målemne';
$txt['merge_confirm'] = 'Er du sikker på du vil flette';
$txt['with'] = 'med';
$txt['merge_desc'] = 'Denne funktion vil flette indlæggene fra to emner sammen til et emne. Indlæggene vil blive sorteret efter datoen de er oprettet. Det ældste oprettede indlæg i de to emner, vil blive det første indlæg i det flettede emne.';

$txt['theme_template_error'] = 'Kan ikke indlæse skabelonen \'%1$s\'.';
$txt['theme_language_error'] = 'Kan ikke indlæse sprogfilen \'%1$s\'.';

$txt['parent_boards'] = 'Underkategorier';

$txt['smtp_no_connect'] = 'Kunne ikke forbinde til SMTP host';
$txt['smtp_port_ssl'] = 'SMTP portindstillingen er forkert; Den skal være port 465 til SSL servere.';
$txt['smtp_bad_response'] = 'Kunne ikke få svar fra mailserveren';
$txt['smtp_error'] = 'Løb ind i problemer med at sende mail. Fejl: ';
$txt['mail_send_unable'] = 'Kan ikke sende mail til e-mailadressen \'%1$s\'';

$txt['mlist_search'] = 'Søg efter brugere';
$txt['mlist_search_email'] = 'Søg efter email';
$txt['mlist_search_group'] = 'Søg efter position';
$txt['mlist_search_name'] = 'Søg efter navn';
$txt['mlist_search_website'] = 'Søg efter webside';
$txt['mlist_search_results'] = 'Søgeresultater på';
$txt['mlist_search_by'] = 'Søg efter %1$s';

$txt['attach_downloaded'] = 'downloadet %1$d gange';
$txt['attach_viewed'] = 'vist %1$d gange';

$txt['settings'] = 'Indstillinger';
$txt['never'] = 'Aldrig';
$txt['more'] = 'flere';

$txt['hostname'] = 'Hostnavn';
$txt['you_are_post_banned'] = 'Beklager %1$s, du er udelukket fra at oprette indlæg eller sende personlige beskeder i dette forum!';
$txt['ban_reason'] = 'Grund';

$txt['add_poll'] = 'Tilføj afstemning';
$txt['poll_options6'] = 'Du må kun markere op til %1$s valgmuligheder.';
$txt['poll_remove'] = 'Fjern afsteming';
$txt['poll_remove_warn'] = 'Er du sikker på at du vil fjerne denne afsteming fra dette emne?';
$txt['poll_results_expire'] = 'Resultater vil blive vist når afstemingen er lukket';
$txt['poll_expires_on'] = 'Afstemingen slutter';
$txt['poll_expired_on'] = 'Afstemingen er lukket';
$txt['poll_change_vote'] = 'Fjern stemme';
$txt['poll_return_vote'] = 'Indstillinger for afstemning';
$txt['poll_cannot_see'] = 'Du kan i øjeblikket ikke se resultatet af denne afstemning.';

$txt['quick_mod_approve'] = 'Godkend valgte';
$txt['quick_mod_remove'] = 'Fjern valgte';
$txt['quick_mod_lock'] = 'Lås/oplås valgte';
$txt['quick_mod_sticky'] = 'Pin/Unpin valgte';
$txt['quick_mod_move'] = 'Flyt valgte til';
$txt['quick_mod_merge'] = 'Flet valgte';
$txt['quick_mod_markread'] = 'Marker valgte som læst';
$txt['quick_mod_go'] = 'Start';
$txt['quickmod_confirm'] = 'Er du sikker på du ønsker at gøre dette?';

$txt['quick_reply'] = 'Hurtig svar';
$txt['quick_reply_warning'] = 'Bemærk! Dette emne er i øjeblikket låst, kun administratorer og moderatører kan svare.';
$txt['quick_reply_verification'] = 'Efter at have afsendt dit indlæg, vil du blive dirigeret til den side for indlæg, for at bekræfte dit indlæg %1$.';
$txt['quick_reply_verification_guests'] = '(krævet for alle gæster)';
$txt['quick_reply_verification_posts'] = '(forlangt for alle brugere med mindre end %1$d indlæg)';
$txt['wait_for_approval'] = 'Bemærk: dette indlæg vil ikke blive vist, før den er blevet godkendt af en moderator.';

$txt['notification_enable_board'] = 'Er du sikker på at du vil aktivere abonnement på nye emner i dette board?';
$txt['notification_disable_board'] = 'Er du sikker på at du vil deaktivere abonnement på nye emner i dette board?';
$txt['notification_enable_topic'] = 'Er du sikker på du vil aktivere abonnement på nye svar i dette emne?';
$txt['notification_disable_topic'] = 'Er du sikker på at du vil deaktivere abonnement på nye svar i dette emne?';

$txt['report_to_mod'] = 'Rapporter Indlæg';
$txt['issue_warning'] = 'Udsted en advarsel';
$txt['issue_warning_post'] = 'Udsted en advarsel på grundlag af dette indlæg';

$txt['like_post'] = 'Synes godt om';
$txt['unlike_post'] = 'Fjern like';
$txt['likes'] = 'Synes godt om';
$txt['liked_by'] = 'Like af:';
$txt['liked_you'] = 'Dig';
$txt['liked_more'] = 'flere';
$txt['likemsg_are_you_sure'] = 'Du har allerede tilføjet en like til denne besked, er du sikker på du vil fjerne din like?';

$txt['unread_topics_visit'] = 'Nyligt ulæste emner';
$txt['unread_topics_visit_none'] = 'Ingen ulæste emner fundet siden dit sidste besøg. <a href="{unread_all_url}" class="linkbutton">Klik her for at prøve alle ulæste emner</a>';
$txt['unread_topics_all'] = 'Alle ulæste emner';
$txt['unread_replies'] = 'Opdaterede Emner';

$txt['who_title'] = 'Hvem er Online';
$txt['who_and'] = ' og ';
$txt['who_viewing_topic'] = ' læser dette emne.';
$txt['who_viewing_board'] = ' læser dette board.';
$txt['who_member'] = 'Medlem';

// Current footer strings
$txt['valid_html'] = 'Gyldig HTML 5';
$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Gæst';
$txt['guests'] = 'Gæster';
$txt['user'] = 'Bruger';
$txt['users'] = 'Brugere';
$txt['hidden'] = 'Skjult';
// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Skjult';
$txt['buddy'] = 'Ven';
$txt['buddies'] = 'Venner';
$txt['most_online_ever'] = 'Flest online';
$txt['most_online_today'] = 'Flest online i dag';

$txt['merge_select_target_board'] = 'Vælg målboardet for det sammenflettede emne';
$txt['merge_select_poll'] = 'Vælg hvilken afstemning det sammenlagte emne skal have';
$txt['merge_topic_list'] = 'Vælg emner der skal flettet';
$txt['merge_select_subject'] = 'Vælg overskriften til det sammenflettede emne';
$txt['merge_custom_subject'] = 'Ny overskrift';
$txt['merge_enforce_subject'] = 'Ændrer overskriften på alle indlæggene';
$txt['merge_include_notifications'] = 'Inkluder abonnementer?';
$txt['merge_check'] = 'Flet?';
$txt['merge_no_poll'] = 'Ingen afsteming';

$txt['response_prefix'] = 'Sv: ';
$txt['current_icon'] = 'Nuværende ikon';
$txt['message_icon'] = 'Indlægsikon';

$txt['smileys_current'] = 'Nuværende smileysæt';
$txt['smileys_none'] = 'Ingen smileys';
$txt['smileys_forum_board_default'] = 'Forum/board-standard';

$txt['search_results'] = 'Søgeresultat';

$txt['totalTimeLogged2'] = ' dage, ';
$txt['totalTimeLogged3'] = ' timer og ';
$txt['totalTimeLogged4'] = ' minutter.';
$txt['totalTimeLogged5'] = 'd';
$txt['totalTimeLogged6'] = 't ';
$txt['totalTimeLogged7'] = 'm';

$txt['approve_thereis'] = 'Der er'; //Deprecated
$txt['approve_thereare'] = 'Der er'; //Deprecated
$txt['approve_member'] = 'et medlem'; //Deprecated
$txt['approve_members'] = 'medlemmer'; //Deprecated
$txt['approve_members_waiting'] = 'afventer godkendelse.'; //Deprecated
$txt['approve_one_member_waiting'] = 'Der er <a href="%1$s">et medlem</a> der venter på godkendelse.';
$txt['approve_many_members_waiting'] = 'Der er <a href="%1$s">%2$d medlemmer</a> der venter på godkendelse.';

$txt['notifyboard_turnon'] = 'Vil du have e-mail når nogen poster et nyt emne i dette board?';
$txt['notifyboard_turnoff'] = 'Er du sikker på at du ikke ønsker at modtage meddelelse om nye emner i dette board?';

$txt['notify_unsubscribed_generic'] = 'specificeret';
$txt['notify_board_unsubscribed'] = 'Emailen, %2$s, er afmeldt og der vil ikke længere blive sendt notifikationer fra boardet "%1$s".';
$txt['notify_topic_unsubscribed'] = 'Emailen, %2$s, er afmeldt og der vil ikke længere blive sendt notifikationer fra emnet "%1$s".';
$txt['notify_mention_unsubscribed'] = 'Emailen, %2$s, er afmeldt og der vil ikke længere blive sendt notifikationer fra "%1$s".';
$txt['notify_default_unsubscribed'] = 'Din anmodning er blevet udført.';

$txt['find_members'] = 'Find medlemmer';
$txt['find_username'] = 'Navn, brugernavn, eller e-mail-adresse';
$txt['find_buddies'] = 'Vis Kun venner?';
$txt['find_wildcards'] = 'Tilladte jokertegn: *, ?';
$txt['find_no_results'] = 'Ingen resultater fundet';
$txt['all_caught_up'] = 'Du er helt opdateret!';
$txt['find_results'] = 'Resultater';
$txt['find_close'] = 'Luk';

$txt['quickmod_delete_selected'] = 'Slet markerede';
$txt['quickmod_split_selected'] = 'Opdel valgte';

$txt['show_personal_messages_heading'] = 'Nye beskeder';
$txt['show_personal_messages'] = 'Du har <strong>%1$s</strong> ulæste personlige beskeder i din indbakke.<br /><br /><a href="%2$s">Gå til din indbakke</a>';

$txt['help_popup'] = 'Spørgsmål?? Forklaring følger:';

$txt['previous_next_back'] = 'forrige emne';
$txt['previous_next_forward'] = 'næste emne';

$txt['upshrink_description'] = 'Formindsk eller ekspander sidehovedet.';

$txt['mark_unread'] = 'Marker som ulæst';

$txt['ssi_not_direct'] = 'Tilgå venligst ikke SSI.php som webadresse direkte; Du kan bruge stien (%1$s) eller tilføje ?ssi_function=et_eller_andet.';
$txt['ssi_session_broken'] = 'SSI.php var ikke i stand til at indlæse en session! Dette kan skabe problemer med at logge ud samt andre funktioner - Check venligst at SSI.php er inkluderet før *noget som helst* andet i alle dine scripts!';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Forhåndsvis indlæg';
$txt['preview_fetch'] = 'Henter forhåndsvisning...';
$txt['pm_error_while_submitting'] = 'Følgende fejl opstod under afsending af denne personlige besked:';
$txt['warning_while_submitting'] = 'Der skete noget, vis det her:';
$txt['error_while_submitting'] = 'Beskeden har følgende fejl som skal rettes før der kan fortsættes:';
$txt['error_old_topic'] = 'Advarsel: der er ikke blevet postet i dette emne i mindst %1$d dage.<br />Med mindre du er sikker på du ønsker at svare, bør du overveje at starte et nyt emne.';

$txt['split_selected_posts'] = 'Valgte indlæg';
$txt['split_selected_posts_desc'] = 'Indlæggene herunder vil efter deling blive til et nyt emne.';
$txt['split_reset_selection'] = 'Nulstil valgene';

$txt['modify_cancel'] = 'Afbryd';
$txt['mark_read_short'] = 'Marker som læst';

$txt['hello_member_ndt'] = 'Hej';

$txt['unapproved_posts'] = 'Ikke-godkendte indlæg (Emner: %1$d, Indlæg: %2$d)';

$txt['ajax_in_progress'] = 'Indlæser...';
$txt['ajax_bad_response'] = 'Ugyldig svar.';

$txt['mod_reports_waiting'] = 'Der er i øjeblikket %1$d moderatorrapporter åbne.';
$txt['pm_reports_waiting'] = 'Der er i øjeblikket %1$d personlige beskeder rapporter åbne.';

$txt['new_posts_in_category'] = 'Klik for at se nye indlæg i %1$s';
$txt['verification'] = 'Bekræftigelse';
$txt['visual_verification_hidden'] = 'Lad denne boks være tom';
$txt['visual_verification_description'] = 'Skriv bogstaverne der vises i billedet';
$txt['visual_verification_request_new'] = 'Forespørg et andet billede';

// @todo Send email strings - should move?
$txt['send_email'] = 'Send email';
$txt['send_email_disclosed'] = 'Bemærk at dette vil være synligt for modtageren.';
$txt['send_email_subject'] = 'E-mail emne';

$txt['ignoring_user'] = 'Du ignorerer denne bruger.';
$txt['show_ignore_user_post'] = '<em>[Vis mig dette indlæg.]</em>';

$txt['spider'] = 'Søgerobot';
$txt['spiders'] = 'Søgerobotter';

$txt['downloads'] = 'Downloads';
$txt['filesize'] = 'Filstørrelse';

// Restore topic
$txt['restore_topic'] = 'Genetabler emne';
$txt['restore_message'] = 'Gendan';
$txt['quick_mod_restore'] = 'Gendan valgte';

// Editor prompt.
$txt['prompt_text_email'] = 'Angiv venligst e-mail-adressen.';
$txt['prompt_text_ftp'] = 'Indskriv FTP adresse.';
$txt['prompt_text_url'] = 'Angiv venligst webadressen du ønsker at linke til.';
$txt['prompt_text_img'] = 'Angiv lokationen for billedet';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Slet emne';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Skabeloner:';
$txt['debug_sub_templates'] = 'Underliggende skabeloner:';
$txt['debug_language_files'] = 'Sprogfiler:';
$txt['debug_sheets'] = 'Style-sheets:';
$txt['debug_javascript'] = 'Scripts:';
$txt['debug_files_included'] = 'Filer inkluderet:';
$txt['debug_kb'] = 'KB.';
$txt['debug_show'] = 'vis';
$txt['debug_cache_hits'] = 'Cache hits:';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s bytes';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss for %2$s bytes';
$txt['debug_queries_used'] = 'Forespørgsler brugt: %1$d. ';
$txt['debug_queries_used_and_warnings'] = 'Forespørgsler brugt: %1$d, %2$d advarsler.';
$txt['debug_query_in_line'] = 'i <em>%1$s</em> linie <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'som tog %1$s sekunder.';
$txt['debug_query_which_took_at'] = 'hvilket tog %1$s sekunder ved %2$s til forespørgsler.';
$txt['debug_show_queries'] = '[Vis forespørgsler]';
$txt['debug_hide_queries'] = '[Skjul forespørgsler]';
$txt['debug_tokens'] = 'Tokens:';
$txt['debug_browser'] = 'Browser ID:';
$txt['debug_hooks'] = 'Hooks kaldt:';
$txt['debug_system_type'] = 'System:';
$txt['debug_server_load'] = 'Server Load:';
$txt['debug_script_mem_load'] = 'Script Hukommelsesforbrug:';
$txt['debug_script_cpu_load'] = 'Script CPU Tid (bruger/system):';

// Video embedding
$txt['preview_image'] = 'Video Forhåndsvisnings billede';
$txt['ctp_video'] = 'Klik for at afspille video';
$txt['hide_video'] = 'Vis/Skjul video';
$txt['youtube'] = 'YouTube:';
$txt['vimeo'] = 'Vimeo:';
$txt['dailymotion'] = 'Dailymotion:';
$txt['tiktok'] = 'TikTok:';
$txt['twitter'] = 'X/Twitter:';
$txt['facebook'] = 'Facebook:';
$txt['instagram'] = 'Instagram:';

// Spoiler BBC
$txt['spoiler'] = 'Spoiler (klik for at vise/skjule)';

$txt['ok_uppercase'] = 'OK';

// Title of box for warnings that admins should see
$txt['admin_warning_title'] = 'Advarsel';

$txt['via'] = 'via';

$txt['like_post_stats'] = 'Like statistik';

$txt['otp_token'] = 'Engangskode';
$txt['otp_enabled'] = 'Aktivér to-faktor-godkendelse';
$txt['invalid_otptoken'] = 'Tids-baseret Engang Kode er ugyldig';
$txt['otp_used'] = 'Tids-baseret Engang Kode er allerede brugt.<br /> Vent venligst et øjeblik og brug den næste kode.';
$txt['otp_generate'] = 'Generer';
$txt['otp_show_qr'] = 'Vis QR-Kode';

$txt['other'] = 'Andre';

$txt['retry'] = 'PRØV IGEN';
$txt['check_connection'] = 'Kontroller venligst din internetforbindelse';
