<?php
// Version: 2.0; MaillistTemplates

// Do not translate anything that is between {}, they are used as replacement variables and MUST
// remain exactly how they are.
// Additionally do not translate the @additional_params: line or the variable names in the lines that follow it.  You may
// translate the description of the variable.
// Do not translate @description:, however you may translate the rest of that line.

/*
	@additional_params: pbe_notify_boards_once_body
		FORUMURL: The url to the forum
		FORUMNAMESHORT: Short or nickname for the forum
		BOARDNAME: Name of the board the post was made in
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		SIGNATURE: The signature of the member who made the post
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
		EMAILREGARDS: The site name signature
	@description: A member wants to be notified of new topics on a board they are watching
*/
$txt['pbe_notify_boards_once_body_subject'] = '[{FORUMNAMESHORT}] {TOPICSUBJECT}';
$txt['pbe_notify_boards_once_body_body'] = 'Et nyt emne, \'{TOPICSUBJECT}\', er blevet startet i \'{BOARDNAME}\'.

{MESSAGE}

{SIGNATURE}


------------------------------------
Beskeds Information:
Flere emner kan blive indrykket, men du vil ikke modtage flere
mail-meddelser (på dette emne) før du returnerer til dette board og læser nogle af dem.
Du kan besvare denne email og have det indtastede indrykket som et emne svar.

{FORUMNAMESHORT} Links:

<*> For at besøge {FORUMNAMESHORT} på web, gå til:
{FORUMURL}

<*> Du kan læse denne besked ved at bruge dette link:
{TOPICLINK}

<*> Afmeld denne meddelse ved at bruge dette link:
{UNSUBSCRIBELINK}

{EMAILREGARDS}';

/*
	@additional_params: pbe_notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
		FORUMURL: The url to the forum
		FORUMNAMESHORT: Short or nickname for the forum
		BOARDNAME: Name of the board the post was made in
		SIGNATURE: The signature of the member who made the post
		EMAILREGARDS: The site name signature
	@description: A new topic has been started in a subscribed board, includes the topic body
*/
$txt['pbe_notify_boards_body_subject'] = '[{FORUMNAMESHORT}] {TOPICSUBJECT}';
$txt['pbe_notify_boards_body_body'] = '
{MESSAGE}

{SIGNATURE}


------------------------------------
Beskeds Information:
{POSTERNAME} har startet emnet \'{TOPICSUBJECT}\' på boardet \'{BOARDNAME}\'
Du kan besvare denne email og have det indtastede indrykket som et emne svar.

{FORUMNAMESHORT} Links:

<*> For at besøge {FORUMNAMESHORT} på web, gå til:
{FORUMURL}

<*> Du kan læse denne besked ved at bruge dette link:
{TOPICLINK}

<*> Du kan gå til din første ulæste besked ved at bruge dette link:
{TOPICLINKNEW}

<*> Afmeld denne meddelse ved at bruge dette link:
{UNSUBSCRIBELINK}

{EMAILREGARDS}';

/*
	@additional_params: pbe_notification_reply_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
		FORUMURL: The url to the forum
		FORUMNAMESHORT: Short or nickname for the forum
		BOARDNAME: Name of the board the post was made in
		SIGNATURE: The signature of the member who made the post
		EMAILREGARDS: The site name signature
	@description: A reply has been made to a topic in a subscribed board, includes the reply body
*/
$txt['pbe_notification_reply_body_subject'] = 'Re: [{FORUMNAMESHORT}] {TOPICSUBJECT}';
$txt['pbe_notification_reply_body_body'] = '
{MESSAGE}

{SIGNATURE}


------------------------------------
Beskeds Information:
{POSTERNAME} har indrykket et svar til emnet \'{TOPICSUBJECT}\' på boardet \'{BOARDNAME}\'
Du kan besvare denne email og have det indtastede indrykket som et emne svar.

{FORUMNAMESHORT} Links:

<*> For at besøge {FORUMNAMESHORT} på web, gå til:
{FORUMURL}

<*> Du kan læse denne besked ved at bruge dette link:
{TOPICLINK}

<*> Du kan gå til din første ulæste besked ved at bruge dette link:
{TOPICLINKNEW}

<*> Afmeld denne {SUBSCRIPTION} ved at bruge dette link:
{UNSUBSCRIBELINK}

{EMAILREGARDS}';

/**
	@additional_params: pbe_notification_reply
	@description: when a topic reply gets approved
 */
$txt['pbe_notification_reply_once_subject'] = $txt['pbe_notification_reply_body_subject'];
$txt['pbe_notification_reply_once_body'] = $txt['pbe_notification_reply_body_body'];

/*
	@additional_params: pbe_notification_reply_body_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
		FORUMURL: The url to the forum
		FORUMNAMESHORT: Short or nickname for the forum
		BOARDNAME: Name of the board the post was made in
		SIGNATURE: The signature of the member who made the post
		EMAILREGARDS: The site name signature
	@description: Full body email notification for the first new reply in a topic
*/
$txt['pbe_notification_reply_body_once_subject'] = 'Re: [{FORUMNAMESHORT}] {TOPICSUBJECT}';
$txt['pbe_notification_reply_body_once_body'] = '
{MESSAGE}

{SIGNATURE}


------------------------------------
Beskeds Information:
{POSTERNAME} har indrykket et svar til emnet \'{TOPICSUBJECT}\' på boardet \'{BOARDNAME}\'
Flere svar kan blive indrykket, men du vil i kke modtage flere mail-meddelselser før du har læst emnet.
Du kan besvare denne email og have det indtastede indrykket som et emne svar.

{FORUMNAMESHORT} Links:

<*> For at besøge {FORUMNAMESHORT} på web, gå til:
{FORUMURL}

<*> Du kan læse denne besked ved at bruge dette link:
{TOPICLINK}

<*> Du kan gå til din første ulæste besked ved at bruge dette link:
{TOPICLINKNEW}

<*> Afmeld denne {SUBSCRIPTION} ved at bruge dette link:
{UNSUBSCRIBELINK}

{EMAILREGARDS}';

/**
	@additional_params: pbe_notification_reply_once
	@description: New reply due to it being approved
 */
$txt['pbe_notification_reply_once_subject'] = $txt['pbe_notification_reply_body_once_subject'];
$txt['pbe_notification_reply_once_body'] = $txt['pbe_notification_reply_body_once_body'];

/*
	@additional_params: pbe_new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The username for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		FORUMNAMESHORT: Short or nickname for the forum
	@description: A notification email sent to the receivers of a personal message
*/
$txt['pbe_new_pm_body_subject'] = 'Ny Personlig Besked: {SUBJECT}';
$txt['pbe_new_pm_body_body'] = 'Du har modtaget en personlig besked fra {SENDER} på {FORUMNAMESHORT}
Beskeden de sendte dig er følgende:

{MESSAGE}

------------------------------------
Beskeds Information:
Du kan besvare denne email og have det indtastede indrykket som et svar til {SENDER}

{FORUMNAMESHORT} Links:

<*> For at besøge {FORUMNAMESHORT} på web, gå til:
{FORUMURL}

<*> Besvar denne Personlige Besked her:
{REPLYLINK}

{EMAILREGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['pbe_new_pm_body_tolist_subject'] = 'Ny Personlig Besked: {SUBJECT}';
$txt['pbe_new_pm_body_tolist_body'] = 'En personlig besked til {TOLIST} er lige blevet sendt fra {SENDER} på {FORUMNAME}

Beskeden der blev sendt er følgende:

{MESSAGE}

------------------------------------
{FORUMNAMESHORT} Links:

<*> For at besøge {FORUMNAMESHORT} på web, gå til:
{FORUMURL}

<*> Besvar denne Personlige Besked her:
{REPLYLINK}

{EMAILREGARDS}';
