<?php
// Version: 2.0; Help

global $helptxt;

$txt['close_window'] = 'Close window';

$helptxt['manage_boards'] = '
	<strong>Edit Boards</strong><br />
	In this menu you can create/reorder/remove boards, and the categories
	above them. For example, if you had a wide-ranging
	site that offered information on &quot;Sports&quot; and &quot;Cars&quot; and &quot;Music&quot;, these
	would be the top-level Categories you\'d create. Under each of these
	categories you\'d likely want to create hierarchical &quot;sub-categories&quot;,
	or &quot;Boards&quot; for topics within each. It\'s a simple hierarchy, with this structure: <br />
	<ul class="normallist">
		<li>
			<strong>Sports</strong>
			&nbsp;- A &quot;category&quot;
			<ul class="normallist">
				<li>
					<strong>Baseball</strong>
					&nbsp;- A board under the category of &quot;Sports&quot;
					<ul class="normallist">
						<li>
							<strong>Stats</strong>
							&nbsp;- A sub-board under the board of &quot;Baseball&quot;
						</li>
					</ul>
				</li>
				<li><strong>Football</strong>
				&nbsp;- A board under the category of &quot;Sports&quot;</li>
			</ul>
		</li>
	</ul>
	Categories allow you to break down the board into broad topics (&quot;Cars,
	&quot;Sports&quot;), and the &quot;Boards&quot; under them are the actual topics under which
	members can post. A user interested in Pintos
	would post a message under &quot;Cars&rarr;Pinto&quot;. Categories allow people to
	quickly find what their interests are: Instead of a &quot;Store&quot; you have
	&quot;Hardware&quot; and &quot;Clothing&quot; stores you can go to. This simplifies your
	search for &quot;pipe joint compound&quot; because you can go to the Hardware
	Store &quot;category&quot; instead of the Clothing Store (where you\'re unlikely
	to find pipe joint compound).<br />
	As noted above, a Board is a key topic underneath a broad category.
	If you want to discuss &quot;Pintos&quot; you\'d go to the &quot;Auto&quot; category and
	jump into the &quot;Pinto&quot; board to post your thoughts in that board.<br />
	Administrative functions for this menu item are to create new boards
	under each category, to reorder them (put &quot;Pinto&quot; behind &quot;Chevy&quot;), or
	to delete the board entirely.';

$helptxt['edit_news'] = '
	<ul class="normallist">
		<li>
			<strong>Nieuws</strong><br />
			Deze sectie stelt je in staat om de tekst van de nieuwsitems op de forumindexpagina te wijzigen.
			Je kunt al het nieuws wat je wil toevoegen (bijv. &quot;Vergeet de bijeenkomst komende dinsdag niet&quot;). Elk nieuwsitem moet in een apart invoervak ingevuld worden. De items worden in willekeurige volgorde getoond.
		</li>
		<li>
			<strong>Nieuwsbrieven</strong><br />
			Deze sectie stelt je in staat om nieuwsbrieven naar de leden van je forum te versturen. Allereerst selecteer je de groepen die je de nieuwsbrief wilt sturen en eventueel ook de groepen die je beslist geen nieuwsbrief wilt sturen. Eventueel kun je ook extra leden en e-mailadressen opgeven waar ook een kopie van de nieuwsbrief naar toegestuurd moet worden. Ten slotte typ je de nieuwsbrief in en kies je of je de nieuwsbrief via PM of via e-mail wilt versturen.
		</li>
		<li>
			<strong>Instellingen</strong><br />
			Deze sectie bevat een aantal instellingen met betrekking tot nieuws en nieuwsbrieven, waaronder een optie waarmee je kunt instellen welke groepen het nieuws kunnen aanpassen. Ook is er een instelling waarmee je nieuwsfeeds op je forum kunt inschakelen, alsook een instelling waarmee je de lengte (in weergeven karakters) voor elk bericht in een nieuwsfeed kunt instellen.
		</li>
	</ul>';

$helptxt['view_members'] = '
	<ul class="normallist">
		<li>
			<strong>View all Members</strong><br />
			View all members in the board. You are presented with a hyperlinked list of member names. You may click
			on any of the names to find details of the members (homepage, age, etc.), and as Administrator
			you are able to modify these parameters. You have complete control over members, including the
			ability to delete them from the forum.<br /><br />
		</li>
		<li>
			<strong>Awaiting Approval</strong><br />
			This section is only shown if you have enabled admin approval of all new registrations. Anyone who registers to join your
			forum will only become a full member once they have been approved by an admin. The section lists all those members who
			are still awaiting approval, along with their email and IP address. You can choose to either accept or reject (delete)
			any member on the list by checking the box next to the member and choosing the action from the drop-down box at the bottom
			of the screen. When rejecting a member you can choose to delete the member either with or without notifying them of your decision.<br /><br />
		</li>
		<li>
			<strong>Awaiting Activation</strong><br />
			This section will only be visible if you have activation of member accounts enabled on the forum. This section will list all
			members who have still not activated their new accounts. From this screen you can choose to either accept, reject or remind
			members with outstanding activations. As above you can also choose to email the member to inform them of the
			action you have taken.<br /><br />
		</li>
	</ul>';

$helptxt['ban_members'] = '<strong>Ban Members</strong><br />
	This provides the ability to &quot;ban&quot; users, to prevent people who have violated the trust of the board
	by spamming, trolling, etc. from continuing. This allows you to ban those users who are detrimental to your forum. As an admin,
	when you view messages, you can see each user\'s IP address used to post at that time. In the ban list,
	you simply type that IP address in, save, and they can no longer post from that location.<br />
	You can also ban people through their email address.';

$helptxt['featuresettings'] = '<strong>Features en opties bewerken</strong><br />
	Er zijn een aantal features in deze sectie die naar jouw inzicht gewijzigd kunnen worden.';

$helptxt['securitysettings'] = '<strong>Beveiliging en moderatie</strong><br />
	Deze sectie bevat de instellingen gerelateerd aan de beveiliging op en moderatie van je forum.';

$helptxt['addonsettings'] = '<strong>Add-On Settings</strong><br />
	This section should contain any settings added by add-ons installed on your forum.';

$helptxt['time_format'] = '<strong>Time Format</strong><br />
	You have the power to adjust how the time and date look for yourself. There are a lot of little letters, but it\'s quite simple.
	The conventions follow PHP\'s strftime function and are described as below (more details can be found at <a href="http://www.php.net/manual/function.strftime.php" target="_blank" class="new_win">php.net</a>).<br />
	<br />
	The following characters are recognized in the format string:<br />
	<span class="smalltext">
	&nbsp;&nbsp;%a - abbreviated weekday name<br />
	&nbsp;&nbsp;%A - full weekday name<br />
	&nbsp;&nbsp;%b - abbreviated month name<br />
	&nbsp;&nbsp;%B - full month name<br />
	&nbsp;&nbsp;%d - day of the month (01 to 31) <br />
	&nbsp;&nbsp;%D<strong>*</strong> - same as %m/%d/%y <br />
	&nbsp;&nbsp;%e<strong>*</strong> - day of the month (1 to 31) <br />
	&nbsp;&nbsp;%H - hour using a 24-hour clock (range 00 to 23) <br />
	&nbsp;&nbsp;%I - hour using a 12-hour clock (range 01 to 12) <br />
	&nbsp;&nbsp;%m - month as a number (01 to 12) <br />
	&nbsp;&nbsp;%M - minute as a number <br />
	&nbsp;&nbsp;%p - either &quot;am&quot; or &quot;pm&quot; according to the given time<br />
	&nbsp;&nbsp;%R<strong>*</strong> - time in 24 hour notation <br />
	&nbsp;&nbsp;%S - second as a decimal number <br />
	&nbsp;&nbsp;%T<strong>*</strong> - current time, equal to %H:%M:%S <br />
	&nbsp;&nbsp;%y - 2 digit year (00 to 99) <br />
	&nbsp;&nbsp;%Y - 4 digit year<br />
	&nbsp;&nbsp;%% - a literal \'%\' character <br />
	<br />
	<em>* Does not work on Windows-based servers.</em></span>';

$helptxt['deleteAccount_posts'] = 'Replies Only: This will remove just the posts this member made in reply to other posts.<br />
	Topics and Replies: This will do the same as above, and additionally will remove all topic threads started by this member.';

$helptxt['live_news'] = '<strong>Live announcements</strong><br />
	This box shows recently updated announcements from <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>.
	You should check here every now and then for updates, new releases, and important information from ElkArte.';

$helptxt['registrations'] = '<strong>Registration Management</strong><br />
	This section contains all the functions that could be necessary to manage new registrations on the forum. It contains up to four
	sections which are visible depending on your forum settings. These are:<br /><br />
	<ul class="normallist">
		<li>
			<strong>Register new member</strong><br />
			From this screen you can choose to register accounts for new members on their behalf. This can be useful in forums where registration is closed
			to new members, or in cases where the admin wishes to create a test account. If the option to require activation of the account
			is selected the member will be emailed a activation link which must be clicked before they can use the account. Similarly you can
			select to email the users new password to the stated email address.<br /><br />
		</li>
		<li>
			<strong>Edit Registration Agreement</strong><br />
			This allows you to set the text for the registration agreement displayed when members sign up for your forum.
			You can add or remove anything from the default registration agreement, which is included with ElkArte.<br /><br />
		</li>
		<li>
			<strong>Set Reserved Names</strong><br />
			Using this interface you can specify names which may not be used by your users.<br /><br />
		</li>
		<li>
			<strong>Settings</strong><br />
			This section will only be visible if you have permission to administrate the forum. From this screen you can decide on the registration method
			for use on your forum, as well as other registration related settings.
		</li>
	</ul>';

$helptxt['requireAgreement'] = 'This setting is recommended to be enabled in order to comply with the rules of the <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';

$helptxt['modlog'] = '<strong>Moderatielog</strong><br />
	Deze sectie stelt leden van het moderatieteam in staat om alle moderatieacties te bekijken die de moderators van het forum hebben uitgevoerd. Om er zeker van te zijn dat
	deze verwijzingen naar activiteiten niet door de moderators kunnen worden gewist, kunnen de ingangen niet worden gewist tot 24 uur na de betreffende activiteit.';
$helptxt['adminlog'] = '<strong>Beheerlog</strong><br />
	Deze sectie stelt leden van het beheerteam in staat tot het bijhouden van een aantal administratieve acties. Om er zeker van te zijn dat
	beheerders deze verwijzingen naar activiteiten niet door beheerders kunnen worden gewist, kunnen de ingangen niet worden gewist tot 24 uur na de betreffende activiteit.';
$helptxt['warning_enable'] = '<strong>User Warning System</strong><br />
	This feature enables members of the admin and moderation team to issue warnings to members - and to use a members warning level to determine the
	actions available to them on the forum. Upon enabling this feature a permission will be available within the permissions section to define
	which groups may assign warnings to members. Warning levels can be adjusted from a members profile. The following additional options are available:';
$helptxt['watch_enable'] = '<strong>Warning Level for Member Watch</strong><br />This setting defines the percentage warning level a member must reach to automatically assign a &quot;watch&quot; to the member. Any member who is being &quot;watched&quot; will appear in the relevant area of the moderation center.';
$helptxt['moderate_enable'] = '<strong>Warning Level for Post Moderation</strong><br />Any member passing the value of this setting will find all their posts require moderator approval before they appear to the forum	community. This will override any local board permissions which may exist related to post moderation.';
$helptxt['mute_enable'] = '<strong>Warning Level for Member Muting</strong><br />If this warning level is passed by a member they will find themselves under a post ban. The member will lose all posting rights.';
$helptxt['perday_limit'] = '<strong>Maximum Member Warning Points per Day</strong><br />This setting limits the amount of points a moderator may add/remove to any particular member in a twenty four hour period. This can be used to limit what a moderator can do in a small period of time. This setting can be disabled by setting to a value of zero. Note that any member with administrator permissions are not affected by this value.';
$helptxt['error_log'] = '<strong>Error Log</strong><br />
	The error log tracks every serious error encountered by users using your forum. It lists all of these errors by date which can be sorted
	by clicking the black arrow next to each date. Additionally you can filter the errors by clicking the picture next to each error statistic. This
	allows you to filter, for example, by member. When a filter is active the only results that will be displayed will be those that match that filter.';
$helptxt['theme_settings'] = '<strong>Thema-instellingen</strong><br />
	Het instellingen scherm laat je alle instellingen van een bepaald thema aanpassen. Je kunt hier bijvoorbeeld de thema directory en URL informatie
	wijzigen maar ook opties aanpassen die betrekking hebben op de lay-out van het forum. De meeste thema\'s hebben een aantal opties die kunnen worden
	geconfigureerd door leden om zo aan hun persoonlijke wensen tegemoet te komen.';
$helptxt['smileys'] = '<strong>Smiley Center</strong><br />
	Here you can add and remove smileys and smiley sets.  Note importantly that if a smiley is in one set, it\'s in all sets - otherwise, it might
	get confusing for your users using different sets.<br /><br />

	You are also able to edit message icons from here, if you have them enabled on the settings page.';

$helptxt['calendar'] = '<strong>Beheer kalender</strong><br />
	Hier kun je de huidige kalenderinstellingen bewerken en feestdagen die op de kalender zichtbaar zijn.';
$helptxt['calendar_settings'] = 'The calendar can be used for showing birthdays or for showing important moments happening in your community.<br /><br />Remember that usage of the calendar (posting events, viewing events, etc.) is controlled by permissions set on the permissions screen.';
$helptxt['cal_days_for_index'] = 'Max days in advance on board index:<br />If this is set to 7, the next week\'s worth of events will be shown.';
$helptxt['cal_showevents'] = 'Enables the highlighting of events on the Mini Calendars, Main Calendar, both places, or disable event highlighting.';
$helptxt['cal_showholidays'] = 'This setting allows you to highlight holidays on the Mini Calendars, Main Calendar, both places, or disable event highlighting.';
$helptxt['cal_showbdays'] = 'This setting allows you to highlight birthdays on the Mini Calendars, Main Calendar, both places, or disable event highlighting.';
$helptxt['cal_export'] = 'Exports a text file in the iCal format for importing into other calendar applications.';
$helptxt['cal_daysaslink'] = 'Show days as link to \'Post Event\':<br />This will allow members to post events for that day when they click on that date.';
$helptxt['cal_allow_unlinked'] = 'Allow events not linked to posts:<br />Allow members to post events without requiring it to be linked with a post in a board.';
$helptxt['cal_defaultboard'] = 'Default Board to Post In:<br />Enter the default board to post events in.';
$helptxt['cal_showInTopic'] = 'Show linked events in topic display:<br />Check to show a link to the event at the top of topic view.';
$helptxt['cal_allowspan'] = 'Allow events to span multiple days:<br />Check to allow events to span multiple days.';
$helptxt['cal_maxspan'] = 'Max number of days an event can span:<br />Enter the maximum number of days that a single event can span.';
$helptxt['cal_minyear'] = 'Minimum year:<br />Select the &quot;first&quot; year on the calendar list.';
$helptxt['cal_maxyear'] = 'Maximum year:<br />Select the &quot;last&quot; year on the calendar list<br />';

$helptxt['serversettings'] = '<strong>Server Settings</strong><br />
	Here you can perform the core configuration for your forum. This section includes the database and URL settings as well as other
	important configuration items such as mail settings and caching. Think carefully whenever editing these settings as an error may
	render the forum inaccessible';
$helptxt['manage_files'] = '
	<ul class="normallist">
		<li>
			<strong>Browse Files</strong><br />
			Browse through all the attachments, avatars and thumbnails stored by the system.<br /><br />
		</li><li>
			<strong>Attachment Settings</strong><br />
			Configure where attachments are stored and set restrictions on the types of attachments.<br /><br />
		</li><li>
			<strong>Avatar Settings</strong><br />
			Configure where avatars are stored and manage resizing of avatars.<br /><br />
		</li><li>
			<strong>File Maintenance</strong><br />
			Check and repair any error in the attachment directory and delete selected attachments.<br /><br />
		</li>
	</ul>';

$helptxt['topicSummaryPosts'] = 'Hier geef je aan hoeveel berichten je totaal op &eacute;&eacute;n pagina wilt zien in een bepaalde topic.';
$helptxt['enableAllMessages'] = 'Stel dit in op het <em>maximaal</em> aantal berichten dat een topic mag hebben voor het tonen van de \'allemaal\'-link. Als dit lager wordt ingesteld dan de &quot;Maximum aantal berichten vertonen op &eacute;&eacute;n pagina&quot;-instelling, zal de link simpelweg nooit getoond worden, terwijl een te hoge instelling het forum zou kunnen vertragen.';
$helptxt['allow_guestAccess'] = 'Als dit vak niet is aangevinkt, zullen gasten niets anders kunnen doen dan de primaire acties - inloggen, registreren, wachtwoordherinnering opvragen, etc. - op je forum. Dit is niet hetzelfde als gasten de toegang verhinderen tot de boards.';
$helptxt['userLanguage'] = 'Turning this option on will allow users to select which language file they use. It will not affect the default selection.';
$helptxt['trackStats'] = 'Stats:<br />This will allow users to see the latest posts and the most popular topics on your forum.
		It will also show several statistics like the most members online, new members and new topics.<hr />
		Page views:<br />Adds another column to the stats page with the number of page views on your forum.';
$helptxt['enable_unwatch'] = 'Enabling this option will allow users to selectively turn off new reply notifications for topics in which they had previously posted.';
$helptxt['titlesEnable'] = 'Switching Custom Titles on will allow members with the relevant permission to create a special title for themselves.
		This will be shown underneath the name.<br /><em>Example:</em><br />Jeff<br />Cool Guy';
$helptxt['onlineEnable'] = 'This will show an image to indicate whether the member is online or offline';
$helptxt['todayMod'] = 'This will format &quot;Today&quot; or &quot;Yesterday&quot; in a variety of formats instead of the full date.<br /><br />
		<strong>Examples:</strong><br /><br />
		<dl class="settings">
			<dt>Disabled</dt>
			<dd>October 3, 2009 at 12:59:18 am</dd>
			<dt>Relative</dt>
			<dd>2 Hours Ago</dd>
			<dt>Only Today</dt>
			<dd>Today at 12:59:18 am</dd>
			<dt>Today &amp; Yesterday</dt>
			<dd>Yesterday at 09:36:55 pm</dd>
		</dl>';
$helptxt['disableCustomPerPage'] = 'Vink deze optie aan om ervoor te zorgen dat gebruikers niet zelf in kunnen stellen hoeveel topics ze per pagina op de topicindex en hoeveel berichten ze per pagina in een topicweergave zien.';
$helptxt['enablePreviousNext'] = 'Hiermee worden links gegeven naar het volgende en vorige topic.';
$helptxt['pollMode'] = 'This selects whether polls are enabled or not. If polls are disabled, the regular topic without their polls are shown.
<br /><br />To choose who can post polls, view polls, and similar, you can allow and disallow those permissions. Remember this if polls don\'t seem to be working.';
$helptxt['enableVBStyleLogin'] = 'Dit laat voor gasten een compact inlogveld zien onderaan je forum.';
$helptxt['enableCompressedOutput'] = 'This option will compress output to lower bandwidth consumption, but it requires zlib to be installed.';
$helptxt['databaseSession_enable'] = 'Deze optie maakt gebruik van de database voor het opslaan van sessies - het werkt het best op load balanced servers, maar helpt tegen allerlei sessie-timeoutproblemen en kan het forum sneller maken.';
$helptxt['databaseSession_loose'] = 'Het aanzetten van deze optie bespaart dataverkeer van je forum, en zorgt ervoor dat het klikken op \'terug\' niet de pagina zal herladen - het nadeel is echter dat de (nieuw) iconen niet worden geactualiseerd, net als enkele andere dingen (tenzij je de pagina aanklikt in plaats van terug te gaan naar die pagina).';
$helptxt['databaseSession_lifetime'] = 'Dit is het aantal seconden dat een sessie blijft bestaan nadat deze voor het laatst is gebruikt. Als de sessie niet gebruikt wordt voor een te lange tijd, dan treedt er een \'timeout\' op. Een waarde hoger dan 2400 wordt aanbevolen.';
$helptxt['cache_enable'] = 'ElkArte performs caching at a variety of levels. The higher the level of caching enabled the more CPU time will be spent retrieving cached information. If caching is available on your machine it is recommended that you try caching at level 1 first.';
$helptxt['cache_memcached'] = 'If you are using memcached you need to provide the server details. This should be entered as a comma separated list as shown in this example:<br /><br/>&quot;server1,server2,server3:port,server4&quot;<br /><br />Note that if no port is specified the software will use port 11211, set this to 0 when using UNIX domain sockets.';
$helptxt['cache_redis'] = 'If you are using redis you need to provide the server details. This should be entered as a comma separated list as shown in this example:<br /><br/>&quot;server1,server2,server3:port,server4&quot;<br /><br />Note that if no port is specified the software will use port 6379, set this to 0 when using UNIX domain sockets.';
$helptxt['cache_cachedir'] = 'This setting is only for the filesystem based cache system. It specifies the path to the cache directory.  It is recommended that you place this in /tmp/ if you are going to use this, although it will work in any directory';
$helptxt['cache_uid'] = 'Some cache systems, for example Redis, may require a user ID to allow ElkArte access the cache.';
$helptxt['cache_password'] = 'Some cache systems, for example Redis, may require a password to allow ElkArte access the cache.';

$helptxt['enableErrorLogging'] = 'Dit zal alle fouten, zoals een mislukte inlogpoging, loggen, zodat je later kunt bekijken wat er fout is gegaan.';
$helptxt['enableErrorQueryLogging'] = 'Dit zal de volledige naar de server verzonden query opslaan wanneer er een databasefout ontstaat. Daarvoor dient fouten loggen wel aan te staan.<br /><br /><strong>NB: dit zal ook de mogelijkheid om fouten te filteren aantasten.</strong>';
$helptxt['allow_disableAnnounce'] = 'This will allow users to opt out of notification of topics you announce by checking the &quot;Announce Topic&quot; checkbox when posting. Disabling this option violates the rules of the <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a> and many other countries\' privacy and anti-spam laws.';
$helptxt['metadata_enabled'] = 'This will create OG (Open Graph) and Schema.org microdata suitable for HTML embedding (requires theme support).  It allows search engines to better understand the information on your site pages, and provides for a better link sharing experience on social sites.  When enabled, metadata will made available for the board listing, topic listing and topic display areas of your site.';
$helptxt['disallow_sendBody'] = 'This option removes the possibility to receive the text of replies, posts and personal messages in notification emails.<br /><br />Often, members will reply to the notification email, which in most cases means the webmaster receives the reply.';
$helptxt['enable_contactform'] = 'This option adds a contact us button to the registration screen';
$helptxt['jquery_source'] = 'This will determine the source used to load the jQuery Library.  Auto will use the CDN first and if not available fall back to the local source.  Local will only use the local source, CDN will only load it from Google\'s Content Delivery Network';
$helptxt['jquery_default'] = 'If you want to use a version of jQuery different than the one that came with ElkArte, select this box and enter the version number X.XX.X The local file must follow the naming conventing of jquery-X.XX.X.min.js for it to be loaded.';
$helptxt['jqueryui_default'] = 'If you want to use a version of jQueryUI different than the one that came with ElkArte, select this box and enter the version number X.XX.X The local file must follow the naming conventing of jquery-ui-X.XX.X.min.js for it to be loaded.';
$helptxt['minify_css_js'] = 'This will remove unnecessary whitespace and comments from the files to reduce their size.  The minimized files are saved so further requests can instantly serve those files.<br />Note that the first time a compilation is needed/created, there may be a slight delay on that page load in order to create the file (this will also happen after the cache is cleared)';
$helptxt['combine_css_js'] = 'This will combine multiple CSS or JavaScript files per page as needed.  The combined files are saved so further requests can instantly serve those files.';
$helptxt['compactTopicPagesEnable'] = 'This will show the supplied number of surrounding pages.<br /><em>Example:</em>
		&quot;3&quot; to display: 1 ... 4 [5] 6 ... 9 <br />
		&quot;5&quot; to display: 1 ... 3 4 [5] 6 7 ... 9';
$helptxt['timeLoadPageEnable'] = 'This will show the time in seconds taken to create that page at the bottom of the board.';
$helptxt['removeNestedQuotes'] = 'This will remove, or limit the number of, nested quotes in a reply when citing the post via the quote link.';
$helptxt['heightBeforeShowMore'] = 'This will limit the height of a quote block.  Quotes exceeding this size will have a "read more" option applied to allow seeing the full quote.';
$helptxt['search_dropdown'] = 'This will show a search selection dropdown next to the quick search box.  From this you can choose to search the current site, current board (if in a board), current topic (if in a topic) or search for members.';
$helptxt['max_image_width'] = 'This allows you to set a maximum size for posted pictures. Pictures smaller than the maximum will not be affected. This also determines how attached images are displayed when a thumbnail is clicked on.';
$helptxt['mail_type'] = 'This setting allows you to choose either PHP\'s default settings, or to override those settings with SMTP.  PHP doesn\'t support using authentication with SMTP (which many hosts require now) so if you want that you should select SMTP.  Please note that SMTP can be slower, and some servers will not take user names and passwords.<br /><br />You don\'t need to fill in the SMTP settings if this is set to PHP\'s default.';
$helptxt['mail_batch_size'] = 'This setting determines how many emails will be sent per page load and can not be set greater than the maximum allowed per minute.<br />Leaving this as 0, the system will automatically determine a batch size to evenly spread the load and fill the quota.<br />If you want to set your own values, setting this to the same value as your limit is a good option for low per minute limits, or 1/6 of the limit for higher per minute limits.';
$helptxt['smtp_client'] = 'Used to identify this client to the SMTP server.<br />The field should contain the fully-qualified domain name (FQDN) of the SMTP client. In situations in which the client system does not have a meaningful domain name you can instead use an address literal formatted as [ipv4] or [IPv6:ipv6 address].<br />If left blank the system will attempt to detect this value for you.';

$helptxt['attachmentEnable'] = 'Enable/Disable the attachment system or disable only new attachments leaving old one available.';
$helptxt['automanage_attachments'] = 'This will create a directory structure based on the selected option.  This can be post date (subdividing attachments by year, or by year and month or by year, month and day) or simply adding a new directory when the space limit is reached.  Each directory created will have the same file count and total size restrictions.  This will help prevent directories from reaching a file or size limit.';
$helptxt['use_sub-directories_for_attachments'] = 'This will create all new directories as sub-directories under the main attachment directory.';
$helptxt['attachmentDirSizeLimit'] = ' Set how large the attachment folder can be.';
$helptxt['attachmentDirFileLimit'] = 'Set the max. number of files an individual attachment directory may contain';
$helptxt['attachmentPostLimit'] = 'Specify how large a single post\'s total upload size can be (in KiB), this is the cumulative size of all attachments made in a post.';
$helptxt['attachmentSizeLimit'] = 'Specify the largest size a single attachment in a post can have.';
$helptxt['attachmentNumPerPostLimit'] = 'Select the number of attachments a member can add per post.';

$helptxt['attachment_image_resize_enabled'] = 'Master on/off switch for this function.  Enabling this will 
	resize attachment images (.jpg, .png, .gif, .bmp, .webp) to fit within the specified bounds.  The image format 
	will be maintained unless the resized image is over the specified max allowed file size.  In this event, if 
	change format is enabled, the system may convert the image to WebP or JPEG for better compression.';
$helptxt['attachment_image_resize_reformat'] = '
	Selecting this option will allow the system to change images into WebP, if available, or JPEG ONLY
	when necessary.  The system will try to maintain the existing format unless the resized image is in
	excess of the maximum allowed file size.  It will not reencode JPG or change a PNG with transparency to JPG';
$helptxt['attachment_image_resize_width'] = 'This allows you to set a maximum width for attachment images. 
	Pictures smaller than the maximum will not be affected, larger images will be resized proportionately. 
	This allows you to accept a larger image on upload and have it resized to save space. The maximum 
	filesize parameter is still enforced.';
$helptxt['attachment_image_resize_height'] = 'This allows you to set a maximum height for attachment images. 
	Pictures smaller than the maximum will not be affected, larger images will be resized proportionately. 
	This allows you to accept a larger image on upload and have it resized to save space. 
	The maximum filesize parameter is still enforced.';

$helptxt['attachmentCheckExtensions'] = 'Check this box to enable attachment filtering, which will only allow files to be uploaded with the file extensions that you have defined.';
$helptxt['attachmentExtensions'] = 'Specify what attachment types are allowed, for example: jpg,png,gif  Remember to be careful in what you allow as some file extensions can cause a security risk to your website.';
$helptxt['attachment_autorotate'] = 'Selecting this option will allow the system to detect rotated images, typical of phone cameras, and automatically adjust the orientation such that the image top is oriented up. Requires either ImageMagick or both GD and Exif modules to be available.';
$helptxt['attachmentShowImages'] = 'If the uploaded file is a picture, this will automatically display it underneath the post.  If not enabled you will only see a filename and its dsize';
$helptxt['attachmentThumbnails'] = 'Enable this to show post images as a smaller thumbnail image, which when selected will expand to the full sized image.';
$helptxt['attachment_webp_enable'] = 'Enabling this will allow the system to create/save thumbnails and avatars 
	in WebP format.  It will also allow the image resize function, when enabled, to save an attachment as Webp when
 	necessary.';
$helptxt['attachmentThumbWidth'] = 'Only used with the &quot;Resize images when showing under posts&quot; option, the maximum width to resize attachments down from.  They will be resized proportionally.';
$helptxt['attachmentThumbHeight'] = 'Only used with the &quot;Resize images when showing under posts&quot; option, the maximum height to resize attachments down from.  They will be resized proportionally.';
$helptxt['attachment_image_reencode'] = 'Selecting this option will enable the re-encode of uploaded image attachments. Image re-encoding offers better security, however it will also render all animated images static.';
$helptxt['max_image_height'] = 'The maximum displayed height of an attached image.';
$helptxt['max_image_width'] = 'This allows you to set a maximum size for posted pictures. Pictures smaller than the maximum will not be affected. This also determines how attached images are displayed when a thumbnail is clicked on.';
$helptxt['attachmentUploadDir'] = 'Select where you want the files uploaded to be stored on your server. This can be located outside your public html directory for additional security.';
$helptxt['attachment_transfer_empty'] = 'Enabling this will move all the files from the source directory to the new location, otherwise only the maximum allowed number of files according to the per-directory setting will be moved.';
$helptxt['avatar_reencode'] = 'Selecting this option will enable the re-encode of uploaded avatars. Image re-encoding offers better security, however it will also render all animated images static.';
$helptxt['karmaMode'] = 'Karma is een feature die de populariteit van een lid laat zien. Leden kunnen, indien toegestaan,
		andere leden meer of minder karma geven, waarmee dan het karma van de leden in kwestie wordt berekend. Je kunt het
		aantal berichten opgeven dat een lid nodig heeft om &quot;karma&quot; te kunnen hebben, de wachttijd aangeven tussen het stemmen en aangeven of de beheerders
		ook aan die wachttijd moeten voldoen.<br /><br />Of groepen al dan niet het karma van leden kunnen aanpassen, wordt geregeld
		door een permissie. Wanneer je dus problemen hebt met het laten werken van de karma: controleer de permissies.';
$helptxt['localCookies'] = 'The system uses cookies to store login information on the client computer.
	Cookies can be stored globally (myserver.com) or locally (myserver.com/path/to/forum).<br />
	Check this option if you\'re experiencing problems with users getting logged out automatically.<hr />
	Globally stored cookies are less secure when used on a shared webserver (like Tripod).<hr />
	Local cookies don\'t work outside the forum directory so, if your forum is stored at www.myserver.com/forum, pages like www.myserver.com/index.php cannot access the account information.
	Especially when using SSI.php, global cookies are recommended.';
$helptxt['enableBBC'] = 'Deze optie biedt de leden de mogelijkheid om Bulletin Board Code (BBC) te gebruiken op het forum, waardoor ze afbeeldingen kunnen tonen en andere opmaak mogelijkheden krijgen.';
$helptxt['time_offset'] = 'Niet alle forumbeheerders willen dat het forum dezelfde tijd gebruiken als de server waarop het forum wordt gehost. Gebruik deze optie om het tijdsverschil (in uren) aan te geven tussen de huidige tijd en de server tijd. Negatieve en decimale waardes zijn toegestaan.';
$helptxt['default_timezone'] = 'The server timezone tells PHP where your server is located. You should ensure this is set correctly, preferably to the country/city in which the server is located. You can find out more information on the <a href="https://www.php.net/manual/en/timezones.php" target="_blank">PHP Site</a>.';
$helptxt['spamWaitTime'] = 'Hier kun je aangeven hoeveel tijd er dient te zitten tussen het plaatsen van berichten. Dit kan voorkomen dat mensen gaan &quot;spammen&quot; op het forum.';

$helptxt['enablePostHTML'] = 'This will allow the use of some basic HTML tags when posting:
	<ul class="normallist enablePostHTML">
		<li>&lt;b&gt;, &lt;u&gt;, &lt;i&gt;, &lt;s&gt;, &lt;em&gt;, &lt;ins&gt;, &lt;del&gt;</li>
		<li>&lt;a href=&quot;&quot;&gt;</li>
		<li>&lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;</li>
		<li>&lt;br /&gt;, &lt;hr /&gt;</li>
		<li>&lt;pre&gt;, &lt;blockquote&gt;</li>
	</ul>';

$helptxt['enablePostMarkdown'] = 'This will allow the use of some basic Markdown tags when posting:
	<ul class="normallist enablePostMarkdown">
		<li>**Text** or __Text__ => [b]Text[/b]</li>
		<li>*Text* or _Text_ => [i]Text[/i]</li>
		<li>~~Text~~ => [s]Text[/s]</li>
		<li>`Text` => [icode]Text[/icode]</li>
		<li>```Text``` => [code]Text[/code]</li>
		<li>> Text => [quote]Text[/quote]</li>
		<li>--- or *** or ___ => [hr]</li>
	</ul>';

// Initial theme settings - Manage and Install
$helptxt['themes'] = 'Here you can select whether the default theme can be chosen, what theme guests will use, as well as other options. Click on a theme to the right to change the settings for it.';
$helptxt['theme_install'] = 'This section permits you to install new themes. You do this by uploading an archived file for the theme from your personal computer, installing from a theme directory on the host server or by copying the default theme and renaming that copied file.<br /><br />Please remember this: the archived file or directory must have a <span class="alert">theme_info.xml</span> definition file as a part of the archive or the directory.';
$helptxt['theme_forum_theme'] = 'Changing the overall forum default does not affect members that have selected another available theme. You must also \'Reset\' all members to force them to the new forum default. You can also set a forum default theme that is seen by guests and then reset members to a different theme. <br /><br />Remember that when permitted to select their own themes, members can overide the theme set by you.';

// Theme Management and Options - Theme settings
$helptxt['themeadmin_list_reset'] = 'On rare occasions the path to the theme will be lost and your forum will not display properly. This may be due to a mistake by an Admin, database errors, failed software updates, mod installations or some other event. Resetting the themes URLs and directories will usually fix this problem.';
$helptxt['themeadmin_delete_help'] = 'The default theme cannot be deleted as doing so would break your forum and would break other themes. However, you can delete any theme that has the red \'X\' next to it by clicking on that \'X\'. <br /><br /> Remember this: Deleting a theme does not remove it from the server, it only removes the themes availability to be used on the forum. You will need to FTP into your server or use the host provided panel to remove the custom theme from the server. Do not ever delete the theme named \'default\'.';

$helptxt['enableVideoEmbeding'] = 'This allows automatic conversion of standard URLs into an embedded video when the post is viewed.  Currently supports YouTube, Vimeo, TikTok, Twitter, Facebook, Instagram and Dailymotion links';
$helptxt['enableCodePrettify'] = 'This will load the Prettify script which will color highlight code used in code tags.  It adds styles to code snippets so that tokens stand out and your users can more easily read the code.';
// @todo Add more information about how to use them here.
$helptxt['xmlnews_enable'] = 'Allows people to link to <a href="%1$s?action=.xml;sa=news" target="_blank" class="new_win">Recent news</a>
	and similar data.  It is also recommended that you limit the number of recent posts/news because, when RSS data
	is displayed in some clients, like Trillian, it is expected to be truncated.';
$helptxt['hotTopicPosts'] = 'Change the number of posts for a topic to reach the state of a &quot;hot&quot; or
	&quot;very hot&quot; topic.  Select the likes option to base this state on the number of likes instead of the number of posts';
$helptxt['globalCookies'] = 'Makes login cookies available across subdomains.  For example, if...<br />
	Your site is at http://www.myserver.com/,<br />
	And your forum is at http://forum.myserver.com/,<br />
	Using this option will allow you to access the forum\'s cookie on your site.  Do not enable this if there are other subdomains (like hacker.elkarte.net) not controlled by you.<br />
	This option does not function when local cookies are enabled.';
$helptxt['globalCookiesDomain'] = 'Define the main domain to be used when login cookies are available across subdomains';
$helptxt['httponlyCookies'] = 'With this setting on, cookies will not be accessible by scripting languages, such as JavaScript. This setting can help to reduce identity theft through XSS attacks. This may cause issues with some third party scripts but is recommended to be on when possible.';
$helptxt['secureCookies'] = 'Het inschakelen van deze optie zal ervoor zorgen dat nieuwe cookies altijd gemarkeerd zullen worden als veilig. Schakel deze optie alleen in als je het HTTPS-protocol gebruikt op je site, anders zullen cookies niet juist afgehandeld worden!';
$helptxt['admin_session_lifetime'] = 'This controls the length of time an admin session can remain active. Once this timer expires the session will end, requiring you to enter your admin credentials to continue accessing the admin area. The minimum value is 5 minutes, the maximum allowed value is 14400 minutes (equals a day). It is strongly recommended to use a value less than 60 minutes for security reasons.';
$helptxt['auto_admin_session'] = 'This controls whether an administrative session is activated during logon or not.';
$helptxt['securityDisable'] = 'Dit <em>deactiveert</em> de extra wachtwoordcontrole voor het beheergedeelte. Het wordt aangeraden dit NIET te doen!';
$helptxt['securityDisable_why'] = 'Dit is je huidige wachtwoord.<br /><br />Dit is een extra controle om te bepalen dat <strong>jij</strong> toegang hebt tot dit gedeelte.';
$helptxt['securityDisable_moderate'] = 'This <em>disables</em> the additional password check for the moderation section. This is not recommended!';
$helptxt['securityDisable_moderate_why'] = 'This is your current password. (the same one you use to login.)<br /><br />Having to type this helps ensure that you want to do whatever moderation you are doing, and that it is <strong>you</strong> doing it.';
$helptxt['enableOTP'] = 'Enabling this feature allows another layer of security for a member\'s account. Two-factor authentication, or 2FA, is a way of logging into websites that requires more than just a password. Using a password to log into a website is susceptible to security threats, because it represents a single piece of information a malicious person needs to acquire. The added security that 2FA provides is requiring additional information to sign in.<br /><br />A Time-based One-Time Password (TOTP) application such as Google Authenticator or Authy automatically generates an authentication code that changes after a certain period of time.';
$helptxt['emailmembers'] = 'In this message you can use a few &quot;variables&quot;.  These are:<br />
	{$board_url} - The URL to your forum.<br />
	{$current_time} - The current time.<br />
	{$member.email} - The current member\'s email.<br />
	{$member.link} - The current member\'s link.<br />
	{$member.id} - The current member\'s ID.<br />
	{$member.name} - The current member\'s name.  (for personalization.)<br />
	{$latest_member.link} - The most recently registered member\'s link.<br />
	{$latest_member.id} - The most recently registered member\'s ID.<br />
	{$latest_member.name} - The most recently registered member\'s name.';
$helptxt['attachmentEncryptFilenames'] = 'Encrypting attachment file names allows you to have more than one attachment of the same name and heightens security.  It, however, could make it more difficult to rebuild your database if something drastic happened.';

$helptxt['failed_login_threshold'] = 'Stel het aantal pogingen in die een gebruiker kan wagen alvorens naar het scherm te worden gestuurd waar hij zijn wachtwoord kan laten opsturen.';
$helptxt['loginHistoryDays'] = 'The number of days to keep login history under user profile history. Default is 30 days.';
$helptxt['oldTopicDays'] = 'Als deze optie is ingesteld, wordt er een waarschuwing getoond wanneer een lid probeert te reageren op een topic waarop al een (gespecificeerd) aantal dagen niet gereageerd is. Zet deze instelling op 0 om deze feature uit te schakelen.';
$helptxt['edit_wait_time'] = 'Aantal seconden na plaatsing waarin een bericht bewerkt kan worden zonder als bewerkt te worden gemarkeerd.';
$helptxt['edit_disable_time'] = 'Aantal minuten die mogen verstrijken, voordat een lid zijn bericht niet langer meer kan wijzigen. Stel op 0 in om deze feature uit te schakelen.<br /><br /><em>Let op: dit be&iuml;nvloedt niet gebruikers met de permissie om andermans bericht aan te passen.</em>';
$helptxt['preview_characters'] = 'This option sets the number of available characters for the first and last message of the topic preview.  <strong>Note</strong> this only makes the information available to the theme, the theme must support the &quot;Enable hover  previews on the message index&quot; setting';
$helptxt['posts_require_captcha'] = 'Deze instelling zal van gebruikers eisen om eerst een anti-spambot verificatiecode over te typen, voor ze een bericht kunnen plaatsen. Alleen gebruikers met een beperkt aantal berichten zullen deze code in moeten voeren. Dit zou moeten helpen tegen spambots.';
$helptxt['lastActive'] = 'Set the number of minutes since their last activity to display people as active on the board index. Default is 15 minutes.';

$helptxt['hide_post_group'] = 'Enabling this will not display a member\'s post group title on the message view if they are assigned to a non-post based group.';

$helptxt['customoptions'] = 'Deze sectie definieert de keuzes die een gebruiker kan kiezen uit een keuzelijst. Er zijn een aantal belangrijke dingen instelbaar:
	<ul class="normallist">
		<li><strong>Standaardkeuze:</strong> de keuze die met het keuzebolletje ernaast (&quot;radio button&quot;) geselecteert is, zal standaard ingesteld zijn bij de profielen van gebruikers.</li>
		<li><strong>Verwijder keuzes:</strong> om een keuze te verwijderen, wis je simpelweg de tekst van die keuze. Alle leden die voor die keuze gekozen hadden, zullen teruggezet worden naar de standaardkeuze.</li>
		<li><strong>Keuzes herordenen:</strong> je kunt de keuzes herordenen door de tekst in de tekstvakken te verwisselen. LET OP! Ben er zeker van dat je de exacte tekst uitwisselt, anders zullen de gebruikerkeuzes verloren gaan.</li>
	</ul>';

$helptxt['autoOptDatabase'] = 'Deze optie optimaliseert de database om de zoveel dagen. Stel het in op 1 als je dit elke dag wilt doen. Je kunt ook het maximum aantal gebruikers opgeven dat online mag zijn op dat moment zodat de server niet te zwaar belast zal worden.';
$helptxt['autoFixDatabase'] = 'Dit zal automatisch beschadigde tabellen repareren.  Je zal een email krijgen zodra dit gebeurt.';

$helptxt['enableParticipation'] = 'Dit laat een icoon zien bij de topics waar een gebruiker een bericht in geplaatst heeft.';
$helptxt['enableFollowup'] = 'This allows members to start new topics quoting the text of any message.';

$helptxt['db_persist'] = 'Houdt de verbinding actief om de performance op te schroeven.  Als je niet op een dedicated server wordt gehost, kan dit problemen met je host opleveren.';
$helptxt['ssi_db_user'] = 'Optionele instelling die je in staat stelt om een andere database-gebruiker en wachtwoord te gebruiken bij het gebruik van SSI.php.';

$helptxt['countChildPosts'] = 'Checking this option will mean that posts and topics in a board\'s sub-board will count toward its totals on the index page.<br /><br />This will make things notably slower, but means that a parent with no posts in it won\'t show \'0\'.';
$helptxt['allow_ignore_boards'] = 'Het inschakelen van deze optie heeft als gevolg dat gebruikers in kunnen stellen welke boards ze willen negeren.';
$helptxt['deny_boards_access'] = 'Checking this option will allow you to deny access to certain boards based on membergroup access';

$helptxt['who_enabled'] = 'Deze optie laat je kiezen of je wilt dat leden van elkaar kunnen zien waar ze zijn en wat ze aan het doen zijn.';

$helptxt['recycle_enable'] = 'Het &quot;Recyclen&quot; van verwijderde topics en berichten naar het aangegeven board.';

$helptxt['enableReportPM'] = 'Deze optie zorgt ervoor dat je gebruikers persoonlijke berichten kunnen melden aan het beheerteam. Dit kan handig zijn om misbruik van persoonlijke berichten in de gaten te houden.';
$helptxt['max_pm_recipients'] = 'Deze optie stelt je in staat een maximum aantal ontvangers per persoonlijk bericht dat een forumlid stuurt in te stellen. Dit kan helpen om misbruik van het PM-systeem te voorkomen. Merk op dat leden die nieuwsbrieven kunnen versturen uitgezonderd zijn. Stel in op nul voor geen limiet.';
$helptxt['pm_posts_verification'] = 'Deze instelling zal gebruikers forceren een verificatiecode in te voeren wanneer ze een persoonlijk bericht willen versturen. Alleen gebruikers met een postteller onder het ingestelde aantal zullen de code moeten invoeren - dit zou automatische spammers tegen moeten werken.';
$helptxt['pm_posts_per_hour'] = 'Dit zal het aantal persoonlijke berichten dat een gebruiker per uur kan versturen limiteren. Dit heeft geen effect op beheerders of moderators.';

$helptxt['default_personal_text'] = 'Sets the default text a new user will have as their &quot;personal text.&quot; This option is not available when personal text is disabled, or when users can set their personal text on registration for themselves.';

$helptxt['modlog_enabled'] = 'Logt alle moderatie acties.';
$helptxt['userlog_enabled'] = 'Logs all key changes a user makes to their profile.';

$helptxt['registration_method'] = 'This option determines what method of registration is used for people wishing to join your forum. You can select from:<br /><br />
	<ul class="normallist">
		<li>
			<strong>Registration Disabled</strong><br />
				Disables the registration process, which means that no new members can register to join your forum.<br />
		</li><li>
			<strong>Immediate Registration</strong><br />
				New members can login and post immediately after registering on your forum.<br />
		</li><li>
			<strong>Email Activation</strong><br />
				When this option is enabled any members registering with the forum will have an activation link emailed to them which they must click before they can become full members.<br />
		</li><li>
			<strong>Admin Approval</strong><br />
				This option will make it so that all new members registering with the forum will need to be approved by an admin before they become full members.
		</li>
	</ul>';

$helptxt['send_validation_onChange'] = 'When this option is checked all members who change their email address in their profile will have to reactivate their account from an email sent to the new address';
$helptxt['send_welcomeEmail'] = 'Als deze optie is geactiveerd krijgen nieuwe leden een welkomst-e-mail bericht gestuurd';
$helptxt['password_strength'] = 'This setting determines the strength required for passwords selected by your forum users. The stronger the password, the harder it should be to compromise the member\'s account.
	Its possible options are:
	<ul class="normallist">
		<li><strong>Low:</strong> The password must be at least four characters long.</li>
		<li><strong>Medium:</strong> The password must be at least eight characters long, and can not be part of a user name or email address.</li>
		<li><strong>High:</strong> As for medium, except the password must also contain a mixture of upper and lower case letters, and at least one digit.</li>
	</ul>';
$helptxt['enable_password_conversion'] = 'By enabling this setting, ElkArte will attempt to detect passwords stored in other formats and convert them for use in this software.  Typically this is used for converted forums, but may have other uses as well.  Disabling this prevents a user from logging in using their password after a conversion and would need to reset their password.';

$helptxt['coppaAge'] = 'De waarde in dit vak bepaalt de minimumleeftijd die nieuwe leden moeten hebben om directe toegang tot het forum te krijgen.
	Bij registratie wordt hen gevraagd om te bevestigen of ze ouder dan deze leeftijd zijn en zo niet wordt hun aanvraag afgewezen of opgeschort totdat de ouder toestemming gegeven hebben - afhankelijk van het gekozen type restrictie.
	Als een waarde van 0 is ingevuld, dan zullen alle andere leeftijdsinstellingen worden genegeerd.';
$helptxt['coppaType'] = 'Indien leeftijdsrestricties zijn ingesteld, bepaalt deze instelling wat er gebeurt als een lid onder de minimale leeftijd zich probeert te registreren op je forum. Er zijn twee mogelijke keuzes:
	<ul class="normallist">
		<li>
			<strong>Verwerp de registratie:</strong><br />
				De registratie van elk nieuw lid dat onder de minimum leeftijd is zal per direct worden verworpen.<br />
		</li><li>
			<strong>Vereis ouderlijke goedkeuring</strong><br />
				Elk nieuw lid dat zich probeert te registreren en onder de minimaal toegestane leeftijd is, krijgt een markering in zijn account in afwachting op goedkeuring en krijgt een formulier te zien waarin zijn ouders toestemming kunnen geven om lid te worden van het forum.
				Ze krijgen ook de contactgegevens van het forum zoals ingesteld op de instellingen-pagina zien, zodat ze het formulier naar de forumbeheerder per e-mail of fax kunnen sturen.
		</li>
	</ul>';
$helptxt['coppaPost'] = 'The contact boxes are required so that forms granting permission for underage registration can be sent to the forum administrator. These details will be shown to all new minors, they are required for parent/guardian approval. At the very least a postal address or fax number must be provided.';

$helptxt['allow_hideOnline'] = 'With this option enabled all members will be able to hide their online status from other users (except administrators). If disabled only users who can moderate the forum can hide their presence. Note that disabling this option will not change any member\'s current status - it just stops them from hiding themselves in the future.';

$helptxt['latest_support'] = 'This panel shows you some of the most common problems and questions on your server configuration. Don\'t worry, this information isn\'t logged or anything.<br /><br />If this stays as &quot;Retrieving support information...&quot;, your computer probably cannot connect to the website.';
$helptxt['latest_packages'] = 'Here you can see some of the most popular and some random packages, with quick and easy installations.<br /><br />If this section doesn\'t show up, your computer probably cannot connect to <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>.';
$helptxt['latest_themes'] = 'This area shows a few of the latest and most popular themes from <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>.  It may not show up properly if your computer can\'t find <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>, though.';

$helptxt['secret_why_blank'] = 'For your security, your password and the answer to your secret question are encrypted so that ElkArte will never tell you, or anyone else, what they are.';
$helptxt['moderator_why_missing'] = 'Since moderation is done on a board-by-board basis, you have to make members moderators from the <a href="%1$s?action=admin;area=manageboards" target="_blank" class="new_win">board management interface</a>.';

$helptxt['permissions'] = 'Permissies geven aan welke groepen wel of niet bepaalde rechten in bepaalde boards hebben.<br /><br />Je kunt meerdere boards tegelijk bewerken of bij een specifieke groep kijken door te klikken op &quot;Bewerken&quot;.';
$helptxt['permissions_board'] = 'Als een board is ingesteld op \'Globaal,\' houdt dit in dat het board geen speciale permissies heeft.  \'Lokaal\' houdt in dat het board specifieke permissies heeft - apart van de Globale permissies.  Op deze manier kun je boards hebben die meer of minder permissies hebben dan een ander board, zonder dit voor ieder board apart in te moeten stellen.';
$helptxt['permissions_quickgroups'] = 'Deze stellen je in staat om &quot;standaard&quot; permissies te gebruiken - standaard betekent \'niets speciaals\', beperkt betekent \'als een gast\', moderator betekent \'wat een moderator heeft\', en \'onderhoud\' betekent permissies die erg dicht in de buurt liggen van een admin.';
$helptxt['permission_enable_deny'] = 'Het ontzeggen van permissies kan handig zijn wanneer je voor een zeker lid een permissie wilt wegnemen. Je kunt leden toevoegen aan een ledengroep met een \'ontzeg\'-permissie om hen die permissies te ontzeggen.<br /><br />Gebruik het voorzichtig, een ontzegde permissie blijft ontzegd, ongeacht welke andere ledengroep het lid in zit.';
$helptxt['permission_enable_postgroups'] = 'Met permissies voor bericht-gerelateerde groepen, kun je permissies aan leden toekennen die een bepaald aantal berichten heeft geplaatst. De bericht-gerelateerde permissies worden <em>toegevoegd</em> aan de permissies van de reguliere ledengroepen.';
$helptxt['membergroup_guests'] = 'De gasten-ledengroep bestaat uit alle gebruikers die niet zijn ingelogd.';
$helptxt['membergroup_regular_members'] = 'De \'reguliere leden\' groep bestaat uit alle leden die ingelogd zijn, maar niet een primaire ledengroep zijn toegewezen.';
$helptxt['membergroup_administrator'] = 'The administrator can, per definition, do anything and see any board. Thus, there are no permission settings for the administrator.';
$helptxt['membergroup_moderator'] = 'The Moderator member group is a special member group. Permissions and settings assigned to this group apply to moderators but only <em>on the boards they moderate</em>. Outside these boards they\'re just like any other member.';
$helptxt['membergroups'] = 'There are two types of groups that your members can be part of. These are:
	<ul class="normallist">
		<li><strong>Regular Groups:</strong> A regular group is a group to which members are not automatically put into. To assign a member to be in a group simply go to their profile and click &quot;Account Settings&quot;. From here you can assign them any number of regular groups to which they will be part.</li>
		<li><strong>Post Groups:</strong> Unlike regular groups post based groups cannot be assigned. Instead, members are automatically assigned to a post based group when they reach the minimum number of posts required to be in that group.</li>
	</ul>';

$helptxt['calendar_how_edit'] = 'Je kunt deze events bewerken door op het rode sterretje naast de naam te klikken.';

$helptxt['maintenance_backup'] = 'Hier kun je een kopie maken van alle berichten, instellingen, leden en alle andere informatie uit de database in &eacute;&eacute;n groot bestand.<br /><br />Doe dit wekelijks, om altijd een goede backup te hebben.';
$helptxt['maintenance_rot'] = 'Hier kun je <strong>volledig</strong> en <strong>onomkeerbaar</strong> oude topics verwijderen.  Het wordt aangeraden eerst een backup te maken.<br /><br />Wees voorzichtig met het gebruik van deze optie.';
$helptxt['maintenance_members'] = 'Deze optie stelt je in staat om leden <strong>volledig</strong> en <strong>permanent</strong> te verwijderen van je forum. Het wordt <strong>sterk aangeraden</strong> van tevoren een backup te maken, voor het geval je iets doet dat je eigenlijk niet wilde doen.<br /><br />Gebruik deze optie voorzichtig.';

$helptxt['avatar_default'] = 'With this option enabled, a default avatar is shown for all users without their own avatar. The file named \'default_avatar.png\' is located in the images folder inside the themes directory.  If you also enable "Use a default gravatar image for all users without their own avatar.", then a gravatar generated image will be used instead.';
$helptxt['avatar_server_stored'] = 'This allows your members to pick an avatar from a number of avatars stored on your server themselves.  They are, generally, in the same place as the forum under the avatars directory.<br />As a tip, if you create directories in that folder, you can make &quot;categories&quot; of avatars.';
$helptxt['avatar_external'] = 'Met deze optie actief kunnen leden een URL opgeven naar hun avatar.  Het nadeel hiervan is dat in sommige gevallen er avatars zullen worden gebruikt die erg groot zijn of niet op je forum kunnen in verband met wat de afbeelding voorstelt.';
$helptxt['avatar_download_external'] = 'Met deze optie wordt de URL die door de gebruiker is opgegeven, benaderd om de avatar te downloaden. Als dat gelukt is, zal de avatar als uploadbare avatar behandeld worden.';
$helptxt['avatar_upload'] = 'Deze optie is vrijwel gelijk aan &quot;Sta leden toe een externe avatar te gebruiken&quot;, alleen heb je nu een betere controle over de avatars, gaat het resizen sneller en hoeven de leden hun avatar niet elders onder te brengen.<br /><br />Het nadeel kan echter zijn dat het een hoop ruimte kan gaan kosten op je server.';
$helptxt['avatar_resize_options'] = 'This set of options apply to any avatar loaded to the server by users, either uploaded or retrieved from an external URL.';
$helptxt['avatar_download_png'] = 'PNGs are larger, but offer higher quality.  If this is unchecked, JPEG will be used instead, which is often smaller, but also removes transparency and is of lesser or blurry quality.';
$helptxt['gravatar'] = 'Gravatar (globally recognized avatar) is a service for providing globally unique avatars. For more details please visit the Gravatar <a href="https://www.gravatar.com" target="_blank"><strong>website</strong>.</a>';
$helptxt['gravatar_rating'] = 'Gravatar allows users to self-rate their images so that they can indicate if an image is appropriate for a certain audience. By default, only \'G\' rated images are displayed unless you indicate that you would like to see higher ratings. <br /><br /><ul><li><strong>g:</strong> suitable for display on all websites with any audience type.</li><li><strong>pg:</strong> may contain rude gestures, provocatively dressed individuals, the lesser swear words, or mild violence.</li><li><strong>r:</strong> may contain such things as harsh profanity, intense violence, nudity, or hard drug use.</li><li><strong>x:</strong> may contain hardcore sexual imagery or extremely disturbing violence.</li></ul>';
$helptxt['disableHostnameLookup'] = 'Dit deactiveert de mogelijkheid om hostnamen te zoeken, wat op sommige servers erg traag kan zijn.  Let op dat het verbannen van leden ook minder effectief zal worden.';
$helptxt['url_format'] = 'The UrlGenerator subsystem builds forum links in three interchangeable styles<br /><br />Standard: classic query parameters (default style), e.g. ?topic=123.45;action=print.<br />Semantic: "pretty url" human‑readable URLs with slugs in the path, e.g. ?t/some-topic-title-123/page-45;other=param.<br />Queryless: path and extension based (no normal query string), e.g. ?topic,123.45.html;other=param.';

$helptxt['search_weight_commonheader'] = 'Weight factors are used to determine the relevancy of a search result. Change these weight factors to match the things that are specifically important for your forum. For instance, a forum of a news site might want a relatively high value for \'age of last matching message\'. All values are relative in relation to each other and should be positive integers.';
$helptxt['search_weight_frequency'] = 'This factor counts the amount of matching messages and divides them by the total number of messages within a topic.';
$helptxt['search_weight_age'] = 'This factor rates the age of the last matching message within a topic. The more recent this message is, the higher the score.';
$helptxt['search_weight_length'] = 'This factor is based on the topic size. The more messages are within the topic, the higher the score.';
$helptxt['search_weight_subject'] = 'This factor looks whether a search term can be found within the subject of a topic.';
$helptxt['search_weight_first_message'] = 'This factor looks whether a match can be found in the first message of a topic.';
$helptxt['search_weight_sticky'] = 'This factor looks whether a topic is pinned and increases the relevancy score if it is.';
$helptxt['search_weight_likes'] = 'This factor looks whether a topic has likes and increases the relevancy score based on the number.';
$helptxt['search'] = 'Pas hier alle instellingen voor de zoekfunctie aan.';
$helptxt['search_why_use_index'] = 'A search index can greatly improve the search performance of your forum. Especially when the number of messages on a forum grows bigger, searching without an index can take a long time and increase the pressure on your database. If your forum is bigger than 50,000 messages, you should consider creating a search index to assure peak performance.<br /><br />Note that a search index can take up quite some space. A fulltext index is a built-in index of the database. It\'s relatively compact (approximately the same size as the message table), but a lot of common words aren\'t indexed and it can, in some wildcard queries, turn out to be slow. The custom index is bigger (it could be up to 3 times the size of the messages table) but its performance is often better than fulltext and indexes most words.';

$helptxt['see_admin_ip'] = 'IP-adressen worden getoond aan beheerders en moderators om het modereren te vergemakkelijken en het eenvoudiger te maken om mensen met slechte bedoelingen te traceren. Bedenk wel dat IP-adressen niet altijd identificerend zijn en dat IP-adressen van mensen van tijd tot tijd kan veranderen. <br /><br />Leden mogen ook hun eigen IP-adres zien.';
$helptxt['see_member_ip'] = 'Je IP-adres is zichtbaar voor jou en de moderators. Bedenk dat deze informatie je niet identificeert en dat de meeste IP-adressen af en toe veranderen.<br /><br />Je kunt het IP-adres van andere leden niet zien en zij kunnen het jouwe niet zien.';
$helptxt['whytwoip'] = 'Various methods are used to detect user IP addresses. Usually these two methods result in the same address but in some cases more than one address may be detected. In this case both addresses will be logged, and both will be used for ban checks (etc). You can click on either address to track that IP and ban if necessary.';

$helptxt['ban_cannot_post'] = 'De \'kan niet posten\' restrictie zet het forum in een alleen-lezen-stand voor de gebande gebruiker. De gebruiker kan niet nieuwe topics maken, reageren op bestaande topics, persoonlijke berichten versturen of stemmen in polls. Wel kan de gebande gebruiker nog steeds persoonlijke berichten en topics lezen.<br /><br />Een waarschuwingsbericht wordt aan de gebruikers getoond die op deze manier zijn geband.';

$helptxt['posts_and_topics'] = '
	<ul class="normallist">
		<li>
			<strong>Post Settings</strong><br />
			Modify the settings related to the posting of messages and the way messages are shown.
		</li><li>
			<strong>Censored Words</strong>
			In order to keep the language on your forum under control, you can censor certain words. This function allows you to convert forbidden words into innocent versions.
		</li><li>
			<strong>Topic Settings</strong>
			Modify the settings related to topics. The number of topics per page, whether pinned topics are enabled or not, the number of messages needed for a topic to be hot, etc.
		</li>
	</ul>';
$helptxt['allow_no_censored'] = 'When checked, this global setting allows members to disable word censoring in their User Profile through the Look and Layout settings. The members\' ability to disable word censoring is still limited by their permission profile.';
$helptxt['spider_mode'] = 'Sets the logging level.<br />
Standard - Logs minimal spider activity.<br />
Moderate - Provides more accurate statistics.<br />
Aggressive - As for &quot;Moderate&quot; but logs data about each page visited.';

$helptxt['spider_group'] = 'Door een spider aan een groep te koppelen, krijgt een gast, wanneer deze als een zoekmachine-indexeerder wordt gedetecteerd, automatisch die groep toegewezen in plaats van die van een gast. Je kunt dit zodanig toepassen dat een zoekmachine meer of juist minder toegang heeft tot zaken dan een normale gast. Je zou bijvoorbeeld een nieuwe groep &quot;Spiders&quot; aan kunnen maken en die hier kunnen selecteren. Voor die groep zou je dan de permissie kunnen ontzeggen voor het bekijken van profielen van je leden, zodat spiders deze niet langer indexeren.<br />Merk op: spiderdetectie is niet perfect en kan door gebruikers misleid worden. Er kan daarom niet worden gegarandeerd dat deze feature de (extra) inhoud alleen voor zoekmachines beschikbaar maakt.';
$helptxt['show_spider_online'] = 'Deze instelling stelt je in staat om in te stellen of spiders moeten verschijnen in de \'Wie is online\'-lijst op de boardindex en \'Wie is online\'-pagina. Mogelijke waarden:
	<ul class="normallist">
		<li>
			<strong>Helemaal niet</strong><br />
			Spiders zullen als gasten worden getoond voor alle gebruikers.
		</li><li>
			<strong>Toon spiderhoeveelheid</strong><br />
			Op de boardindex zal het aantal spiders dat momenteel het forum bezoekt worden weergegeven.
		</li><li>
			<strong>Toon spidernamen</strong><br />
			De naam van elke spider zal worden getoond, zodat leden kunnen zien welke spiders momenteel het forum bezoeken. Dit heeft effect op zowel de boardindex als de \'Wie is online\'-pagina.
		</li><li>
			<strong>Toon spidernamen - alleen voor beheerders</strong><br />
			Hetzelfde als hierboven, maar dan zien enkel beheerders de spiderstatussen - alle andere gebruikers zien ze als gasten.
		</li>
	</ul>';
$helptxt['spider_no_guest'] = 'By selecting this, the spider will only be a member of the restrictive group and have the permissions and board access of that group (no guest access). You can use this to provide lesser access to a search engine than you would a normal guest. You might for example wish to remove spiders from indexing certain boards while still allowing guest viewing.';

$helptxt['birthday_email'] = 'Kies hier de verjaardags e-mail die je wilt verzenden. <br /> Er zal een voorbeeld verschijnen in de velden e-mailonderwerp en e-mailinhoud.<br /><strong>NB:</strong> het instellen van de gewenste verjaardags e-mail activeert niet automatisch het verzenden van deze e-mails. Om het verzenden van de verjaardags e-mails in te schakelen ga je naar <a href="%1$s?action=admin;area=maintain;sa=tasks;%3$s=%2$s" target="_blank" class="new_win">Geplande taken</a>. Daar vind je de optie om het verzenden van de verjaardagmails te activeren.';
$helptxt['pm_bcc'] = 'Als je een persoonlijk bericht verstuurt, kun je ervoor kiezen om een ontvanger als BCC (&quot;Blind Carbon Copy&quot;) in te stellen. BCC-ontvangers zijn niet zichtbaar voor andere ontvangers van het bericht.';

$helptxt['move_topics_maintenance'] = 'Dit stelt je in staat om alle topics van een board naar een ander board te verplaatsen.';
$helptxt['maintain_reattribute_posts'] = 'Je kunt deze functie gebruiken om posts die door gasten zijn geplaatst, aan een lid toe te kennen. Dit is bijvoorbeeld handig als een lid zijn account heeft verwijderd, maar toch van gedachten veranderd is en daarom zijn oude posts aan een nieuw account gekoppeld zou willen hebben.';
$helptxt['chmod_flags'] = 'You can manually set the permissions you wish to set the selected files to. To do this enter the chmod value as a numeric (octet) value. Note that these flags will have no effect on Microsoft Windows operating systems.';

$helptxt['postmod'] = 'Deze sectie staat leden van het moderatorteam (met de juiste permissies) toe om berichten en topics goed te keuren alvorens ze getoond worden.';

$helptxt['field_show_enclosed'] = 'Encloses the user input between some text or HTML code.  This will allow you to add more instant message providers, images or an embed, etc. For example:<br /><br />
		&lt;a href="http://website.com/{INPUT}"&gt;&lt;img src="{DEFAULT_IMAGES_URL}/icon.png" alt="{INPUT}" /&gt;&lt;/a&gt;<br /><br />
		You can use the following variables:<br />
		<ul class="normallist">
			<li>{INPUT} - The input specified by the user.</li>
			<li>{KEY} - The key specified for a certain value of select box or radio buttons in the admin panel. Usually to use in case of localization or use in CSS of Javascript elements (e.g. as class name).</li>
			<li>{SCRIPTURL} - Web address of forum.</li>
			<li>{IMAGES_URL} - URI of the images directory of the user\'s current theme.</li>
			<li>{DEFAULT_IMAGES_URL} - URI of the images directory of the default theme.</li>
		</ul>';

$helptxt['custom_mask'] = 'The input mask is important for your forum\'s security. Validating the input from a user can help to ensure that data is not used in a way you do not expect. We have provided some simple regular expressions as hints.<br /><br />
	<div class="smalltext custom_mask">
		&quot;~[A-Za-z]+~&quot; - Match all upper and lower case alphabet characters.<br />
		&quot;~[0-9]+~&quot; - Match all numeric characters.<br />
		&quot;~[A-Za-z0-9]{7}~&quot; - Match all upper and lower case alphabet and numeric characters seven times.<br />
		&quot;~[^0-9]?~&quot; - Forbid any number from being matched.<br />
		&quot;~^([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$~&quot; - Only allow 3 or 6 character hexcodes.<br />
	</div><br /><br />
	Additionally, special metacharacters ?+*^$ and {xx} can be defined.
	<div class="smalltext custom_mask">
		? - None or one match of previous expression.<br />
		+ - One or more of previous expression.<br />
		* - None or more of previous expression.<br />
		{xx} - An exact number of the previous expression.<br />
		{xx,} - An exact number or more of the previous expression.<br />
		{,xx} - An exact number or less of the previous expression.<br />
		{xx,yy} - An exact match between the two numbers from previous expression.<br />
		^ - Start of string.<br />
		$ - End of string.<br />
		\ - Escapes the next character.<br />
	</div><br /><br />
	More information and advanced techniques may be found on the internet.';

$helptxt['badbehavior_httpbl_maxage'] = 'This is the number of days since suspicious activity was last observed from an IP address by Project Honey Pot. The system will block requests with a maximum age equal to or less than this setting.';
$helptxt['badbehavior_httpbl_threat'] = 'This number provides a measure of how suspicious an IP address is, based on activity observed at Project Honey Pot. The system will block requests with a threat level equal or higher to this setting. Project Honey Pot has <a href="https://www.projecthoneypot.org/threat_info.php" target="_blank">more information on this parameter</a>.';
$helptxt['badbehavior_httpbl_key'] = 'Use data from the <a href="https://www.projecthoneypot.org/faq.php#g" target="_blank">http:BL</a> service provided by <a href="https://www.projecthoneypot.org/" target="_blank">Project Honey Pot</a> to screen requests.<br /><br />This is optional setting; however if you wish to use it, you must <a href="https://www.projecthoneypot.org/httpbl_configure.php" target="_blank">sign up for the service</a> and obtain an Access key. To disable http:BL use, remove the API key from your settings.';
$helptxt['badbehavior_accept_header'] = 'This enforces that a proper Accept header be send with requests.  All browsers due this by default, but many scrappers/harvesters do not and will be blocked.';

$helptxt['filter_to'] = 'Replace the found text with this, leave blank to replace with found text with nothing (i.e. remove it)';
$helptxt['filter_from'] = 'Enter the text you want to find/replace.  If type is set to regex then this must be a valid regular expression, including delimiters.  If not regex it will do a simple text match and replace it with the replacement text';
$helptxt['filter_type'] = 'Standard will find the exact phrase and replace it with the text in the replace field.  Regular Expression is a wildcard option, but it must be in a valid regex format.';
$helptxt['pbe_post_enabled'] = 'Enable this to allow users to respond to email notifications and have them post as a reply.  They are still required to have posting permissions.';
$helptxt['pbe_pm_enabled'] = 'Enable this to allow users to reply by email to PM notifications.  They are still required to have PM permissions, this setting only allows them to receive and reply to notifications';
$helptxt['maillist_group_mode'] = 'If enabled outbound post/topic emails will come from the poster\'s display name, otherwise it will come from the site name.  This is simply a envelope, affecting only how the "From name" appears in the receiving mailbox, the actual from email address is unchanged.';
$helptxt['maillist_newtopic_change'] = 'This will allow a user to change the subject of a email notification and have it post as a new topic.  The new topic will be started on the same board as the reply was going to.';
$helptxt['maillist_sitename_address'] = 'This must be the address that is piped to the emailpost.php file or the address of the IMAP mailbox';
$helptxt['maillist_help_short'] = 'This feature allows users of your forum to reply to the site\'s email notifications and have those replies post on the forum.  Please visit the Wiki for full instructions';

$helptxt['frame_security'] = 'The X-Frame-Options HTTP response header can be used to indicate whether or not a browser should be allowed to render a page in a frame or an iframe. You can use this additional security restriction on your site against attempts at clickjacking attacks, by ensuring that the content of your site is not embedded into other sites.
	<br />
	More information about this header may be found on the internet.';

$helptxt['attachment_inline_title'] = '<b>Add an inline attachment</b><br />
		Example:
		<br /><b>[attach align=left width=400]123[/attach]</b>
		<br />This will show a left-aligned image resized to 400 pixels wide with the post text flowing around it. Except for the attachment tag and the attachment id all other parameters are optional
		<br /><b>[attach]123[/attach]</b>
		<br />This will show the attachment as a thumbnail if available, if no thumbnail is available it will use a full sized image. The image will be in line with the text of your post.
		<br /><br />
		<br /><b>Options:</b>
		<br />where x is the attachment id
		<br />align=left, center, right
		<br />width=### (where # is number in pixels)
		<br />height=### (where # is number in pixels)
		<br />
		<h3>Modes available</h3>
		<p>
			You can choose the inline mode you want for your attachment:
			<ul>
				<li>Thumbnail [attach]x[/attach] : Your image will be shown as a thumbnail</li>
				<li>Text Link [attachurl]x[/attachurl] : Only a link is show with size and view details. By clicking on it, the image is displayed.</li>
			</ul>
		</p><br />
		<p>
			You can choose how to align the inline image:
			<ul>
				<li>align=left : The image is aligned to the left and the text will flow around it</li>
				<li>align=right : The image is aligned to the right and the text will flow around it</li>
				<li>align=center : The image is centered and the text will be below it</li>
			</ul>
		</p><br />
		<p>
			You can choose how wide to show the image:
			<ul>
				<li>width=123 : The image is displayed 123 pixels wide</li>
				<li>If the width specified is larger than the image or larger than the forum allows the largest allowable width will be used</li>
				<li>Can be used to shrink a thumbnail as well [attach width=50]x[/attach] will display a 50px wide thumbnail</li>
			</ul>
		</p><br />
		<p>
			You can choose how tall to show the image:
			<ul>
				<li>height=123 : The image is displayed 123 pixels tall</li>
				<li>If the height specified is bigger than the image or bigger than the forum allows the biggest allowable width will be used</li>
				<li>Can be used to shrink a thumbnail as well [attach height=50]x[/attach] will display a 50px tall thumbnail</li>
			</ul>
		</p>';
