<?php
// Version: 2.0; index

global $forum_copyright;

// Locale (strftime, pspell_new) and spelling.
// For more information see:
//   - https://www.php.net/function.pspell-new
//   - https://www.php.net/function.setlocale
$txt['lang_locale'] = 'nl_NL.utf8';
$txt['lang_dictionary'] = 'nl';
$txt['lang_spelling'] = 'amerikaans';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8javascript:;';
// Character set and right to left?
$txt['lang_rtl'] = false;
// Capitalize day and month names?
$txt['lang_capitalize_dates'] = true;
// Number format.
$txt['number_format'] = '1.234,00';

$txt['sunday'] = 'zondag';
$txt['monday'] = 'maandag';
$txt['tuesday'] = 'dinsdag';
$txt['wednesday'] = 'woensdag';
$txt['thursday'] = 'donderdag';
$txt['friday'] = 'vrijdag';
$txt['saturday'] = 'zaterdag';

$txt['sunday_short'] = 'Zo';
$txt['monday_short'] = 'Ma';
$txt['tuesday_short'] = 'Di';
$txt['wednesday_short'] = 'Wo';
$txt['thursday_short'] = 'Do';
$txt['friday_short'] = 'Vr';
$txt['saturday_short'] = 'Za';

$txt['january'] = 'januari';
$txt['february'] = 'februari';
$txt['march'] = 'maart';
$txt['april'] = 'april';
$txt['may'] = 'mei';
$txt['june'] = 'juni';
$txt['july'] = 'juli';
$txt['august'] = 'augustus';
$txt['september'] = 'september';
$txt['october'] = 'oktober';
$txt['november'] = 'november';
$txt['december'] = 'december';

$txt['january_titles'] = 'januari';
$txt['february_titles'] = 'februari';
$txt['march_titles'] = 'maart';
$txt['april_titles'] = 'april';
$txt['may_titles'] = 'mei';
$txt['june_titles'] = 'juni';
$txt['july_titles'] = 'juli';
$txt['august_titles'] = 'augustus';
$txt['september_titles'] = 'september';
$txt['october_titles'] = 'oktober';
$txt['november_titles'] = 'november';
$txt['december_titles'] = 'december';

$txt['january_short'] = 'Jan';
$txt['february_short'] = 'Feb';
$txt['march_short'] = 'Mrt';
$txt['april_short'] = 'Apr';
$txt['may_short'] = 'mei';
$txt['june_short'] = 'Jun';
$txt['july_short'] = 'Jul';
$txt['august_short'] = 'Aug';
$txt['september_short'] = 'Sep';
$txt['october_short'] = 'Okt';
$txt['november_short'] = 'Nov';
$txt['december_short'] = 'Dec';

$txt['time_am'] = 'am';
$txt['time_pm'] = 'pm';

// Let's get all the main menu strings in one place.
$txt['main_menu'] = 'Hoofdmenu';
$txt['home'] = 'Index';
$txt['community'] = 'Gemeenschap';
$txt['forum'] = 'Forum';

// Sub menu labels
$txt['help'] = 'Help';
$txt['search'] = 'Zoekfunctie';
$txt['calendar'] = 'Kalender';
$txt['members'] = 'Leden';
$txt['recent_posts'] = 'Recente berichten';
$txt['recent_topics'] = 'Recente Onderwerpen';

$txt['admin'] = 'Beheer';
// Sub menu labels
$txt['errlog'] = 'Foutenlog';
$txt['package'] = 'Add-on Beheerder';
$txt['edit_permissions'] = 'Permissies';
$txt['modSettings_title'] = 'Foruminstellingen';
$txt['pwa_label'] = 'Webapplicatie';

$txt['moderate'] = 'Moderatie';
// Sub menu labels
$txt['modlog_view'] = 'Moderatielog';
$txt['mc_emailerror'] = 'Niet-goedgekeurde E-mails';
$txt['mc_reported_posts'] = 'Gerapporteerde posts';
$txt['mc_reported_pms'] = 'Gerapporteerde Persoonlijke Berichten';
$txt['mc_unapproved_attachments'] = 'Niet-goedgekeurde bijlagen';
$txt['mc_unapproved_poststopics'] = 'Niet-goedgekeurde posts en topics';

$txt['pm_short'] = 'Mijn berichten';
// Sub menu labels
$txt['pm_menu_read'] = 'Lees je berichten';
$txt['pm_menu_send'] = 'Stuur een bericht';

$txt['account_short'] = 'Mijn Account';
// Sub menu labels
$txt['profile'] = 'Profiel';
$txt['mydrafts'] = 'Mijn Concepten';
$txt['summary'] = 'Overzicht';
$txt['theme'] = 'Lay-out-voorkeuren';
$txt['account'] = 'Accountinstellingen';
$txt['forumprofile'] = 'Forumprofiel';

$txt['view_unread_category'] = 'Nieuw bericht';
$txt['view_replies_category'] = 'Nieuwe Antwoorden';

$txt['login'] = 'Inloggen';
$txt['register'] = 'Registreren';
$txt['logout'] = 'Uitloggen';
// End main menu strings.

$txt['save'] = 'Opslaan';

$txt['modify'] = 'Bewerk';
$txt['forum_index'] = '%1$s - Forumindex';
$txt['board_name'] = 'Forumnaam';
$txt['posts'] = 'berichten';

$txt['member_postcount'] = 'berichten';
$txt['no_subject'] = '(Geen onderwerp)';
$txt['view_profile'] = 'Bekijk profiel';
$txt['guest_title'] = 'Gast';
$txt['author'] = 'Auteur';
$txt['on'] = 'op';
$txt['remove'] = 'Verwijder';
$txt['start_new_topic'] = 'Begin een nieuw topic';

// Use numeric entities in the below string.
$txt['username'] = 'Gebruikersnaam';
$txt['password'] = 'Wachtwoord';

$txt['username_no_exist'] = 'Deze gebruikersnaam bestaat niet.';
$txt['no_user_with_email'] = 'Er zijn geen gebruikersnamen verbonden aan dat e-mailadres.';

$txt['board_moderator'] = 'Board-moderator';
$txt['remove_topic'] = 'Verwijder';
$txt['topics'] = 'Onderwerpen';
$txt['modify_msg'] = 'Bewerk bericht';
$txt['name'] = 'Naam';
$txt['email'] = 'E-mail';
$txt['user_email_address'] = 'E-mailadres';
$txt['subject'] = 'Onderwerp';
$txt['message'] = 'Bericht';
$txt['redirects'] = 'keer aangeklikt';

$txt['choose_pass'] = 'Kies wachtwoord';
$txt['verify_pass'] = 'Herhaal wachtwoord';
$txt['position'] = 'Positie';
$txt['notify_announcements'] = 'Meld je aan om belangrijke site-nieuws per e-mail te ontvangen';

$txt['profile_of'] = 'Bekijk profiel van';
$txt['total'] = 'Totaal';
$txt['posts_made'] = 'berichten';
$txt['topics_made'] = 'Onderwerpen';
$txt['website'] = 'Website';
$txt['contact'] = 'Neem Contact Op';
$txt['warning_status'] = 'Waarschuwingsstatus';
$txt['user_warn_watch'] = 'Gebruiker staat op moderatietoezichtlijst';
$txt['user_warn_moderate'] = 'Gebruikersposts komen op goedkeuringslijst';
$txt['user_warn_mute'] = 'Gebruiker is verbannen van posten';
$txt['warn_watch'] = 'Toezicht';
$txt['warn_moderate'] = 'Gemodereerd';
$txt['warn_mute'] = 'Stilgelegd';
$txt['warning_issue'] = 'Waarschuwing';

$txt['message_index'] = 'Berichtenindex';
$txt['news'] = 'Nieuws';
$txt['page'] = 'Pagina';
$txt['prev'] = 'vorige';
$txt['next'] = 'volgende';

$txt['post'] = 'Verzenden';
$txt['error_occurred'] = 'Er is een fout opgetreden';
$txt['send_error_occurred'] = 'Er is een fout opgetreden, <a href="{href}">klik hier om het opnieuw te proberen</a>.';
$txt['require_field'] = 'Dit is een verplicht veld.';
$txt['started_by'] = 'Gestart door auteur';
$txt['topic_started_by'] = 'Gestart door %1$s';
$txt['topic_started_by_in'] = 'Gestart door %1$s in %2$s';
$txt['replies'] = 'Reacties';
$txt['last_post'] = 'Laatste bericht';
$txt['first_post'] = 'Eerste bericht';
$txt['last_poster'] = 'Laatste bericht auteur';

$txt['last_post_message'] = '<span class="lastpost_link">%2$s </span><span class="board_lastposter">by %1$s</span><span class="board_lasttime"><strong>Last post: </strong>%3$s</span>';
$txt['boardindex_total_posts'] = '%1$s Berichten in %2$s Onderwerpen door %3$s Leden';
$txt['show'] = 'Toon';
$txt['hide'] = 'Verberg';
$txt['sort_by'] = 'Sorteer Op';
$txt['sort_asc'] = 'Sorteer oplopend';
$txt['sort_desc'] = 'Sorteer aflopend';

$txt['admin_login'] = 'Administratie Inloggen';
// Use numeric entities in the below string.
$txt['topic'] = 'Onderwerp';
$txt['notify'] = 'Notificatie';
$txt['unnotify'] = 'Notificatie opzeggen';
$txt['notify_request'] = 'Wil je een e-mail ontvangen als iemand antwoord geeft op dit topic?';
// Use numeric entities in the below string.
$txt['regards_team'] = "Met vriendelijke groet,\nHet {forum_name_html_unsafe} Team.";
$txt['notify_replies'] = 'Notificatie bij reacties';
$txt['move_topic'] = 'Verplaatsen';
$txt['move_to'] = 'Verplaats naar';
$txt['pages'] = 'Pagina\'s';
$txt['users_active'] = 'Actief in de afgelopen %1$d minuten';
$txt['personal_messages'] = 'Persoonlijke berichten';
$txt['reply_quote'] = 'Reageer met citaat';
$txt['reply'] = 'Reactie';
$txt['reply_number'] = 'Antwoord #%1$s';
$txt['approve'] = 'Goedkeuren';
$txt['unapprove'] = 'Afkeuren';
$txt['approve_all'] = 'alles goedkeuren';
$txt['awaiting_approval'] = 'Wachtend op goedkeuring';
$txt['attach_awaiting_approve'] = 'Bijlagen wachtend op goedkeuring';
$txt['post_awaiting_approval'] = 'NB: dit bericht wacht op goedkeuring van een moderator.';
$txt['there_are_unapproved_topics'] = 'Er zijn %1$s onderwerpen en %2$s berichten die goedkeuring wachten in dit bord. <a href="%3$s">Klik hier om ze te bekijken</a>.';
$txt['send_message'] = 'Verzend bericht';

$txt['msg_alert_no_messages'] = 'je hebt geen berichten';
$txt['msg_alert_one_message'] = 'je hebt <a href="%1$s">1 bericht</a>';
$txt['msg_alert_many_message'] = 'je hebt <a href="%1$s">%2$d berichten</a>';
$txt['msg_alert_one_new'] = '1 is nieuw';
$txt['msg_alert_many_new'] = '%1$d zijn nieuw';
$txt['remove_message'] = 'Verwijder dit bericht';

$txt['topic_alert_none'] = 'Geen berichten...';
$txt['pm_alert_none'] = 'Geen berichten...';

$txt['online_users'] = 'Gebruikers Online'; //Deprecated
$txt['online_now'] = 'Nu Online';
$txt['personal_message'] = 'Persoonlijke berichten';
$txt['jump_to'] = 'Ga naar';
$txt['go'] = 'zoek';
$txt['are_sure_remove_topic'] = 'Weet je zeker dat je dit topic wilt verwijderen?';
$txt['yes'] = 'Ja';
$txt['no'] = 'Nee';

// @todo this string seems a good candidate for deprecation
$txt['search_on'] = 'op';

$txt['all'] = 'Allemaal';
$txt['search_entireforum'] = 'Hele Forum';
$txt['search_thisbrd'] = 'Dit bord';
$txt['search_thistopic'] = 'Dit onderwerp';
$txt['search_members'] = 'Leden';

$txt['back'] = 'Terug';
$txt['continue'] = 'Doorgaan';
$txt['password_reminder'] = 'Wachtwoord vergeten?';
$txt['topic_started'] = 'Topic gestart door';
$txt['title'] = 'Titel';
$txt['post_by'] = 'Bericht door';
$txt['welcome_newest_member'] = 'Welkom %1$s, onze nieuwste lid.';
$txt['admin_center'] = 'Beheerscherm';
$txt['admin_session_active'] = 'Je hebt een actieve admin-sessie. We raden aan om <strong><a class="strong" href="%1$s">deze sessie te beëindigen</a></strong> zodra je klaar bent met je administratieve taken.';
$txt['admin_maintenance_active'] = 'Je forum is momenteel in onderhoudsmodus, alleen admins kunnen inloggen. Vergeet niet om <strong><a class="strong" href="%1$s">onderhoud te beëindigen</a></strong> zodra je klaar bent met je administratieve taken.';
$txt['query_command_denied'] = 'De volgende MySQL-fouten doen zich voor, controleer je instellingen:';
$txt['query_command_denied_guests'] = 'Het lijkt erop dat er iets mis is met de database van het forum. Dit probleem zou tijdelijk moeten zijn, dus kom later terug en probeer het opnieuw. Als je deze boodschap blijft zien, rapporteer dan de volgende boodschap aan de administrator:';
$txt['query_command_denied_guests_msg'] = 'de opdracht %1$s is geweigerd op de database';
$txt['last_edit_by'] = '<span class="lastedit">Laatste Bewerking</span>: %1$s door %2$s';
$txt['notify_deactivate'] = 'Weet je zeker dat je geen notificatie-e-mails meer wilt ontvangen bij nieuwe reacties in dit topic?';

$txt['date_registered'] = 'Datum van registratie';
$txt['date_joined'] = 'Lid geworden';
$txt['date_joined_format'] = '%b %d, %Y';
$txt['last_seen'] = 'Laatst Gezien';

$txt['recent_view'] = 'Bekijk alle recente berichten.';
$txt['is_recent_updated'] = '%1$s is het meest recent bijgewerkte onderwerp';

$txt['male'] = 'Man';
$txt['female'] = 'Vrouw';

$txt['error_invalid_characters_username'] = 'Ongeldig teken gebruikt in gebruikersnaam.';

$txt['welcome_guest'] = 'Welkom, <strong>Gast</strong>. Gelieve <a href="{login_url}" rel="nofollow">in te loggen</a>.';
$txt['welcome_guest_register'] = 'Welkom bij <strong>{forum_name}</strong>. Gelieve <a href="{login_url}" rel="nofollow">in te loggen</a> of <a href="{register_url}" rel="nofollow">te registreren</a>.';
$txt['welcome_guest_activate'] = '<br />Heeft u uw <a href="{activate_url}" rel="nofollow">activatiemail</a> gemist?';
$txt['welcome_register'] = 'Heeft u geen account?';

// @todo the following to sprintf
$txt['hello_member'] = 'Hoi,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Welkom,';
$txt['select_destination'] = 'Selecteer een bestemming';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Geplaatst door';

$txt['icon_smiley'] = 'Glimlach';
$txt['icon_angry'] = 'Boos';
$txt['icon_cheesy'] = 'Lachen';
$txt['icon_laugh'] = 'Lach';
$txt['icon_sad'] = 'Droevig';
$txt['icon_wink'] = 'Knipoog';
$txt['icon_grin'] = 'Grijns';
$txt['icon_shocked'] = 'Geschrokken';
$txt['icon_cool'] = 'Cool';
$txt['icon_huh'] = 'Verbaasd';
$txt['icon_rolleyes'] = 'Rollende ogen';
$txt['icon_tongue'] = 'Tong';
$txt['icon_embarrassed'] = 'Beschaamd';
$txt['icon_lips'] = 'Lippen verzegeld';
$txt['icon_undecided'] = 'Ik weet het niet';
$txt['icon_kiss'] = 'Kus';
$txt['icon_cry'] = 'Huilen';
$txt['icon_angel'] = 'Onschuldig';

$txt['moderator'] = 'Moderator';
$txt['moderators'] = 'Moderators';

$txt['views'] = 'Gelezen';
$txt['new'] = 'Nieuw';
$txt['no_redir'] = 'Omgeleid van %1$s';

$txt['view_all_members'] = 'Bekijk alle leden';
$txt['view'] = 'Bekijk';

$txt['viewing_members'] = 'Bekijk de leden %1$s tot %2$s';
$txt['of_total_members'] = 'van het totale aantal %1$s';

$txt['forgot_your_password'] = 'Wachtwoord vergeten?';

$txt['date'] = 'Datum';
// Use numeric entities in the below string.
$txt['from'] = 'Van';
$txt['to'] = 'Naar';

$txt['board_topics'] = 'Onderwerpen';
$txt['members_title'] = 'Leden';
$txt['members_list'] = 'Ledenlijst';
$txt['new_posts'] = 'Nieuw bericht';
$txt['old_posts'] = 'Geen nieuw bericht';
$txt['redirect_board'] = 'Doorlinkboard';
$txt['redirect_board_to'] = 'Omleiden naar %1$s';

$txt['sendtopic_send'] = 'Zenden';
$txt['report_sent'] = 'Je rapport is met succes verstuurd.';
$txt['topic_sent'] = 'Uw e-mail is succesvol verzonden.';

$txt['time_offset'] = 'Tijdafwijking';
$txt['or'] = 'of';

$txt['mention'] = 'Notificaties';
$txt['notifications'] = 'Notificaties';
$txt['unread_notifications'] = 'U heeft %1$s ongelezen meldingen sinds uw laatste bezoek.';
$txt['new_from_last_notifications'] = 'U heeft %1$s nieuwe meldingen.';
$txt['forum_notification'] = 'Meldingen van %1$s.';

$txt['your_ban'] = 'Sorry %1$s, je bent verbannen van gebruik van dit forum!';
$txt['your_ban_expires'] = 'Deze verbanning loopt af op %1$s.';
$txt['your_ban_expires_never'] = 'Deze verbanning is permanent.';
$txt['ban_continue_browse'] = 'Je kunt het forum blijven doorbladeren als gast.';

$txt['mark_as_read'] = 'Markeer alle berichten als gelezen';
$txt['mark_as_read_confirm'] = 'Weet u zeker dat u ALLE berichten als gelezen wilt markeren?';
$txt['mark_these_as_read'] = 'Markeer DEZE berichten als gelezen';
$txt['mark_these_as_read_confirm'] = 'Weet u zeker dat u DEZE berichten als gelezen wilt markeren?';

$txt['locked_topic'] = 'Gesloten topic';
$txt['normal_topic'] = 'Normaal topic';
$txt['participation_caption'] = 'Topic waaraan je hebt deelgenomen';

$txt['print'] = 'Print';
$txt['topic_summary'] = 'Samenvatting van topic';
$txt['not_applicable'] = 'Niet aanwezig';
$txt['name_in_use'] = 'De naam %1$s is al in gebruik door een andere lid.';

$txt['total_members'] = 'Totaal aantal leden';
$txt['total_posts'] = 'Totaal aantal berichten';
$txt['total_topics'] = 'Totaal aantal topics';

$txt['mins_logged_in'] = 'Aantal minuten dat je blijft<br />ingelogd';

$txt['preview'] = 'Bekijken';
$txt['always_logged_in'] = 'Altijd ingelogd blijven';

$txt['logged'] = 'Gelogd';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';

$txt['www'] = 'WWW';
$txt['link'] = 'Link';

$txt['by'] = 'door'; //Deprecated

$txt['hours'] = 'uren';
$txt['minutes'] = 'minuten';
$txt['seconds'] = 'seconden';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Uur';
$txt['days_word'] = 'dagen';

$txt['newest_member'] = ', ons nieuwste lid.'; //Deprecated

$txt['search_for'] = 'Zoeken op';
$txt['search_match'] = 'Overeenkomst';

$txt['maintain_mode_on'] = 'Vergeet niet, dit forum is in \'Onderhoudsmodus\'.';

$txt['read'] = 'gelezen'; //Deprecated
$txt['times'] = 'keer'; //Deprecated
$txt['read_one_time'] = '1 keer gelezen';
$txt['read_many_times'] = '%1$d keer gelezen';

$txt['forum_stats'] = 'Statistieken';
$txt['latest_member'] = 'Nieuwste lid';
$txt['total_cats'] = 'Totaal categorie&euml;n';
$txt['latest_post'] = 'Laatste bericht';

$txt['here'] = 'hier';
$txt['you_have_no_msg'] = 'U heeft geen berichten...';
$txt['you_have_one_msg'] = 'U heeft 1 bericht...<a href="%1$s">Klik hier om het te bekijken</a>';
$txt['you_have_many_msgs'] = 'U heeft %2$d berichten...<a href="%1$s">Klik hier om ze te bekijken</a>';

$txt['total_boards'] = 'Totaal aantal boards';

$txt['print_page'] = 'Print pagina';
$txt['print_page_text'] = 'Alleen tekst';
$txt['print_page_images'] = 'Tekst met afbeeldingen';

$txt['valid_email'] = 'Dit moet een geldig e-mailadres zijn.';

$txt['info_center_title'] = '%1$s - Infocentrum';

$txt['send_topic'] = 'Delen';
$txt['unwatch'] = 'Niet meer volgen';
$txt['watch'] = 'Volgen';

$txt['allow_user_email'] = 'Sta gebruikers toe mij een e-mail te sturen';

$txt['check_all'] = 'Vink alles aan';

// Use numeric entities in the below string.
$txt['database_error'] = 'Databasefout';
$txt['try_again'] = 'Probeer het opnieuw. Gaat het weer fout, meld het dan aan de beheerder.';
$txt['file'] = 'Bestand';
$txt['line'] = 'Regel';

// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'ElkArte heeft een fout in uw database gedetecteerd en geprobeerd deze automatisch te repareren. Als u problemen blijft ondervinden of deze e-mails blijft ontvangen, neem dan contact op met uw host.';
$txt['database_error_versions'] = '<strong>Opmerking:</strong> Uw databaseversie is %1$s.';
$txt['template_parse_error'] = 'Template-verwerkingsfout!';
$txt['template_parse_error_message'] = 'Het lijkt erop dat er iets verkeerd gegaan is met het templatesysteem van het forum. Dit probleeem zou slechts tijdelijk moeten zijn, dus probeer het later opnieuw. Als je dit bericht blijft krijgen, neem dan contact op met de beheerer.<br /><br />Je kunt ook proberen om <a href="javascript:location.reload();">deze pagina te verversen</a>.';
$txt['template_parse_error_details'] = 'Er was een probleem met het laden van de <span class="tt"><strong>%1$s</strong></span> sjabloon of taalbestand. Controleer de syntaxis en probeer het opnieuw - onthoud dat enkele aanhalingstekens (<span class="tt">\'</span>) vaak moeten worden ontsnapt met een backslash (<span class="tt">\\</span>). Om meer specifieke foutinformatie van PHP te zien, probeer <a href="%2$s%1$s">het bestand direct te openen</a>.<br /><br />U kunt proberen om deze pagina te <a href="javascript:location.reload();">verversen</a> of <a href="%3$s">het standaardthema te gebruiken</a>.';
$txt['template_parse_undefined'] = 'Er is een ongedefinieerde fout opgetreden tijdens het parseren van dit sjabloon';

$txt['today'] = 'Vandaag om %1$s';
$txt['yesterday'] = 'Gisteren om %1$s';

// Relative times
$txt['rt_now'] = 'zojuist';
$txt['rt_minute'] = 'Een minuut geleden';
$txt['rt_minutes'] = '%s minuten geleden';
$txt['rt_hour'] = 'Een uur geleden';
$txt['rt_hours'] = '%s uur geleden';
$txt['rt_day'] = 'Een dag geleden';
$txt['rt_days'] = '%s dagen geleden';
$txt['rt_week'] = 'Een week geleden';
$txt['rt_weeks'] = '%s weken geleden';
$txt['rt_month'] = 'Een maand geleden';
$txt['rt_months'] = '%s maanden geleden';
$txt['rt_year'] = 'Een jaar geleden';
$txt['rt_years'] = '%s jaren geleden';

$txt['new_poll'] = 'Nieuwe poll';
$txt['poll_question'] = 'Vraag';
$txt['poll_question_options'] = 'Vraag en Opties';
$txt['poll_vote'] = 'Stem';
$txt['poll_total_voters'] = 'Totaal aantal stemmen';
$txt['draft_saved_on'] = 'Concept laatst opgeslagen';
$txt['poll_results'] = 'Bekijk de resultaten';
$txt['poll_lock'] = 'Vergrendel de poll';
$txt['poll_unlock'] = 'Ontgrendel de poll';
$txt['poll_edit'] = 'Bewerk de poll';
$txt['poll'] = 'Peiling';
$txt['one_day'] = '1 dag';
$txt['one_week'] = '1 week';
$txt['two_weeks'] = '2 Weken';
$txt['one_month'] = '1 maand';
$txt['two_months'] = '2 Maanden';
$txt['forever'] = 'blijvend';
$txt['quick_login_dec'] = 'Login met gebruikersnaam, wachtwoord en sessielengte';
$txt['one_hour'] = '1 uur';
$txt['moved'] = 'VERPLAATST';
$txt['moved_why'] = 'Geef even een korte beschrijving waarom<br />dit topic wordt verplaatst.';
$txt['board'] = 'Bord';
$txt['in'] = 'in';
$txt['sticky_topic'] = 'Vastgezet Onderwerp';
$txt['split'] = 'SPLITSEN';

$txt['delete'] = 'Verwijder';

$txt['byte'] = 'b';
$txt['kilobyte'] = 'kB';
$txt['megabyte'] = 'MB';
$txt['gigabyte'] = 'GB';

$txt['more_stats'] = '[Meer statistieken]';

$txt['code'] = 'Code';
$txt['code_select'] = '[Selecteer]';
$txt['quote_from'] = 'Citaat van';
$txt['quote'] = 'Citaat';
$txt['quick_quote'] = 'Citaat Geselecteerd';
$txt['quote_new'] = 'Nieuw onderwerp';
$txt['follow_ups'] = 'Vervolgacties';
$txt['topic_derived_from'] = 'Onderwerp afgeleid van %1$s';
$txt['edit'] = 'Bewerk';
$txt['quick_edit'] = 'Snelle Bewerking';
$txt['post_options'] = 'Meer Opties';
$txt['quote_expand'] = 'Toon Citaat';

$txt['set_sticky'] = 'Vastzetten';
$txt['set_nonsticky'] = 'Losmaken';
$txt['set_lock'] = 'Sluit';
$txt['set_unlock'] = 'Heropen';

$txt['search_advanced'] = 'Toon geavanceerde opties';
$txt['search_simple'] = 'Verberg geavanceerde opties';

$txt['security_risk'] = 'GROOT BEVEILIGINGSRISICO:';
$txt['not_removed'] = 'Je hebt %1$s niet verwijderd';
$txt['not_removed_extra'] = '%1$s is een back-up van %2$s die niet door ElkArte is aangemaakt. Het kan direct worden benaderd en gebruikt om ongeautoriseerde toegang tot je forum te verkrijgen. Je moet het onmiddellijk verwijderen.';
$txt['generic_warning'] = 'Waarschuwing';
$txt['agreement_missing'] = 'Je vereist dat nieuwe gebruikers een registratieovereenkomst accepteren, maar het bestand (in sources/ElkArte/Languages/Agreement/) bestaat niet.';
$txt['agreement_accepted'] = 'Je hebt zojuist de overeenkomst geaccepteerd.';
$txt['privacypolicy_accepted'] = 'Je hebt zojuist het privacybeleid van het forum geaccepteerd.';

$txt['new_version_updates'] = 'Je hebt zojuist bijgewerkt!';
$txt['new_version_updates_text'] = '<a href="{admin_url};area=credits#latest_updates">Klik hier om te zien wat er nieuw is in deze versie van ElkArte!</a>!';

$txt['cache_writable'] = 'De cachemap is niet beschrijfbaar! Dit zal je forumprestaties ongunstig be&iuml;nvloeden.';

$txt['page_created_full'] = 'Pagina aangemaakt in %1$.3f seconden met %2$d queries.';

$txt['report_to_mod_func'] = 'Gebruik deze functie om de moderators en beheerders te informeren over een beledigend of verkeerd geplaatst bericht.';

$txt['online'] = 'Online';
$txt['member_is_online'] = '%1$s is online';
$txt['offline'] = 'Offline';
$txt['member_is_offline'] = '%1$s is offline';
$txt['pm_online'] = 'Persoonlijk bericht (Online)';
$txt['pm_offline'] = 'Persoonlijk bericht (Offline)';
$txt['status'] = 'Status';

$txt['skip_nav'] = 'Overslaan naar hoofdinhoud';
$txt['go_up'] = 'Omhoog';
$txt['go_down'] = 'Omlaag';

$forum_copyright = '<a href="https://www.elkarte.net" title="ElkArte Forum" target="_blank" class="new_win">Powered by %1$s</a> | <a href="{credits_url}" title="Credits" target="_blank" class="new_win" rel="nofollow">Credits</a>';

$txt['birthdays'] = 'Verjaardagen:';
$txt['events'] = 'Gebeurtenissen:';
$txt['birthdays_upcoming'] = 'Aanstaande verjaardagen:';
$txt['events_upcoming'] = 'Aanstaande evenementen:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Feestdagen:';
$txt['calendar_month'] = 'Maand:';
$txt['calendar_year'] = 'Jaar:';
$txt['calendar_day'] = 'Dag:';
$txt['calendar_event_title'] = 'Titel van gebeurtenis';
$txt['calendar_event_options'] = 'Opties voor gebeurtenis';
$txt['calendar_post_in'] = 'Plaats In:';
$txt['calendar_edit'] = 'Bewerk deze gebeurtenis';
$txt['event_delete_confirm'] = 'Deze gebeurtenis verwijderen?';
$txt['event_delete'] = 'Verwijder deze gebeurtenis';
$txt['calendar_post_event'] = 'Nieuwe gebeurtenis';
$txt['calendar_link'] = 'Link aan de kalender';
$txt['calendar_upcoming'] = 'Aanstaande kalender';
$txt['calendar_today'] = 'Kalender van vandaag';
$txt['calendar_week'] = 'Week';
$txt['calendar_week_title'] = 'Week %1$d van %2$d';
$txt['calendar_numb_days'] = 'Aantal dagen:';
$txt['calendar_how_edit'] = 'Hoe bewerk je deze gebeurtenissen?';
$txt['calendar_link_event'] = 'Koppel gebeurtenis aan bericht:';
$txt['calendar_confirm_delete'] = 'Weet je zeker dat je deze gebeurtenis wilt verwijderen?';
$txt['calendar_linked_events'] = 'Gekoppelde gebeurtenissen';
$txt['calendar_click_all'] = 'klik hier om alle %1$s te zien';

$txt['moveTopic1'] = 'Plaats een verwijstopic';
$txt['moveTopic2'] = 'Wijzig het onderwerp van dit bericht';
$txt['moveTopic3'] = 'Nieuwe onderwerp';
$txt['moveTopic4'] = 'Verander het onderwerp van elk bericht';
$txt['move_topic_unapproved_js'] = 'Waarschuwing! Dit topic is nog niet goedgekeurd.\n\nHet wordt afgeraden een verplaatst-topic te maken, tenzij je van plan bent het topic direct na het verplaatsen goed te keuren.';
$txt['movetopic_auto_board'] = '[BORD]';
$txt['movetopic_auto_topic'] = '[ONDERWERP LINK]';
$txt['movetopic_default'] = 'Dit onderwerp is verplaatst naar [BORD] - [ONDERWERP LINK]';
$txt['movetopic_redirect'] = 'Doorverwijzen naar het verplaatste onderwerp';
$txt['movetopic_expires'] = 'Verwijder automatisch het doorverwijs onderwerp';

$txt['merge_to_topic_id'] = 'ID van doeltopic';
$txt['split_topic'] = 'Splitsen';
$txt['merge'] = 'Samenvoegen';
$txt['subject_new_topic'] = 'Titel van het nieuwe topic';
$txt['split_this_post'] = 'Splits alleen dit bericht';
$txt['split_after_and_this_post'] = 'Splits topic vanaf dit bericht.';
$txt['select_split_posts'] = 'Selecteer berichten om te splitsen.';

$txt['splittopic_notification'] = 'Plaats een bericht wanneer het onderwerp is gesplitst';
$txt['splittopic_default'] = 'Een of meer berichten van dit onderwerp zijn verplaatst naar [BORD] - [ONDERWERP LINK]';
$txt['splittopic_move'] = 'Verplaats het nieuwe onderwerp naar een ander bord';

$txt['new_topic'] = 'Nieuw topic';
$txt['split_successful'] = 'Onderwerp succesvol gesplitst in twee onderwerpen.';
$txt['origin_topic'] = 'Oorspronkelijke topic';
$txt['please_select_split'] = 'Selecteer welke berichten je wilt afsplitsen.';
$txt['merge_successful'] = 'Topics succesvol samengevoegd.';
$txt['new_merged_topic'] = 'Nieuw samengevoegd topic';
$txt['topic_to_merge'] = 'Topic dat moet worden samengevoegd';
$txt['target_board'] = 'Doelboard';
$txt['target_topic'] = 'Doeltopic ';
$txt['merge_confirm'] = 'Weet je zeker dat je';
$txt['with'] = 'wilt samenvoegen met';
$txt['merge_desc'] = 'Deze optie zal de twee topics samenvoegen. De berichten zullen worden gesorteerd op datum, dus het eerst geplaatste bericht zal bovenaan komen te staan.';

$txt['theme_template_error'] = 'Kan template \'%1$s\' niet laden.';
$txt['theme_language_error'] = 'Kan taalbestand \'%1$s\' niet laden.';

$txt['parent_boards'] = 'Sub-borden';

$txt['smtp_no_connect'] = 'Kan geen verbinding krijgen met de SMTP host';
$txt['smtp_port_ssl'] = 'SMTP-poortinstelling onjuist; het zou 465 moeten zijn voor SSL-servers.';
$txt['smtp_bad_response'] = 'Kan geen antwoordcodes van de mail server krijgen';
$txt['smtp_error'] = 'Problemen opgetreden gedurende het verzenden van mail. Foutmelding: ';
$txt['mail_send_unable'] = 'Kon mail niet verzenden naar e-mailadres \'%1$s\'';

$txt['mlist_search'] = 'Zoek naar leden';
$txt['mlist_search_email'] = 'Zoeken op e-mail';
$txt['mlist_search_group'] = 'Zoek op ledengroep';
$txt['mlist_search_name'] = 'Zoek op naam';
$txt['mlist_search_website'] = 'Zoek op website';
$txt['mlist_search_results'] = 'Zoekresultaten voor';
$txt['mlist_search_by'] = 'Zoek op %1$s';

$txt['attach_downloaded'] = 'gedownload %1$d keer';
$txt['attach_viewed'] = 'bekeken %1$d keer';

$txt['settings'] = 'Instellingen';
$txt['never'] = 'Nooit';
$txt['more'] = 'meer';

$txt['hostname'] = 'Hostnaam';
$txt['you_are_post_banned'] = 'Sorry %1$s, je bent verbannen van het plaatsen van berichten en het versturen van persoonlijke berichten op dit forum.';
$txt['ban_reason'] = 'Reden';

$txt['add_poll'] = 'Voeg poll toe';
$txt['poll_options6'] = 'Je kunt tot %1$s opties selecteren.';
$txt['poll_remove'] = 'Verwijder poll';
$txt['poll_remove_warn'] = 'Weet je zeker dat je deze poll van dit topic wilt verwijderen?';
$txt['poll_results_expire'] = 'Resultaten zullen worden getoond als de poll is gesloten';
$txt['poll_expires_on'] = 'Poll sluit';
$txt['poll_expired_on'] = 'Poll gesloten';
$txt['poll_change_vote'] = 'Verwijder stem';
$txt['poll_return_vote'] = 'Stemopties';
$txt['poll_cannot_see'] = 'Je kunt op dit moment de uitslag van deze poll niet bekijken.';

$txt['quick_mod_approve'] = 'Keur selectie goed';
$txt['quick_mod_remove'] = 'Verwijder selectie';
$txt['quick_mod_lock'] = 'Sluit/heropen selectie';
$txt['quick_mod_sticky'] = 'Vastzetten/Vastzetting opheffen van geselecteerde';
$txt['quick_mod_move'] = 'Verplaats selectie naar';
$txt['quick_mod_merge'] = 'Voeg selectie samen';
$txt['quick_mod_markread'] = 'Markeer selectie als gelezen';
$txt['quick_mod_go'] = 'zoek';
$txt['quickmod_confirm'] = 'Weet je zeker dat je dit wilt doen?';

$txt['quick_reply'] = 'Snel beantwoorden';
$txt['quick_reply_warning'] = 'Waarschuwing! Dit onderwerp is momenteel vergrendeld, alleen beheerders en moderators kunnen reageren.';
$txt['quick_reply_verification'] = 'Na het verzenden van je post word je doorgewezen naar de reguliere postpagina om je bericht te verifi&euml;ren %1$s.';
$txt['quick_reply_verification_guests'] = '(vereist voor alle gasten)';
$txt['quick_reply_verification_posts'] = '(vereist voor alle leden met minder dan %1$d berichten)';
$txt['wait_for_approval'] = 'Merk op: het bericht zal niet verschijnen tot het is goedgekeurd door een moderator.';

$txt['notification_enable_board'] = 'Weet je zeker dat je notificatie van nieuwe topics voor dit board wilt activeren?';
$txt['notification_disable_board'] = 'Weet je zeker dat je notificatie van nieuwe topics voor dit board wilt deactiveren?';
$txt['notification_enable_topic'] = 'Weet je zeker dat je notificatie van nieuwe berichten voor dit topic wilt activeren?';
$txt['notification_disable_topic'] = 'Weet je zeker dat je notificatie van nieuwe berichten voor dit topic wilt deactiveren?';

$txt['report_to_mod'] = 'Rapporteer Bericht';
$txt['issue_warning'] = 'Geef een Waarschuwing';
$txt['issue_warning_post'] = 'Geef een waarschuwing vanwege dit bericht';

$txt['like_post'] = 'Vind ik leuk';
$txt['unlike_post'] = 'Vind ik niet leuk';
$txt['likes'] = 'Vind-ik-leuks';
$txt['liked_by'] = 'Vond leuk door:';
$txt['liked_you'] = 'Jij';
$txt['liked_more'] = 'meer';
$txt['likemsg_are_you_sure'] = 'Je hebt dit bericht al leuk gevonden, ben je zeker dat je je \'vind ik leuk\' wilt verwijderen?';

$txt['unread_topics_visit'] = 'Recente ongelezen topics';
$txt['unread_topics_visit_none'] = 'Geen ongelezen onderwerpen gevonden sinds je laatste bezoek. <a href="{unread_all_url}" class="linkbutton">Probeer alle ongelezen onderwerpen</a>';
$txt['unread_topics_all'] = 'Alle ongelezen berichten';
$txt['unread_replies'] = 'Ongelezen berichten';

$txt['who_title'] = 'Wie is online?';
$txt['who_and'] = ' en ';
$txt['who_viewing_topic'] = ' bekijken dit topic.';
$txt['who_viewing_board'] = ' bekijken dit board.';
$txt['who_member'] = 'Lid';

// Current footer strings
$txt['valid_html'] = 'Geldige HTML 5';
$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Gast';
$txt['guests'] = 'Ongeregistreerde gasten';
$txt['user'] = 'lid';
$txt['users'] = 'leden';
$txt['hidden'] = 'verborgen';
// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'verborgen';
$txt['buddy'] = 'vriend';
$txt['buddies'] = 'vrienden';
$txt['most_online_ever'] = 'Meeste online ooit';
$txt['most_online_today'] = 'Meeste online vandaag';

$txt['merge_select_target_board'] = 'Selecteer het doel-board waar het samen te voegen topic terecht komt';
$txt['merge_select_poll'] = 'Selecteer welke poll het samengevoegde topic moet krijgen';
$txt['merge_topic_list'] = 'Selecteer de samen te voegen topics';
$txt['merge_select_subject'] = 'Selecteer het onderwerp van het samengevoegde topic';
$txt['merge_custom_subject'] = 'Aangepast onderwerp';
$txt['merge_enforce_subject'] = 'Verander het onderwerp van alle berichten';
$txt['merge_include_notifications'] = 'neem notificatie mee?';
$txt['merge_check'] = 'Samenvoegen?';
$txt['merge_no_poll'] = 'Geen poll';

$txt['response_prefix'] = 'Re: ';
$txt['current_icon'] = 'Huidig pictogram';
$txt['message_icon'] = 'Berichticoon';

$txt['smileys_current'] = 'Huidige smileyset';
$txt['smileys_none'] = 'Geen smileys';
$txt['smileys_forum_board_default'] = 'Forum/Board Standaard';

$txt['search_results'] = 'Zoekresultaten';

$txt['totalTimeLogged2'] = ' dagen, ';
$txt['totalTimeLogged3'] = ' uren en ';
$txt['totalTimeLogged4'] = ' minuten.';
$txt['totalTimeLogged5'] = 'd ';
$txt['totalTimeLogged6'] = 'u ';
$txt['totalTimeLogged7'] = 'm';

$txt['approve_thereis'] = 'Er wacht'; //Deprecated
$txt['approve_thereare'] = 'Er wachten'; //Deprecated
$txt['approve_member'] = '&eacute;&eacute;n lid'; //Deprecated
$txt['approve_members'] = 'leden'; //Deprecated
$txt['approve_members_waiting'] = 'op goedkeuring.'; //Deprecated
$txt['approve_one_member_waiting'] = 'Er is <a href="%1$s">één lid</a> in afwachting van goedkeuring.';
$txt['approve_many_members_waiting'] = 'Er zijn <a href="%1$s">%2$d leden</a> in afwachting van goedkeuring.';

$txt['notifyboard_turnon'] = 'Wil je een notificatie per e-mail ontvangen wanneer iemand een nieuw topic wordt gestart in dit board?';
$txt['notifyboard_turnoff'] = 'Weet je zeker dat je geen notificatie-e-mails meer wilt ontvangen bij het starten van nieuwe topics in dit board?';

$txt['notify_unsubscribed_generic'] = 'gespecificeerd';
$txt['notify_board_unsubscribed'] = 'De e-mail, %2$s, is succesvol afgemeld en ontvangt geen meldingen meer van het %1$s bord.';
$txt['notify_topic_unsubscribed'] = 'De e-mail, %2$s, is succesvol afgemeld en ontvangt geen meldingen meer over het %1$s onderwerp.';
$txt['notify_mention_unsubscribed'] = 'De e-mail, %2$s, is succesvol afgemeld en ontvangt geen "%1$s" meldingen meer.';
$txt['notify_default_unsubscribed'] = 'Uw verzoek is succesvol verwerkt.';

$txt['find_members'] = 'Zoek leden';
$txt['find_username'] = 'Naam, gebruikersnaam of e-mailadres';
$txt['find_buddies'] = 'Toon alleen vrienden?';
$txt['find_wildcards'] = 'Toegestane jokertekens: *, ?';
$txt['find_no_results'] = 'Geen resultaten gevonden';
$txt['all_caught_up'] = 'Je bent helemaal bij!';
$txt['find_results'] = 'Resultaten';
$txt['find_close'] = 'Sluiten';

$txt['quickmod_delete_selected'] = 'Verwijder selectie';
$txt['quickmod_split_selected'] = 'Geselecteerde splitsen';

$txt['show_personal_messages_heading'] = 'Nieuwe berichten';
$txt['show_personal_messages'] = 'Je hebt <strong>%1$s</strong> ongelezen persoonlijke berichten in je inbox.<br /><br /><a href="%2$s">Ga naar je inbox</a>';

$txt['help_popup'] = 'Een beetje verloren? Laat me het uitleggen:';

$txt['previous_next_back'] = 'vorig onderwerp';
$txt['previous_next_forward'] = 'volgend onderwerp';

$txt['upshrink_description'] = 'Krimp of vergroot de kop.';

$txt['mark_unread'] = 'Markeer als ongelezen';

$txt['ssi_not_direct'] = 'Het is niet mogelijk om SSI.php direct per URL te benaderen; gebruik het pad (%1$s) of voeg ?ssi_function=something toe.';
$txt['ssi_session_broken'] = 'SSI.php kon geen sessie laden! Dit zou tot problemen kunnen leiden bij het uitloggen en andere functies - zorg ervoor dat SSI.php ingevoegd staat voor ook maar *iets* anders in je scripts!';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Bekijk bericht';
$txt['preview_fetch'] = 'Haalt concept op...';
$txt['pm_error_while_submitting'] = 'De volgende fout of fouten zijn opgetreden bij het verzenden van dit persoonlijke bericht:';
$txt['warning_while_submitting'] = 'Er is iets gebeurd, bekijk het hier:';
$txt['error_while_submitting'] = 'Het bericht heeft de volgende fout of fouten die gecorrigeerd moeten worden voordat het gepost kan worden:';
$txt['error_old_topic'] = 'Waarschuwing: er is al ten minste %1$d dagen geen nieuw bericht geplaatst in dit topic.<br />Tenzij je zeker weet dat je hier wilt reageren, overweeg je beter om een nieuw topic aan te maken.';

$txt['split_selected_posts'] = 'Geselecteerde berichten';
$txt['split_selected_posts_desc'] = 'De berichten hieronder worden na het splitsen een nieuw topic.';
$txt['split_reset_selection'] = 'deselecteer alles';

$txt['modify_cancel'] = 'Annuleren';
$txt['mark_read_short'] = 'Markeer gelezen';

$txt['hello_member_ndt'] = 'Hallo';

$txt['unapproved_posts'] = 'Niet-goedgekeurde berichten (topics: %1$d, berichten: %2$d)';

$txt['ajax_in_progress'] = 'Laden...';
$txt['ajax_bad_response'] = 'Ongeldige reactie.';

$txt['mod_reports_waiting'] = 'Er staan momenteel %1$d moderatorrapporten open.';
$txt['pm_reports_waiting'] = 'Er zijn momenteel %1$d open persoonlijke bericht rapporten.';

$txt['new_posts_in_category'] = 'Klik om de nieuwe berichten in %1$s te zien';
$txt['verification'] = 'Verificatie';
$txt['visual_verification_hidden'] = 'Laat dit vakje leeg';
$txt['visual_verification_description'] = 'Typ de afgebeelde letters over';
$txt['visual_verification_request_new'] = 'Vraag een andere afbeelding aan';

// @todo Send email strings - should move?
$txt['send_email'] = 'Verzend e-mail';
$txt['send_email_disclosed'] = 'NB: dit zal zichtbaar zijn voor de ontvanger.';
$txt['send_email_subject'] = 'Onderwerp';

$txt['ignoring_user'] = 'Je negeert deze gebruiker.';
$txt['show_ignore_user_post'] = '<em>Toon me de post.</em>';

$txt['spider'] = 'spider';
$txt['spiders'] = 'Spiders';

$txt['downloads'] = 'Downloads';
$txt['filesize'] = 'Bestandsgrootte';

// Restore topic
$txt['restore_topic'] = 'Herstel topic';
$txt['restore_message'] = 'Herstel bericht';
$txt['quick_mod_restore'] = 'Herstel selectie';

// Editor prompt.
$txt['prompt_text_email'] = 'Welk e-mailadres wil je invoegen?';
$txt['prompt_text_ftp'] = 'Voer alstublieft het FTP-adres in.';
$txt['prompt_text_url'] = 'Naar welke URL wil je linken?';
$txt['prompt_text_img'] = 'Wat is de URL van de afbeelding die je wilt invoegen?';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Verwijder item';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Sjablonen: ';
$txt['debug_sub_templates'] = 'Subtemplates: ';
$txt['debug_language_files'] = 'Taalbestanden: ';
$txt['debug_sheets'] = 'Stylesheets: ';
$txt['debug_javascript'] = 'Scripts: ';
$txt['debug_files_included'] = 'Geopende bestanden: ';
$txt['debug_kb'] = 'kB.';
$txt['debug_show'] = 'toon';
$txt['debug_cache_hits'] = 'Cachehits: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s bytes';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss voor %2$s bytes';
$txt['debug_queries_used'] = 'Gebruikte query\'s: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Gebruikte query\'s: %1$d, %2$d waarschuwingen.';
$txt['debug_query_in_line'] = 'in <em>%1$s</em> regel <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'die %1$s duurde.';
$txt['debug_query_which_took_at'] = 'wat %1$s seconden duurde bij %2$s in het verzoek.';
$txt['debug_show_queries'] = '[Toon query\'s]';
$txt['debug_hide_queries'] = '[Verberg query\'s]';
$txt['debug_tokens'] = 'Tokens: ';
$txt['debug_browser'] = 'Browser-ID: ';
$txt['debug_hooks'] = 'Aangeroepen hooks: ';
$txt['debug_system_type'] = 'Systeem: ';
$txt['debug_server_load'] = 'Serverbelasting: ';
$txt['debug_script_mem_load'] = 'Geheugengebruik van script: ';
$txt['debug_script_cpu_load'] = 'CPU-tijd van script (gebruiker/systeem): ';

// Video embedding
$txt['preview_image'] = 'Videovoorbeeldafbeelding';
$txt['ctp_video'] = 'Klik om video af te spelen';
$txt['hide_video'] = 'Toon/Verberg video';
$txt['youtube'] = 'YouTube:';
$txt['vimeo'] = 'Vimeo:';
$txt['dailymotion'] = 'Dailymotion:';
$txt['tiktok'] = 'TikTok:';
$txt['twitter'] = 'X/Twitter:';
$txt['facebook'] = 'Facebook:';
$txt['instagram'] = 'Instagram:';

// Spoiler BBC
$txt['spoiler'] = 'Spoiler (klik om te tonen/verbergen)';

$txt['ok_uppercase'] = 'OK';

// Title of box for warnings that admins should see
$txt['admin_warning_title'] = 'Waarschuwing';

$txt['via'] = 'via';

$txt['like_post_stats'] = 'Like stats';

$txt['otp_token'] = 'Eenmalig wachtwoord';
$txt['otp_enabled'] = 'Schakel twee-factor-authenticatie in';
$txt['invalid_otptoken'] = 'Tijdgebaseerd eenmalig wachtwoord is ongeldig';
$txt['otp_used'] = 'Tijdgebaseerd eenmalig wachtwoord is al gebruikt.<br /> Gelieve even te wachten en gebruik de volgende code.';
$txt['otp_generate'] = 'Genereren';
$txt['otp_show_qr'] = 'Toon QR-Code';

$txt['other'] = 'Overig';

$txt['retry'] = 'OPNIEUW PROBEREN';
$txt['check_connection'] = 'Controleer alstublieft uw internetverbinding';
