<?php
// Version: 2.0; index

global $forum_copyright;

// Locale (strftime, pspell_new) and spelling.
// For more information see:
//   - https://www.php.net/function.pspell-new
//   - https://www.php.net/function.setlocale
$txt['lang_locale'] = 'fr_FR-utf8';
$txt['lang_dictionary'] = 'fr';
$txt['lang_spelling'] = 'french';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set and right to left?
$txt['lang_rtl'] = false;
// Capitalize day and month names?
$txt['lang_capitalize_dates'] = true;
// Number format.
$txt['number_format'] = '1234,00';

$txt['sunday'] = 'Dimanche';
$txt['monday'] = 'Lundi';
$txt['tuesday'] = 'Mardi';
$txt['wednesday'] = 'Mercredi';
$txt['thursday'] = 'Jeudi';
$txt['friday'] = 'Vendredi';
$txt['saturday'] = 'Samedi';

$txt['sunday_short'] = 'Dim';
$txt['monday_short'] = 'Lun';
$txt['tuesday_short'] = 'Mar';
$txt['wednesday_short'] = 'Mer';
$txt['thursday_short'] = 'Jeu';
$txt['friday_short'] = 'Ven';
$txt['saturday_short'] = 'Sam';

$txt['january'] = 'Janvier';
$txt['february'] = 'Février';
$txt['march'] = 'Mars';
$txt['april'] = 'Avril';
$txt['may'] = 'Mai';
$txt['june'] = 'Juin';
$txt['july'] = 'Juillet';
$txt['august'] = 'Août';
$txt['september'] = 'Septembre';
$txt['october'] = 'Octobre';
$txt['november'] = 'Novembre';
$txt['december'] = 'Décembre';

$txt['january_titles'] = 'Janvier';
$txt['february_titles'] = 'Février';
$txt['march_titles'] = 'Mars';
$txt['april_titles'] = 'Avril';
$txt['may_titles'] = 'Mai';
$txt['june_titles'] = 'Juin';
$txt['july_titles'] = 'Juillet';
$txt['august_titles'] = 'Août';
$txt['september_titles'] = 'Septembre';
$txt['october_titles'] = 'Octobre';
$txt['november_titles'] = 'Novembre';
$txt['december_titles'] = 'Décembre';

$txt['january_short'] = 'Jan';
$txt['february_short'] = 'Fév';
$txt['march_short'] = 'Mar';
$txt['april_short'] = 'Avr';
$txt['may_short'] = 'Mai';
$txt['june_short'] = 'Jui';
$txt['july_short'] = 'Juil';
$txt['august_short'] = 'Aoû';
$txt['september_short'] = 'Sep';
$txt['october_short'] = 'Oct';
$txt['november_short'] = 'Nov';
$txt['december_short'] = 'Déc';

$txt['time_am'] = 'am';
$txt['time_pm'] = 'pm';

// Let's get all the main menu strings in one place.
$txt['main_menu'] = 'Menu Principal';
$txt['home'] = 'Accueil';
$txt['community'] = 'Accueil';
$txt['forum'] = 'Forum';

// Sub menu labels
$txt['help'] = 'Aide';
$txt['search'] = 'Recherche';
$txt['calendar'] = 'Calendrier';
$txt['members'] = 'Membres';
$txt['recent_posts'] = 'Messages récents';
$txt['recent_topics'] = 'Sujets récents';

$txt['admin'] = 'Admin';
// Sub menu labels
$txt['errlog'] = 'Journal des erreurs';
$txt['package'] = 'Gestionnaire d\'Add-ons';
$txt['edit_permissions'] = 'Permissions';
$txt['modSettings_title'] = 'Fonctionnalités et Options';
$txt['pwa_label'] = 'Application Web';

$txt['moderate'] = 'Modérer';
// Sub menu labels
$txt['modlog_view'] = 'Journal de Modération';
$txt['mc_emailerror'] = 'Courriel non approuvés';
$txt['mc_reported_posts'] = 'Messages signalés';
$txt['mc_reported_pms'] = 'Messages personnels signalés';
$txt['mc_unapproved_attachments'] = 'Fichiers joints non approuvés';
$txt['mc_unapproved_poststopics'] = 'Messages et Sujets non approuvés';

$txt['pm_short'] = 'Messagerie';
// Sub menu labels
$txt['pm_menu_read'] = 'Lire mes messages';
$txt['pm_menu_send'] = 'Envoyer un message';

$txt['account_short'] = 'Mon compte';
// Sub menu labels
$txt['profile'] = 'Profil';
$txt['mydrafts'] = 'Mes brouillons';
$txt['summary'] = 'Résumé';
$txt['theme'] = 'Affichage et disposition';
$txt['account'] = 'Paramètres du Compte';
$txt['forumprofile'] = 'Profil de base et avatar';

$txt['view_unread_category'] = 'Nouveaux messages';
$txt['view_replies_category'] = 'Nouvelles réponses';

$txt['login'] = 'Connexion';
$txt['register'] = 'Inscription';
$txt['logout'] = 'Déconnexion';
// End main menu strings.

$txt['save'] = 'Enregistrer';

$txt['modify'] = 'Modifier';
$txt['forum_index'] = '%1$s - Accueil';
$txt['board_name'] = 'Nom de la section';
$txt['posts'] = 'Messages';

$txt['member_postcount'] = 'Messages';
$txt['no_subject'] = '(Pas de titre)';
$txt['view_profile'] = 'Voir le profil';
$txt['guest_title'] = 'Invité';
$txt['author'] = 'Auteur';
$txt['on'] = 'le';
$txt['remove'] = 'Supprimer';
$txt['start_new_topic'] = 'Nouveau sujet';

// Use numeric entities in the below string.
$txt['username'] = 'Identifiant';
$txt['password'] = 'Mot de passe';

$txt['username_no_exist'] = 'Cet identifiant n\'existe pas.';
$txt['no_user_with_email'] = 'Aucun nom d\'utilisateur associé à cet e-mail.';

$txt['board_moderator'] = 'Modérateur de la section';
$txt['remove_topic'] = 'Supprimer';
$txt['topics'] = 'Sujets';
$txt['modify_msg'] = 'Modifier le message';
$txt['name'] = 'Nom';
$txt['email'] = 'Courriel';
$txt['user_email_address'] = 'Adresse de courriel';
$txt['subject'] = 'Titre';
$txt['message'] = 'Message';
$txt['redirects'] = 'Redirections';

$txt['choose_pass'] = 'Choisir un mot de passe';
$txt['verify_pass'] = 'Vérifier le mot de passe';
$txt['position'] = 'Rang';
$txt['notify_announcements'] = 'Enregistrez vous pour recevoir des informations importantes sur le forum par courriel';

$txt['profile_of'] = 'Voir le profil de';
$txt['total'] = 'Total';
$txt['posts_made'] = 'Messages';
$txt['topics_made'] = 'Sujets';
$txt['website'] = 'Site Web';
$txt['contact'] = 'Contact';
$txt['warning_status'] = 'État des avertissements';
$txt['user_warn_watch'] = 'L\'utilisateur est sur la liste de surveillance des modérateurs';
$txt['user_warn_moderate'] = 'Les messages de l\'utilisateur doivent être approuvés avant publication';
$txt['user_warn_mute'] = 'Suite à un bannissement, l\'utilisateur ne peut plus poster';
$txt['warn_watch'] = 'Surveillé';
$txt['warn_moderate'] = 'Modéré';
$txt['warn_mute'] = 'Ne publie plus';
$txt['warning_issue'] = 'Avertir';

$txt['message_index'] = 'Index des messages';
$txt['news'] = 'Nouvelles';
$txt['page'] = 'Page';
$txt['prev'] = 'Précédent';
$txt['next'] = 'Suivant';

$txt['post'] = 'Publier';
$txt['error_occurred'] = 'Une erreur s\'est produite';
$txt['send_error_occurred'] = 'Une erreur est survenue, <a href="{href}">veuillez cliquer ici pour réessayer</a>.';
$txt['require_field'] = 'Champ obligatoire';
$txt['started_by'] = 'Initié par auteur';
$txt['topic_started_by'] = 'Initié par %1$s';
$txt['topic_started_by_in'] = 'Initié par %1$s dans %2$s';
$txt['replies'] = 'Réponses';
$txt['last_post'] = 'Dernier message';
$txt['first_post'] = 'Premier message';
$txt['last_poster'] = 'Dernier post auteur';

$txt['last_post_message'] = '<span class="lastpost_link">%2$s </span><span class="board_lastposter">par %1$s</span><span class="board_lasttime"><strong>Dernier message : </strong>%3$s</span>';
$txt['boardindex_total_posts'] = '%1$s Messages dans %2$s Sujets par %3$s Membres';
$txt['show'] = 'Afficher';
$txt['hide'] = 'Cacher';
$txt['sort_by'] = 'Trier par';
$txt['sort_asc'] = 'Tri croissant';
$txt['sort_desc'] = 'Tri décroissant';

$txt['admin_login'] = 'Connexion à l\'espace d\'administration';
// Use numeric entities in the below string.
$txt['topic'] = 'Sujet';
$txt['notify'] = 'Notifier';
$txt['unnotify'] = 'Dénotifier';
$txt['notify_request'] = 'Voulez-vous recevoir un courriel de notification si quelqu\'un répond à ce sujet ?';
// Use numeric entities in the below string.
$txt['regards_team'] = "Cordialement,\nL'équipe {forum_name_html_unsafe}.";
$txt['notify_replies'] = 'Notification de réponses';
$txt['move_topic'] = 'Déplacer';
$txt['move_to'] = 'Déplacer vers';
$txt['pages'] = 'Pages';
$txt['users_active'] = 'Actif dans les %1$d dernières minutes';
$txt['personal_messages'] = 'Messages personnels';
$txt['reply_quote'] = 'Citer en réponse';
$txt['reply'] = 'Répondre';
$txt['reply_number'] = 'Répondre #%1$s';
$txt['approve'] = 'Approuver';
$txt['unapprove'] = 'Invalider';
$txt['approve_all'] = 'Tout approuver';
$txt['awaiting_approval'] = 'En attente d\'approbation';
$txt['attach_awaiting_approve'] = 'Fichiers joints en attente d\'approbation';
$txt['post_awaiting_approval'] = 'Ce message est en attente d\'approbation par un modérateur.';
$txt['there_are_unapproved_topics'] = 'Il y a %1$s sujets et %2$s messages en attente de validation dans cette section. <a href="%3$s">Cliquez ici pour les voir</a>.';
$txt['send_message'] = 'Envoyer un message';

$txt['msg_alert_no_messages'] = 'Vous n\'avez aucun message';
$txt['msg_alert_one_message'] = 'vous avez <a href="%1$s">1 message</a>';
$txt['msg_alert_many_message'] = 'vous avez <a href="%1$s">%2$d messages</a>';
$txt['msg_alert_one_new'] = '1 nouveau';
$txt['msg_alert_many_new'] = '%1$d nouveaux';
$txt['remove_message'] = 'Effacer ce message';

$txt['topic_alert_none'] = 'Pas de messages...';
$txt['pm_alert_none'] = 'Pas de messages...';

$txt['online_users'] = 'Membres en ligne'; //Deprecated
$txt['online_now'] = 'En ligne actuellement';
$txt['personal_message'] = 'Message personnel';
$txt['jump_to'] = 'Aller à';
$txt['go'] = 'Aller';
$txt['are_sure_remove_topic'] = 'Êtes-vous sûr de vouloir effacer ce sujet ?';
$txt['yes'] = 'Oui';
$txt['no'] = 'Non';

// @todo this string seems a good candidate for deprecation
$txt['search_on'] = 'le';

$txt['all'] = 'Toutes';
$txt['search_entireforum'] = 'Tout le forum';
$txt['search_thisbrd'] = 'Cette section';
$txt['search_thistopic'] = 'Ce sujet';
$txt['search_members'] = 'Membres';

$txt['back'] = 'Retour';
$txt['continue'] = 'Continuer';
$txt['password_reminder'] = 'Rappel de mot de passe';
$txt['topic_started'] = 'Discussion initiée par';
$txt['title'] = 'Titre';
$txt['post_by'] = 'Publié par';
$txt['welcome_newest_member'] = 'S\'il vous plaît souhaitez la bienvenue à %1$s, notre nouveau membre.';
$txt['admin_center'] = 'Centre d\'administration';
$txt['admin_session_active'] = 'Vous avez une session admin active. Nous vous recommandons de <strong><a class="strong" href="%1$s">fermer cette session</a></strong> lorsque vous aurez terminées vos tâches d\'administration.';
$txt['admin_maintenance_active'] = 'Votre forum est en Mode Maintenance, seuls les administrateurs peuvent se connecter. N\'oubliez pas de <strong><a class="strong" href="%1$s">sortir de la maintenance</a></strong> quand vous avez terminé vos tâches d\'administration.';
$txt['query_command_denied'] = 'Les erreurs MYSQL suivantes se sont produites : vérifiez votre configuration.';
$txt['query_command_denied_guests'] = 'Il semble que la base de données est un comportement anormal. Ce problème pourrait être temporaire : réessayez un peu plus tard s\'il vous plaît. Si vous continuez à avoir ce massage signalez le message suivant à votre administrateur.';
$txt['query_command_denied_guests_msg'] = 'La commande %1$s est interdite dans la base de données';
$txt['last_edit_by'] = '<span class="lastedit">Dernière édition</span> : %1$s par %2$s';
$txt['notify_deactivate'] = 'Voulez-vous désactiver la notification pour ce sujet ?';

$txt['date_registered'] = 'Inscrit le';
$txt['date_joined'] = 'Rejoint';
$txt['date_joined_format'] = '%b %d, %Y';
$txt['last_seen'] = 'Dernière vue';

$txt['recent_view'] = 'Voir tous les messages récents.';
$txt['is_recent_updated'] = '%1$s est le sujet mis à jour le plus récent';

$txt['male'] = 'Homme';
$txt['female'] = 'Femme';

$txt['error_invalid_characters_username'] = 'Caractère invalide dans le nom d\'utilisateur.';

$txt['welcome_guest'] = 'Bienvenue, <strong>Invité</strong>. Veuillez <a href="{login_url}" rel="nofollow">vous connecter</a>.';
$txt['welcome_guest_register'] = 'Bienvenue sur <strong>{forum_name}</strong>. Veuillez <a href="{login_url}" rel="nofollow">vous connecter</a> ou <a href="{register_url}" rel="nofollow">vous inscrire</a>.';
$txt['welcome_guest_activate'] = '<br />Avez-vous manqué votre <a href="{activate_url}" rel="nofollow">email d\'activation</a>?';
$txt['welcome_register'] = 'Vous n\'avez pas de compte?';

// @todo the following to sprintf
$txt['hello_member'] = 'Coucou,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Bienvenue,';
$txt['select_destination'] = 'Merci de choisir une destination';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Publié par';

$txt['icon_smiley'] = 'Sourire';
$txt['icon_angry'] = 'Fâché';
$txt['icon_cheesy'] = 'Très souriant';
$txt['icon_laugh'] = 'Rit';
$txt['icon_sad'] = 'Triste';
$txt['icon_wink'] = 'Clin d\'oeil';
$txt['icon_grin'] = 'Grimaçant';
$txt['icon_shocked'] = 'Choqué';
$txt['icon_cool'] = 'Cool';
$txt['icon_huh'] = 'Hein ?';
$txt['icon_rolleyes'] = 'Roulement d\'yeux';
$txt['icon_tongue'] = 'Tire la langue';
$txt['icon_embarrassed'] = 'Embarrassé';
$txt['icon_lips'] = 'Bouche cousue';
$txt['icon_undecided'] = 'Indécis';
$txt['icon_kiss'] = 'Bisou';
$txt['icon_cry'] = 'Pleure';
$txt['icon_angel'] = 'Innocent';

$txt['moderator'] = 'Modérateur';
$txt['moderators'] = 'Modérateurs';

$txt['views'] = 'Vues';
$txt['new'] = 'Nouveau';
$txt['no_redir'] = 'Redirigé de %1$s';

$txt['view_all_members'] = 'Voir tous les membres';
$txt['view'] = 'Vue';

$txt['viewing_members'] = 'Voir les membres de %1$s à %2$s';
$txt['of_total_members'] = 'sur %1$s au total';

$txt['forgot_your_password'] = 'Mot de passe oublié ?';

$txt['date'] = 'Date';
// Use numeric entities in the below string.
$txt['from'] = 'De';
$txt['to'] = 'à';

$txt['board_topics'] = 'Sujets';
$txt['members_title'] = 'Membres';
$txt['members_list'] = 'Liste des membres';
$txt['new_posts'] = 'Nouveaux messages';
$txt['old_posts'] = 'Pas de nouveau messages';
$txt['redirect_board'] = 'Redirection';
$txt['redirect_board_to'] = 'Rediriger vers %1$s';

$txt['sendtopic_send'] = 'Envoyer';
$txt['report_sent'] = 'Votre rapport a été envoyé avec succès.';
$txt['topic_sent'] = 'Votre email a été envoyé avec succès.';

$txt['time_offset'] = 'Décalage horaire';
$txt['or'] = 'ou';

$txt['mention'] = 'Notifications';
$txt['notifications'] = 'Notifications';
$txt['unread_notifications'] = 'Vous avez %1$s notifications non lues depuis votre dernière visite.';
$txt['new_from_last_notifications'] = 'Vous avez %1$s nouvelles notifications.';
$txt['forum_notification'] = 'Notifications de %1$s.';

$txt['your_ban'] = 'Désolé %1$s, vous êtes banni de ce forum !';
$txt['your_ban_expires'] = 'Ce bannissement devrait expirer le %1$s';
$txt['your_ban_expires_never'] = 'Ce bannissement n\'a pas de date d\'expiration.';
$txt['ban_continue_browse'] = 'Vous pouvez cependant continuer à naviguer sur le forum en mode invité.';

$txt['mark_as_read'] = 'Marquer TOUS les messages comme lus';
$txt['mark_as_read_confirm'] = 'Êtes vous certain de vouloir marquer TOUS les messages comme lus ?';
$txt['mark_these_as_read'] = 'Marquer CES messages comme lus.';
$txt['mark_these_as_read_confirm'] = 'Êtes vous certain de vouloir marquer CES messages comme lus ?';

$txt['locked_topic'] = 'Sujet verrouillé';
$txt['normal_topic'] = 'Sujet normal';
$txt['participation_caption'] = 'Sujet dans lequel vous avez publié';

$txt['print'] = 'Imprimer';
$txt['topic_summary'] = 'Résumé de la discussion';
$txt['not_applicable'] = 'N/A';
$txt['name_in_use'] = 'Le nom %1$s est déjà utilisé par un autre membre.';

$txt['total_members'] = 'Total des membres';
$txt['total_posts'] = 'Total des messages';
$txt['total_topics'] = 'Total des sujets';

$txt['mins_logged_in'] = 'Durée de connexion (en minutes)';

$txt['preview'] = 'Prévisualiser';
$txt['always_logged_in'] = 'Toujours connecté';

$txt['logged'] = 'Connecté';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';

$txt['www'] = 'WWW';
$txt['link'] = 'Lien';

$txt['by'] = 'par'; //Deprecated

$txt['hours'] = 'heures';
$txt['minutes'] = 'minutes';
$txt['seconds'] = 'secondes';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'heure';
$txt['days_word'] = 'jours';

$txt['newest_member'] = ', notre nouveau membre.'; //Deprecated

$txt['search_for'] = 'Chercher pour';
$txt['search_match'] = 'Correspondance';

$txt['maintain_mode_on'] = 'Attention, ce forum est en \'Mode Maintenance\'.';

$txt['read'] = 'Lu'; //Deprecated
$txt['times'] = 'fois'; //Deprecated
$txt['read_one_time'] = 'Lu 1 fois';
$txt['read_many_times'] = 'Lu %1$d fois';

$txt['forum_stats'] = 'Statistiques du forum';
$txt['latest_member'] = 'Dernier membre';
$txt['total_cats'] = 'Total des catégories';
$txt['latest_post'] = 'Dernier message';

$txt['here'] = 'ici';
$txt['you_have_no_msg'] = 'Vous n\'avez aucun message...';
$txt['you_have_one_msg'] = 'Vous avez 1 message...<a href="%1$s">Cliquez ici pour le voir</a>';
$txt['you_have_many_msgs'] = 'Vous avez %2$d messages...<a href="%1$s">Cliquez ici pour les voir</a>';

$txt['total_boards'] = 'Total des sections';

$txt['print_page'] = 'Imprimer la page';
$txt['print_page_text'] = 'Texte seulement';
$txt['print_page_images'] = 'Texte et Images';

$txt['valid_email'] = 'L\'adresse de courriel doit être valide.';

$txt['info_center_title'] = '%1$s - Centre d\'informations';

$txt['send_topic'] = 'Partager';
$txt['unwatch'] = 'Non vu';
$txt['watch'] = 'Vu';

$txt['allow_user_email'] = 'Permettre aux utilisateurs de m\'envoyer des courriels';

$txt['check_all'] = 'Tout cocher';

// Use numeric entities in the below string.
$txt['database_error'] = 'Erreur de la base de données';
$txt['try_again'] = 'Merci de réessayer.  Si l\'erreur se reproduit, signalez cette erreur à un administrateur.';
$txt['file'] = 'Fichier';
$txt['line'] = 'Ligne';

// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'ElkArte a détecté une erreur et automatiquement essayé de réparer la base de données. Si vous continuez à avoir des problèmes, ou continuez à recevoir ces courriels, contactez votre hébergeur.';
$txt['database_error_versions'] = '<strong>Note :</strong> Votre version de base de données est %1$s.';
$txt['template_parse_error'] = 'Erreur de traitement du modèle !';
$txt['template_parse_error_message'] = 'Il semble que le forum rencontre actuellement quelques difficultés avec un de ses modèles graphiques. Le problème pourrait n\'être que temporaire, essayez de revenir plus tard. Si vous continuez à voir ce message, contactez l\'administrateur.<br /><br /> Vous pouvez aussi essayer de <a href="javascript:location.reload();">recharger la page</a>.';
$txt['template_parse_error_details'] = 'Il y a eu un problème  au chargement de <span class="tt"><strong>%1$s</strong></span> modèle ou fichier de langue. Vérifiez la syntaxe et essayez à nouveau - souvenez-vous , la simple quote (<span class="tt">\'</span>) doit souvent être annulée par 2 anti-slash (<span class="tt">\</span>). Pour avoir des informations sur des erreurs plus spécifiques de PHP, essayer <a href="%2$s%1$s">accéder au fichier directement</a>. <br /><br />Vous pourriez vouloir <a href="javascript:location.reload();">rafraîchir cette page</a> ou <a href="%3$s">utiliser le thème par défaut</a>.';
$txt['template_parse_undefined'] = 'Une erreur inconnue s\'est produite pendant le traitement de ce modèle.';

$txt['today'] = 'Aujourd\'hui à %1$s';
$txt['yesterday'] = 'Hier à %1$s';

// Relative times
$txt['rt_now'] = 'Maintenant';
$txt['rt_minute'] = 'Il y a une minute';
$txt['rt_minutes'] = 'Il y a %s minutes';
$txt['rt_hour'] = 'Il y a une heure';
$txt['rt_hours'] = 'Il y a %s heures';
$txt['rt_day'] = 'Il y a un jour';
$txt['rt_days'] = 'Il y a %s jours';
$txt['rt_week'] = 'Il y a une semaine';
$txt['rt_weeks'] = 'Il y a %s semaines';
$txt['rt_month'] = 'Il y a un mois';
$txt['rt_months'] = 'Il y a %s mois';
$txt['rt_year'] = 'Il y a un an';
$txt['rt_years'] = 'Il y a %s ans';

$txt['new_poll'] = 'Nouveau sondage';
$txt['poll_question'] = 'Question';
$txt['poll_question_options'] = 'Question et Options';
$txt['poll_vote'] = 'Soumettre mon vote';
$txt['poll_total_voters'] = 'Total des votants';
$txt['draft_saved_on'] = 'Derniers brouillons enregistrés';
$txt['poll_results'] = 'Voir les résultats';
$txt['poll_lock'] = 'Bloquer les votes';
$txt['poll_unlock'] = 'Débloquer les votes';
$txt['poll_edit'] = 'Modifier le sondage';
$txt['poll'] = 'Sondage';
$txt['one_day'] = '1 Jour';
$txt['one_week'] = '1 Semaine';
$txt['two_weeks'] = '2 Semaines';
$txt['one_month'] = '1 Mois';
$txt['two_months'] = '2 Mois';
$txt['forever'] = 'Toujours';
$txt['quick_login_dec'] = 'Connexion avec identifiant, mot de passe et durée de la session';
$txt['one_hour'] = '1 heure';
$txt['moved'] = 'DÉPLACÉ';
$txt['moved_why'] = 'Merci de préciser la raison du déplacement de ce sujet.';
$txt['board'] = 'Section';
$txt['in'] = 'dans';
$txt['sticky_topic'] = 'Sujet épinglé';
$txt['split'] = 'DIVISER';

$txt['delete'] = 'Effacer';

$txt['byte'] = 'octets';
$txt['kilobyte'] = 'Ko';
$txt['megabyte'] = 'Mo';
$txt['gigabyte'] = 'GB';

$txt['more_stats'] = '[plus de statistiques]';

$txt['code'] = 'Code';
$txt['code_select'] = '[Sélectionner]';
$txt['quote_from'] = 'Citation de';
$txt['quote'] = 'Citer';
$txt['quick_quote'] = 'Citer la sélection';
$txt['quote_new'] = 'Nouveau sujet';
$txt['follow_ups'] = 'Suivi';
$txt['topic_derived_from'] = 'Sujet provenant de %1$s';
$txt['edit'] = 'Modifier';
$txt['quick_edit'] = 'Édition rapide';
$txt['post_options'] = 'Plus d\'options';
$txt['quote_expand'] = 'Afficher le devis';

$txt['set_sticky'] = 'Épingler';
$txt['set_nonsticky'] = 'Détacher';
$txt['set_lock'] = 'Verrouiller';
$txt['set_unlock'] = 'Déverrouiller';

$txt['search_advanced'] = 'Afficher les options avancées';
$txt['search_simple'] = 'Cacher les options avancées';

$txt['security_risk'] = 'RISQUE DE SÉCURITÉ MAJEUR :';
$txt['not_removed'] = 'Vous n\'avez pas supprimé %1$s';
$txt['not_removed_extra'] = '%1$s est une sauvegarde de %2$s qui n\'a pas été généré par ElkArte. On peut y accéder directement et elle peut être utilisée pour donner des accès mon autorisés à votre forum. Vous devriez la supprimer immédiatement.';
$txt['generic_warning'] = 'Avertissement';
$txt['agreement_missing'] = 'Vous demandez aux nouveaux utilisateurs d\'accepter un accord d\'enregistrement, cependant le fichier (dans sources/ElkArte/Languages/Agreement/) n\'existe pas.';
$txt['agreement_accepted'] = 'Vous avez accepté les conditions d\'inscription.';
$txt['privacypolicy_accepted'] = 'Vous avez accepté le politique de protection de la vie privée du forum.';

$txt['new_version_updates'] = 'Vous venez de mettre à jour !';
$txt['new_version_updates_text'] = '<a href="{admin_url};area=credits#latest_updates">Cliquer ici pour découvrir les nouveautés de cette version d\'ElkArte</a> ! ';

$txt['cache_writable'] = 'Le répertoire cache est protégé en écriture - cela affectera grandement la performance de votre forum.';

$txt['page_created_full'] = 'Page créée en %1$.3f seconds avec %2$d requêtes.';

$txt['report_to_mod_func'] = 'Utilisez cette fonction pour informer les modérateurs et les administrateurs d\'un message abusif ou mal posté.';

$txt['online'] = 'En ligne';
$txt['member_is_online'] = '%1$s est en ligne';
$txt['offline'] = 'Hors ligne';
$txt['member_is_offline'] = '%1$s est hors ligne';
$txt['pm_online'] = 'Message personnel (En ligne)';
$txt['pm_offline'] = 'Message personnel (Hors ligne)';
$txt['status'] = 'Statut';

$txt['skip_nav'] = 'Aller au contenu principal';
$txt['go_up'] = 'En haut';
$txt['go_down'] = 'En bas';

$forum_copyright = '<a href="https://www.elkarte.net" title="ElkArte Forum" target="_blank" class="new_win">Powered by %1$s</a> | <a href="{credits_url}" title="Credits" target="_blank" class="new_win" rel="nofollow">Credits</a>';

$txt['birthdays'] = 'Anniversaires :';
$txt['events'] = 'Événements :';
$txt['birthdays_upcoming'] = 'Prochains anniversaires :';
$txt['events_upcoming'] = 'Prochains événements :';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Vacances :';
$txt['calendar_month'] = 'Mois :';
$txt['calendar_year'] = 'Année :';
$txt['calendar_day'] = 'Jour :';
$txt['calendar_event_title'] = 'Titre de l\'événement';
$txt['calendar_event_options'] = 'Options de l\'événement';
$txt['calendar_post_in'] = 'Publier dans :';
$txt['calendar_edit'] = 'Modifier l\'événement';
$txt['event_delete_confirm'] = 'Effacer cet événement ?';
$txt['event_delete'] = 'Effacer l\'événement';
$txt['calendar_post_event'] = 'Publier un événement';
$txt['calendar_link'] = 'Lien vers le calendrier';
$txt['calendar_upcoming'] = 'Prochains événements';
$txt['calendar_today'] = 'Événements du jour';
$txt['calendar_week'] = 'Semaine';
$txt['calendar_week_title'] = 'Semaine %1$d sur %2$d';
$txt['calendar_numb_days'] = 'Nombre de jours :';
$txt['calendar_how_edit'] = 'comment modifier ces événements ?';
$txt['calendar_link_event'] = 'Lier l\'événement au message :';
$txt['calendar_confirm_delete'] = 'Voulez-vous vraiment supprimer cet événement ?';
$txt['calendar_linked_events'] = 'Événements liés';
$txt['calendar_click_all'] = 'cliquer pour voir tous les %1$s';

$txt['moveTopic1'] = 'Publier un sujet redirigé';
$txt['moveTopic2'] = 'Changer le titre du sujet';
$txt['moveTopic3'] = 'Nouveau titre';
$txt['moveTopic4'] = 'Changer le titre de tous les messages';
$txt['move_topic_unapproved_js'] = 'Attention ! Ce sujet n\'a pas encore été approuvé.Il n\'est pas recommandé de créer un message de redirection à moins que vous n\'ayez l\'intention d\'approuver le message immédiatement après le déplacement.';
$txt['movetopic_auto_board'] = '[TABLEAU]';
$txt['movetopic_auto_topic'] = '[TOPIC LINK] ';
$txt['movetopic_default'] = 'Ce sujet a été déplacé vers [TABLEAU] - [LIEN DU SUJET]';
$txt['movetopic_redirect'] = 'Redirigé vers le sujet déplacé';
$txt['movetopic_expires'] = 'Supprimer automatiquement la redirection du sujet';

$txt['merge_to_topic_id'] = 'ID du sujet de destination';
$txt['split_topic'] = 'Diviser';
$txt['merge'] = 'Fusionner';
$txt['subject_new_topic'] = 'Titre du nouveau sujet';
$txt['split_this_post'] = 'Ne séparer du sujet que ce message-ci.';
$txt['split_after_and_this_post'] = 'Diviser le sujet en incluant ce message et tous ceux qui le suivent.';
$txt['select_split_posts'] = 'Choisir les messages à séparer du sujet.';

$txt['splittopic_notification'] = 'Publier un message quand un sujet est divisé';
$txt['splittopic_default'] = 'Un ou plusieurs messages de ce sujet ont été déplacés vers [BOARD] - [TOPIC LINK] ';
$txt['splittopic_move'] = 'Déplacer le nouveau sujet vers une autre section';

$txt['new_topic'] = 'Nouveau sujet';
$txt['split_successful'] = 'Le sujet a été divisé avec succès en deux sujets.';
$txt['origin_topic'] = 'Sujet d\'origine';
$txt['please_select_split'] = 'Merci de choisir quels messages vous voulez séparer.';
$txt['merge_successful'] = 'Sujets fusionnés avec succès.';
$txt['new_merged_topic'] = 'Nouveau sujet fusionné';
$txt['topic_to_merge'] = 'Sujet à fusionner';
$txt['target_board'] = 'Section de destination';
$txt['target_topic'] = 'Sujet de destination';
$txt['merge_confirm'] = 'Êtes-vous sûr de vouloir fusionner';
$txt['with'] = 'avec';
$txt['merge_desc'] = 'Cette fonction fusionnera les messages de deux sujets en un seul. Les messages seront classés par date de publication. Le plus ancien message deviendra le premier du nouveau sujet fusionné.';

$txt['theme_template_error'] = 'Impossible de charger le modèle \'%1$s\'.';
$txt['theme_language_error'] = 'Impossible de charger le fichier de langue \'%1$s\'.';

$txt['parent_boards'] = 'Sous-section';

$txt['smtp_no_connect'] = 'Échec de connexion au serveur SMTP';
$txt['smtp_port_ssl'] = 'Le port SMTP est incorrect. Il doit être mis à 465 pour un serveur SSL.';
$txt['smtp_bad_response'] = 'Erreur en réception des codes de réponse du serveur de courriel';
$txt['smtp_error'] = 'Incident survenu lors de l\'envoi de courriels. Erreur : ';
$txt['mail_send_unable'] = 'Impossible d\'envoyer un courriel à l\'adresse \'%1$s\'.';

$txt['mlist_search'] = 'Rechercher des membres';
$txt['mlist_search_email'] = 'Rechercher par e-mail';
$txt['mlist_search_group'] = 'Recherche par rang';
$txt['mlist_search_name'] = 'Recherche par pseudonyme';
$txt['mlist_search_website'] = 'Recherche par site web';
$txt['mlist_search_results'] = 'Résultats de la recherche pour';
$txt['mlist_search_by'] = 'Rechercher par %1$s';

$txt['attach_downloaded'] = 'téléchargé %1$d fois';
$txt['attach_viewed'] = 'vu %1$d fois';

$txt['settings'] = 'Paramètres';
$txt['never'] = 'Jamais';
$txt['more'] = 'plus';

$txt['hostname'] = 'Nom d\'hôte';
$txt['you_are_post_banned'] = 'Désolé %1$s, vous n\'avez plus le droit de publier ou d\'envoyer des messages personnels sur ce forum.';
$txt['ban_reason'] = 'Raison';

$txt['add_poll'] = 'Ajouter un sondage';
$txt['poll_options6'] = 'Vous ne pouvez pas choisir plus de %1$s options.';
$txt['poll_remove'] = 'Supprimer le sondage';
$txt['poll_remove_warn'] = 'Êtes-vous sûr de vouloir supprimer ce sondage de la discussion ?';
$txt['poll_results_expire'] = 'Les résultats seront affichés à la clôture du vote';
$txt['poll_expires_on'] = 'Arrêt des votes';
$txt['poll_expired_on'] = 'Les votes sont terminés';
$txt['poll_change_vote'] = 'Supprimer le vote';
$txt['poll_return_vote'] = 'Options de vote';
$txt['poll_cannot_see'] = 'Vous ne pouvez pas voir les résultats de ce sondage pour le moment.';

$txt['quick_mod_approve'] = 'Approuver la sélection';
$txt['quick_mod_remove'] = 'Supprimer la sélection';
$txt['quick_mod_lock'] = 'Bloquer/Débloquer la sélection';
$txt['quick_mod_sticky'] = 'Épingler/Détacher la sélection';
$txt['quick_mod_move'] = 'Déplacer la sélection vers';
$txt['quick_mod_merge'] = 'Fusionner la sélection';
$txt['quick_mod_markread'] = 'Marquer la sélection comme lue';
$txt['quick_mod_go'] = 'Aller';
$txt['quickmod_confirm'] = 'Êtes-vous sûr de vouloir faire cela ?';

$txt['quick_reply'] = 'Réponse Rapide';
$txt['quick_reply_warning'] = 'Attention ! Ce sujet est verrouillé, seuls les administrateurs et les modérateurs peuvent répondre.';
$txt['quick_reply_verification'] = 'Après avoir soumis votre message, vous serez redirigé vers la page habituelle d\'écriture pour vérifier votre message %1$s.';
$txt['quick_reply_verification_guests'] = '(requis pour tous les invités)';
$txt['quick_reply_verification_posts'] = '(requis pour tous les utilisateurs ayant moins de %1$d messages)';
$txt['wait_for_approval'] = 'Note : ce message ne s\'affichera qu\'après avoir été approuvé par un modérateur.';

$txt['notification_enable_board'] = 'Êtes-vous sûr de vouloir activer la notification des nouveaux sujets pour cette section ?';
$txt['notification_disable_board'] = 'Êtes-vous sûr de vouloir désactiver la notification des nouveaux sujets pour cette section ?';
$txt['notification_enable_topic'] = 'Êtes-vous sûr de vouloir activer la notification des nouvelles réponses pour ce sujet ?';
$txt['notification_disable_topic'] = 'Êtes-vous sûr de vouloir désactiver la notification des nouvelles réponses pour ce sujet ?';

$txt['report_to_mod'] = 'Signaler un message';
$txt['issue_warning'] = 'Émettre un avertissement';
$txt['issue_warning_post'] = 'Donner un avertissement à cause de ce message';

$txt['like_post'] = 'J\'aime';
$txt['unlike_post'] = 'J\'aime pas';
$txt['likes'] = 'J\'aime';
$txt['liked_by'] = 'Apprécié par :';
$txt['liked_you'] = 'Vous';
$txt['liked_more'] = 'plus';
$txt['likemsg_are_you_sure'] = 'Vous avez déjà apprécié ce message, êtes vous certain de vouloir retirer votre appréciation ?';

$txt['unread_topics_visit'] = 'Sujets récents non lus';
$txt['unread_topics_visit_none'] = 'Pas de sujets non lus trouvés depuis votre dernière visite. <a href="{unread_all_url}" class="linkbutton">Cliquez ici pour essayer tous les sujets non lus</a>';
$txt['unread_topics_all'] = 'Tous les sujets non lus';
$txt['unread_replies'] = 'Sujets mis à jour';

$txt['who_title'] = 'Qui est en ligne';
$txt['who_and'] = ' et ';
$txt['who_viewing_topic'] = 'dans ce sujet';
$txt['who_viewing_board'] = ' dans cette section.';
$txt['who_member'] = 'Membre';

// Current footer strings
$txt['valid_html'] = 'Validé HTML5';
$txt['rss'] = 'Flux RSS';
$txt['atom'] = 'Atome';
$txt['html'] = 'HTML';

$txt['guest'] = 'Invité';
$txt['guests'] = 'Invités';
$txt['user'] = 'Membre';
$txt['users'] = 'Membres';
$txt['hidden'] = 'Caché';
// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Cachés';
$txt['buddy'] = 'Ami';
$txt['buddies'] = 'Amis';
$txt['most_online_ever'] = 'Record de connexions absolu';
$txt['most_online_today'] = 'Record de connexions aujourd\'hui';

$txt['merge_select_target_board'] = 'Choisir la section de destination pour le sujet fusionné';
$txt['merge_select_poll'] = 'Choisir quel sondage le sujet fusionné aura';
$txt['merge_topic_list'] = 'Choisir les sujets à fusionner';
$txt['merge_select_subject'] = 'Choisir le titre du sujet fusionné';
$txt['merge_custom_subject'] = 'Titre personnel';
$txt['merge_enforce_subject'] = 'Changer le titre de tous les messages';
$txt['merge_include_notifications'] = 'Inclure les notifications ?';
$txt['merge_check'] = 'Fusionner ?';
$txt['merge_no_poll'] = 'Pas de sondage';

$txt['response_prefix'] = 'Re : ';
$txt['current_icon'] = 'Icône actuelle';
$txt['message_icon'] = 'Icône du message';

$txt['smileys_current'] = 'Jeu actuel d\'émoticônes';
$txt['smileys_none'] = 'Pas d\'émoticônes';
$txt['smileys_forum_board_default'] = 'Forum/Section par défaut';

$txt['search_results'] = 'Résultats de la Recherche';

$txt['totalTimeLogged2'] = ' jours, ';
$txt['totalTimeLogged3'] = ' heures et ';
$txt['totalTimeLogged4'] = ' minutes.';
$txt['totalTimeLogged5'] = 'j';
$txt['totalTimeLogged6'] = 'h ';
$txt['totalTimeLogged7'] = 'm';

$txt['approve_thereis'] = 'Il y a'; //Deprecated
$txt['approve_thereare'] = 'Il y a'; //Deprecated
$txt['approve_member'] = 'un membre'; //Deprecated
$txt['approve_members'] = 'membres'; //Deprecated
$txt['approve_members_waiting'] = 'en attente d\'approbation.'; //Deprecated
$txt['approve_one_member_waiting'] = 'Il y a <a href="%1$s">un membre</a> en attente d\'approbation.';
$txt['approve_many_members_waiting'] = 'Il y a <a href="%1$s">%2$d membres</a> en attente d\'approbation.';

$txt['notifyboard_turnon'] = 'Voulez-vous recevoir un courriel de notification quand quelqu\'un publie un nouveau sujet dans cette section ?';
$txt['notifyboard_turnoff'] = 'Êtes-vous sûr de vouloir désactiver les courriels de notification des nouveaux sujet pour cette section ?';

$txt['notify_unsubscribed_generic'] = 'spécifié';
$txt['notify_board_unsubscribed'] = 'Le courriel, %2$s, a été désabonné avec succès et ne recevra plus de notifications de la section "%1$s".';
$txt['notify_topic_unsubscribed'] = 'Le courriel, %2$s, a été désabonné avec succès et ne recevra plus de notifications du sujet "%1$s".';
$txt['notify_mention_unsubscribed'] = 'Le courriel, %2$s a été désabonné avec succès et ne recevra plus de notifications de "%1$s".';
$txt['notify_default_unsubscribed'] = 'Votre demande a été traitée avec succès.';

$txt['find_members'] = 'Trouver des membres';
$txt['find_username'] = 'Identifiant, pseudonyme ou adresse de courriel';
$txt['find_buddies'] = 'Ne montrer que les amis ?';
$txt['find_wildcards'] = 'Jokers autorisés : *, ?';
$txt['find_no_results'] = 'Pas de résultats trouvés';
$txt['all_caught_up'] = 'Vous êtes à jour !';
$txt['find_results'] = 'Résultats';
$txt['find_close'] = 'Fermer';

$txt['quickmod_delete_selected'] = 'Effacer la sélection';
$txt['quickmod_split_selected'] = 'Scinder la sélection';

$txt['show_personal_messages_heading'] = 'Nouveaux messages';
$txt['show_personal_messages'] = 'Vous avez <strong>%1$s</strong> messages personnels non lus dans votre boîte de réception. <br /><br /><a href="%2$s">Aller à le boîte de réception</a>';

$txt['help_popup'] = 'Un peu perdu ? Je vais vous expliquer :';

$txt['previous_next_back'] = 'sujet précédent';
$txt['previous_next_forward'] = 'sujet suivant';

$txt['upshrink_description'] = 'Cacher ou afficher l\'entête.';

$txt['mark_unread'] = 'Marquer non lu';

$txt['ssi_not_direct'] = 'Veuillez ne pas accéder directement à SSI.php par l\'URL ; utilisez plutôt le chemin (%1$s) ou ajoutez ?ssi_function=quelquechose.';
$txt['ssi_session_broken'] = 'SSI.php n\'a pas pu charger une session ! Cela peut causer des problèmes pour la déconnexion et d\'autres fonctions - veuillez vous assurer que SSI.php est inclus avant *tout autre code* dans vos scripts !';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Prévisualiser le message';
$txt['preview_fetch'] = 'Chargement de la prévisualisation ;';
$txt['pm_error_while_submitting'] = 'La ou les erreurs suivantes se sont produites pendant l\'envoie de ce message personnel :';
$txt['warning_while_submitting'] = 'Quelque chose s\'est produit, consultez le retour ici :';
$txt['error_while_submitting'] = 'La ou les erreurs suivantes doivent être corrigées dans le message avant de poursuivre :';
$txt['error_old_topic'] = 'Attention, il n\'y a pas eu de réponse à ce sujet depuis au moins %1$d jours.<br /> À moins que vous ne soyez sûr de vouloir répondre, pensez éventuellement à créer un nouveau sujet.';

$txt['split_selected_posts'] = 'Messages sélectionnés';
$txt['split_selected_posts_desc'] = 'Les messages suivants formeront un nouveau sujet après la scission.';
$txt['split_reset_selection'] = 'réinitialiser la sélection';

$txt['modify_cancel'] = 'Annuler';
$txt['mark_read_short'] = 'Marquer lu';

$txt['hello_member_ndt'] = 'Bonjour';

$txt['unapproved_posts'] = 'Messages non approuvés (Sujets : %1$d, Messages : %2$d)';

$txt['ajax_in_progress'] = 'Chargement...';
$txt['ajax_bad_response'] = 'Réponse invalide.';

$txt['mod_reports_waiting'] = 'Il y a actuellement %1$d rapports de modérateur ouverts.';
$txt['pm_reports_waiting'] = 'Il y a actuellement %1$d rapports de messages personnels ouverts.';

$txt['new_posts_in_category'] = 'Cliquez ici pour voir les nouveaux messages dans %1$s';
$txt['verification'] = 'Vérification';
$txt['visual_verification_hidden'] = 'S\'il vous plaît laisser cet espace vide';
$txt['visual_verification_description'] = 'Saisissez les lettres montrées dans l\'image';
$txt['visual_verification_request_new'] = 'Demander une autre image';

// @todo Send email strings - should move?
$txt['send_email'] = 'Envoyer un courriel';
$txt['send_email_disclosed'] = 'Notez que cela sera visible pour le destinataire.';
$txt['send_email_subject'] = 'Sujet du courriel';

$txt['ignoring_user'] = 'Vous ignorez cet utilisateur.';
$txt['show_ignore_user_post'] = '<em>[Afficher le message.</em>]';

$txt['spider'] = 'Robot';
$txt['spiders'] = 'Robots';

$txt['downloads'] = 'Téléchargements';
$txt['filesize'] = 'Taille du fichier';

// Restore topic
$txt['restore_topic'] = 'Restaurer ce sujet';
$txt['restore_message'] = 'Restaurer ce message';
$txt['quick_mod_restore'] = 'Restaurer les messages sélectionnés';

// Editor prompt.
$txt['prompt_text_email'] = 'Indiquez l\'adresse de courriel.';
$txt['prompt_text_ftp'] = 'Indiquez l\'adresse du serveur FTP.';
$txt['prompt_text_url'] = 'Indiquez l\'adresse Web du lien.';
$txt['prompt_text_img'] = 'Indiquez l\'adresse Web de l\'image';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Supprimer cet élément';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Modèles : ';
$txt['debug_sub_templates'] = 'Sous-modèles : ';
$txt['debug_language_files'] = 'Fichiers de langue : ';
$txt['debug_sheets'] = 'Feuilles de style :';
$txt['debug_javascript'] = 'Scripts : ';
$txt['debug_files_included'] = 'Fichiers inclus : ';
$txt['debug_kb'] = 'Ko';
$txt['debug_show'] = 'afficher';
$txt['debug_cache_hits'] = 'Appel au cache  : ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s octets';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss pour %2$s octets';
$txt['debug_queries_used'] = 'Requêtes utilisées : %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Requêtes utilisées : %1$d, %2$d avertissements.';
$txt['debug_query_in_line'] = 'Appelée dans <em>%1$s</em>, à la ligne <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'et exécutée en %1$s secondes.';
$txt['debug_query_which_took_at'] = 'et exécutée en %1$s secondes, à %2$s secondes du lancement du script.';
$txt['debug_show_queries'] = '[Afficher les requêtes]';
$txt['debug_hide_queries'] = '[Cacher les requêtes]';
$txt['debug_tokens'] = 'Jetons : ';
$txt['debug_browser'] = 'ID du navigateur : ';
$txt['debug_hooks'] = 'Crochets appelés : ';
$txt['debug_system_type'] = 'Système : ';
$txt['debug_server_load'] = 'Charge du serveur : ';
$txt['debug_script_mem_load'] = 'Script usage de la mémoire : ';
$txt['debug_script_cpu_load'] = 'Script temps CPU (utilisateur/système) : ';

// Video embedding
$txt['preview_image'] = 'Image de prévisualisation de la vidéo';
$txt['ctp_video'] = 'Cliquer pour lire la vidéo';
$txt['hide_video'] = 'Afficher/Cacher la vidéo';
$txt['youtube'] = 'YouTube :';
$txt['vimeo'] = 'Vimeo :';
$txt['dailymotion'] = 'Dailymotion :';
$txt['tiktok'] = 'TikTok :';
$txt['twitter'] = 'X/Twitter :';
$txt['facebook'] = 'Facebook :';
$txt['instagram'] = 'Instagram :';

// Spoiler BBC
$txt['spoiler'] = 'Afficher (cliquer pour afficher/cacher)';

$txt['ok_uppercase'] = 'OK';

// Title of box for warnings that admins should see
$txt['admin_warning_title'] = 'Avertissement';

$txt['via'] = 'via';

$txt['like_post_stats'] = 'Statistiques des appréciations';

$txt['otp_token'] = 'Mot de passe à usage unique';
$txt['otp_enabled'] = 'Activer la double authentification';
$txt['invalid_otptoken'] = 'Le mot de passe à usage unique n\'est pas valide';
$txt['otp_used'] = 'Le mot de passe à usage unique a déjà été utilisé.<br /> Patientez un moment et utilisez le code suivant.';
$txt['otp_generate'] = 'Créer';
$txt['otp_show_qr'] = 'Afficher le QR-Code';

$txt['other'] = 'Autre';

$txt['retry'] = 'RÉESSAYER';
$txt['check_connection'] = 'Veuillez vérifier votre connexion Internet';
