<?php
// Version: 2.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
// Additionally do not translate the @additional_params: line or the variable names in the lines that follow it.  You may
// translate the description of the variable.  Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

$txt['scheduled_approval_email_topic'] = 'Folgende Themen warten auf Genehmigung:';
$txt['scheduled_approval_email_msg'] = 'Folgende Beiträge warten auf Genehmigung:';
$txt['scheduled_approval_email_attach'] = 'Folgende Dateianhänge warten auf Genehmigung:';
$txt['scheduled_approval_email_event'] = 'Folgende Ereignisse warten auf Genehmigung:';

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Willkommen im Forum {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Thank you for registering at {FORUMNAME}. Your username is {USERNAME}. If you forget your password, you can reset it by visiting {FORGOTPASSWORDLINK}

Before you can login, you must first activate your account by selecting the following link:

{ACTIVATIONLINK}

Should you have any problems with the activation, please visit {ACTIVATIONLINKWITHOUTCODE} and enter the code "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Willkommen im Forum {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Hallo, {REALNAME}, wir haben Ihre Anfrage zur Registrierung im Forum {FORUMNAME} erhalten.

Der Benutzername mit dem Sie sich registriert haben ist {USERNAME}.

Bevor Sie sich einloggen und das Forum benutzen können, wird Ihre Anfrage geprüft und genehmigt. Wenn dies geschehen ist, erhalten Sie eine weitere E-Mail von dieser Adresse.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Genehmigung der Gruppenmitgliedschaft';
$txt['mc_group_approve_body'] = '{USERNAME},

Wir freuen uns Ihnen mitteilen zu können, dass Ihre Anfrage der Gruppe "{GROUPNAME}" im Forum {FORUMNAME} beizutreten akzeptiert wurde. Ihr Benutzerkonto wurde um die neue Mitgliedergruppe ergänzt.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Ablehnung der Gruppenmitgliedschaft';
$txt['mc_group_reject_body'] = '{USERNAME},

Wir bedauern Ihnen mitteilen zu müssen, dass Ihre Anfrage der Gruppe "{GROUPNAME}" im Forum {FORUMNAME} beizutreten abgelehnt wurde.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Ablehnung der Gruppenmitgliedschaft';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

Wir bedauern Ihnen mitteilen zu müssen, dass Ihre Anfrage der Gruppe "{GROUPNAME}" im Forum {FORUMNAME} beizutreten abgelehnt wurde.

Dies erfolgte aus folgenden Gründen: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Willkommen im Forum {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Welcome, {NAME}

Your account has been activated manually by the admin and you can now login and post. Your username is: {USERNAME}. If you forget your password, you can change it at {FORGOTPASSWORDLINK}

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Willkommen im Forum {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Willkommen, {USERNAME}!

Ihr Benutzerkonto im Forum {FORUMNAME} wurde vom Administrator genehmigt und muss jetzt aktiviert werden, bevor Sie Beiträge schreiben können. Bitte benutze folgenden Link, um Ihr Benutzerkonto zu aktivieren:

{ACTIVATIONLINK}

Sollten Sie Probleme mit der Aktivierung haben, verwenden Sie bitte diesen Link {ACTIVATIONLINKWITHOUTCODE} und geben Sie dort folgenden Code ein: "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Registrierung abgelehnt';
$txt['admin_approve_reject_body'] = '{USERNAME},

Ihre Anfrage dem Forum {FORUMNAME} beizutreten wurde abgelehnt.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Profil gelöscht';
$txt['admin_approve_delete_body'] = '{USERNAME},

Ihr Profil im Forum {FORUMNAME} wurde gelöscht. Dies ist eventuell passiert, weil Sie Ihr Profil nie aktiviert haben. War dies der Fall, können Sie sich jederzeit erneut registrieren.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Registrierungserinnerung';
$txt['admin_approve_remind_body'] = '{USERNAME},
Sie haben Ihr Benutzerkonto im Forum {FORUMNAME} noch nicht aktiviert.

Bitte benutzen Sie folgenden Link, um Ihr Benutzerkonto zu aktivieren:
{ACTIVATIONLINK}

Sollten Sie Probleme mit der Aktivierung haben, verwenden Sie bitte diesen Link {ACTIVATIONLINKWITHOUTCODE} und geben Sie dort folgenden Code ein: "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Willkommen im Forum {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Sie sind jetzt mit einem Benutzerkonto im Forum {FORUMNAME} registriert. Ihr Benutzername lautet {USERNAME} und Ihr Passwort lautet {PASSWORD}.

Bevor Sie sich einloggen können, müssen Sie zuerst Ihr Konto aktivieren. Dazu folgen Sie bitte folgendem Link:

{ACTIVATIONLINK}

Sollten Sie Probleme mit der Aktivierung haben, verwenden Sie bitte diesen Link {ACTIVATIONLINKWITHOUTCODE} und geben Sie dort folgenden Code ein "{ACTIVATIONCODE}".
{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Willkommen im Forum {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Sie sind jetzt mit einem Benutzerkonto im Forum {FORUMNAME} registriert. Ihr Benutzername lautet {USERNAME} und Ihr Passwort lautet {PASSWORD}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
	@description:
*/
$txt['new_announcement_subject'] = 'Neue Ankündigung: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

Um diese Ankündigungen abzubestellen, loggen Sie sich bitte im Forum ein und deaktivieren die Option "E-Mail Benachrichtigung bei neuen Ankündigungen schicken" in Ihrem Profil.

Sie können die komplette Ankündigung unter folgendem Link lesen:
{TOPICLINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Neues Thema: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Ein neues Thema, \'{TOPICSUBJECT}\', wurde in einem Forum erstellt, welches Sie beobachten.

Sie finden es unter
{TOPICLINK}


Es könnten mehrere Themen erstellt worden sein, Sie erhalten jedoch erst weitere Benachrichtigungen, wenn Sie das Forum besucht haben.

Der Titel des Themas lautet:
{MESSAGE}

Um die Benachrichtigungen über neue Themen aus diesem Board abzubestellen, klicken Sie bitte auf folgenden Link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Neues Thema: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Ein neues Thema, \'{TOPICSUBJECT}\', wurde in einem Forum erstellt, welches Sie beobachten.

Sie finden es unter
{TOPICLINK}

Es könnten mehrere Themen erstellt worden sein, Sie erhalten jedoch erst weitere Benachrichtigungen, wenn Sie das Forum besucht haben.

Um die Benachrichtigungen über neue Themen aus diesem Board abzubestellen, klicken Sie bitte auf folgenden Link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Neues Thema: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Ein neues Thema, \'{TOPICSUBJECT}\', wurde in einem Forum erstellt, welches Sie beobachten.

Sie finden es unter
{TOPICLINK}

Der Inhalt des Themas lautet:
{MESSAGE}

Um die Benachrichtigungen über neue Themen aus diesem Board abzubestellen, klicken Sie bitte auf folgenden Link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Neues Thema: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Ein neues Thema, \'{TOPICSUBJECT}\', wurde in einem Forum erstellt, welches Sie beobachten.

Sie finden es unter
{TOPICLINK}

Um die Benachrichtigungen über neue Themen aus diesem Board abzubestellen, klicken Sie bitte auf folgenden Link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Neue Gruppenbeitrittsanfrage';
$txt['request_membership_body'] = '{RECPNAME},

{APPYNAME} hat eine Mitgliedschaft für die Gruppe "{GROUPNAME}" angefordert. Der Benutzer hat folgenden Grund angegeben:

{REASON}

Sie können diese Anfrage genehmigen oder ablehnen, indem Sie den folgenden Link besuchen:

{MODLINK}

{REGARDS}';

/**
	@additional_params: scheduled_approval
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Das Abonnement im Forum {FORUMNAME} läuft ab';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Eines Ihrer Abonnements im Forum {FORUMNAME} läuft in der nächsten Zeit ab. Wenn Sie beim Bestellen des Abonnements die automatische Erneuerung aktiviert haben, müssen Sie nichts weiter tun; ansonsten müssen Sie das Abonnement nochmal durchführen, wenn Sie dies möchten. Lesen Sie die folgenden Details:

Name des Abonnements: {SUBSCRIPTION}
Läuft ab: {END_DATE}

Um Ihre Abonnements zu ändern, besuchen Sie bitte folgenden Link:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The url link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Willkommen zurück im Forum {FORUMNAME}';
$txt['activate_reactivate_body'] = 'Um Ihre E-Mail-Adresse zu überprüfen, wurde Ihr Profil deaktiviert. Klicken Sie den folgenden Link, um es wieder zu aktivieren:
{ACTIVATIONLINK}

Sollten Sie Probleme mit der Aktivierung haben, verwenden Sie bitte diesen Link {ACTIVATIONLINKWITHOUTCODE} und geben Sie dort folgenden Code ein "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Neues Passwort für das Forum {FORUMNAME}';
$txt['forgot_password_body'] = 'Dear {REALNAME},

This mail was sent because the \'forgot password\' function has been applied to your account. To set a new password, click the following link:
{REMINDLINK}

IP: {IP}
Username: {MEMBERNAME}

If you\'ve received this password-assistance email and you didn\'t request one, it\'s likely that another user entered your email address by mistake.  If you didn\'t initiate the request, don\'t worry - your account is secure, and there\'s no need for you to take any further action.
Your privacy and security aren\'t compromised by this email.

{REGARDS}';

/**
	@additional_params: scheduled_approval
		REALNAME: The real (display) name of the person receiving the email.
		BODY: The generated body of the mail.
	@description:
*/
$txt['scheduled_approval_subject'] = 'Zusammenfassung der Beiträge, die eine Genehmigung im Forum {FORUMNAME} erwarten';
$txt['scheduled_approval_body'] = '{REALNAME},

Diese E-Mail enthält eine Zusammenfassung der Beiträge, die im Forum {FORUMNAME} eine Genehmigung erwarten.

{BODY}

Bitte loggen Sie sich im Forum ein, um die einzelnen Beiträge zu prüfen.
{SCRIPTURL}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The report post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The url of the post that is being reported.
		REPORTLINK: The url of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Gemeldeter Beitrag: {TOPICSUBJECT} von {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Der Beitrag "{TOPICSUBJECT}" von {POSTERNAME} wurde von {REPORTERNAME} in einem von Ihnen moderierten Board gemeldet:

Das Thema: {TOPICLINK}
Moderationszentrum: {REPORTLINK}

Der Benutzer hat folgenden Kommentar dazu geschrieben:
{COMMENT}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Details zum neuen Passwort';
$txt['change_password_body'] = 'Hallo, {USERNAME}!

Ihre Daten zum Anmelden im Forum {FORUMNAME} wurden geändert und das Passwort zurückgesetzt. Im Folgenden sind Ihre neuen Login-Daten aufgelistet.

Ihr Benutzername lautet "{USERNAME}" und Ihr Passwort lautet "{PASSWORD}".

Sie können diese Daten ändern, wenn Sie nach dem Anmelden Ihr Profil editieren. Sie können nach dem Anmelden auch folgenden Link besuchen:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The url link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Willkommen im Forum {FORUMNAME}';
$txt['register_activate_body'] = 'Thank you for registering at {FORUMNAME}. Your username is {USERNAME}. If you forget your password, you can reset it by visiting {FORGOTPASSWORDLINK}

Before you can login, you first need to activate your account. To do so, please follow this link:

{ACTIVATIONLINK}

Should you have any problems with activation, please visit {ACTIVATIONLINKWITHOUTCODE} use the code "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The url link to the coppa form.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Willkommen im Forum {FORUMNAME}';
$txt['register_coppa_body'] = 'Du bist jetzt mit einem Benutzerkonto im Forum {FORUMNAME} registriert, {REALNAME}!

Dein Benutzername lautet {USERNAME} und das Passwort lautet {PASSWORD}. Wenn du dein Passwort vergessen hast, kannst du es unter folgendem Link zurücksetzen: {FORGOTPASSWORDLINK}

Bevor du dich anmelden kannst, benötigt der Administrator das Einverständnis deiner Eltern/Erziehungsberechtigten. Weitere Informationen findest du hier:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Willkommen im Forum {FORUMNAME}';
$txt['register_immediate_body'] = 'Thank you for registering at {FORUMNAME}. Your username is {USERNAME}. If you forget your password, you may change it at {FORGOTPASSWORDLINK}

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Willkommen im Forum {FORUMNAME}';
$txt['register_pending_body'] = 'Hello {REALNAME}, your registration request at {FORUMNAME} has been received.

The username you registered with was {USERNAME}. If you forget your password, you can change it at {FORGOTPASSWORDLINK}

Before you can login and start using the forum, your request will be reviewed and approved.  When this happens, you will receive another email from this address.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Antwort im Thema: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'In diesem Thema wurde eine Antwort von {POSTERNAME} geschrieben.

Lesen Sie die Antwort unter: {TOPICLINK}

Um die Benachrichtigungen für dieses Thema abzubestellen, klicken Sie auf folgenden Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Antwort im Thema: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'In diesem Thema wurde eine Antwort von {POSTERNAME} geschrieben.

Lesen Sie die Antwort unter: {TOPICLINK}

Um die Benachrichtigungen für dieses Thema abzubestellen, klicken Sie auf folgenden Link: {UNSUBSCRIBELINK}

Der Text der Antwort lautet:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Antwort im Thema: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'In einem Thema, das Sie beobachten, wurde eine Antwort von {POSTERNAME} geschrieben.

Lesen Sie die Antwort unter: {TOPICLINK}

Um die Benachrichtigungen für dieses Thema abzubestellen, klicken Sie auf folgenden Link: {UNSUBSCRIBELINK}

Es könnten mehrere Antworten geschrieben worden sein, Sie erhalten jedoch erst weitere Benachrichtigungen, wenn Sie das Thema gelesen haben.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Antwort im Thema: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'In einem Thema, das Sie beobachten, wurde eine Antwort von {POSTERNAME} geschrieben.

Lesen Sie die Antwort unter: {TOPICLINK}

Um die Benachrichtigungen für dieses Thema abzubestellen, klicken Sie auf folgenden Link: {UNSUBSCRIBELINK}

Der Text der Antwort lautet:
{MESSAGE}

Es könnten mehrere Antworten geschrieben worden sein, Sie erhalten jedoch erst weitere Benachrichtigungen, wenn Sie das Thema gelesen haben.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Thema angeheftet: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Ein von Ihnen beobachtetes Thema wurde von {POSTERNAME} angeheftet.

Lesen Sie das Thema unter: {TOPICLINK}

Um die Benachrichtigungen für dieses Thema abzubestellen, klicken Sie auf folgenden Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Thema geschlossen: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Ein von Ihnen beobachtetes Thema wurde von {POSTERNAME} geschlossen.

Lesen Sie das Thema unter: {TOPICLINK}

Um die Benachrichtigungen für dieses Thema abzubestellen, klicken Sie auf folgenden Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Thema geöffnet: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Ein von Ihnen beobachtetes Thema wurde von {POSTERNAME} wieder geöffnet.

Lesen Sie das Thema unter: {TOPICLINK}

Um die Benachrichtigungen für dieses Thema abzubestellen, klicken Sie auf folgenden Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Thema gelöscht: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Ein von Ihnen beobachtetes Thema wurde von {POSTERNAME} gelöscht.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Thema verschoben: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Ein von Ihnen beobachtetes Thema wurde von {POSTERNAME} in ein anderes Forum verschoben.

Lesen Sie das Thema unter: {TOPICLINK}

Um die Benachrichtigungen für dieses Thema abzubestellen, klicken Sie auf folgenden Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Thema zusammengeführt: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Ein von Ihnen beobachtetes Thema wurde von {POSTERNAME} mit einem anderen Thema zusammengeführt.

Lesen Sie das neue, zusammengeführte Thema unter: {TOPICLINK}

Um die Benachrichtigungen für dieses Thema abzubestellen, klicken Sie auf folgenden Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Thema geteilt: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Ein von Ihnen beobachtetes Thema wurde von {POSTERNAME} in zwei oder mehr Themen geteilt.

Lesen Sie das verbliebene Thema unter: {TOPICLINK}

Um die Benachrichtigungen für dieses Thema abzubestellen, klicken Sie auf folgenden Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Ein neues Mitglied hat sich angemeldet';
$txt['admin_notify_body'] = '{USERNAME} hat sich als neues Mitglied in Ihrem Forum angemeldet. Klicken Sie auf den folgenden Link, um das Profil zu betrachten.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Ein neues Mitglied hat sich angemeldet';
$txt['admin_notify_approval_body'] = '{USERNAME} hat sich als neues Mitglied in Ihrem Forum angemeldet. Klicken Sie auf den folgenden Link, um das Profil zu betrachten.
{PROFILELINK}

Bevor dieses Mitglied Beiträge schreiben kann, muss das Profil zuerst genehmigt werden. Klicken Sie auf den folgenden Link, um auf die Aktivierungsseite zu gelangen.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Dringend! Das Anhänge-Verzeichnis ist fast voll';
$txt['admin_attachments_full_body'] = '{REALNAME},

Das Verzeichnis für Anhänge des Forums {FORUMNAME} ist fast voll. Bitte kontrollieren Sie die Einstellungen, um das Problem zu beseitigen.

Wenn das Anhänge-Verzeichnis die max. Größe erreicht hat, können die Benutzer keine weiteren Dateianhänge oder Benutzerbilder hochladen (wenn aktiviert).

{REGARDS}';

/**
	@additional_params: admin_backup_database
		BAK_REALNAME: the name of the user doing the backup
	@description:
*/
$txt['admin_backup_database_subject'] = 'Die Datenbank wurde gesichert';
$txt['admin_backup_database_body'] = '{REALNAME},

This email is to inform you that {BAK_REALNAME} has just downloaded a backup of the database at {FORUMNAME}.

{REGARDS}';

/**
	@additional_params: editing_theme
		EDIT_REALNAME: the name of the user doing the backup
		FILE_EDITED: the name of the file being modified
		THEME_NAME: the name of the theme
	@description:
*/
$txt['editing_theme_subject'] = 'Ändert ein Design';
$txt['editing_theme_body'] = '{REALNAME},⏎
⏎
mit dieser E-Mail möchten wir Sie darüber informieren, dass {EDIT_REALNAME} die Vorlagendatei {FILE_EDITED} des Designs {THEME_NAME} auf {FORUMNAME} bearbeitet.⏎
⏎
Wenn Sie wissen, dass das nicht der Fall ist, stellen Sie bitte Nachforschungen an.
⏎
{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Zurückgezahltes Abonnement';
$txt['paid_subscription_refund_body'] = '{REALNAME},

Ein Benutzer hat ein bezahltes Abonnement zurückerstattet bekommen. Hier sind weitere Details des Abonnements:

	Abonnement: {NAME}
	Benutzername: {REFUNDNAME} ({REFUNDUSER})
	Datum: {DATE}

Sie können das Profil des Benutzers anschauen, in dem Sie den folgenden Link anklicken:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Neues bezahltes Abonnement';
$txt['paid_subscription_new_body'] = '{REALNAME},

Ein Benutzer hat ein neues Abonnement bestellt. Hier sind die Details zu der Bestellung:

	Abonnement: {NAME}
	Benutzername: {SUBNAME} ({SUBUSER})
	E-Mail-Adresse: {SUBEMAIL}
	Preis: {PRICE}
	Datum: {DATE}

Sie können das Profil des Benutzers anschauen, in dem Sie den folgenden Link anklicken:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Bezahltes Abonnement. Ein Fehler ist aufgetreten';
$txt['paid_subscription_error_body'] = '{REALNAME},

Der folgende Fehler trat während der Verarbeitung eines bezahlten Abonnements auf
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Neue private Nachricht: {SUBJECT}';
$txt['new_pm_body'] = 'Sie haben eine private Nachricht von {SENDER} im Forum {FORUMNAME} erhalten.

WICHTIG: Das ist nur eine Benachrichtigung - bitte antworten Sie nicht auf diese E-Mail!

Die Nachricht lesen: {READLINK}

Auf die Nachricht antworten: {REPLYLINK}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Neue private Nachricht: {SUBJECT}';
$txt['new_pm_body_body'] = 'Sie haben eine private Nachricht von {SENDER} im Forum {FORUMNAME} erhalten.

WICHTIG: Das ist nur eine Benachrichtigung - bitte antworten Sie nicht auf diese E-Mail!

Diese Nachricht wurde Ihnen gesendet:

{MESSAGE}

Auf die Nachricht antworten: {REPLYLINK}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Neue private Nachricht: {SUBJECT}';
$txt['new_pm_tolist_body'] = '{TOLIST} hat eine private Nachricht von {SENDER} im Forum {FORUMNAME} erhalten.

WICHTIG: Das ist nur eine Benachrichtigung - bitte antworten Sie nicht auf diese E-Mail!

Die Nachricht lesen: {READLINK}

Auf die Nachricht antworten (nur dem Absender): {REPLYLINK}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Neue private Nachricht: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = '{TOLIST} hat eine private Nachricht von {SENDER} im Forum {FORUMNAME} erhalten.

WICHTIG: Das ist nur eine Benachrichtigung - bitte antworten Sie nicht auf diese E-Mail!

Diese Nachricht wurde gesendet:

{MESSAGE}

Auf die Nachricht antworten (nur dem Absender): {REPLYLINK}';

/**
	@additional_params: notify_new_buddy
		ACTIONNAME:  The user name of the member adding as buddy.
	@description: A notification email sent to the members that are set as buddy by someone
*/
$txt['notify_new_buddy_subject'] = '{ACTIONNAME} added you as buddy';
$txt['notify_new_buddy_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} has just added you as a buddy 
at {FORUMNAME}.  

{REGARDS}


You can unsubscribe to further "new buddy" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_new_buddy_digest'] = 'You have been added as buddy by:';
$txt['notify_new_buddy_snippet'] = '{ACTIONNAME}';

/**
	@additional_params: notify_new_likemsg
		ACTIONNAME:  The user name of the member that liked the message.
		MSGLINK:  The url to the message liked.
		SUBJECT: The subject of the message
	@description: A notification email sent to the members whose message has been liked
*/
$txt['notify_new_likemsg_subject'] = 'A message received a like';
$txt['notify_new_likemsg_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} has just liked your message 
in the "{SUBJECT}" topic at {FORUMNAME}.  
You can view that message by following this link:
{MSGLINK}

{REGARDS}


You can unsubscribe to further "liked by" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_new_likemsg_digest'] = 'The following messages has been liked:';
$txt['notify_new_likemsg_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_mentionmem
		ACTIONNAME:  The user name of the member that mentioned someone.
		MSGLINK:  The url to the message where someone has been mentioned.
		SUBJECT: The subject of the message
	@description: A notification email sent to the members mentioned by someone else in a message
*/
$txt['notify_mentionmem_subject'] = 'You have been mentioned';
$txt['notify_mentionmem_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} has just mentioned you in a message 
in the "{SUBJECT}" topic at {FORUMNAME}.  
You can view that message by following this link:
{MSGLINK}

{REGARDS}


You can unsubscribe to further "mentioned" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_mentionmem_digest'] = 'You have been mentioned in the following messages:';
$txt['notify_mentionmem_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_quotedmem
		ACTIONNAME:  The user name of the member that quoted someone's message.
		MSGLINK:  The url to the message where someone has been quoted.
		SUBJECT: The subject of the message
  		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description: A notification email sent to the members quoted in someone else message
*/
$txt['notify_quotedmem_subject'] = 'Your message has been quoted';
$txt['notify_quotedmem_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} at {FORUMNAME} has just quoted
your messages in the "{SUBJECT}" topic.  You can view that message by 
following this link:
{MSGLINK}

{REGARDS}


You can unsubscribe to further "quoted message" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_quotedmem_digest'] = 'Your messages have been quoted in:';
$txt['notify_quotedmem_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_html_email
		FORUMNAMESHORT: Short or nickname for the forum
		TOPICSUBJECT: The subject of the message.
		MESSAGE: This is the body of the message.
		EMAILCSS: The location of the stylesheet.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description: A basic HTML wrapper to place around a prepared HTML email
 */
$txt['notify_html_email_subject'] = '';
$txt['notify_html_email_body'] = '<!DOCTYPE html>
<html>
<head>
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title>{TOPICSUBJECT}</title>
	<style>
		{EMAILCSS}
	</style>
</head>
<body>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="body">
	<tr>
		<td class="container">
			<div class="content">
				<table role="presentation" class="main">
					<tr>
						<td class="wrapper">
							<table role="presentation" border="0" cellpadding="0" cellspacing="0">
								<tr>
									<td>
										<p>{MESSAGE}</p>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<div class="footer">
					<table role="presentation" border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td class="content-block">
								<span class="apple-link">{FORUMNAMESHORT}</span>
								<br>
								Dont like these emails? <a href="{UNSUBSCRIBELINK}">Unsubscribe</a>.
							</td>
						</tr>
						<tr>
							<td>
								<span class="key-holder">[]</span>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</td>
	</tr>
</table>
</body>
</html>
';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/

$txtBirthdayEmails['happy_birthday_subject'] = 'Happy birthday from {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Dear {REALNAME},

We here at {FORUMNAME} would like to wish you a happy birthday.  May this day and the year to follow be full of joy.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'On your Birthday...';
$txtBirthdayEmails['karlbenson1_body'] = 'We could have sent you a birthday card.  We could have sent you some flowers or a cake.

But we didn\'t.

We could have even sent you one of those automatically generated messages to wish you happy birthday where we don\'t even have to replace INSERT NAME.

But we didn\'t

We wrote this birthday greeting just for you.

We would like to wish you a very special birthday.

{REGARDS}

//:: This message was automatically generated :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Happy Birthday!';
$txtBirthdayEmails['nite0859_body'] = 'Your friends at {FORUMNAME} would like to take a moment of your time to wish you a happy birthday, {REALNAME}. If you have not done so recently, please visit our community in order for others to have the opportunity to pass along their warm regards.

Even though today is your birthday, {REALNAME}, we would like to remind you that your membership in our community has been the best gift to us thus far.

Best Wishes,
The Staff of {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Birthday Wishes to {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Dear {REALNAME},

Another year in your life has passed.  We at {FORUMNAME} hope it has been filled with happiness, and wish you luck in the coming one.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Happy birthday, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Do you know who\'s having a birthday today, {REALNAME}?

We know... YOU!

Happy birthday!

You\'re now a year older but we hope you\'re a lot happier than last year.

Enjoy your day today, {REALNAME}!

- From your {FORUMNAME} family';
$txtBirthdayEmails['geezmo_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Your Birthday Greeting';
$txtBirthdayEmails['karlbenson2_body'] = 'We hope your birthday is the best ever cloudy, sunny or whatever the weather.
Have lots of birthday cake and fun, and tell us what you have done.

We hope this message brought you cheer, and make it last, until same time same place, next year.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';
