<?php
// Version: 2.0; Help

global $helptxt;

$txt['close_window'] = 'Close window';

$helptxt['manage_boards'] = '
	<strong>Foren ändern</strong><br />
	In diesem Menü können Sie Foren und die Kategorien über ihnen
	erstellen/umsortieren/entfernen. Wenn Sie zum Beispiel eine Website
	mit vielen Themen wie &quot;Sport&quot; und &quot;Autos&quot; und &quot;Musik&quot; betreiben, wären dies
	die Oberkategorien, die Sie erstellen. Unter jeder dieser Kategorien
	möchten Sie wahrscheinlich hierarchische &quot;Unterkategorien&quot; oder Foren
	für jedes einzelne Thema anlegen. Dies ist eine einfache Hierarchie
	mit folgender Struktur:<br />
	<ul class="normallist">
		<li>
			<strong>Sport</strong>
			&nbsp;- Eine &quot;Kategorie&quot;
			<ul class="normallist">
				<li>
					<strong>Handball</strong>
					&nbsp;- Ein Forum unterhalb der &quot;Sport&quot;-Kategorie
					<ul class="normallist">
						<li>
							<strong>Ergebnisse</strong>
							&nbsp;- Ein Unterforum unterhalb des &quot;Handball&quot;-Forums
						</li>
					</ul>
				</li>
				<li><strong>Fußball</strong>
				&nbsp;- Ein Forum unterhalb der &quot;Sport&quot;-Kategorie</li>
			</ul>
		</li>
	</ul>
	Kategorien ermöglichen es Ihnen, das Forum in Themenbereiche (&quot;Autos&quot;,
	&quot;Sport&quot;) aufzuteilen, und die &quot;Foren&quot; darunter sind die eigentlichen
	Themen, in denen Mitglieder Beiträge schreiben können. Ein Benutzer,
	der sich für Smarts interessiert, würde zum Beispiel einen Beitrag
	unter &quot;Autos&rarr;Smart&quot; schreiben. Kategorien erlauben es Mitgliedern,
	ihre Interessen schnell zu finden: Anstelle eines &quot;Ladens&quot; können Sie
	etwa getrennte &quot;Geräte&quot;- und &quot;Bekleidungs&quot;läden aufführen. Dies
	würde die Suche nach bestimmten Produkten vereinfachen, denn wenn ein
	Benutzer sich zum Beispiel für Schraubenzieher interessiert, so kann
	er direkt in den &quot;Geräteladen&quot; gehen, statt einen Umweg über das
	&quot;Bekleidungsgeschäft&quot; machen zu müssen, wo es vermutlich keinen
	Schraubenzieher gibt.<br />
	Ein Unterforum, wie oben angemerkt, ist ein Schlüsselthema innerhalb
	einer breiten Kategorie. Wenn Sie über &quot;Smarts&quot; diskutieren möchten,
	gehen Sie direkt in die &quot;Auto&quot;-Kategorie und springen Sie dort in das
	&quot;Smart&quot;-Forum.<br />
	Administrative Funktionen für diesen Menüeintrag dienen dem Zweck, in
	jeder Kategorie neue Foren zu erstellen, sie umzusortieren (&quot;Smart&quot;
	etwa hinter &quot;S-Klasse&quot; zu platzieren) oder das Forum vollständig zu
	löschen.';

$helptxt['edit_news'] = '
	<ul class="normallist">
		<li>
			<strong>Neuigkeiten</strong><br />
			Dieser Bereich ermöglicht es Ihnen, den Text der Neuigkeiten, die auf der Startseite des Forums angezeigt werden, festzulegen.
			Fügen Sie ein Element Ihrer Wahl ein (zum Beispiel &quot;Verpassen Sie nicht die Konferenz am Dienstag&quot;). Jede Neuigkeit wird zufällig angezeigt und sollte in einem eigenen Feld platziert werden.
		</li>
		<li>
			<strong>Rundbriefe</strong><br />
			Dieser Bereich ermöglicht es Ihnen, per privater Nachricht oder E-Mail Rundbriefe an die Mitglieder des Forums zu versenden. Wählen Sie zunächst die Gruppen aus, die den Rundbrief erhalten oder nicht erhalten sollen. Auf Wunsch können Sie auch weitere Mitglieder und E-Mail-Adressen hinzufügen. Geben Sie dann die Nachricht ein, die Sie versenden möchten, und wählen Sie aus, ob sie per privater Nachricht oder per E-Mail versandt werden soll.
		</li>
		<li>
			<strong>Einstellungen</strong><br />
				Dieser Bereich enthält einige Einstellungen bezüglich Neuigkeiten und Rundbriefen, darunter, welche Gruppen Neuigkeiten ändern oder Rundbriefe versenden dürfen. Es gibt auch eine Einstellung zur Aktivierung von Newsfeeds im Forum und eine zur Konfiguration der Länge (wie viele Zeichen angezeigt werden) jedes Eintrags in einem Newsfeed.
		</li>
	</ul>';

$helptxt['view_members'] = '
	<ul class="normallist">
		<li>
			<strong>Alle Mitglieder ansehen</strong><br />
			Hier können Sie alle Mitglieder des Forums ansehen. Ihnen wird eine verlinkte Liste der Mitgliedsnamen
			präsentiert. Sie können auf jeden der Namen klicken, um Details über die Mitglieder (Website, Alter und
			so weiter) zu erfahren, als Administrator können Sie obendrein diese Eigenschaften ändern. Sie haben
			die volle Kontrolle über die Mitglieder, dies schließt die Möglichkeit, sie aus dem Forum zu löschen,
			ein.<br /><br />
		</li>
		<li>
			<strong>Wartet auf Freischaltung</strong><br />
			Dieser Bereich wird nur angezeigt, wenn Sie die administrative Freischaltung aller neuen Registrierungen aktiviert haben.
			Jeder, der sich in Ihrem Forum registriert, wird erst dann ein vollwertiges Mitglied, wenn er von einem Administrator
			überprüft und freigeschaltet worden ist. Der Bereich listet alle Mitglieder, die noch darauf warten, sowie deren E-Mail-
			und IP-Adressen auf. Sie können jedes Mitglied auf der Liste entweder akzeptieren oder ablehnen (löschen), indem Sie den
			Auswahlkasten neben ihm aktivieren und die jeweilige Aktion aus dem Auswahlfeld am Ende der Seite auswählen. Wenn Sie ein
			Mitglied ablehnen, können Sie es mit oder ohne Benachrichtigung über Ihre Entscheidung löschen.<br /><br />
		</li>
		<li>
			<strong>Wartet auf Aktivierung</strong><br />
			Dieser Bereich ist nur sichtbar, wenn Sie die Aktivierung aller neuen Benutzerkonten im Forum zur Pflicht gemacht haben. Es
			werden alle Mitglieder, die ihr Konto noch nicht aktiviert haben, aufgelistet. Auf dieser Seite können Sie Mitglieder mit
			ausstehender Aktivierung händisch aktivieren, ablehnen oder an die Aktivierung erinnern. Wie oben können Sie den Benutzer
			auch per E-Mail über Ihr Handeln informieren.<br /><br />
		</li>
	</ul>';

$helptxt['ban_members'] = '<strong>Mitglieder sperren</strong><br />
	Dies stellt die Fähigkeit bereit, Benutzer zu &quot;sperren&quot;, um Leute, die das Vertrauen der Administration
	mittels Spammens, Trollens und dergleichen missbraucht haben, an ihrem Treiben zu hindern. Dies erlaubt es Ihnen,
	diejenigen Benutzer auszusperren, die Ihrem Forum Schaden zufügen möchten. Als Administrator können Sie, wenn Sie
	Beiträge ansehen, die IP-Adresse sehen, die jeder Benutzer zum jeweiligen Zeitpunkt verwendet hat. In der Sperrliste
	können Sie dann einfach diese IP-Adresse eingeben und speichern, und schon kann der jeweilige Benutzer von diesem
	Ort aus keine weiteren Beiträge tätigen.<br />
	Sie können Personen auch anhand ihrer E-Mail-Adresse sperren.';

$helptxt['featuresettings'] = '<strong>Funktionen und Optionen</strong><br />
	In diesem Bereich stehen verschiedene Funktionen zur Verfügung, die an Ihre Vorlieben angepasst werden können.';

$helptxt['securitysettings'] = '<strong>Sicherheit und Moderation</strong><br />
	Dieser Bereich beinhaltet Einstellungen bezüglich der Sicherheit und der Moderation Ihres Forums.';

$helptxt['addonsettings'] = '<strong>Erweiterungseinstellungen</strong><br />
	Dieser Bereich sollte jegliche Einstellungen beinhalten, die von installierten Erweiterungen Ihres Forums hinzugefügt wurden.';

$helptxt['time_format'] = '<strong>Zeitformat</strong><br />
	Sie haben die Macht zu entscheiden, wie Zeit und Datum für Sie aussehen. Es gibt viele kleine Buchstaben, aber es ist ziemlich einfach.
	Die Konventionen folgen PHPs strftime-Funktion und werden unten beschrieben (weitere Details können Sie auf <a href="http://de3.php.net/manual/de/function.strftime.php">php.net</a> finden).<br />
	<br />
	Folgende Zeichen werden in der Formatierungszeichenkette erkannt:<br />
	<span class="smalltext">
	&nbsp;&nbsp;%a - kurzer Wochentagsname<br />
	&nbsp;&nbsp;%A - vollständiger Wochentagsname<br />
	&nbsp;&nbsp;%b - kurzer Monatsname<br />
	&nbsp;&nbsp;%B - vollständiger Monatsname<br />
	&nbsp;&nbsp;%d - Tag des Monats (01 bis 31) <br />
	&nbsp;&nbsp;%D<strong>*</strong> - wie %m/%d/%y <br />
	&nbsp;&nbsp;%e<strong>*</strong> - Tag des Monats (1 bis 31) <br />
	&nbsp;&nbsp;%H - Stunden im 24-Stunden-Format (von 00 bis 23) <br />
	&nbsp;&nbsp;%I - Stunden im 12-Stunden-Format (von 01 bis 12) <br />
	&nbsp;&nbsp;%m - Monat als Zahl (01 bis 12) <br />
	&nbsp;&nbsp;%M - Minuten als Zahl <br />
	&nbsp;&nbsp;%p - je nach Uhrzeit entweder &quot;am&quot; (vormittags) oder &quot;pm&quot; (nachmittags)<br />
	&nbsp;&nbsp;%R<strong>*</strong> - Zeit im 24-Stunden-Format<br />
	&nbsp;&nbsp;%S - Sekunden als Dezimalzahl<br />
	&nbsp;&nbsp;%T<strong>*</strong> - aktuelle Uhrzeit, identisch mit %H:%M:%S <br />
	&nbsp;&nbsp;%y - zweistelliges Jahr (00 bis 99) <br />
	&nbsp;&nbsp;%Y - vierstelliges Jahr<br />
	&nbsp;&nbsp;%% - das Zeichen \'%\'<br />
	<br />
	<em>* Funktioniert nicht auf Windows-Servern.</em></span>';

$helptxt['deleteAccount_posts'] = 'Nur Antworten: Dies wird nur die Beiträge entfernen, die dieses Mitglied als Antwort auf andere Beiträge veröffentlicht hat.<br />
	Themen und Antworten: Dies wird ebenso verfahren, außerdem wird es alle von diesem Mitglied eröffneten Themen entfernen.';

$helptxt['live_news'] = '<strong>Live announcements</strong><br />
	This box shows recently updated announcements from <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>.
	You should check here every now and then for updates, new releases, and important information from ElkArte.';

$helptxt['registrations'] = '<strong>Registrierungsverwaltung</strong><br />
	Dieser Bereich beinhaltet alle nötigen Funktionen, um Neuanmeldungen im Forum zu verwalten. Er enthält bis zu vier Bereiche, die
	abhängig von Ihren Forumseinstellungen sichtbar sind. Dies sind:<br /><br />
	<ul class="normallist">
		<li>
			<strong>Neues Mitglied registrieren</strong><br />
			Auf dieser Seite können Sie Konten für neue Mitglieder anlegen. Dies kann in Foren nützlich sein, in denen die Registrierung neuer Benutzer
			geschlossen wurde, oder wenn ein Administrator ein Testkonto anlegen möchte. Falls eine separate Aktivierung des Kontos nötig ist, wird dem
			Mitglied ein Aktivierungslink zugesandt, der angeklickt werden muss, bevor es das Konto nutzen kann. Sie können auch auswählen, dass das neue
			Passwort für den Benutzer an die angegebene E-Mail-Adresse gesendet wird.<br /><br />
		</li>
		<li>
			<strong>Nutzungsbedingungen ändern</strong><br />
			Hier können Sie den Text der Nutzungsbedingungen ändern, die angezeigt werden, wenn sich Benutzer in Ihrem Forum registrieren.
			Sie können die Standardnutzungsbedingungen, die in ElkArte enthalten sind, nach Belieben ändern.<br /><br />
		</li>
		<li>
			<strong>Reservierte Namen einstellen</strong><br />
			Mittels dieser Eingabemaske können Sie Namen definieren, die von Ihren Benutzern nicht verwendet werden können.<br /><br />
		</li>
		<li>
			<strong>Einstellungen</strong><br />
			Dieser Bereich ist nur sichtbar, wenn Sie die Befugnis besitzen, das Forum zu administrieren. Hier können Sie die Registrierungsmethode
			festlegen, die für Ihr Forum verwendet wird, sowie weitere registrierungsbezogene Einstellungen vornehmen.
		</li>
	</ul>';

$helptxt['requireAgreement'] = 'This setting is recommended to be enabled in order to comply with the rules of the <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';

$helptxt['modlog'] = '<strong>Moderationsprotokoll</strong><br />
	Dieser Bereich erlaubt es Mitgliedern des Moderationsteams, alle Aktionen zu verfolgen, die von Moderatoren vorgenommen wurden. Um
	sicherzustellen, dass Moderatoren ihre Aktionen nicht verschleiern können, können Einträge nicht vor Ablauf von 24 Stunden nach der erfolgten
	Aktion gelöscht werden.';
$helptxt['adminlog'] = '<strong>Administrationsprotokoll</strong><br />
	Dieser Bereich erlaubt es Mitgliedern des Administrationsteams, alle administrativen Aktionen zu verfolgen, die im Forum vorgenommen wurden. Um
	sicherzustellen, dass Administratoren ihre Aktionen nicht verschleiern können, können Einträge nicht vor Ablauf von 24 Stunden nach der erfolgten
	Aktion gelöscht werden.';
$helptxt['warning_enable'] = '<strong>Benutzerverwarnystem</strong><br />
	Diese Funktion gewährt Administratoren und Moderatoren die Fähigkeit, Mitglieder zu verwarnen und eine Verwarnstufe zu verwenden, um die Aktionen
	auszuwählen, die diesen künftig verwehrt werden sollen. Bei Aktivierung dieser Funktion wird im Befugnisbereich eine Befugnis verfügbar gemacht,
	mittels derer festgelegt werden kann, welche Gruppen Mitglieder verwarnen dürfen. Verwarnstufen können aus einem Mitgliedsprofil heraus angepasst
	werden. Folgende zusätzliche Optionen sind verfügbar:';
$helptxt['watch_enable'] = '<strong>Verwarnstufe für Beobachtung</strong><br />Diese Einstellung legt die prozentuale Verwarnstufe fest, die ein Mitglied erreichen muss, um automatisch &quot;beobachtet&quot; zu werden. Jedes &quot;beobachtete&quot; Mitglied erscheint im entsprechenden Bereich im Moderationszentrum.';
$helptxt['moderate_enable'] = '<strong>Verwarnstufe für Beitragsmoderation</strong><br />Die Beiträge jedes Mitglieds, das diesen Wert überschreitet, müssen von einem Moderatoren freigeschaltet werden, bevor sie öffentlich im Forum angezeigt werden. Dies wird jegliche lokalen Forenbefugnisse überschreiben, die mit Beitragsmoderation zu tun haben.';
$helptxt['mute_enable'] = '<strong>Verwarnstufe für Stummschaltung</strong><br />Wird diese Verwarnstufe von einem Mitglied überschritten, so unterliegt es einer Beitragssperre. Es verliert damit jede Berechtigung zum Verfassen neuer Beiträge.';
$helptxt['perday_limit'] = '<strong>Maximale Verwarnpunkte pro Mitglied und Tag</strong><br />Diese Einstellung begrenzt die Anzahl an Punkten, die ein Moderator einem einzelnen Mitglied innerhalb von 24 Stunden geben/nehmen kann. Dies kann verwendet werden, um zu beschränken, was ein Moderator binnen kurzer Zeit tun kann. Die Einstellung kann mit dem Wert 0 deaktiviert werden. Beachten Sie, dass Mitglieder mit Administrationsrechten nicht von diesem Wert betroffen sind.';
$helptxt['error_log'] = '<strong>Fehlerprotokoll</strong><br />
	Das Fehlerprotokoll verfolgt jeden von Benutzern festgestellten ernsthaften Fehler beim Benutzen Ihres Forums. Es listet all diese Fehler nach Datum
	auf, sie können per Klick auf den schwarzen Pfeil neben jedem Datum sortiert werden. Sie können die Fehler mittels Klicks auf das Bild neben jeder
	Fehlerstatistik zusätzlich filtern. Dadurch können Sie zum Beispiel die Fehler nach einem bestimmten Mitglied filtern. Wenn ein Filter aktiv ist,
	werden nur die Fehler angezeigt, auf die dieser Filter zutrifft.';
$helptxt['theme_settings'] = '<strong>Designeinstellungen</strong><br />
	Diese Einstellungsseite erlaubt es Ihnen, Einstellungen zu ändern, die sich nur auf ein Design auswirken. Solche Designeinstellungen beinhalten Optionen
	wie das Designverzeichnis und URL-Informationen, aber auch Optionen, die das Aussehen des Designs beeinflussen. Die meisten Designs haben eine Vielzahl
	an konfigurierbaren Optionen, was Ihnen erlaubt, ein Design auf Ihre individuellen Bedürfnisse zuzuschneiden.';
$helptxt['smileys'] = '<strong>Smileyzentrum</strong><br />
	Hier können Sie Smileys und Smileysätze hinzufügen und entfernen.  Beachten Sie unbedingt, dass, wenn ein Smiley in <em>einem</em> Satz enthalten ist, er
	in <em>allen</em> Sätzen enthalten ist - andernfalls könnte es für Ihre Benutzer verwirrend sein, wenn sie unterschiedliche Smileysätze verwenden.<br /><br />

	Sie können hier auch die Nachrichtensymbole ändern, wenn Sie sie in den Einstellungen aktiviert haben.';

$helptxt['calendar'] = '<strong>Kalender verwalten</strong><br />
	Hier können Sie die aktuellen Kalendereinstellungen anpassen sowie Feiertage, die im Kalender erscheinen, hinzufügen und entfernen.';
$helptxt['calendar_settings'] = 'Der Kalender kann verwendet werden, um Geburtstage oder wichtige Ereignisse in Ihrem Forum anzuzeigen.<br /><br />Denken Sie daran, dass die Verwendung des Kalenders (Veröffentlichung und Ansehen von Ereignissen usw.) mittels Befugnissen gesteuert wird, die Sie auf der Befugnisseite vergeben können.';
$helptxt['cal_days_for_index'] = 'Max. Tage im Voraus auf der Hauptseite:<br />Wird dies auf 7 gesetzt, so werden alle Ereignisse der nächsten Woche angezeigt.';
$helptxt['cal_showevents'] = 'Aktiviert die Hervorhebung von Ereignissen in den Minikalendern, im Hauptkalender, beides oder nirgendwo.';
$helptxt['cal_showholidays'] = 'Diese Einstellung ermöglicht es Ihnen, Feiertage in den Minikalendern, im Hauptkalender oder in allen Kalendern hervorzuheben sowie die Hervorhebung von Ereignissen zu deaktivieren.';
$helptxt['cal_showbdays'] = 'Diese Einstellung ermöglicht es Ihnen, Geburtstags in den Minikalendern, im Hauptkalender oder in allen Kalendern hervorzuheben sowie die Hervorhebung von Ereignissen zu deaktivieren.';
$helptxt['cal_export'] = 'Exports a text file in the iCal format for importing into other calendar applications.';
$helptxt['cal_daysaslink'] = 'Zeigt Tage als Verweis auf \'Ereignis veröffentlichen\' an:<br />Dies erlaubt es Mitgliedern, Ereignisse an diesem Tag anzukündigen, wenn sie auf ein Datum klicken.';
$helptxt['cal_allow_unlinked'] = 'Nicht mit Beiträgen verknüpfte Ereignisse erlauben:<br />Erlaubt es Mitgliedern, Ereignisse zu veröffentlichen, ohne sie mit einem Beitrag im Forum zu verknüpfen.';
$helptxt['cal_defaultboard'] = 'Standardforum zur Veröffentlichung von Ereignissen:<br />Geben Sie das Forum an, in dem Ereignisse standardmäßig veröffentlicht werden sollen.';
$helptxt['cal_showInTopic'] = 'Show linked events in topic display:<br />Check to show a link to the event at the top of topic view.';
$helptxt['cal_allowspan'] = 'Ereignisse dürfen mehrere Tage umfassen:<br />Aktivieren, um Ereignisse zu erlauben, die mehrere Tage umfassen.';
$helptxt['cal_maxspan'] = 'Max. Anzahl an Tagen, die ein Ereignis umfassen darf:<br />Geben Sie die maximale Anzahl an Tagen ein, die ein Ereignis umfassen darf.';
$helptxt['cal_minyear'] = 'Minimum year:<br />Select the &quot;first&quot; year on the calendar list.';
$helptxt['cal_maxyear'] = 'Maximum year:<br />Select the &quot;last&quot; year on the calendar list<br />';

$helptxt['serversettings'] = '<strong>Servereinstellungen</strong><br />
	Hier können Sie die Kernkonfiguration Ihres Forums vornehmen. Dieser Bereich umfasst die Datenbank- und URL-Einstellungen sowie
	weitere wichtige Konfigurationselemente wie E-Mail-Einstellungen und Zwischenspeicherung. Denken Sie sorgsam über jede Änderung
	an diesen Einstellungen nach, da ein Fehler den Zugriff auf das Forum verhindern kann';
$helptxt['manage_files'] = '
	<ul class="normallist">
		<li>
			<strong>Dateien durchsuchen</strong><br />
			Hier können Sie alle Dateianhänge, Avatare und Miniaturansichten ansehen, die vom System gespeichert wurden.<br /><br />
		</li><li>
			<strong>Dateianhangseinstellungen</strong><br />
			Konfigurieren Sie hier, wo Dateianhänge gespeichert werden, und beschränken Sie den Zugriff auf verschiedene Arten von
			Dateianhängen.<br /><br />
		</li><li>
			<strong>Avatareinstellungen</strong><br />
			Konfigurieren Sie hier, wo Avatare gespeichert werden, und stellen Sie die Größenänderung von Avataren ein.<br /><br />
		</li><li>
			<strong>Dateiwartung</strong><br />
			Prüfen und reparieren Sie jeglichen Fehler im Dateianhangsverzeichnis und löschen Sie ausgewählte Dateianhänge.<br /><br />
		</li>
	</ul>';

$helptxt['topicSummaryPosts'] = 'Dies erlaubt es Ihnen, die Anzahl früherer Beiträge festzulegen, die in der Themenzusammenfassung auf der Antworten-Seite angezeigt werden.';
$helptxt['enableAllMessages'] = 'Setzen Sie dies auf die <em>Höchstzahl</em> an Beiträgen, die ein Thema haben darf, damit der &quot;Alle&quot;-Verweis angezeigt wird.  Wird dieser Wert niedriger als die &quot;maximale Anzahl an Beiträgen pro Seite&quot; gesetzt, so bedeutet dies nur, dass er niemals angezeigt wird; setzen Sie ihn zu hoch, so könnte dies Ihr Forum verlangsamen.';
$helptxt['allow_guestAccess'] = 'Die Deaktivierung dieser Option wird es Gästen verbieten, irgendetwas außer den nötigsten Aktionen - Anmelden, Registrieren, Passworterinnerung und so weiter - in Ihrem Forum zu tun.  Dies ist nicht dasselbe wie das Verbot des Zugriffs auf einzelne Foren durch Gäste.';
$helptxt['userLanguage'] = 'Die Aktivierung dieser Option wird es Benutzern erlauben, auszuwählen, welche Sprachdatei sie verwenden möchten. Dies betrifft nicht die Standardauswahl.';
$helptxt['trackStats'] = 'Statistiken:<br />Dies wird es Benutzern erlauben, die neuesten Beiträge und beliebtesten Themen in Ihrem Forum zu sehen.
		Es wird außerdem diverse Statistiken wie die Höchstzahl an Mitgliedern, die gleichzeitig online waren, neue Mitglieder und neue Themen anzeigen.<hr />
		Seitenansichten:<br />Fügt der Statistikseite eine weitere Spalte mit der Anzahl an Seitenansichten in Ihrem Forum hinzu.';
$helptxt['enable_unwatch'] = 'Die Aktivierung dieser Option wird es Benutzern erlauben, gezielt die Benachrichtigung über neue Antworten in Themen abzuschalten, in denen sie zuvor einen Beitrag geschrieben haben.';
$helptxt['titlesEnable'] = 'Schalten Sie eigene Titel an, so wird es Mitgliedern mit den entsprechenden Befugnissen erlaubt, einen besonderen Titel für sich selbst zu erstellen.
		Dieser wird unter dem Namen angezeigt.<br /><em>Beispiel:</em><br />Max<br />Toller Typ';
$helptxt['onlineEnable'] = 'Dies wird ein Bild hinzufügen, das anzeigt, ob das Mitglied online oder offline ist';
$helptxt['todayMod'] = 'Dies wird &quot;Heute&quot; oder &quot;Gestern&quot; in einer Vielzahl an Formaten anstelle des vollständigen Datums anzeigen.<br /><br />
		<strong>Beispiele:</strong><br /><br />
		<dl class="settings">
			<dt>Deaktiviert</dt>
			<dd>3. Oktober 2009 um 12:59:18</dd>
			<dt>Relativ</dt>
			<dd>Vor 2 Stunden</dd>
			<dt>Nur heute</dt>
			<dd>Heute um 12:59:18</dd>
			<dt>Heute &amp; gestern</dt>
			<dd>Gestern um 21:36:55</dd>
		</dl>';
$helptxt['disableCustomPerPage'] = 'Verwenden Sie diese Option, um Benutzer davon abzuhalten, die Menge an Beiträgen und Themen pro Seite in der Nachrichten- beziehungsweise Themenübersicht anzupassen.';
$helptxt['enablePreviousNext'] = 'Dies wird Verweise auf das nächste und auf das vorherige Thema anzeigen.';
$helptxt['pollMode'] = 'Hier können Sie auswählen, ob Umfragen aktiviert werden sollen oder nicht. Werden sie deaktiviert, so werden Themen angezeigt, als hätten sie keine Umfragen.
<br /><br />Um auszuwählen, wer Umfragen starten, ansehen und dergleichen darf, können Sie diese Befugnisse separat setzen. Denken Sie daran, falls Umfragen nicht zu funktionieren scheinen.';
$helptxt['enableVBStyleLogin'] = 'Dies wird eine kompaktere Anmeldung für Gäste auf jeder Seite des Forums anzeigen.';
$helptxt['enableCompressedOutput'] = 'Diese Option wird die Ausgabe für niedrigere Bandbreitennutzung komprimieren, benötigt jedoch eine installierte zlib.';
$helptxt['databaseSession_enable'] = 'Mit dieser Option wird die Datenbank zur Speicherung von Sitzungen verwendet - dies ist das Beste für lastausgeglichene Server, hilft jedoch bei allen Zeitüberschreitungsproblemen und kann das Forum beschleunigen.';
$helptxt['databaseSession_loose'] = 'Wird dies angeschaltet, so verringert dies die Bandbreite, die von Ihrem Forum verwendet wird, und sorgt dafür, dass ein Klick auf Zurück nicht die Seite neu lädt - der Nachteil ist, dass unter anderem die (Neu)-Symbole nicht aktualisiert werden. (Es sei denn, Sie öffnen diese Seite mit einem Klick statt zu ihr zurückzukehren.)';
$helptxt['databaseSession_lifetime'] = 'Dies ist die Anzahl an Sekunden, für die Sitzungen nach ihrer letzten Verwendung bestehen bleiben sollen.  Wird eine Sitzung lange genug nicht verwendet, wird davon ausgegangen, dass sie &quot;abgelaufen&quot; ist. Ein Wert über 2400 (entspricht 40 Minuten) wird empfohlen.';
$helptxt['cache_enable'] = 'ElkArte führt Zwischenspeicherung in verschiedenen Stufen durch. Je höher die aktivierte Stufe ist, um so mehr Prozessorzeit wird für das Abrufen der zwischengespeicherten Informationen aufgewendet. Wenn auf Ihrem Rechner Zwischenspeicherung verfügbar ist, wird empfohlen, dass Sie es zunächst mit Stufe 1 versuchen.';
$helptxt['cache_memcached'] = 'If you are using memcached you need to provide the server details. This should be entered as a comma separated list as shown in this example:<br /><br/>&quot;server1,server2,server3:port,server4&quot;<br /><br />Note that if no port is specified the software will use port 11211, set this to 0 when using UNIX domain sockets.';
$helptxt['cache_redis'] = 'If you are using redis you need to provide the server details. This should be entered as a comma separated list as shown in this example:<br /><br/>&quot;server1,server2,server3:port,server4&quot;<br /><br />Note that if no port is specified the software will use port 6379, set this to 0 when using UNIX domain sockets.';
$helptxt['cache_cachedir'] = 'Diese Einstallung kommt nur bei dateisystembasierter Zwischenspeicherung zur Anwendung. Sie gibt den Pfad zum Zwischenspeicherungsverzeichnis an.  Es wird empfohlen, dass Sie dieses in /tmp/ anlegen, wenn Sie diese Methode verwenden möchten, aber es funktioniert auch jedes andere Verzeichnis';
$helptxt['cache_uid'] = 'Some cache systems, for example Redis, may require a user ID to allow ElkArte access the cache.';
$helptxt['cache_password'] = 'Some cache systems, for example Redis, may require a password to allow ElkArte access the cache.';

$helptxt['enableErrorLogging'] = 'Dies wird jegliche Fehler wie fehlgeschlagene Anmeldungen protokollieren, so dass Sie sehen können, was falsch lief.';
$helptxt['enableErrorQueryLogging'] = 'Dies fügt die vollständige Datenbankabfrage in das Fehlerprotokoll ein.  Setzt die Aktivierung der Fehlerprotokollierung voraus.<br /><br /><strong>Hinweis:  Dies beeinflusst die Fähigkeit, das Fehlerprotokoll nach der Fehlernachricht zu filtern.</strong>';
$helptxt['allow_disableAnnounce'] = 'This will allow users to opt out of notification of topics you announce by checking the &quot;Announce Topic&quot; checkbox when posting. Disabling this option violates the rules of the <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a> and many other countries\' privacy and anti-spam laws.';
$helptxt['metadata_enabled'] = 'This will create OG (Open Graph) and Schema.org microdata suitable for HTML embedding (requires theme support).  It allows search engines to better understand the information on your site pages, and provides for a better link sharing experience on social sites.  When enabled, metadata will made available for the board listing, topic listing and topic display areas of your site.';
$helptxt['disallow_sendBody'] = 'Diese Option entfernt die Möglichkeit, den Text von Antworten, Beiträgen und privaten Nachrichten in Benachrichtigungs-E-Mails zu erhalten.<br /><br />Oft antworten Mitglieder auf die Benachrichtigungsmail, was meist bedeutet, dass der Serveradministrator die Antwort erhält.';
$helptxt['enable_contactform'] = 'Diese Option fügt der Registrierungsseite eine Schaltfläche für die Kontaktaufnahme hinzu';
$helptxt['jquery_source'] = 'Dies legt die Quelle fest, aus der die jQuery-Bibliothek geladen wird.  Auto wird zunächst das CDN verwenden und, wenn es nicht verfügbar ist, auf die lokale Quelle zurückgreifen.  Lokal wird nur die lokale Quelle verwenden, CDN wird die Bibliothek nur von Googles Servern laden';
$helptxt['jquery_default'] = 'If you want to use a version of jQuery different than the one that came with ElkArte, select this box and enter the version number X.XX.X The local file must follow the naming conventing of jquery-X.XX.X.min.js for it to be loaded.';
$helptxt['jqueryui_default'] = 'If you want to use a version of jQueryUI different than the one that came with ElkArte, select this box and enter the version number X.XX.X The local file must follow the naming conventing of jquery-ui-X.XX.X.min.js for it to be loaded.';
$helptxt['minify_css_js'] = 'This will remove unnecessary whitespace and comments from the files to reduce their size.  The minimized files are saved so further requests can instantly serve those files.<br />Note that the first time a compilation is needed/created, there may be a slight delay on that page load in order to create the file (this will also happen after the cache is cleared)';
$helptxt['combine_css_js'] = 'This will combine multiple CSS or JavaScript files per page as needed.  The combined files are saved so further requests can instantly serve those files.';
$helptxt['compactTopicPagesEnable'] = 'Dies wird die angegebene Anzahl an umgebenden Seiten im Thema anzeigen.<br /><em>Beispiel:</em>
		&quot;3&quot; zeigt drei Seiten an: 1 ... 4 [5] 6 ... 9 <br />
		&quot;5&quot; zeigt fünf Seiten an: 1 ... 3 4 [5] 6 7 ... 9';
$helptxt['timeLoadPageEnable'] = 'Dies wird unten im Forum die Zeit in Sekunden anzeigen, die benötigt wurde, um die jeweilige Seite zu erstellen.';
$helptxt['removeNestedQuotes'] = 'This will remove, or limit the number of, nested quotes in a reply when citing the post via the quote link.';
$helptxt['heightBeforeShowMore'] = 'This will limit the height of a quote block.  Quotes exceeding this size will have a "read more" option applied to allow seeing the full quote.';
$helptxt['search_dropdown'] = 'Dies wird neben dem Schnellsuchfeld eine Suchaufklappliste anzeigen.  Aus dieser können Sie auswählen, ob Sie die gesamte Website, das aktuelle Forum (sofern Sie in einem Forum sind), das aktuelle Thema (sofern Sie in einem Thema sind) durchsuchen oder nach Mitgliedern suchen möchten.';
$helptxt['max_image_width'] = 'Dies erlaubt es Ihnen, eine maximale Größe für veröffentlichte Bilder festzulegen. Bilder, die kleiner sind, sind nicht betroffen. Dies legt außerdem fest, wie angehängte Bilder angezeigt werden sollen, wenn auf ihre Miniaturansicht geklickt wird.';
$helptxt['mail_type'] = 'Diese Einstellung erlaubt es Ihnen, entweder PHPs Standardeinstellungen zu verwenden oder stattdessen auf SMTP zurückzugreifen.  PHP unterstützt keine Anmeldung per SMTP (was viele Anbieter mittlerweile voraussetzen), weshalb Sie, wenn Sie dies wollen, SMTP auswählen sollten.  Bitte beachten Sie, dass SMTP langsamer sein kann und einige Server Benutzernamen und Passwort nicht entgegennehmen.<br /><br />Sie müssen die SMTP-Daten nicht angeben, wenn dies auf den PHP-Standard gesetzt ist.';
$helptxt['mail_batch_size'] = 'Diese Einstellung legt fest, wie viele E-Mails pro Seitenaufruf versandt werden, und kann den Höchstwert pro Minute nicht überschreiten.<br />Wird sie auf 0 gesetzt, so wird das System automatisch eine Stapelgröße festlegen, um die Last gleichmäßig zu verteilen und das Kontingent zu füllen.<br />Sofern Sie Ihre eigenen Werte einsetzen möchten, ist es eine gute Option, dies auf den gleichen Wert wie die Begrenzung (für niedrige Pro-Minute-Werte) oder 1/6 der Begrenzung (für höhere Pro-Minute-Werte) zu setzen.';
$helptxt['smtp_client'] = 'Used to identify this client to the SMTP server.<br />The field should contain the fully-qualified domain name (FQDN) of the SMTP client. In situations in which the client system does not have a meaningful domain name you can instead use an address literal formatted as [ipv4] or [IPv6:ipv6 address].<br />If left blank the system will attempt to detect this value for you.';

$helptxt['attachmentEnable'] = 'Aktiviert/Deaktiviert das Dateianhangssystem oder deaktiviert nur neue Dateianhänge, lässt jedoch bereits vorhandene unangetastet.';
$helptxt['automanage_attachments'] = 'Dies wird eine Verzeichnisstruktur auf Basis der ausgewählten Option erzeugen.  Bei dieser kann es sich um das Beitragsdatum (Aufteilung per Jahr oder per Jahr und Monat oder per Jahr, Monat und Tag) oder um das schlichte Hinzufügen eines neuen Verzeichnisses, wenn die Kapazitätsgrenze erreicht wurde, handeln.  Jedes erzeugte Verzeichnis wird die gleiche Anzahl an Dateien beherbergen und die gleichen Größenbeschränkungen besitzen.  Dies wird dabei helfen, Verzeichnisse daran zu hindern, eine bestimmte Größe (Anzahl oder Dateigröße der enthaltenen Dateien) zu erreichen.';
$helptxt['use_sub-directories_for_attachments'] = 'Dies wird alle neuen Verzeichnisse als Unterverzeichnisse des Hauptdateianhangsverzeichnisses anlegen.';
$helptxt['attachmentDirSizeLimit'] = ' Legen Sie fest, wie groß der Dateianhangsordner sein darf.';
$helptxt['attachmentDirFileLimit'] = 'Legen Sie die Höchstanzahl an Dateien fest, die ein einzelnes Dateianhangsverzeichnis enthalten darf';
$helptxt['attachmentPostLimit'] = 'Geben Sie an, wie groß (in KiB) ein einzelner Beitrag insgesamt sein darf; dies betrifft die Gesamtgröße aller Dateianhänge eines Beitrags.';
$helptxt['attachmentSizeLimit'] = 'Geben Sie die maximale Größe eines einzelnen Dateianhangs an.';
$helptxt['attachmentNumPerPostLimit'] = 'Wählen Sie die Anzahl an Dateien aus, die ein Mitglied pro Beitrag anhängen darf.';

$helptxt['attachment_image_resize_enabled'] = 'Master on/off switch for this function.  Enabling this will 
	resize attachment images (.jpg, .png, .gif, .bmp, .webp) to fit within the specified bounds.  The image format 
	will be maintained unless the resized image is over the specified max allowed file size.  In this event, if 
	change format is enabled, the system may convert the image to WebP or JPEG for better compression.';
$helptxt['attachment_image_resize_reformat'] = '
	Selecting this option will allow the system to change images into WebP, if available, or JPEG ONLY
	when necessary.  The system will try to maintain the existing format unless the resized image is in
	excess of the maximum allowed file size.  It will not reencode JPG or change a PNG with transparency to JPG';
$helptxt['attachment_image_resize_width'] = 'This allows you to set a maximum width for attachment images. 
	Pictures smaller than the maximum will not be affected, larger images will be resized proportionately. 
	This allows you to accept a larger image on upload and have it resized to save space. The maximum 
	filesize parameter is still enforced.';
$helptxt['attachment_image_resize_height'] = 'This allows you to set a maximum height for attachment images. 
	Pictures smaller than the maximum will not be affected, larger images will be resized proportionately. 
	This allows you to accept a larger image on upload and have it resized to save space. 
	The maximum filesize parameter is still enforced.';

$helptxt['attachmentCheckExtensions'] = 'Aktivieren Sie diesen Auswahlkasten, um die Dateianhangsfilterung zu aktivieren, die nur das Hochladen von Dateien mit den Dateierweiterungen erlaubt, die Sie definiert haben.';
$helptxt['attachmentExtensions'] = 'Legen Sie fest, welche Dateianhangstypen erlaubt sind, zum Beispiel: jpg,png,gif  Denken Sie daran, vorsichtig zu sein, da einige Dateitypen ein Sicherheitsrisiko für Ihre Website darstellen können.';
$helptxt['attachment_autorotate'] = 'Selecting this option will allow the system to detect rotated images, typical of phone cameras, and automatically adjust the orientation such that the image top is oriented up. Requires either ImageMagick or both GD and Exif modules to be available.';
$helptxt['attachmentShowImages'] = 'If the uploaded file is a picture, this will automatically display it underneath the post.  If not enabled you will only see a filename and its dsize';
$helptxt['attachmentThumbnails'] = 'Aktivieren Sie dies, um Beitragsbilder als kleinere Miniaturbilder anzuzeigen, die bei Auswahl auf die volle Größe erweitert werden.';
$helptxt['attachment_webp_enable'] = 'Enabling this will allow the system to create/save thumbnails and avatars 
	in WebP format.  It will also allow the image resize function, when enabled, to save an attachment as Webp when
 	necessary.';
$helptxt['attachmentThumbWidth'] = 'Wird nur zusammen mit der Option &quot;Bildgröße beim Anzeigen unter Beiträgen ändern&quot; verwendet, legt die maximale Breite fest, von der Dateianhänge verkleinert werden.  Die Größenänderung erfolgt proportional.';
$helptxt['attachmentThumbHeight'] = 'Wird nur zusammen mit der Option &quot;Bildgröße beim Anzeigen unter Beiträgen ändern&quot; verwendet, legt die maximale Höhe fest, von der Dateianhänge verkleinert werden.  Die Größenänderung erfolgt proportional.';
$helptxt['attachment_image_reencode'] = 'Selecting this option will enable the re-encode of uploaded image attachments. Image re-encoding offers better security, however it will also render all animated images static.';
$helptxt['max_image_height'] = 'Die maximal angezeigte Höhe eines Bildanhangs.';
$helptxt['max_image_width'] = 'Dies erlaubt es Ihnen, eine maximale Größe für veröffentlichte Bilder festzulegen. Bilder, die kleiner sind, sind nicht betroffen. Dies legt außerdem fest, wie angehängte Bilder angezeigt werden sollen, wenn auf ihre Miniaturansicht geklickt wird.';
$helptxt['attachmentUploadDir'] = 'Wählen Sie aus, wo auf Ihrem Server hochgeladene Dateien gespeichert werden sollen. Für mehr Sicherheit kann dieses Verzeichnis auch außerhalb des öffentlichen Webserververzeichnisses liegen.';
$helptxt['attachment_transfer_empty'] = 'Aktivieren Sie dies, so werden alle Dateien aus dem Quellverzeichnis an ihren neuen Ort verschoben, andernfalls wird nur die maximale Anzahl an Dateien gemäß der Pro-Verzeichnis-Einstellung verschoben.';
$helptxt['avatar_reencode'] = 'Selecting this option will enable the re-encode of uploaded avatars. Image re-encoding offers better security, however it will also render all animated images static.';
$helptxt['karmaMode'] = 'Karma ist eine Funktion, die die Beliebtheit eines Mitglieds anzeigt, Wenn aktiviert, können
		Mitglieder anderen Mitgliedern \'applaudieren\' oder sie \'zerschmettern\', anhand dessen deren Beliebtheit
		berechnet wird. Sie können die Anzahl an Beiträgen, die benötigt werden, um ein &quot;Karma&quot; zu haben, den
		Zeitabstand zwischen zwei Aktionen und die Einstellung, ob dieser auch für Administratoren gilt, ändern.<br /><br />
		Ob Benutzergruppen andere zerschmettern können, wird über eine Befugnis entschieden.  Wenn Sie Probleme dabei
		haben, diese Funktion für jedermann zu aktivieren, überprüfen Sie die vergebenen Befugnisse erneut.';
$helptxt['localCookies'] = 'Das System verwendet Cookies, um Anmeldeinformationen auf dem Benutzerrechner zu speichern.
	Cookies können global (meinserver.de) oder lokal (meinserver.de/pfad/zum/forum) gespeichert werden.<br />
	Aktivieren Sie diese Option, wenn Benutzer wider Erwarten automatisch abgemeldet werden.<hr />
	Global gespeicherte Cookies sind auf einem geteilten Webserver (etwa bplaced) weniger sicher.<hr />
	Lokale Cookies funktionieren außerhalb des Forumsverzeichnisses nicht, so dass, wenn Ihr Forum unter www.meinserver.de/forum liegt, Seiten wie www.meinserver.de/index.php nicht auf die Kontoinformationen zugreifen können.
	Vor allem, wenn SSI.php verwendet wird, werden globale Cookies empfohlen.';
$helptxt['enableBBC'] = 'Die Auswahl dieser Option wird es Ihren Mitgliedern erlauben, Bulletin Board Code (BBCode) überall im Forum zu verwenden, was es ihnen ermöglicht, ihre Beiträge mit Bildern, Schriftformatierung und mehr zu formatieren.';
$helptxt['time_offset'] = 'Nicht alle Forumsadministratoren wollen, dass ihr Forum dieselbe Zeitzone wie der Server, auf dem es liegt, nutzt. Verwenden Sie diese Option, um einen Zeitunterschied (in Stunden) anzugeben, den das Forum abhängig von der Serverzeit befolgen soll. Negative und Dezimalwerte sind erlaubt.';
$helptxt['default_timezone'] = 'Die Serverzeitzone sagt PHP, wo Ihr Server steht. Sie sollten sicherstellen, dass dieser Wert korrekt gesetzt ist, bevorzugt auf das Land/die Stadt, wo Ihr Server steht. Sie können weitere Informationen hierüber im <a href="http://www.php.net/manual/de/timezones.php" target="_blank">PHP-Handbuch</a> finden.';
$helptxt['spamWaitTime'] = 'Hier können Sie die Zeitspanne, die zwischen zwei Beiträgen vergehen muss, auswählen. Dies kann benutzt werden, um Leute davon abzuhalten, in Ihrem Forum zu "spammen", indem beschränkt wird, wie oft sie neue Beiträge schreiben können.';

$helptxt['enablePostHTML'] = 'Dies wird die Nutzung einiger grundlegender HTML-Tags gestatten:
	<ul class="normallist enablePostHTML">
		<li>&lt;b&gt;, &lt;u&gt;, &lt;i&gt;, &lt;s&gt;, &lt;em&gt;, &lt;ins&gt;, &lt;del&gt;</li>
		<li>&lt;a href=&quot;&quot;&gt;</li>
		<li>&lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;</li>
		<li>&lt;br /&gt;, &lt;hr /&gt;</li>
		<li>&lt;pre&gt;, &lt;blockquote&gt;</li>
	</ul>';

$helptxt['enablePostMarkdown'] = 'This will allow the use of some basic Markdown tags when posting:
	<ul class="normallist enablePostMarkdown">
		<li>**Text** or __Text__ => [b]Text[/b]</li>
		<li>*Text* or _Text_ => [i]Text[/i]</li>
		<li>~~Text~~ => [s]Text[/s]</li>
		<li>`Text` => [icode]Text[/icode]</li>
		<li>```Text``` => [code]Text[/code]</li>
		<li>> Text => [quote]Text[/quote]</li>
		<li>--- or *** or ___ => [hr]</li>
	</ul>';

// Initial theme settings - Manage and Install
$helptxt['themes'] = 'Hier können Sie auswählen, ob das Standarddesign ausgewählt werden kann, welches Design Gäste benutzen und weitere Optionen. Klicken Sie rechts auf ein Design, um seine Einstellungen zu ändern.';
$helptxt['theme_install'] = 'This section permits you to install new themes. You do this by uploading an archived file for the theme from your personal computer, installing from a theme directory on the host server or by copying the default theme and renaming that copied file.<br /><br />Please remember this: the archived file or directory must have a <span class="alert">theme_info.xml</span> definition file as a part of the archive or the directory.';
$helptxt['theme_forum_theme'] = 'Das Ändern des globalen Forenstandards betrifft keine Mitglieder, die ein anderes verfügbares Design ausgewählt haben. Sie müssen auch alle Mitglieder \'zurücksetzen\', um sie zum neuen Standard zu zwingen. Sie können auch ein Standarddesign auswählen, das von Gästen gesehen wird, und dann Ihre Mitglieder auf ein anderes Design zurücksetzen. <br /><br />Denken Sie daran, dass Benutzer, sofern Sie ihnen erlaubt haben, ihr eigenes Design auszuwählen, das von Ihnen gesetzte Design überschreiben können.';

// Theme Management and Options - Theme settings
$helptxt['themeadmin_list_reset'] = 'In seltenen Fällen geht der Pfad zum Design verloren und Ihr Forum wird nicht korrekt angezeigt. Dies kann in einem Fehler durch einen Administrator, Datenbankfehlern, fehlgeschlagenen Softwareaktualisierungen, Modinstallationen oder anderen Ereignissen begründet sein. Das Zurücksetzen der Design-URLs und -Verzeichnisse löst dieses Problem normalerweise.';
$helptxt['themeadmin_delete_help'] = 'Das Standarddesign kann nicht gelöscht werden, da dies Ihr Forum und andere Designs zerstören würde. Sie können allerdings jedes Design löschen, neben dem ein rotes \'X\' steht, indem Sie auf dieses \'X\' klicken. <br /><br /> Beachten Sie: Das Löschen eines Designs wird es nicht vom Server löschen, es wird nur im Forum nicht mehr zur Verfügung stehen. Sie werden das eigene Design via FTP vom Server löschen müssen. Löschen Sie niemals das \'Standard\'-Design.';

$helptxt['enableVideoEmbeding'] = 'This allows automatic conversion of standard URLs into an embedded video when the post is viewed.  Currently supports YouTube, Vimeo, TikTok, Twitter, Facebook, Instagram and Dailymotion links';
$helptxt['enableCodePrettify'] = 'Dies wird das Prettify-Script laden, das Code innerhalb von code-Tags farbig markieren wird.  Es fügt Codeschnipseln Stile hinzu, so dass Schlüsselwörter hervorgehoben werden und Ihre Benutzer den Code einfacher lesen können.';
// @todo Add more information about how to use them here.
$helptxt['xmlnews_enable'] = 'Erlaubt es Leuten, auf die <a href="%1$s?action=.xml;sa=news" target="_blank" class="new_win">letzten Neuigkeiten</a>
	und ähnliche Daten zu verlinken.  Es wird außerdem empfohlen, dass Sie die Anzahl der letzten Beiträge/Neuigkeiten
	begrenzen, weil, wenn RSS-Daten in einigen Clients wie Trillian angezeigt werden, diese vermutlich abgeschnitten werden.';
$helptxt['hotTopicPosts'] = 'Ändern Sie die Anzahl an Beiträgen, die ein Thema benötigt, um zu einem &quot;heißen&quot; oder
	&quot;brandheißen&quot; Thema zu werden.  Wählen Sie die Gefällt-mir-Option aus, um diesen Status auf der Anzahl an
	&quot;Gefällt mir&quot;s anstatt der Anzahl der Beiträge beruhen zu lassen';
$helptxt['globalCookies'] = 'Stellt Anmeldecookies über Subdomains hinaus zur Verfügung.  Wenn zum Beispiel...<br />
	Ihre Website auf http://www.meinserver.de/ liegt<br />
	und Ihr Forum unter http://forum.meinserver.de/,<br />
	gewährt diese Option der Website Zugriff auf die Cookies des Forums.  Aktivieren Sie diese Option nicht, wenn es andere Subdomains (wie hacker.meinserver.de) gibt, die nicht unter Ihrer Kontrolle stehen.<br />
	Diese Option funktioniert nicht, wenn lokale Cookies aktiviert sind.';
$helptxt['globalCookiesDomain'] = 'Legen Sie die Hauptdomain fest, die verwendet werden soll, wenn Anmeldecookies über Subdomains hinweg verfügbar sind';
$helptxt['httponlyCookies'] = 'Wird dies aktiviert, so kann mit Skriptsprachen wie JavaScript nicht auf die Cookies des Forums zugegriffen werden. Diese Einstellungen kann dabei helfen, Identitätsdiebstahl mittels XSS-Angriffen zu reduzieren. Dies kann Probleme mit einigen Drittanbieterskripten verursachen, aber es wird empfohlen, dies nach Möglichkeit zu aktivieren.';
$helptxt['secureCookies'] = 'Die Aktivierung dieser Option wird die für die Benutzer Ihres Forums erzeugten Cookies als sicher markieren. Aktivieren Sie diese Option nur, wenn Sie auf Ihrer Website ausnahmslos HTTPS verwenden, da sonst die Cookiebehandlung nicht mehr korrekt funktioniert!';
$helptxt['admin_session_lifetime'] = 'Dies steuert die maximale Dauer einer Administratorensitzung. Sobald diese Stoppuhr abläuft, wird die Sitzung beendet, was dazu führt, dass Sie Ihre Zugangsdaten erneut eingeben müssen, um weiterhin auf administrative Funktionen zugreifen zu können. Der Mindestwert beträgt 5 Minuten, der Höchstwert 14400 Minuten (entspricht einem Tag). Es wird aus Sicherheitsgründen dringend empfohlen, einen Wert unter 60 Minuten anzugeben.';
$helptxt['auto_admin_session'] = 'Dies legt fest, ob eine administrative Sitzung bereits bei der Anmeldung gestartet werden soll oder nicht.';
$helptxt['securityDisable'] = 'Dies <em>deaktiviert</em> die zusätzliche Passwortüberprüfung für den Administrationsbereich. Dies wird nicht empfohlen!';
$helptxt['securityDisable_why'] = 'Dies ist Ihr derzeitiges Passwort (das Sie auch zur Anmeldung verwenden).<br /><br />Dies eingeben zu müssen unterstützt dabei, sicherzugehen, dass Sie, was immer Sie gerade Administratives tun wollen, wirklich vorhaben und dass es wirklich <strong>Sie</strong> sind.';
$helptxt['securityDisable_moderate'] = 'Dies <em>deaktiviert</em> die zusätzliche Passwortüberprüfung für den Moderationsbereich. Dies wird nicht empfohlen!';
$helptxt['securityDisable_moderate_why'] = 'Dies ist Ihr derzeitiges Passwort (das Sie auch zur Anmeldung verwenden).<br /><br />Dies eingeben zu müssen unterstützt dabei, sicherzugehen, dass Sie, was immer Sie gerade Moderierendes tun wollen, wirklich vorhaben und dass es wirklich <strong>Sie</strong> sind.';
$helptxt['enableOTP'] = 'Enabling this feature allows another layer of security for a member\'s account. Two-factor authentication, or 2FA, is a way of logging into websites that requires more than just a password. Using a password to log into a website is susceptible to security threats, because it represents a single piece of information a malicious person needs to acquire. The added security that 2FA provides is requiring additional information to sign in.<br /><br />A Time-based One-Time Password (TOTP) application such as Google Authenticator or Authy automatically generates an authentication code that changes after a certain period of time.';
$helptxt['emailmembers'] = 'In dieser Nachricht können Sie ein paar &quot;Variablen&quot; verwenden.  Dies sind:<br />
	{$board_url} - Der URL Ihres Forums.<br />
	{$current_time} - Der momentane Zeitpunkt.<br />
	{$member.email} - Die E-Mail-Adresse des aktuellen Mitglieds.<br />
	{$member.link} - Der Verweis zum aktuellen Mitglied.<br />
	{$member.id} - Die Kennung des aktuellen Mitglieds.<br />
	{$member.name} - Der Name des aktuellen Mitglieds (zwecks Personalisierung).<br />
	{$latest_member.link} - Der Verweis zum neuesten Mitglied.<br />
	{$latest_member.id} - Die Kennung des neuesten Mitglieds.<br />
	{$latest_member.name} - Der Name des neuesten Mitglieds.';
$helptxt['attachmentEncryptFilenames'] = 'Die Verschlüsselung der Dateinamen von Dateianhängen erlaubt es Ihnen, mehr als einen Dateianhang des gleichen Namens zu haben, und erhöht die Sicherheit.  Es könnte es allerdings schwieriger machen, Ihre Datenbank neu aufzubauen, wenn etwas Schlimmes passiert ist.';

$helptxt['failed_login_threshold'] = 'Legt die Anzahl an fehlgeschlagenen Anmeldeversuchen fest, bevor der Benutzer auf die Passwort-vergessen-Seite weitergeleitet wird.';
$helptxt['loginHistoryDays'] = 'Die Anzahl an Tagen, für die der Anmeldeverlauf unter dem Profilverlauf eines Benutzers gespeichert wird. Standard sind 30 Tage.';
$helptxt['oldTopicDays'] = 'Sofern diese Option aktiviert ist, wird einem Benutzer eine Warnung angezeigt, wenn er versucht, auf ein Thema zu antworten, das seit der hier (in Tagen) angegebenen Zeit keine neuen Antworten erhalten hat. Setzen Sie dies auf 0, um diese Funktion zu deaktivieren.';
$helptxt['edit_wait_time'] = 'Anzahl an Sekunden, während derer ein Beitrag bearbeitet werden kann, bevor der Zeitpunkt der letzten Änderung protokolliert wird.';
$helptxt['edit_disable_time'] = 'Anzahl an Minuten, die vergehen dürfen, bevor ein Benutzer einen eigenen Beitrag nicht mehr bearbeiten darf. Setzen Sie dies zum Deaktivieren auf 0.<br /><br /><em>Beachten Sie: Dies betrifft nicht diejenigen Benutzer, die die Beiträge anderer Benutzer uneingeschränkt bearbeiten dürfen.</em>';
$helptxt['preview_characters'] = 'Diese Option legt die Anzahl an verfügbaren Zeichen für den ersten und den letzten Beitrag in der Themenvorschau fest.  <strong>Beachten Sie,</strong> dass dies die Informationen nur für das Design verfügbar macht, das Design muss die Einstellung &quot;Beitragsvorschau im Nachrichtenindex anzeigen&quot; selbst unterstützen';
$helptxt['posts_require_captcha'] = 'Diese Einstellung wird es voraussetzen, dass Benutzer jedes Mal, wenn sie einen Beitrag veröffentlichen möchten, einer Anti-Spambot-Überprüfung standhalten. Nur Benutzer mit einer niedrigeren als der festgelegten Anzahl an Beiträgen müssen den Code eingeben - dies sollte bei der Bekämpfung automatischer Spamskripte helfen.';
$helptxt['lastActive'] = 'Legt die Anzahl an Minuten fest, binnen derer Benutzer auf der Startseite als aktiv angezeigt werden. Standard sind 15 Minuten';

$helptxt['hide_post_group'] = 'Enabling this will not display a member\'s post group title on the message view if they are assigned to a non-post based group.';

$helptxt['customoptions'] = 'Dieser Bereich definiert die Optionen, aus denen ein Benutzer aus einer Aufklappliste auswählen kann. Hier gilt es einige wichtige Punkte zu beachten:
	<ul class="normallist">
		<li><strong>Standardoption:</strong> Jedwelche Option, deren nebenstehendes Optionsfeld ausgewählt ist, wird als Standardauswahl gesetzt, wenn ein Benutzer sein Profil ausfüllt.</li>
		<li><strong>Optionen entfernen:</strong> Um eine Option zu entfernen, leeren Sie einfach ihr Textfeld - bei allen Benutzern, die sie ausgewählt haben, wird sie daraufhin zurückgesetzt.</li>
		<li><strong>Optionen umsortieren:</strong> Sie können die Optionen umsortieren, indem Sie Text zwischen den Kästen verschieben. Sie müssen allerdings - wichtiger Hinweis - sicherstellen, dass Sie den Text beim Umsortieren <strong>nicht</strong> ändern, da sonst Benutzerdaten verloren gehen.</li>
	</ul>';

$helptxt['autoOptDatabase'] = 'Diese Option aktiviert die Optimierung der Datenbank im festgelegten Intervall (in Tagen).  Setzen Sie dies auf 1 für eine tägliche Optimierung.  Sie können auch eine maximale Anzahl an Onlinebenutzern angeben, so dass Ihr Server nicht überlastet wird oder Sie zu viele Benutzer verärgern.';
$helptxt['autoFixDatabase'] = 'Dies wird automatisch defekte Tabellen reparieren und fortsetzen, als wäre nichts geschehen.  Dies kann nützlich sein, denn die einzige Möglichkeit zur Behebung ist es, die Tabelle zu REPARIEREN, und auf diese Weise wird Ihr Forum nicht unerreichbar sein, ohne dass Sie es bemerken.  Sie werden eine E-Mail erhalten, wenn es geschieht.';

$helptxt['enableParticipation'] = 'Dies zeigt an Themen, in denen der Benutzer einen Beitrag geschrieben hat, ein kleines Symbol an.';
$helptxt['enableFollowup'] = 'Dies erlaubt es Mitgliedern, neue Themen mit einem Zitat aus irgendeinem Beitrag zu eröffnen.';

$helptxt['db_persist'] = 'Hält die Verbindung aufrecht, um die Geschwindigkeit zu erhöhen.  Wenn Sie nicht auf einem eigenen Server sind, könnte dies Probleme mit Ihrem Anbieter verursachen.';
$helptxt['ssi_db_user'] = 'Optionale Einstellung zur Verwendung anderer Datenbankzugangsdaten, wenn Sie SSI.php benutzen.';

$helptxt['countChildPosts'] = 'Die Aktivierung dieser Option bedeutet, dass Beiträge und Themen in einem Unterforum auf der Startseite zu denen des Elternforums addiert werden.<br /><br />Dies wird die Dinge merklich verlangsamen, bedeutet aber, dass ein Elternforum ohne enthaltene Beiträge nicht \'0\' anzeigen wird.';
$helptxt['allow_ignore_boards'] = 'Die Aktivierung dieser Option wird es Benutzern erlauben, Foren auszuwählen, die sie ignorieren möchten.';
$helptxt['deny_boards_access'] = 'Die Aktivierung dieser Option wird es Ihnen erlauben, den Zugriff auf bestimmte Foren basierend auf dem Benutzergruppenzugriff zu verweigern';

$helptxt['who_enabled'] = 'Diese Option erlaubt es Ihnen, die Möglichkeit, dass Benutzer sehen können, wer online ist und was derjenige gerade tut, an- und abzuschalten.';

$helptxt['recycle_enable'] = '&quot;Recycles&quot; deleted topics and posts to the specified board.';

$helptxt['enableReportPM'] = 'Diese Option erlaubt es Ihren Benutzern, erhaltene private Nachrichten den Administratoren zu melden. Dies könnte dabei helfen, Missbrauch des Private-Nachrichten-Systems zu verfolgen.';
$helptxt['max_pm_recipients'] = 'Diese Option erlaubt es Ihnen, die maximale Anzahl an Empfängern pro privater Nachricht seitens eines Mitglieds zu begrenzen. Sie kann verwendet werden, um Spammissbrauch des Private-Nachrichten-Systems einzudämmen. Beachten Sie, dass Benutzer mit der Befugnis, Rundbriefe zu versenden, von dieser Beschränkung ausgenommen sind. Setzen Sie dies auf null, um die Begrenzung aufzuheben.';
$helptxt['pm_posts_verification'] = 'Diese Einstellung wird Benutzer dazu zwingen, jedes Mal, wenn sie eine private Nachricht versenden möchten, einen Code auf einer Verifizierungsgrafik einzugeben. Nur Benutzer mit einer Beitragsanzahl unterhalb des eingestellten Wertes müssen den Code eingeben - dies sollte dabei helfen, automatische Spamskripte zu bezwingen.';
$helptxt['pm_posts_per_hour'] = 'Dies wird die Anzahl an privaten Nachrichten, die ein Benutzer pro Stunde versenden kann, begrenzen. Dies betrifft weder Administratoren noch Moderatoren.';

$helptxt['default_personal_text'] = 'Legt den Standardtext fest, der im Profil eines neuen Benutzers als sein &quot;persönlicher Text&quot; erscheinen wird. Diese Option ist nicht verfügbar, wenn persönliche Texte deaktiviert sind oder Benutzer sie bei der Registrierung selbst festlegen können.';

$helptxt['modlog_enabled'] = 'Protokolliert alle Moderationshandlungen.';
$helptxt['userlog_enabled'] = 'Logs all key changes a user makes to their profile.';

$helptxt['registration_method'] = 'Diese Option legt fest, welche Art der Registrierung Leuten angeboten wird, die Ihrem Forum beitreten möchten. Sie können auswählen aus:<br /><br />
	<ul class="normallist">
		<li>
			<strong>Registrierung deaktiviert</strong><br />
				Deaktiviert den Registrierungsvorgang, was bedeutet, dass Ihr Forum keine neuen Mitglieder aufnehmen kann.<br />
		</li><li>
			<strong>Sofortige Registrierung</strong><br />
				Neue Mitglieder können sich sofort anmelden und neue Beiträge verfassen, sobald sie sich in Ihrem Forum registriert haben.<br />
		</li><li>
			<strong>E-Mail-Aktivierung</strong><br />
				Ist diese Option aktiviert, so wird jedem Mitglied, das sich im Forum registriert, ein Link per E-Mail gesendet, den es zunächst anklicken muss, bevor es ein vollwertiges Mitglied werden kann.<br />
		</li><li>
			<strong>Administrative Freischaltung</strong><br />
				Diese Option sorgt dafür, dass alle neuen Mitglieder nach der Registrierung zunächst von einem Administrator freigeschaltet werden müssen, bevor sie vollwertige Mitglieder werden können.
		</li>
	</ul>';

$helptxt['send_validation_onChange'] = 'Wenn diese Option angekreuzt ist, müssen alle Mitglieder, die ihre E-Mail-Adresse in ihrem Profil ändern, ihr Konto unter Zuhilfenahme einer E-Mail, die an die neue Adresse gesendet wird, erneut aktivieren';
$helptxt['send_welcomeEmail'] = 'Wenn diese Option aktiviert ist, wird allen neuen Mitgliedern eine E-Mail gesendet, die sie in Ihrem Forum willkommen heißt';
$helptxt['password_strength'] = 'Diese Einstellung legt die nötige Stärke für von Ihren Benutzern ausgewählte Passwörter fest. Je stärker das Passwort ist, desto schwerer sollte es sein, das jeweilige Benutzerkonto zu kompromittieren.
	Ihre verfügbaren Optionen lauten:
	<ul class="normallist">
		<li><strong>Niedrig:</strong> Das Passwort muss mindestens vier Zeichen lang sein.</li>
		<li><strong>Mittel:</strong> Das Passwort muss mindestens acht Zeichen lang sein und kann kein Teil eines Benutzernamens oder einer E-Mail-Adresse sein.</li>
		<li><strong>Hoch:</strong> Wie mittel, aber das Passwort muss außerdem Groß- und Kleinbuchstaben und mindestens eine Ziffer enthalten.</li>
	</ul>';
$helptxt['enable_password_conversion'] = 'Nach Aktivierung dieser Einstellung wird ElkArte versuchen, Passwörter, die in anderen Formaten vorliegen, zu erkennen und zur Verwendung in dieser Software zu konvertieren.  Typischerweise wird dies für konvertierte Foren genutzt, es könnte aber auch andere Anwendungsfälle geben.  Die Deaktivierung verhindert, dass sich ein Benutzer nach einer Konvertierung mit seinen bisherigen Benutzerdaten anmeldet, und zwingt ihn zu einer Zurücksetzung seines Passworts.';

$helptxt['coppaAge'] = 'Der in diesem Feld angegebene Wert legt das Mindestalter fest, das neue Mitglieder erreicht haben müssen, damit ihnen sofortiger Zugriff auf das Forum gewährt wird.
	Bei der Registrierung werden sie darum gebeten, zu bestätigen, dass sie alt genug sind, und andernfalls entweder abgewiesen oder bis zur elterlichen Zustimmung suspendiert - abhängig von der ausgewählten Registrierungsart.
	Wird hier ein Wert von 0 ausgewählt, so werden alle anderen Altersbeschränkungen ignoriert.';
$helptxt['coppaType'] = 'Falls Altersbeschränkungen aktiv sind, definiert diese Einstellung, was passieren soll, wenn ein Benutzer unterhalb des Mindestalters sich zu registrieren versucht. Es gibt zwei mögliche Optionen:
	<ul class="normallist">
		<li>
			<strong>Registrierung abweisen:</strong><br />
				Die Registrierung jedes neuen Mitglieds unterhalb des Mindestalters wird umgehend abgewiesen.<br />
		</li><li>
			<strong>Einverständniserklärung eines Erziehungsberechtigten voraussetzen</strong><br />
				Jedes neue Mitglied, das sich zu registrieren versucht und das Mindestalter noch nicht erreicht hat, wird angemeldet, jedoch nicht freigeschaltet, und erhält ein Formular, auf dem seine Eltern oder Erziehungsberechtigten ihr Einverständnis für die Mitgliedschaft im Forum mitteilen müssen.
				Außerdem werden die Kontaktdaten angezeigt, die auf der Einstellungsseite angegeben wurden, so dass sie das Formular per E-Mail oder Fax übermitteln können.
		</li>
	</ul>';
$helptxt['coppaPost'] = 'Die Kontaktfelder werden benötigt, damit Formulare zur Beantragung einer Registrierung für minderjährige Benutzer an den Administrator gesendet werden können. Die Kontaktdaten werden all diesen neuen Benutzern angezeigt und sind Voraussetzung für die Genehmigung der Eltern/Erziehungsberechtigten. Außerdem muss eine Postadresse oder Faxnummer angegeben werden.';

$helptxt['allow_hideOnline'] = 'Nach der Aktivierung dieser Option werden alle Mitglieder dazu in der Lage sein, ihren Onlinestatus vor anderen Benutzern (außer Administratoren) zu verstecken. Falls deaktiviert, können nur Benutzer, die das Forum moderieren, ihre Gegenwart verbergen. Beachten Sie, dass die Deaktivierung dieser Option nicht den aktuellen Status von Mitgliedern ändern wird - sie hält sie nur davon ab, sich künftig zu verstecken.';

$helptxt['latest_support'] = 'Dieser Bereich zeigt Ihnen einige der häufigsten Probleme und Fragen zu Ihrer Serverkonfiguration an. Keine Sorge, diese Informationen werden nicht protokolliert oder so.<br /><br />Wenn die Anzeige auf &quot;Rufe Supportinformationen ab...&quot; stehen bleibt, kann Ihr Rechner vermutlich keine Verbindung zur Website herstellen.';
$helptxt['latest_packages'] = 'Here you can see some of the most popular and some random packages, with quick and easy installations.<br /><br />If this section doesn\'t show up, your computer probably cannot connect to <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>.';
$helptxt['latest_themes'] = 'This area shows a few of the latest and most popular themes from <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>.  It may not show up properly if your computer can\'t find <a href="https://www.elkarte.net/" target="_blank" class="new_win">www.elkarte.net/</a>, though.';

$helptxt['secret_why_blank'] = 'Zu Ihrer Sicherheit werden Ihr Passwort und die Antwort auf Ihre geheime Frage verschlüsselt, so dass weder ElkArte noch irgendjemand anders Ihnen sagen kann, wie sie lauten.';
$helptxt['moderator_why_missing'] = 'Since moderation is done on a board-by-board basis, you have to make members moderators from the <a href="%1$s?action=admin;area=manageboards" target="_blank" class="new_win">board management interface</a>.';

$helptxt['permissions'] = 'Befugnisse sind Ihre Möglichkeit, Gruppen bestimmte Aktionen zu erlauben oder sie ihnen zu verwehren.<br /><br />Sie können mithilfe der Auswahlkästen mehrere Foren gleichzeitig ändern oder die Befugnisse für eine bestimmte Gruppe per Klick auf \'Ändern\' ansehen.';
$helptxt['permissions_board'] = 'Falls ein Forum auf \'Global\' gesetzt ist, so bedeutet dies, dass es keine besonderen Befugnisse besitzt.  \'Lokal\' heißt, dass es seine eigenen Befugnisse besitzt - getrennt von den globalen.  Dies erlaubt es Ihnen, ein Forum zu haben, das mehr oder weniger Befugnisse als ein anderes hat, ohne dass Sie sie für jedes einzelne Forum festlegen müssen.';
$helptxt['permissions_quickgroups'] = 'Diese erlauben es Ihnen, &quot;Standard&quot;-Befugnissätze zu verwenden - \'Standard\' heißt \'nichts Besonderes\', \'beschränkt\' heißt \'wie ein Gast\', \'Moderator\' heißt \'was ein Moderator hat\', \'Wartung\' schließlich umfasst Befugnisse, die denen eines Administrators sehr nahe kommen.';
$helptxt['permission_enable_deny'] = 'Das Verweigern von Befugnissen kann nützlich sein, wenn Sie sie bestimmten Mitgliedern entziehen möchten. Sie können Mitgliedern, denen Sie eine Befugnis verweigern möchten, eine Benutzergruppe mit einer \'Verweigern\'-Befugnis zuweisen.<br /><br />Verwenden Sie dies achtsam, eine entzogene Befugnis bleibt unabhängig von anderen Benutzergruppen, in denen ein Mitglied ist, entzogen.';
$helptxt['permission_enable_postgroups'] = 'Die Aktivierung von Befugnissen für beitragsbasierte Gruppen wird es Ihnen ermöglichen, Mitgliedern mit einer bestimmten Anzahl an Beiträgen gesonderte Berechtigungen zu erteilen. Diese Berechtigungen werden den Befugnissen der übrigen Benutzergruppen des Mitglieds <em>hinzugefügt</em>.';
$helptxt['membergroup_guests'] = 'Die Benutzergruppe der Gäste enthält alle Benutzer, die nicht angemeldet sind.';
$helptxt['membergroup_regular_members'] = 'Normale Mitglieder sind alle Mitglieder, die angemeldet sind, denen jedoch keine primäre Benutzergruppe zugewiesen wurde.';
$helptxt['membergroup_administrator'] = 'Der Administrator kann definitionsgemäß alles tun und jedes Forum sehen. Für ihn gibt es daher keine Befugniseinstellungen.';
$helptxt['membergroup_moderator'] = 'Die Benutzergruppe der Moderatoren ist eine besondere Benutzergruppe. Befugnisse und Einstellungen für diese Gruppen gelten für Moderatoren, aber <em>nur in den Foren, die sie moderieren</em>. Außerhalb dieser Foren sind sie lediglich ein normales Mitglied wie jedes andere auch.';
$helptxt['membergroups'] = 'Es gibt zwei Arten von Gruppen, in die Ihre Benutzer gehören können. Dies sind:
	<ul class="normallist">
		<li><strong>Normale Gruppen:</strong> Eine normale Gruppe ist eine Gruppe, die Mitgliedern nicht automatisch zugeteilt wird. Um eine Gruppe einem Benutzer zuzuweisen, gehen Sie einfach in sein Profil und klicken Sie auf &quot;Kontoeinstellungen&quot;. Von hier aus können Sie ihn einer beliebigen Anzahl an normalen Gruppen zuweisen, denen er fortan angehören wird.</li>
		<li><strong>Beitragsgruppen:</strong> Anders als normalen Gruppen können Benutzer beitragsbasierten Gruppen nicht zugewiesen werden. Stattdessen werden Mitglieder einer solchen Gruppe automatisch zugewiesen, wenn sie die Mindestanzahl an nötigen Beiträgen für diese Gruppe erreicht haben.</li>
	</ul>';

$helptxt['calendar_how_edit'] = 'Sie können diese Ereignisse per Klick auf das rote Sternchen (*) neben ihren Namen ändern.';

$helptxt['maintenance_backup'] = 'Dieser Bereich erlaubt es Ihnen, eine Kopie all der Beiträge, Einstellungen, Mitglieder und weiterer Informationen über Ihr Forum in eine sehr große Datei zu speichern.<br /><br />Aus Sicherheitsgründen wird empfohlen, dass Sie dies oft tun, womöglich etwa wöchentlich.';
$helptxt['maintenance_rot'] = 'Dies erlaubt es Ihnen, alte Themen <strong>vollständig</strong> und <strong>unwiderruflich</strong> zu entfernen.  Es wird empfohlen, dass Sie zunächst versuchen, eine Sicherungskopie anzulegen, falls Sie versehentlich etwas entfernen, das Sie nicht entfernen wollten.<br /><br />Verwenden Sie diese Option sorgsam.';
$helptxt['maintenance_members'] = 'Dies erlaubt es Ihnen, Benutzerkonten <strong>vollständig</strong> und <strong>unwiderruflich</strong> aus Ihrem Forum zu entfernen.  Es wird <strong>wärmstens</strong> empfohlen, dass Sie zunächst versuchen, eine Sicherungskopie anzulegen, falls Sie versehentlich etwas entfernen, das Sie nicht entfernen wollten.<br /><br />Verwenden Sie diese Option sorgsam.';

$helptxt['avatar_default'] = 'With this option enabled, a default avatar is shown for all users without their own avatar. The file named \'default_avatar.png\' is located in the images folder inside the themes directory.  If you also enable "Use a default gravatar image for all users without their own avatar.", then a gravatar generated image will be used instead.';
$helptxt['avatar_server_stored'] = 'Dies erlaubt es Ihren Mitgliedern, ihren Avatar aus einer Reihe an auf Ihrem Server gespeicherten Avataren selbst auszuwählen.  Diese liegen im Allgemeinen am selben Ort wie das Forum im Avatarverzeichnis.<br />Ein Tipp: Indem Sie in diesem Verzeichnis Ordner erstellen, können Sie sie zu &quot;Avatarkategorien&quot; machen.';
$helptxt['avatar_external'] = 'Ist dies aktiviert, so können Ihre Mitglieder den URL ihres eigenen Benutzerbildes eingeben.  Der Nachteil hiervon ist in manchen Fällen, dass sie Avatare verwenden könnten, die übermäßig groß sind oder Bilder darstellen, die Sie in Ihrem Forum nicht haben möchten.';
$helptxt['avatar_download_external'] = 'Wenn Sie dies aktivieren, wird auf den vom Benutzer angegebenen URL zugegriffen, um den Avatar an dieser Stelle herunterzuladen. Bei Erfolg wird der Avatar wie ein hochladbares Benutzerbild behandelt.';
$helptxt['avatar_upload'] = 'Diese Option funktioniert ähnlich wie &quot;Externe Avatare erlauben&quot;, außer dass Sie eine bessere Kontrolle über die Avatare, eine schnellere Größenänderung und den Vorteil erzielen, dass Ihre Mitglieder keinen gesonderten Ordner brauchen, in den sie Avatare hochladen können.<br /><br />Der Nachteil ist allerdings, dass Avatare viel Platz auf Ihrem Server belegen können.';
$helptxt['avatar_resize_options'] = 'Diese Optionen beziehen sich auf alle Avatare, die von Benutzern auf den Server geladen oder von einem externen Server bezogen werden.';
$helptxt['avatar_download_png'] = 'PNGs are larger, but offer higher quality.  If this is unchecked, JPEG will be used instead, which is often smaller, but also removes transparency and is of lesser or blurry quality.';
$helptxt['gravatar'] = 'Gravatar (global erkannter Avatar) ist ein Dienst, der weltweit eindeutige Avatare zur Verfüging stellt. Für weitere Informationen besuchen Sie bitte die Gravatar-<a href="http://www.gravatar.com" target="_blank"><strong>Website</strong>.</a>';
$helptxt['gravatar_rating'] = 'Gravatar erlaubt es Benutzern, ihre Bilder selbst zu bewerten, so dass sie anzeigen können, ob ein Bild für eine bestimmte Zielgruppe angemessen ist. Standardmäßig werden nur als \'G\' bewertete Bilder angezeigt, es sei denn, Sie legen fest, dass Sie auch gern höhere Ränge sehen möchten.<br /><br /><ul><li><strong>g:</strong> angemessen für die Anzeige auf allen Webseiten mit beliebiger Zielgruppe.</li><li><strong>pg:</strong> kann rüde Gesten, provokant gekleidete Personen, mindere Schimpfwörter oder milde Gewalt enthalten.</li><li><strong>r:</strong> kann Dinge wie herbe Obszönität, heftige Gewalt, Nacktheit oder den Gebrauch harter Drogen enthalten.</li><li><strong>x:</strong>kann Hardcoresex-Darstellungen oder äußerst verstörende Gewalt enthalten.</li></ul>';
$helptxt['disableHostnameLookup'] = 'Dies deaktiviert das Nachschlagen von Hostnamen, das auf manchen Servern sehr langsam ist.  Beachten Sie, dass dies Sperrungen weniger effizient macht.';
$helptxt['url_format'] = 'The UrlGenerator subsystem builds forum links in three interchangeable styles<br /><br />Standard: classic query parameters (default style), e.g. ?topic=123.45;action=print.<br />Semantic: "pretty url" human‑readable URLs with slugs in the path, e.g. ?t/some-topic-title-123/page-45;other=param.<br />Queryless: path and extension based (no normal query string), e.g. ?topic,123.45.html;other=param.';

$helptxt['search_weight_commonheader'] = 'Weight factors are used to determine the relevancy of a search result. Change these weight factors to match the things that are specifically important for your forum. For instance, a forum of a news site might want a relatively high value for \'age of last matching message\'. All values are relative in relation to each other and should be positive integers.';
$helptxt['search_weight_frequency'] = 'Dieser Faktor zählt die Menge passender Beiträge und teilt sie durch die Gesamtzahl an Beiträgen in einem Thema.';
$helptxt['search_weight_age'] = 'Dieser Faktor bewertet das Alter des letzten passenden Beitrags in einem Thema. Je neuer der Beitrag ist, desto höher sein Wert.';
$helptxt['search_weight_length'] = 'Dieser Faktor basiert auf der Größe eines Themas. Je mehr Beiträge es enthält, desto höher sein Wert.';
$helptxt['search_weight_subject'] = 'Dieser Faktor schaut nach, ob ein Suchbegriff innerhalb eines Thementitels gefunden werden kann.';
$helptxt['search_weight_first_message'] = 'Dieser Faktor schaut nach, ob ein Treffer im ersten Beitrag eines Themas gefunden werden kann.';
$helptxt['search_weight_sticky'] = 'Dieser Faktor schaut nach, ob ein Thema angeheftet ist, und erhöht dessen Relevanz, wenn es das ist.';
$helptxt['search_weight_likes'] = 'This factor looks whether a topic has likes and increases the relevancy score based on the number.';
$helptxt['search'] = 'Nehmen Sie hier alle Einstellungen für die Suchfunktion vor.';
$helptxt['search_why_use_index'] = 'Ein Suchindex kann die Geschwindigkeit von Suchanfragen in Ihrem Forum nennenswert verbessern. Besonders dann, wenn die Anzahl an Beiträgen in einem Forum größer wird, kann das Suchen ohne einen Index lange dauern und die Last auf Ihrer Datenbank vergrößern. Wenn Ihr Forum mehr als 50.000 Beiträge hat, sollten Sie in Erwägung ziehen, einen Suchindex zu erstellen, um eine dauerhaft hohe Geschwindigkeit Ihres Forums sicherzustellen.<br /><br />Beachten Sie, dass ein Suchindex ein wenig Speicherplatz belegen kann. Ein Volltextindex ist ein eingebauter Index der Datenbank. Er ist vergleichsweise klein (ungefähr so groß wie die Beitragstabelle), aber viele allgemeine Begriffe werden nicht indiziert und er kann sich bei komplexen Abfragen als langsam herausstellen. Der eigene Index ist größer (abhängig von Ihrer Konfiguration kann er bis zu dreimal so groß wie die Beitragstabelle werden), aber seine Geschwindigkeit ist oft besser als die des Volltextindexes und er indiziert die meisten Begriffe.';

$helptxt['see_admin_ip'] = 'IP-Adressen werden Administratoren und Moderatoren angezeigt, um die Moderation zu vereinfachen und es leichter zu machen, Leute zu verfolgen, die Böses im Sinn haben.  Beachten Sie, dass IP-Adressen nicht immer eindeutig identifizierbar sind und die IP-Adressen der meisten Leute sich wiederkehrend ändern.<br /><br />Mitglieder können auch ihre eigenen IPs sehen.';
$helptxt['see_member_ip'] = 'Ihre IP-Adresse wird nur Ihnen und Moderatoren angezeigt.  Beachten Sie, dass diese Informationen keine eindeutige Identifikation ermöglichen und dass die meisten IPs sich wiederkehrend ändern.<br /><br />Sie können die IP-Adressen anderer Mitglieder nicht sehen und diese die Ihre nicht.';
$helptxt['whytwoip'] = 'Verschiedene Methoden werden verwendet, um Benutzer-IP-Adressen zu ermitteln. Normalerweise resultieren diese beiden Methoden in der gleichen Adresse, aber in manchen Fällen könnte mehr als eine Adresse entdeckt werden. In diesem Fall werden beide Adressen protokolliert und für Sperrprüfungen (und so weiter) verwendet. Sie können auf jede Adresse klicken, um sie zu verfolgen únd bei Bedarf zu sperren.';

$helptxt['ban_cannot_post'] = 'Die \'kann keine Beiträge erstellen\'-Berschränkung versetzt das Forum für den gesperrten Benutzer in einen Lesemodus. Der Benutzer kann keine neuen Themen erstellen oder auf bestehende Themen antworten, private Nachrichten versenden oder an Umfragen teilnehmen. Der gesperrte Benutzer kann jedoch noch immer private Nachrichten und Themen lesen.<br /><br />Eine Warnung wird auf diese Weise gesperrten Benutzern angezeigt.';

$helptxt['posts_and_topics'] = '
	<ul class="normallist">
		<li>
			<strong>Post Settings</strong><br />
			Modify the settings related to the posting of messages and the way messages are shown.
		</li><li>
			<strong>Censored Words</strong>
			In order to keep the language on your forum under control, you can censor certain words. This function allows you to convert forbidden words into innocent versions.
		</li><li>
			<strong>Topic Settings</strong>
			Modify the settings related to topics. The number of topics per page, whether pinned topics are enabled or not, the number of messages needed for a topic to be hot, etc.
		</li>
	</ul>';
$helptxt['allow_no_censored'] = 'When checked, this global setting allows members to disable word censoring in their User Profile through the Look and Layout settings. The members\' ability to disable word censoring is still limited by their permission profile.';
$helptxt['spider_mode'] = 'Legt die Protokollierungsstufe fest.<br />
Standard - Protokolliert minimale Suchmaschinenaktivität.<br />
Moderat - Stellt genauere Statistiken zur Verfügung.<br />
Aggressiv - Wie &quot;Moderat&quot;, protokolliert jedoch auch Daten für jede besuchte Seite.';

$helptxt['spider_group'] = 'Mittels Auswählens einer beschränkten Gruppe wird ein Gast, sofern er als Suchmaschine identifiziert wird, zusätzlich zu den normalen Gastbefugnissen automatisch alle &quot;Verbieten&quot;-Befugnisse dieser Gruppe erhalten. Sie können dies verwenden, um einer Suchmaschine weniger Zugriffsrechte als einem normalen Gast einzuräumen. Sie könnten zum Beispiel eine neue Gruppe namens &quot;Suchmaschinen&quot; erstellen und hier auswählen. Sie können dann dieser Gruppe die Anzeige von Profilen verbieten, um Suchmaschinen davon abzuhalten, die Profile Ihrer Mitglieder zu indizieren.<br />Hinweis: Die Suchmaschinenerkennung ist nicht perfekt und eine Suchmaschine kann von Benutzern simuliert werden, so dass wir nicht garantieren können, dass diese Funktion Inhalte nur für die hinzugefügten Suchmaschinen beschränkt.';
$helptxt['show_spider_online'] = 'Diese Einstellungen erlaubt es Ihnen, auszuwählen, ob Suchmaschinen in der Onlineliste auf der Startseite des Forums und auf der &quot;Wer ist online?&quot;-Seite angezeigt werden sollen. Die Optionen sind:
	<ul class="normallist">
		<li>
			<strong>Gar nicht</strong><br />
			Suchmaschinen werden allen Benutzern nur als Gäste angezeigt.
		</li><li>
			<strong>Anzahl an Spidern anzeigen</strong><br />
			Die Startseite des Forums wird die Anzahl an Suchmaschinen anzeigen, die derzeit das Forum besuchen.
		</li><li>
			<strong>Namen der Spider anzeigen</strong><br />
			Jeder Suchmaschinenname wrd aufgedeckt, so dass Benutzer sehen können, wie viele Spider von jeder Suchmaschine momentan im Forum unterwegs sind - dies wirkt sich sowohl auf die Onlineliste als auch auf die Onlineseite aus.
		</li><li>
			<strong>Namen der Spider anzeigen - nur Admin</strong><br />
			Wie oben, gilt aber nur für Administratoren - allen anderen Benutzern werden Spider als Gäste angezeigt.
		</li>
	</ul>';
$helptxt['spider_no_guest'] = 'By selecting this, the spider will only be a member of the restrictive group and have the permissions and board access of that group (no guest access). You can use this to provide lesser access to a search engine than you would a normal guest. You might for example wish to remove spiders from indexing certain boards while still allowing guest viewing.';

$helptxt['birthday_email'] = 'Wählen Sie den Text der Geburtstags-E-Mail aus, den Sie verwenden möchten.  Eine Vorschau wird in den Betreff- und Inhalt-Feldern angezeigt.<br /><strong>Hinweis:</strong> Die Änderung dieser Option aktiviert nicht automatisch die Geburtstags-E-Mails.  Um dies zu tun, gehen Sie zu den <a href="%1$s?action=admin;area=scheduledtasks;%3$s=%2$s" target="_blank" class="new_win">geplanten Aufgaben</a> und aktivieren Sie die Aufgabe für die Geburtstags-E-Mails.';
$helptxt['pm_bcc'] = 'Beim Versand einer privaten Nachricht können Sie einen Empfänger als BCC oder &quot;Blindkopie&quot; auswählen. BCC-Empfänger werden anderen Empfängern einer Nachricht nicht angezeigt.';

$helptxt['move_topics_maintenance'] = 'Dies wird es Ihnen erlauben, alle Beiträge von einem Forum in ein anderes zu verschieben.';
$helptxt['maintain_reattribute_posts'] = 'Sie können diese Funktion verwenden, um Gastbeiträge in Ihrem Forum einem registrierten Mitglied zuzuweisen. Dies ist nützlich, wenn ein Benutzer zum Beispiel sein Konto gelöscht, sich dann aber umentschieden hat und seine alten Beiträge wieder an sein (neues) Konto binden lassen möchte.';
$helptxt['chmod_flags'] = 'Sie können die Befugnisse, die Sie den ausgewählten Dateien zuteilen möchten, händisch festlegen. Um dies zu tun, geben Sie den chmod-Wert als nummerischen Wert (Oktett) ein. Beachten Sie, dass dieser Wert unter Microsoft Windows keine Auswirkungen hat.';

$helptxt['postmod'] = 'Dieser Bereich erlaubt es Mitgliedern des Moderationsteams (mit ausreichenden Befugnissen), jegliche Beiträge und Themen zu überprüfen, bevor sie freigegeben werden.';

$helptxt['field_show_enclosed'] = 'Encloses the user input between some text or HTML code.  This will allow you to add more instant message providers, images or an embed, etc. For example:<br /><br />
		&lt;a href="http://website.com/{INPUT}"&gt;&lt;img src="{DEFAULT_IMAGES_URL}/icon.png" alt="{INPUT}" /&gt;&lt;/a&gt;<br /><br />
		You can use the following variables:<br />
		<ul class="normallist">
			<li>{INPUT} - The input specified by the user.</li>
			<li>{KEY} - The key specified for a certain value of select box or radio buttons in the admin panel. Usually to use in case of localization or use in CSS of Javascript elements (e.g. as class name).</li>
			<li>{SCRIPTURL} - Web address of forum.</li>
			<li>{IMAGES_URL} - URI of the images directory of the user\'s current theme.</li>
			<li>{DEFAULT_IMAGES_URL} - URI of the images directory of the default theme.</li>
		</ul>';

$helptxt['custom_mask'] = 'The input mask is important for your forum\'s security. Validating the input from a user can help to ensure that data is not used in a way you do not expect. We have provided some simple regular expressions as hints.<br /><br />
	<div class="smalltext custom_mask">
		&quot;~[A-Za-z]+~&quot; - Match all upper and lower case alphabet characters.<br />
		&quot;~[0-9]+~&quot; - Match all numeric characters.<br />
		&quot;~[A-Za-z0-9]{7}~&quot; - Match all upper and lower case alphabet and numeric characters seven times.<br />
		&quot;~[^0-9]?~&quot; - Forbid any number from being matched.<br />
		&quot;~^([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$~&quot; - Only allow 3 or 6 character hexcodes.<br />
	</div><br /><br />
	Additionally, special metacharacters ?+*^$ and {xx} can be defined.
	<div class="smalltext custom_mask">
		? - None or one match of previous expression.<br />
		+ - One or more of previous expression.<br />
		* - None or more of previous expression.<br />
		{xx} - An exact number of the previous expression.<br />
		{xx,} - An exact number or more of the previous expression.<br />
		{,xx} - An exact number or less of the previous expression.<br />
		{xx,yy} - An exact match between the two numbers from previous expression.<br />
		^ - Start of string.<br />
		$ - End of string.<br />
		\ - Escapes the next character.<br />
	</div><br /><br />
	More information and advanced techniques may be found on the internet.';

$helptxt['badbehavior_httpbl_maxage'] = 'Dies ist die Anzahl an Tagen, seit eine verdächtige Aktivität durch eine IP-Adresse zuletzt durch das Project Honey Pot beobachtet wurde. Bad Behavior wird Anfragen mit einem Höchstalter gleich oder niedriger als diese Einstellung.';
$helptxt['badbehavior_httpbl_threat'] = 'Diese Zahl dient als Messwert, wie verdächtig eine IP-Adresse ist, basierend auf bei Project Honey Pot beobachteter Aktivität. Bad Behavior wird Anfragen mit einer Bedrohungsstufe ab dieser Einstellung blockieren. Project Honey Pot hat <a href="http://www.projecthoneypot.org/threat_info.php" target="_blank">weitere Informationen über diesen Parameter</a>.';
$helptxt['badbehavior_httpbl_key'] = 'Bad Behavior ist dazu in der Lage, Daten des vom <a href="http://www.projecthoneypot.org/" target="_blank">Project Honey Pot</a> bereitgestellten <a href="http://www.projecthoneypot.org/faq.php#g" target="_blank">http:BL</a>-Dienstes zur Durchleuchtung von Anfragen zu verwenden.<br /><br />Dieser Dienst ist rein optional; wenn Sie ihn allerdings verwenden möchten, müssen Sie sich <a href="http://www.projecthoneypot.org/httpbl_configure.php" target="_blank">für den Dienst registrieren</a> und einen API-Schlüssel anfordern. Um die Verwendung von http:BL zu deaktivieren, entfernen Sie den API-Schlüssel aus Ihren Einstellungen.';
$helptxt['badbehavior_accept_header'] = 'This enforces that a proper Accept header be send with requests.  All browsers due this by default, but many scrappers/harvesters do not and will be blocked.';

$helptxt['filter_to'] = 'Ersetzt den gefundenen Text hierdurch, leer lassen, um ihn durch nichts zu ersetzen (d.h. zu entfernen)';
$helptxt['filter_from'] = 'Geben Sie den Text ein, den Sie suchen/ersetzen möchten.  Wenn der Typ auf regex gesetzt ist, muss dies ein gültiger regulärer Ausdruck einschließlich der Trennzeichen sein.  Andernfalls wird eine einfache Textübereinstimmung gesucht und durch den Ersetzungstext ersetzt';
$helptxt['filter_type'] = 'Standard wird den genauen Begriff suchen und durch den Text im Ersetzen-Feld ersetzen.  Regulärer Ausdruck ist eine Platzhalteroption, es muss sich jedoch um einen gültigen regulären Ausdruck handeln.';
$helptxt['pbe_post_enabled'] = 'Aktivieren Sie dies, um es Benutzern zu erlauben, auf E-Mail-Benachrichtungen zu antworten und dies als Antwort zu veröffentlichen.  Sie müssen dennoch berechtigt sein, Beiträge zu verfassen.';
$helptxt['pbe_pm_enabled'] = 'Aktivieren Sie dies, um es Benutzern zu erlauben, per E-Mail auf Benachrichtigungen über private Nachrichten zu antworten.  Sie müssen dennoch berechtigt sein, private Nachrichten zu verfassen, diese Einstellung erlaubt es ihnen nur, sie zu empfangen und auf Benachrichtigungen zu antworten';
$helptxt['maillist_group_mode'] = 'Falls aktiviert, werden ausgehende Beitrags-/Themen-E-Mails vom Anzeigenamen des Verfassers kommen, ansonsten kommen sie vom Namen des Forums.  Dies ist nur ein Umschlag, es hat nur Auswirkungen darauf, wie der "Absendername" im Posteingang des Empfängers erscheint, die E-Mail-Adresse des Absenders bleibt unverändert.';
$helptxt['maillist_newtopic_change'] = 'Dies wird es einem Benutzer erlauben, den Betreff einer E-Mail-Benachrichtigung zu ändern und sie dadurch als neues Thema zu veröffentlichen.  Das neue Thema wird im gleichen Forum wie das Thema eröffnet, in dem sich das Thema befindet, über das der Benutzer benachrichtigt wurde.';
$helptxt['maillist_sitename_address'] = 'Dies muss die Adresse, die an die Datei emailpost.php weitergeleitet wird, oder die Adresse des IMAP-Posteingangs sein';
$helptxt['maillist_help_short'] = 'Diese Funktion erlaubt es Benutzern Ihres Forums, auf die Mailbenachrichtigungen Ihres Forums zu antworten und diese Antworten im Forum zu veröffentlichen.  Bitte besuchen Sie das Wiki für eine vollständige Anleitung';

$helptxt['frame_security'] = 'Die X-Frame-Options-HTTP-Antwortkopfzeile kann verwendet werden, um anzuzeigen, ob ein Browser eine Seite in einem Frame oder einem iframe darstellen darf oder nicht. Sie können diese zusätzliche Sicherheitsbeschränkung auf Ihrer Website gegen Clickjackingangriffe verwenden, indem sichergestellt wird, dass der Inhalt Ihrer Website nicht in andere Websites eingebunden ist.
	<br />
	Weitere Informationen über diese Kopfzeile können im Internet gefunden werden.';

$helptxt['attachment_inline_title'] = '<b>Add an inline attachment</b><br />
		Example:
		<br /><b>[attach align=left width=400]123[/attach]</b>
		<br />This will show a left-aligned image resized to 400 pixels wide with the post text flowing around it. Except for the attachment tag and the attachment id all other parameters are optional
		<br /><b>[attach]123[/attach]</b>
		<br />This will show the attachment as a thumbnail if available, if no thumbnail is available it will use a full sized image. The image will be in line with the text of your post.
		<br /><br />
		<br /><b>Options:</b>
		<br />where x is the attachment id
		<br />align=left, center, right
		<br />width=### (where # is number in pixels)
		<br />height=### (where # is number in pixels)
		<br />
		<h3>Modes available</h3>
		<p>
			You can choose the inline mode you want for your attachment:
			<ul>
				<li>Thumbnail [attach]x[/attach] : Your image will be shown as a thumbnail</li>
				<li>Text Link [attachurl]x[/attachurl] : Only a link is show with size and view details. By clicking on it, the image is displayed.</li>
			</ul>
		</p><br />
		<p>
			You can choose how to align the inline image:
			<ul>
				<li>align=left : The image is aligned to the left and the text will flow around it</li>
				<li>align=right : The image is aligned to the right and the text will flow around it</li>
				<li>align=center : The image is centered and the text will be below it</li>
			</ul>
		</p><br />
		<p>
			You can choose how wide to show the image:
			<ul>
				<li>width=123 : The image is displayed 123 pixels wide</li>
				<li>If the width specified is larger than the image or larger than the forum allows the largest allowable width will be used</li>
				<li>Can be used to shrink a thumbnail as well [attach width=50]x[/attach] will display a 50px wide thumbnail</li>
			</ul>
		</p><br />
		<p>
			You can choose how tall to show the image:
			<ul>
				<li>height=123 : The image is displayed 123 pixels tall</li>
				<li>If the height specified is bigger than the image or bigger than the forum allows the biggest allowable width will be used</li>
				<li>Can be used to shrink a thumbnail as well [attach height=50]x[/attach] will display a 50px tall thumbnail</li>
			</ul>
		</p>';
