<?php
// Version: 2.0; index

global $forum_copyright;

// Locale (strftime, pspell_new) and spelling.
// For more information see:
//   - https://www.php.net/function.pspell-new
//   - https://www.php.net/function.setlocale
$txt['lang_locale'] = 'de_DE';
$txt['lang_dictionary'] = 'de';
$txt['lang_spelling'] = 'deutsch';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set and right to left?
$txt['lang_rtl'] = false;
// Capitalize day and month names?
$txt['lang_capitalize_dates'] = true;
// Number format.
$txt['number_format'] = '1.234,00';

$txt['sunday'] = 'Sonntag';
$txt['monday'] = 'Montag';
$txt['tuesday'] = 'Dienstag';
$txt['wednesday'] = 'Mittwoch';
$txt['thursday'] = 'Donnerstag';
$txt['friday'] = 'Freitag';
$txt['saturday'] = 'Sonnabend';

$txt['sunday_short'] = 'So';
$txt['monday_short'] = 'Mo';
$txt['tuesday_short'] = 'Di';
$txt['wednesday_short'] = 'Mi';
$txt['thursday_short'] = 'Do';
$txt['friday_short'] = 'Fr';
$txt['saturday_short'] = 'Sa';

$txt['january'] = 'Januar';
$txt['february'] = 'Februar';
$txt['march'] = 'März';
$txt['april'] = 'Apri';
$txt['may'] = 'Mai';
$txt['june'] = 'Juni';
$txt['july'] = 'Juli';
$txt['august'] = 'August';
$txt['september'] = 'September';
$txt['october'] = 'Oktober';
$txt['november'] = 'November';
$txt['december'] = 'Dezember';

$txt['january_titles'] = 'Januar';
$txt['february_titles'] = 'Februar';
$txt['march_titles'] = 'März';
$txt['april_titles'] = 'Apri';
$txt['may_titles'] = 'Mai';
$txt['june_titles'] = 'Juni';
$txt['july_titles'] = 'Juli';
$txt['august_titles'] = 'August';
$txt['september_titles'] = 'September';
$txt['october_titles'] = 'Oktober';
$txt['november_titles'] = 'November';
$txt['december_titles'] = 'Dezember';

$txt['january_short'] = 'Jan';
$txt['february_short'] = 'Feb';
$txt['march_short'] = 'Mär';
$txt['april_short'] = 'Apr';
$txt['may_short'] = 'Mai';
$txt['june_short'] = 'Jun';
$txt['july_short'] = 'Jul';
$txt['august_short'] = 'Aug';
$txt['september_short'] = 'Sep';
$txt['october_short'] = 'Okt';
$txt['november_short'] = 'Nov';
$txt['december_short'] = 'Dez';

$txt['time_am'] = 'vormittags';
$txt['time_pm'] = 'nachmittags';

// Let's get all the main menu strings in one place.
$txt['main_menu'] = 'Main Menu';
$txt['home'] = 'Startseite';
$txt['community'] = 'Forum';
$txt['forum'] = 'Forum';

// Sub menu labels
$txt['help'] = 'Hilfe';
$txt['search'] = 'Suchen';
$txt['calendar'] = 'Kalender';
$txt['members'] = 'Mitglieder';
$txt['recent_posts'] = 'Letzte Beiträge';
$txt['recent_topics'] = 'Letzte Themen';

$txt['admin'] = 'Admin';
// Sub menu labels
$txt['errlog'] = 'Fehlerprotokoll';
$txt['package'] = 'Add-on Manager';
$txt['edit_permissions'] = 'Befugnisse';
$txt['modSettings_title'] = 'Funktionen und Optionen';
$txt['pwa_label'] = 'Web Application';

$txt['moderate'] = 'Moderat';
// Sub menu labels
$txt['modlog_view'] = 'Moderationsprotokoll';
$txt['mc_emailerror'] = 'Nicht überprüfte E-Mails';
$txt['mc_reported_posts'] = 'Gemeldete Beiträge';
$txt['mc_reported_pms'] = 'Reported Personal Messages';
$txt['mc_unapproved_attachments'] = 'Nicht überprüfte Anhänge';
$txt['mc_unapproved_poststopics'] = 'Nicht überprüfte Beiträge und Themen';

$txt['pm_short'] = 'Meine Nachrichten';
// Sub menu labels
$txt['pm_menu_read'] = 'Lesen Sie Ihre Nachrichten';
$txt['pm_menu_send'] = 'Senden Sie eine Nachricht';

$txt['account_short'] = 'Mein Konto';
// Sub menu labels
$txt['profile'] = 'Profil';
$txt['mydrafts'] = 'My Drafts';
$txt['summary'] = 'Zusammenfassung';
$txt['theme'] = 'Aussehen und Anordnung';
$txt['account'] = 'Kontoeinstellungen';
$txt['forumprofile'] = 'Forenprofil';

$txt['view_unread_category'] = 'Neue Beiträge';
$txt['view_replies_category'] = 'Neue Antworten';

$txt['login'] = 'Anmelden';
$txt['register'] = 'Registrieren';
$txt['logout'] = 'Abmelden';
// End main menu strings.

$txt['save'] = 'Speichern';

$txt['modify'] = 'Übernehmen';
$txt['forum_index'] = '%1$s - Index';
$txt['board_name'] = 'Boardname';
$txt['posts'] = 'Beiträge';

$txt['member_postcount'] = 'Beiträge';
$txt['no_subject'] = '(Kein Betreff)';
$txt['view_profile'] = 'Profil ansehen';
$txt['guest_title'] = 'Gast';
$txt['author'] = 'Autor';
$txt['on'] = 'am';
$txt['remove'] = 'Löschen';
$txt['start_new_topic'] = 'Neues Thema starten';

// Use numeric entities in the below string.
$txt['username'] = 'Benutzername';
$txt['password'] = 'Passwort';

$txt['username_no_exist'] = 'Dieser Benutzername existiert nicht.';
$txt['no_user_with_email'] = 'Mit dieser E-Mail-Adresse sind keine Benutzernamen verbunden.';

$txt['board_moderator'] = 'Boardmoderator';
$txt['remove_topic'] = 'Löschen';
$txt['topics'] = 'Themen';
$txt['modify_msg'] = 'Nachricht ändern';
$txt['name'] = 'Name';
$txt['email'] = 'E-Mail';
$txt['user_email_address'] = 'E-Mail-Adresse';
$txt['subject'] = 'Betreff';
$txt['message'] = 'Text';
$txt['redirects'] = 'Weiterleitungen';

$txt['choose_pass'] = 'Passwort auswählen';
$txt['verify_pass'] = 'Passwort bestätigen';
$txt['position'] = 'Position';
$txt['notify_announcements'] = 'Sign up to receive important site news by email';

$txt['profile_of'] = 'Profil von';
$txt['total'] = 'Insgesamt';
$txt['posts_made'] = 'Beiträge';
$txt['topics_made'] = 'Themen';
$txt['website'] = 'Website';
$txt['contact'] = 'Kontakt';
$txt['warning_status'] = 'Verwarnstatus';
$txt['user_warn_watch'] = 'Benutzer wird beobachtet';
$txt['user_warn_moderate'] = 'Benutzerbeiträge müssen moderiert werden';
$txt['user_warn_mute'] = 'Benutzer ist vom Beitragsschreiben ausgeschlossen';
$txt['warn_watch'] = 'Beobachtet';
$txt['warn_moderate'] = 'Moderiert';
$txt['warn_mute'] = 'Stumm';
$txt['warning_issue'] = 'Verwarnen';

$txt['message_index'] = 'Nachrichtenindex';
$txt['news'] = 'Neuigkeiten';
$txt['page'] = 'Seite';
$txt['prev'] = 'vorherige';
$txt['next'] = 'nächste';

$txt['post'] = 'Beitrag';
$txt['error_occurred'] = 'Ein Fehler ist aufgetreten';
$txt['send_error_occurred'] = 'Ein Fehler ist aufgetreten, <a href="{href}">bitte klicken Sie hier, um es erneut zu versuchen</a>.';
$txt['require_field'] = 'Dieses Feld wird benötigt.';
$txt['started_by'] = 'Begonnen vom Autoren';
$txt['topic_started_by'] = 'Begonnen von %1$s';
$txt['topic_started_by_in'] = 'Started by %1$s in %2$s';
$txt['replies'] = 'Antworten';
$txt['last_post'] = 'Letzter Beitrag';
$txt['first_post'] = 'Erster Beitrag';
$txt['last_poster'] = 'Autor des letzten Beitrags';

$txt['last_post_message'] = '<span class="lastpost_link">%2$s </span><span class="board_lastposter">von %1$s</span><span class="board_lasttime"><strong>Neuester Beitrag: </strong>%3$s</span>';
$txt['boardindex_total_posts'] = '%1$s Posts in %2$s Topics by %3$s Members';
$txt['show'] = 'Zeigen';
$txt['hide'] = 'Verstecken';
$txt['sort_by'] = 'Sortieren nach';
$txt['sort_asc'] = 'Aufsteigend sortieren';
$txt['sort_desc'] = 'Absteigend sortieren';

$txt['admin_login'] = 'Administratorenanmeldung';
// Use numeric entities in the below string.
$txt['topic'] = 'Thema';
$txt['help'] = 'Hilfe';
$txt['notify'] = 'Benachrichtigung';
$txt['unnotify'] = 'Nicht mehr benachrichtigen';
$txt['notify_request'] = 'Möchten Sie per E-Mail benachrichtigt werden, wenn jemand auf dieses Thema antwortet?';
// Use numeric entities in the below string.
$txt['regards_team'] = "Regards,\nThe {forum_name_html_unsafe} Team.";
$txt['notify_replies'] = 'Bei Antwort benachrichtigen';
$txt['move_topic'] = 'Verschiebe';
$txt['move_to'] = 'Verschieben nach';
$txt['pages'] = 'Seiten';
$txt['users_active'] = 'Active in past %1$d minutes';
$txt['personal_messages'] = 'Private Nachrichten';
$txt['reply_quote'] = 'Mit Zitat antworten';
$txt['reply'] = 'Antwort';
$txt['reply_number'] = 'Antwort #%1$s';
$txt['approve'] = 'Freigeben';
$txt['unapprove'] = 'Nicht freigeben';
$txt['approve_all'] = 'alles freigeben';
$txt['awaiting_approval'] = 'Wartet auf Freischaltung';
$txt['attach_awaiting_approve'] = 'Anhänge warten auf Freischaltung';
$txt['post_awaiting_approval'] = 'Hinweis: Dieser Beitrag wartet auf Freischaltung durch einen Moderator.';
$txt['there_are_unapproved_topics'] = 'There are %1$s topics and %2$s posts awaiting approval in this board. <a href="%3$s">Click here to view them</a>.';
$txt['send_message'] = 'Nachricht senden';

$txt['msg_alert_no_messages'] = 'Sie haben keine Nachrichten';
$txt['msg_alert_one_message'] = 'you have <a href="%1$s">1 message</a>';
$txt['msg_alert_many_message'] = 'you have <a href="%1$s">%2$d messages</a>';
$txt['msg_alert_one_new'] = '1 ist neu';
$txt['msg_alert_many_new'] = '%1$d sind neu';
$txt['remove_message'] = 'Diese Nachricht entfernen';

$txt['topic_alert_none'] = 'Keine Nachrichten...';
$txt['pm_alert_none'] = 'Keine Nachrichten...';

$txt['online_users'] = 'Benutzer online'; //Deprecated
$txt['online_now'] = 'jetzt online';
$txt['personal_message'] = 'Private Nachricht';
$txt['jump_to'] = 'Springe zu';
$txt['go'] = 'Los';
$txt['are_sure_remove_topic'] = 'Sind Sie sich sicher, dass Sie dieses Thema löschen möchten?';
$txt['yes'] = 'Ja';
$txt['no'] = 'Nein';

// @todo this string seems a good candidate for deprecation
$txt['search_on'] = 'am';

$txt['search'] = 'Suchen';
$txt['all'] = 'Alles';
$txt['search_entireforum'] = 'Ganzes Forum';
$txt['search_thisbrd'] = 'Dieses Board';
$txt['search_thistopic'] = 'Dieses Thema';
$txt['search_members'] = 'Mitglieder';

$txt['back'] = 'Zurück';
$txt['continue'] = 'Fortfahren';
$txt['password_reminder'] = 'Passworterinnerung';
$txt['topic_started'] = 'Thema begonnen von';
$txt['title'] = 'Titel';
$txt['post_by'] = 'Beitrag von';
$txt['welcome_newest_member'] = 'Bitte heißen Sie %1$s, unser neuestes Mitglied, willkommen.';
$txt['admin_center'] = 'Administrationszentrum';
$txt['admin_session_active'] = 'Sie haben eine laufende Adminsitzung. Wir empfehlen <strong><a class="strong" href="%1$s">diese Sitzung zu beenden</a></strong>, wenn Sie mit Ihren administrativen Tätigkeiten fertig sind.';
$txt['admin_maintenance_active'] = 'Ihr Forum läuft zurzeit im Wartungsmodus, nur Administratoren können sich anmelden.  Denken Sie daran, <strong><a class="strong" href="%1$s">den Wartungsmodus abzuschalten</a></strong> , wenn Sie mit Ihren administrativen Tätigkeiten fertig sind.';
$txt['query_command_denied'] = 'Folgende MySQL-Fehler sind aufgetreten, bitte überprüfen Sie Ihre Konfiguration:';
$txt['query_command_denied_guests'] = 'Es scheint, als wäre im Forum etwas mit der Datenbank nicht in Ordnung. Dieses Problem sollte nur vorübergehend bestehen, kommen Sie also bitte später wieder und versuchen Sie es erneut.  Wenn Sie diese Nachricht weiterhin zu Gesicht bekommen, melden Sie bitte folgende Nachricht einem Administrator:';
$txt['query_command_denied_guests_msg'] = 'der Befehl %1$s ist der Datenbank nicht erlaubt';
$txt['last_edit_by'] = '<span class="lastedit">Zuletzt geändert</span>: %1$s von %2$s';
$txt['notify_deactivate'] = 'Would you like to deactivate notification on this topic?';

$txt['date_registered'] = 'Registrierungsdatum';
$txt['date_joined'] = 'Joined';
$txt['date_joined_format'] = '%b %d, %Y';
$txt['last_seen'] = 'Last Seen';

$txt['recent_view'] = 'Alle neuen Beiträge anzeigen.';
$txt['is_recent_updated'] = '%1$s ist das zuletzt aktualisierte Thema';

$txt['male'] = 'Männlich';
$txt['female'] = 'Weiblich';

$txt['error_invalid_characters_username'] = 'Ungültiges Zeichen im Benutzernamen.';

$txt['welcome_guest'] = 'Welcome, <strong>Guest</strong>. Please <a href="{login_url}" rel="nofollow">login</a>.';
$txt['welcome_guest_register'] = 'Welcome to <strong>{forum_name}</strong>. Please <a href="{login_url}" rel="nofollow">login</a> or <a href="{register_url}" rel="nofollow">register</a>.';
$txt['welcome_guest_activate'] = '<br />Did you miss your <a href="{activate_url}" rel="nofollow">activation email</a>?';
$txt['welcome_register'] = 'Don\'t have an account?';

// @todo the following to sprintf
$txt['hello_member'] = 'Moin,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Willkommen,';
$txt['select_destination'] = 'Bitte wählen Sie ein Ziel aus';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Geschrieben von';

$txt['icon_smiley'] = 'Lächeln';
$txt['icon_angry'] = 'Wütend';
$txt['icon_cheesy'] = 'Frech';
$txt['icon_laugh'] = 'Lachen';
$txt['icon_sad'] = 'Traurig';
$txt['icon_wink'] = 'Zwinkern';
$txt['icon_grin'] = 'Grinsen';
$txt['icon_shocked'] = 'Schockiert';
$txt['icon_cool'] = 'Lässig';
$txt['icon_huh'] = 'Hä?';
$txt['icon_rolleyes'] = 'Augenrollen';
$txt['icon_tongue'] = 'Zunge';
$txt['icon_embarrassed'] = 'Peinlich berührt';
$txt['icon_lips'] = 'Lippen versiegelt';
$txt['icon_undecided'] = 'Unentschlossen';
$txt['icon_kiss'] = 'Kuss';
$txt['icon_cry'] = 'Weinen';
$txt['icon_angel'] = 'Unschuldig';

$txt['moderator'] = 'Moderator';
$txt['moderators'] = 'Moderatoren';

$txt['views'] = 'Ansichten';
$txt['new'] = 'Neu';
$txt['no_redir'] = 'Weitergeleitet von %1$s';

$txt['view_all_members'] = 'Alle Mitglieder ansehen';
$txt['view'] = 'Ansicht';

$txt['viewing_members'] = 'Betrachte Mitglied %1$s bis %2$s';
$txt['of_total_members'] = 'von insgesamt %1$s Mitgliedern';

$txt['forgot_your_password'] = 'Passwort vergessen?';

$txt['date'] = 'Datum';
// Use numeric entities in the below string.
$txt['from'] = 'Von';
$txt['to'] = 'An';

$txt['board_topics'] = 'Themen';
$txt['members_title'] = 'Mitglieder';
$txt['members_list'] = 'Mitgliederliste';
$txt['new_posts'] = 'Neue Beiträge';
$txt['old_posts'] = 'Keine neuen Beiträge';
$txt['redirect_board'] = 'Forum umleiten';
$txt['redirect_board_to'] = 'Leite weiter auf %1$s';

$txt['sendtopic_send'] = 'Absenden';
$txt['report_sent'] = 'Ihre Meldung wurde erfolgreich versandt.';
$txt['topic_sent'] = 'Ihre E-Mail wurde erfolgreich versandt.';

$txt['time_offset'] = 'Zeitabweichung';
$txt['or'] = 'oder';

$txt['mention'] = 'Benachrichtigungen';
$txt['notifications'] = 'Benachrichtigungen';
$txt['unread_notifications'] = 'You have %1$s unread notifications since your last visit.';
$txt['new_from_last_notifications'] = 'You have %1$s new notifications.';
$txt['forum_notification'] = 'Notifications from %1$s.';

$txt['your_ban'] = 'Pardon, %1$s, Sie wurden aus diesem Forum verbannt!';
$txt['your_ban_expires'] = 'Dieser Bann wird am %1$s aufgehoben.';
$txt['your_ban_expires_never'] = 'Dieser Bann wird niemals aufgehoben.';
$txt['ban_continue_browse'] = 'Sie können das Forum als Gast weiterhin benutzen.';

$txt['mark_as_read'] = 'ALLE Nachrichten als gelesen markieren';
$txt['mark_as_read_confirm'] = 'Are you sure you want to mark ALL messages as read?';
$txt['mark_these_as_read'] = 'DIESE Nachrichten als gelesen markieren';
$txt['mark_these_as_read_confirm'] = 'Are you sure you want to mark THESE messages as read?';

$txt['locked_topic'] = 'Geschlossenes Thema';
$txt['normal_topic'] = 'Normales Thema';
$txt['participation_caption'] = 'Topic you have posted in';

$txt['print'] = 'Drucken';
$txt['topic_summary'] = 'Themenzusammenfassung';
$txt['not_applicable'] = 'n.v.';
$txt['name_in_use'] = 'Der Name %1$s wird bereits von einem anderen Mitglied verwendet.';

$txt['total_members'] = 'Mitglieder insgesamt';
$txt['total_posts'] = 'Gesamte Beiträge';
$txt['total_topics'] = 'Themen insgesamt';

$txt['mins_logged_in'] = 'Minuten angemeldet bleiben';

$txt['preview'] = 'Vorschau';
$txt['always_logged_in'] = 'Immer angemeldet bleiben';

$txt['logged'] = 'Protokolliert';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';

$txt['www'] = 'WWW';
$txt['link'] = 'Verweis';

$txt['by'] = 'von'; //Deprecated

$txt['hours'] = 'Stunden';
$txt['minutes'] = 'Minuten';
$txt['seconds'] = 'Sekunden';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Stunde';
$txt['days_word'] = 'Tage';

$txt['newest_member'] = ', unser neuestes Mitglied.'; //Deprecated

$txt['search_for'] = 'Suchen nach';
$txt['search_match'] = 'Treffer';

$txt['maintain_mode_on'] = 'Denken Sie daran: Dieses Forum befindet sich im \'Wartungsmodus\'.';

$txt['read'] = 'Gelesen'; //Deprecated
$txt['times'] = '-mal'; //Deprecated
$txt['read_one_time'] = 'Einmal gelesen';
$txt['read_many_times'] = '%1$d-mal gelesen';

$txt['forum_stats'] = 'Forumsstatistiken';
$txt['latest_member'] = 'Neuestes Mitglied';
$txt['total_cats'] = 'Kategorien insgesamt';
$txt['latest_post'] = 'Neuester Beitrag';

$txt['here'] = 'hier';
$txt['you_have_no_msg'] = 'Sie haben keine Nachrichten...';
$txt['you_have_one_msg'] = 'Sie haben eine Nachricht...<a href="%1$s">Klicken Sie hier, um sie anzusehen</a>';
$txt['you_have_many_msgs'] = 'Sie haben %2$d Nachrichten...<a href="%1$s">Klicken Sie hier, um sie anzusehen</a>';

$txt['total_boards'] = 'Foren insgesamt';

$txt['print_page'] = 'Seite drucken';
$txt['print_page_text'] = 'Nur Text';
$txt['print_page_images'] = 'Text mit Bildern';

$txt['valid_email'] = 'Dies muss eine gültige E-Mail-Adresse sein.';

$txt['info_center_title'] = '%1$s - Infozentrum';

$txt['send_topic'] = 'Teilen';
$txt['unwatch'] = 'Nicht mehr beobachten';
$txt['watch'] = 'Beobachten';

$txt['allow_user_email'] = 'Benutzern erlauben, mir eine E-Mail zu senden';

$txt['check_all'] = 'Alle auswählen';

// Use numeric entities in the below string.
$txt['database_error'] = 'Datenbankfehler';
$txt['try_again'] = 'Bitte versuchen Sie es erneut.  Wenn Sie nochmals diesen Fehler sehen, melden Sie dies bitte einem Administrator.';
$txt['file'] = 'Datei';
$txt['line'] = 'Zeile';

// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'ElkArte hat einen Fehler in Ihrer Datenbank entdeckt und automatisch zu beheben versucht.  Wenn Sie weiterhin Probleme haben oder diese E-Mails erhalten, kontaktieren Sie bitte Ihren Serverbetreiber.';
$txt['database_error_versions'] = '<strong>Hinweis:</strong> Ihre Datenbankversion ist %1$s.';
$txt['template_parse_error'] = 'Vorlagenverarbeitungsfehler!';
$txt['template_parse_error_message'] = 'Anscheinend ist etwas mit dem Vorlagensystem nicht in Ordnung.  Dieses Problem sollte nur vorübergehend bestehen, kommen Sie also bitte später wieder und versuchen Sie es erneut.  Wenn Sie diese Nachricht weiterhin zu Gesicht bekommen, kontaktieren Sie bitte einen Administrator.<br /><br />Sie können auch versuchen, <a href="javascript:location.reload();">diese Seite neu zu laden</a>.';
$txt['template_parse_error_details'] = 'Ein Problem ist beim Laden der Vorlage oder Sprachdatei <span class="tt"><strong>%1$s</strong></span> aufgetreten.  Bitte überprüfen Sie die Syntax und versuchen Sie es erneut - denken Sie daran, dass einfache Anführungszeichen (<span class="tt">\'</span>) oft mit einem umgekehrten Schrägstrich (<span class="tt">\</span>) markiert werden müssen.  Um spezifischere Fehlerinformationen von PHP einzusehen, versuchen Sie <a href="%2$s%1$s">die Datei direkt zu öffnen</a>.<br /><br />Möglicherweise möchten Sie <a href="javascript:location.reload();">diese Seite neu laden</a> oder <a href="%3$s">das Standarddesign verwenden</a>.';
$txt['template_parse_undefined'] = 'Ein unbekannter Fehler ist bei der Verarbeitung dieser Vorlage aufgetreten';

$txt['today'] = 'Heute um %1$s';
$txt['yesterday'] = 'Gestern um %1$s';

// Relative times
$txt['rt_now'] = 'gerade eben';
$txt['rt_minute'] = 'Vor einer Minute';
$txt['rt_minutes'] = 'Vor %s Minuten';
$txt['rt_hour'] = 'Vor einer Stunde';
$txt['rt_hours'] = 'Vor %s Stunden';
$txt['rt_day'] = 'Gestern';
$txt['rt_days'] = 'Vor %s Tagen';
$txt['rt_week'] = 'Letzte Woche';
$txt['rt_weeks'] = 'Vor %s Wochen';
$txt['rt_month'] = 'Letzten Monat';
$txt['rt_months'] = 'Vor %s Monaten';
$txt['rt_year'] = 'Letztes Jahr';
$txt['rt_years'] = 'Vor %s Jahren';

$txt['new_poll'] = 'Neue Umfrage';
$txt['poll_question'] = 'Frage';
$txt['poll_question_options'] = 'Frage und Optionen';
$txt['poll_vote'] = 'Abstimmen';
$txt['poll_total_voters'] = 'Teilnehmer insgesamt';
$txt['draft_saved_on'] = 'Entwurf zuletzt gespeichert';
$txt['poll_results'] = 'Ergebnisse ansehen';
$txt['poll_lock'] = 'Abstimmung beenden';
$txt['poll_unlock'] = 'Abstimmung fortsetzen';
$txt['poll_edit'] = 'Umfrage ändern';
$txt['poll'] = 'Umfrage';
$txt['one_day'] = '1 Tag';
$txt['one_week'] = '1 Woche';
$txt['two_weeks'] = '2 Wochen';
$txt['one_month'] = '1 Monat';
$txt['two_months'] = '2 Monate';
$txt['forever'] = 'Für immer';
$txt['quick_login_dec'] = 'Mit Benutzername, Passwort und Sitzungslänge anmelden';
$txt['one_hour'] = '1 Stunde';
$txt['moved'] = 'VERSCHOBEN';
$txt['moved_why'] = 'Bitte geben Sie eine kurze Begründung ein,<br />warum dieses Thema verschoben wird.';
$txt['board'] = 'Forum';
$txt['in'] = 'in';
$txt['sticky_topic'] = 'Angeheftetes Thema';
$txt['split'] = 'AUFTEILEN';

$txt['delete'] = 'Lösche';

$txt['byte'] = 'B';
$txt['kilobyte'] = 'KiB';
$txt['megabyte'] = 'MB';
$txt['gigabyte'] = 'GB';

$txt['more_stats'] = '[Mehr Statistiken]';

$txt['code'] = 'Code';
$txt['code_select'] = '[Auswählen]';
$txt['quote_from'] = 'Zitat von';
$txt['quote'] = 'Zitat';
$txt['quick_quote'] = 'Quote Selected';
$txt['quote_new'] = 'Neues Thema';
$txt['follow_ups'] = 'Antworten';
$txt['topic_derived_from'] = 'Thema abgeleitet von %1$s';
$txt['edit'] = 'Ändern';
$txt['quick_edit'] = 'Schnell ändern';
$txt['post_options'] = 'More Options';
$txt['quote_expand'] = 'Show Quote';

$txt['set_sticky'] = 'Anheften';
$txt['set_nonsticky'] = 'Nicht mehr anheften';
$txt['set_lock'] = 'Sperren';
$txt['set_unlock'] = 'Entsperren';

$txt['search_advanced'] = 'Erweiterte Optionen anzeigen';
$txt['search_simple'] = 'Erweiterte Optionen verstecken';

$txt['security_risk'] = 'GROSSES SICHERHEITSRISIKO:';
$txt['not_removed'] = 'Sie haben %1$s nicht entfernt';
$txt['not_removed_extra'] = '%1$s ist eine Sicherungskopie von %2$s, die nicht von ElkArte erzeugt wurde. Sie kann direkt aufgerufen und verwendet werden, um vollen Zugriff auf das Forum zu erhalten. Sie sollten sie umgehend löschen.';
$txt['generic_warning'] = 'Warnung';
$txt['agreement_missing'] = 'You are requiring new users to accept a registration agreement, however the file (in sources/ElkArte/Languages/Agreement/) doesn\'t exist.';
$txt['agreement_accepted'] = 'You have just accepted the agreement.';
$txt['privacypolicy_accepted'] = 'You have just accepted the forum privacy policy.';

$txt['new_version_updates'] = 'Sie haben soeben aktualisiert!';
$txt['new_version_updates_text'] = '<a href="{admin_url};area=credits#latest_updates">Click here to see what\'s new in this version of ElkArte!</a>!';

$txt['cache_writable'] = 'Das Cacheverzeichnis ist nicht beschreibbar - dies wird sich negativ auf die Geschwindigkeit Ihres Forums auswirken.';

$txt['page_created_full'] = 'Page created in %1$.3f seconds with %2$d queries.';

$txt['report_to_mod_func'] = 'Use this function to inform the moderators and administrators of an abusive or wrongly posted message.';

$txt['online'] = 'Online';
$txt['member_is_online'] = '%1$s ist online';
$txt['offline'] = 'Offline';
$txt['member_is_offline'] = '%1$s ist offline';
$txt['pm_online'] = 'Private Nachricht (online)';
$txt['pm_offline'] = 'Private Nachricht (offline)';
$txt['status'] = 'Status';

$txt['skip_nav'] = 'Zum Hauptinhalt springen';
$txt['go_up'] = 'Nach oben';
$txt['go_down'] = 'Nach unten';

$forum_copyright = '<a href="https://www.elkarte.net" title="ElkArte Forum" target="_blank" class="new_win">Powered by %1$s</a> | <a href="{credits_url}" title="Credits" target="_blank" class="new_win" rel="nofollow">Credits</a>';

$txt['birthdays'] = 'Geburtstage:';
$txt['events'] = 'Ereignisse:';
$txt['birthdays_upcoming'] = 'Kommende Geburtstage:';
$txt['events_upcoming'] = 'Kommende Ereignisse:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Feiertage:';
$txt['calendar_month'] = 'Monat:';
$txt['calendar_year'] = 'Jahr:';
$txt['calendar_day'] = 'Tag:';
$txt['calendar_event_title'] = 'Ereignistitel';
$txt['calendar_event_options'] = 'Ereignisoptionen';
$txt['calendar_post_in'] = 'Post In:';
$txt['calendar_edit'] = 'Ereignis ändern';
$txt['event_delete_confirm'] = 'Dieses Ereignis löschen?';
$txt['event_delete'] = 'Ereignis löschen';
$txt['calendar_post_event'] = 'Ereignis veröffentlichen';
$txt['calendar'] = 'Kalender';
$txt['calendar_link'] = 'Mit Kalender verknüpfen';
$txt['calendar_upcoming'] = 'Kommender Kalender';
$txt['calendar_today'] = 'Heutiger Kalender';
$txt['calendar_week'] = 'Woche';
$txt['calendar_week_title'] = 'Woche %1$d von %2$d';
$txt['calendar_numb_days'] = 'Anzahl an Tagen:';
$txt['calendar_how_edit'] = 'wie ändert man diese Ereignisse?';
$txt['calendar_link_event'] = 'Ereignis mit Beitrag verknüpfen:';
$txt['calendar_confirm_delete'] = 'Sind Sie sich sicher, dass Sie dieses Ereignis löschen möchten?';
$txt['calendar_linked_events'] = 'Verknüpfte Ereignisse';
$txt['calendar_click_all'] = 'klicken Sie hier, um alle %1$s zu sehen';

$txt['moveTopic1'] = 'Eine Weiterleitung erstellen';
$txt['moveTopic2'] = 'Den Betreff dieses Themas ändern';
$txt['moveTopic3'] = 'Neuer Betreff';
$txt['moveTopic4'] = 'Den Betreff jeder Nachricht ändern';
$txt['move_topic_unapproved_js'] = 'Warnung! Dieses Thema wurde noch nicht freigeschaltet.\n\nEs wird nicht empfohlen, dass Sie eine Weiterleitung erstellen, sofern Sie nicht sofort danach den Beitrag freigeben möchten.';
$txt['movetopic_auto_board'] = '[BOARD]';
$txt['movetopic_auto_topic'] = '[TOPIC LINK]';
$txt['movetopic_default'] = 'This topic has been moved to [BOARD] - [TOPIC LINK]';
$txt['movetopic_redirect'] = 'Redirect to the moved topic';
$txt['movetopic_expires'] = 'Die Weiterleitung automatisch entfernen';

$txt['merge_to_topic_id'] = 'ID des Zielthemas';
$txt['split_topic'] = 'Aufteilen';
$txt['merge'] = 'Zusammenführen';
$txt['subject_new_topic'] = 'Betreff des neuen Themas';
$txt['split_this_post'] = 'Nur diesen Beitrag abtrennen.';
$txt['split_after_and_this_post'] = 'Thema ab diesem Beitrag aufteilen.';
$txt['select_split_posts'] = 'Beiträge zum Abtrennen auswählen.';

$txt['splittopic_notification'] = 'Eine Nachricht schreiben, wenn das Thema aufgeteilt wird';
$txt['splittopic_default'] = 'One or more of the messages of this topic have been moved to [BOARD] - [TOPIC LINK]';
$txt['splittopic_move'] = 'Move the new topic to another board';

$txt['new_topic'] = 'Neues Thema';
$txt['split_successful'] = 'Topic successfully split into two topics.';
$txt['origin_topic'] = 'Ursprungsthema';
$txt['please_select_split'] = 'Bitte wählen Sie die Beiträge aus, die Sie abtrennen möchten.';
$txt['merge_successful'] = 'Themen erfolgreich zusammengeführt.';
$txt['new_merged_topic'] = 'Neu zusammengeführtes Thema';
$txt['topic_to_merge'] = 'Zusammenzuführendes Thema';
$txt['target_board'] = 'Zielforum';
$txt['target_topic'] = 'Zielthema';
$txt['merge_confirm'] = 'Sind Sie sich sicher, dass Sie';
$txt['with'] = 'zusammenführen möchten mit';
$txt['merge_desc'] = 'Diese Funktion wird die Beiträge zweier Themen in ein Thema zusammenführen. Die Beiträge werden nach der Zeit ihrer Erstellung sortiert. Daher wird der zuerst erstellte Beitrag der erste Beitrag des zusammengeführten Themas sein.';

$txt['theme_template_error'] = 'Konnte die Vorlage \'%1$s\' nicht laden.';
$txt['theme_language_error'] = 'Konnte die Sprachdatei \'%1$s\' nicht laden.';

$txt['parent_boards'] = 'Unterforen';

$txt['smtp_no_connect'] = 'Konnte nicht mit dem SMTP-Host verbinden';
$txt['smtp_port_ssl'] = 'SMTP-Porteinstellung inkorrekt; sie sollte für SSL-Server 465 lauten.';
$txt['smtp_bad_response'] = 'Konnte Mailserverantwortcodes nicht erhalten';
$txt['smtp_error'] = 'Beim Versenden von Mails sind Probleme aufgetreten. Fehler: ';
$txt['mail_send_unable'] = 'Konnte keine Mail an die E-Mail-Adresse \'%1$s\' versenden';

$txt['mlist_search'] = 'Nach Mitgliedern suchen';
$txt['mlist_search_email'] = 'Search by email';
$txt['mlist_search_group'] = 'Nach Position suchen';
$txt['mlist_search_name'] = 'Nach Benutzername suchen';
$txt['mlist_search_website'] = 'Nach Website suchen';
$txt['mlist_search_results'] = 'Suchergebnisse für';
$txt['mlist_search_by'] = 'Nach %1$s suchen';

$txt['attach_downloaded'] = '%1$d-mal heruntergeladen';
$txt['attach_viewed'] = '%1$d-mal angesehen';

$txt['settings'] = 'Einstellungen';
$txt['never'] = 'Niemals';
$txt['more'] = 'mehr';

$txt['hostname'] = 'Hostname';
$txt['you_are_post_banned'] = 'Verzeihung, %1$s, Sie wurden vom Schreiben von Beiträgen und privaten Nachrichten in diesem Forum ausgeschlossen.';
$txt['ban_reason'] = 'Grund';

$txt['add_poll'] = 'Umfrage hinzufügen';
$txt['poll_options6'] = 'Sie können höchstens %1$s Optionen auswählen.';
$txt['poll_remove'] = 'Umfrage entfernen';
$txt['poll_remove_warn'] = 'Sind Sie sich sicher, dass Sie diese Umfrage aus dem Thema entfernen möchten?';
$txt['poll_results_expire'] = 'Die Ergebnisse werden erst angezeigt, wenn die Umfrage abgeschlossen ist';
$txt['poll_expires_on'] = 'Abstimmung läuft bis';
$txt['poll_expired_on'] = 'Abstimmung beendet am';
$txt['poll_change_vote'] = 'Stimme zurückziehen';
$txt['poll_return_vote'] = 'Abstimmungsoptionen';
$txt['poll_cannot_see'] = 'Sie können derzeit die Ergebnisse dieser Umfrage nicht einsehen.';

$txt['quick_mod_approve'] = 'Ausgewählte freigeben';
$txt['quick_mod_remove'] = 'Ausgewählte entfernen';
$txt['quick_mod_lock'] = 'Ausgewählte sperren/entsperren';
$txt['quick_mod_sticky'] = 'Ausgewählte anheften/nicht mehr anheften';
$txt['quick_mod_move'] = 'Ausgewählte verschieben nach';
$txt['quick_mod_merge'] = 'Ausgewählte zusammenführen';
$txt['quick_mod_markread'] = 'Ausgewählte als gelesen markieren';
$txt['quick_mod_go'] = 'Los';
$txt['quickmod_confirm'] = 'Sind Sie sich sicher, dass Sie dies tun möchten?';

$txt['quick_reply'] = 'Schnellantwort';
$txt['quick_reply_warning'] = 'Warnung! Dieses Thema ist zurzeit geschlossen, nur Administratoren und Moderatoren können antworten.';
$txt['quick_reply_verification'] = 'Nach der Übertragung werden Sie auf die normale Beitragsseite weitergeleitet, um Ihren Beitrag %1$s zu überprüfen.';
$txt['quick_reply_verification_guests'] = '(gilt für alle Gäste)';
$txt['quick_reply_verification_posts'] = '(gilt für alle Benutzer mit weniger als %1$s Beiträgen)';
$txt['wait_for_approval'] = 'Hinweis: Dieser Beitrag wird nicht angezeigt, bevor er von einem Moderator freigeschaltet worden ist.';

$txt['notification_enable_board'] = 'Sind Sie sich sicher, dass Sie die Benachrichtigung über neue Themen in diesem Forum aktivieren möchten?';
$txt['notification_disable_board'] = 'Sind Sie sich sicher, dass Sie die Benachrichtigung über neue Themen in diesem Forum deaktivieren möchten?';
$txt['notification_enable_topic'] = 'Sind Sie sich sicher, dass Sie die Benachrichtigung über neue Antworten in diesem Thema aktivieren möchten?';
$txt['notification_disable_topic'] = 'Sind Sie sich sicher, dass Sie die Benachrichtigung über neue Antworten in diesem Thema deaktivieren möchten?';

$txt['report_to_mod'] = 'Beitrag melden';
$txt['issue_warning'] = 'Issue a Warning';
$txt['issue_warning_post'] = 'Eine Verwarnung aufgrund dieses Beitrags aussprechen';

$txt['like_post'] = 'Gefällt mir';
$txt['unlike_post'] = 'Gefällt mir nicht mehr';
$txt['likes'] = 'gefällt\'s';
$txt['liked_by'] = 'Gefällt diesen Benutzern:';
$txt['liked_you'] = 'Ihnen';
$txt['liked_more'] = 'mehr';
$txt['likemsg_are_you_sure'] = 'Sie mögen diesen Beitrag bereits, sind Sie sich sicher, dass Sie dies rückgängig machen möchten?';

$txt['unread_topics_visit'] = 'Neue ungelesene Themen';
$txt['unread_topics_visit_none'] = 'Es wurden keine seit Ihrem letzten Besuch ungelesenen Themen gefunden. <a href="{unread_all_url}" class="linkbutton">Klicken Sie hier, um alle ungelesenen Themen anzuzeigen</a>';
$txt['unread_topics_all'] = 'Alle ungelesenen Themen';
$txt['unread_replies'] = 'Aktualisierte Themen';

$txt['who_title'] = 'Wer ist online';
$txt['who_and'] = ' und ';
$txt['who_viewing_topic'] = ' betrachten dieses Thema.';
$txt['who_viewing_board'] = ' betrachten dieses Forum.';
$txt['who_member'] = 'Mitglied';

// Current footer strings
$txt['valid_html'] = 'Gültiges HTML 5';
$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Gast';
$txt['guests'] = 'Gäste';
$txt['user'] = 'Benutzer';
$txt['users'] = 'Benutzer';
$txt['hidden'] = 'Versteckt';
// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Versteckt';
$txt['buddy'] = 'Freund';
$txt['buddies'] = 'Freunde';
$txt['most_online_ever'] = 'Bisher am meisten online';
$txt['most_online_today'] = 'Heute am meisten online';

$txt['merge_select_target_board'] = 'Wählen Sie das Zielforum des zusammengeführten Themas aus';
$txt['merge_select_poll'] = 'Wählen Sie aus, welche Umfrage das zusammengeführte Thema haben soll';
$txt['merge_topic_list'] = 'Wählen Sie die zusammenzuführenden Themen aus';
$txt['merge_select_subject'] = 'Wählen Sie den Betreff des zusammengeführten Themas aus';
$txt['merge_custom_subject'] = 'Eigener Betreff';
$txt['merge_enforce_subject'] = 'Den Betreff aller Beiträge ändern';
$txt['merge_include_notifications'] = 'Benachrichtigungen einschließen?';
$txt['merge_check'] = 'Zusammenführen?';
$txt['merge_no_poll'] = 'Keine Umfrage';

$txt['response_prefix'] = 'AW: ';
$txt['current_icon'] = 'Aktuelles Symbol';
$txt['message_icon'] = 'Nachrichtensymbol';

$txt['smileys_current'] = 'Aktueller Smileysatz';
$txt['smileys_none'] = 'Keine Smileys';
$txt['smileys_forum_board_default'] = 'Forumsstandard';

$txt['search_results'] = 'Suchergebnisse';

$txt['totalTimeLogged2'] = ' Tage, ';
$txt['totalTimeLogged3'] = ' Stunden und ';
$txt['totalTimeLogged4'] = ' Minutes.';
$txt['totalTimeLogged5'] = 'T ';
$txt['totalTimeLogged6'] = 'h ';
$txt['totalTimeLogged7'] = 'm';

$txt['approve_thereis'] = 'Es wartet'; //Deprecated
$txt['approve_thereare'] = 'Es warten'; //Deprecated
$txt['approve_member'] = 'ein Mitglied'; //Deprecated
$txt['approve_members'] = 'Mitglieder'; //Deprecated
$txt['approve_members_waiting'] = 'auf Freischaltung.'; //Deprecated
$txt['approve_one_member_waiting'] = 'There is <a href="%1$s">one member</a> awaiting approval.';
$txt['approve_many_members_waiting'] = 'There are <a href="%1$s">%2$d members</a> awaiting approval.';

$txt['notifyboard_turnon'] = 'Möchten Sie eine Benachrichtigungsmail erhalten, wenn jemand ein neues Thema in diesem Forum erstellt?';
$txt['notifyboard_turnoff'] = 'Sind Sie sich sicher, dass Sie keine Benachrichtigungsmails bei neuen Themen in diesem Forum mehr erhalten möchten?';

$txt['notify_unsubscribed_generic'] = 'specified';
$txt['notify_board_unsubscribed'] = 'The email, %2$s, has been successfully unsubscribed and will no longer be sent notifications from the %1$s board.';
$txt['notify_topic_unsubscribed'] = 'The email, %2$s, has been successfully unsubscribed and will no longer be sent notifications on the %1$s topic.';
$txt['notify_mention_unsubscribed'] = 'The email, %2$s, has been successfully unsubscribed and will no longer be sent "%1$s" notifications.';
$txt['notify_default_unsubscribed'] = 'Your request has been successfully processed.';

$txt['find_members'] = 'Mitglieder suchen';
$txt['find_username'] = 'Name, Benutzername oder E-Mail-Adresse';
$txt['find_buddies'] = 'Nur Freunde anzeigen?';
$txt['find_wildcards'] = 'Erlaubte Platzhalter: *, ?';
$txt['find_no_results'] = 'Nichts gefunden';
$txt['all_caught_up'] = 'Your all caught up!';
$txt['find_results'] = 'Ergebnisse';
$txt['find_close'] = 'Schließen';

$txt['quickmod_delete_selected'] = 'Ausgewählte entfernen';
$txt['quickmod_split_selected'] = 'Ausgewählte aufteilen';

$txt['show_personal_messages_heading'] = 'Neue Nachrichten';
$txt['show_personal_messages'] = 'You have <strong>%1$s</strong> unread personal messages in your inbox.<br /><br /><a href="%2$s">Go to your inbox</a>';

$txt['help_popup'] = 'Sie wissen nicht weiter? Lassen Sie mich erklären:';

$txt['previous_next_back'] = 'vorheriges Thema';
$txt['previous_next_forward'] = 'nächstes Thema';

$txt['upshrink_description'] = 'Die Kopfzeile ein- oder ausklappen.';

$txt['mark_unread'] = 'Als ungelesen markieren';

$txt['ssi_not_direct'] = 'Bitte greifen Sie nicht per URL direkt auf SSI.php zu; Sie sollten den Pfad (%1$s) verwenden oder ?ssi_function=irgendwas hinzufügen.';
$txt['ssi_session_broken'] = 'SSI.php konnte keine Sitzung laden!  Dies könnte Probleme beim Abmelden und anderen Funktionen verursachen - bitte stellen Sie sicher, dass SSI.php in all Ihren Scripts vor *irgendetwas* anderem eingebunden wird!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Beitragsvorschau';
$txt['preview_fetch'] = 'Hole Vorschau...';
$txt['pm_error_while_submitting'] = 'Folgende Fehler traten beim Versand dieser privaten Nachricht auf:';
$txt['warning_while_submitting'] = 'Etwas ist geschehen, und zwar:';
$txt['error_while_submitting'] = 'Die Nachricht hat folgende Fehler, die vor dem Versand korrigiert werden müssen:';
$txt['error_old_topic'] = 'Warnung: In diesem Thema wurde seit %1$d Tagen nichts geschrieben.<br />Falls Sie sich nicht sicher sind, ob Sie hier antworten müssen, ziehen Sie bitte in Erwägung, ein neues Thema zu eröffnen.';

$txt['split_selected_posts'] = 'Ausgewählte Beiträge';
$txt['split_selected_posts_desc'] = 'Unten stehende Beiträge werden nach der Aufteilung ein neues Thema bilden.';
$txt['split_reset_selection'] = 'Auswahl zurücksetzen';

$txt['modify_cancel'] = 'Abbrechen';
$txt['mark_read_short'] = 'Als gelesen markieren';

$txt['hello_member_ndt'] = 'Hallo';

$txt['unapproved_posts'] = 'Nicht freigeschaltete Beiträge (Themen: %1$d, Beiträge: %2$d)';

$txt['ajax_in_progress'] = 'Lade...';
$txt['ajax_bad_response'] = 'Invalid response.';

$txt['mod_reports_waiting'] = 'Derzeit gibt es %1$s offene Moderationsberichte.';
$txt['pm_reports_waiting'] = 'There are currently %1$d personal message reports open.';

$txt['new_posts_in_category'] = 'Click to see the new posts in %1$s';
$txt['verification'] = 'Verifikation';
$txt['visual_verification_hidden'] = 'Bitte lassen Sie dieses Feld leer';
$txt['visual_verification_description'] = 'Geben Sie die Buchstaben im Bild ein';
$txt['visual_verification_request_new'] = 'Ein anderes Bild anfordern';

// @todo Send email strings - should move?
$txt['send_email'] = 'E-Mail senden';
$txt['send_email_disclosed'] = 'Beachten Sie, dass dies für den Empfänger sichtbar sein wird.';
$txt['send_email_subject'] = 'E-Mail-Betreff';

$txt['ignoring_user'] = 'Sie ignorieren diesen Benutzer.';
$txt['show_ignore_user_post'] = '<em>[Zeig\' mir den Beitrag.]</em>';

$txt['spider'] = 'Suchmaschine';
$txt['spiders'] = 'Suchmaschinen';

$txt['downloads'] = 'Downloads';
$txt['filesize'] = 'Dateigröße';

// Restore topic
$txt['restore_topic'] = 'Thema wiederherstellen';
$txt['restore_message'] = 'Wiederherstellen';
$txt['quick_mod_restore'] = 'Ausgewählte wiederherstellen';

// Editor prompt.
$txt['prompt_text_email'] = 'Bitte geben Sie die E-Mail-Adresse ein.';
$txt['prompt_text_ftp'] = 'Bitte geben Sie die FTP-Adresse ein.';
$txt['prompt_text_url'] = 'Bitte geben Sie den URL ein, auf den Sie verweisen möchten.';
$txt['prompt_text_img'] = 'Geben Sie den Ort des Bildes ein';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Element löschen';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Vorlagen: ';
$txt['debug_sub_templates'] = 'Untervorlagen: ';
$txt['debug_language_files'] = 'Sprachdateien: ';
$txt['debug_sheets'] = 'Stylesheets: ';
$txt['debug_javascript'] = 'Scripts: ';
$txt['debug_files_included'] = 'Eingebundene Dateien: ';
$txt['debug_kb'] = 'KB.';
$txt['debug_show'] = 'zeigen';
$txt['debug_cache_hits'] = 'Cachetreffer: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s Byte';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss für %2$s Byte';
$txt['debug_queries_used'] = 'Verwendete Abfragen: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Verwendete Abfragen: %1$d, %2$d Warnungen.';
$txt['debug_query_in_line'] = 'in <em>%1$s</em> line <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'was %1$s Sekunden dauerte.';
$txt['debug_query_which_took_at'] = 'which took %1$s seconds at %2$s into request.';
$txt['debug_show_queries'] = '[Abfragen zeigen]';
$txt['debug_hide_queries'] = '[Abfragen verstecken]';
$txt['debug_tokens'] = 'Token: ';
$txt['debug_browser'] = 'Browserkennung: ';
$txt['debug_hooks'] = 'Aufgerufene Einschubmethoden: ';
$txt['debug_system_type'] = 'System: ';
$txt['debug_server_load'] = 'Serverlast: ';
$txt['debug_script_mem_load'] = 'Skriptspeicherbelegung: ';
$txt['debug_script_cpu_load'] = 'Skript-CPU-Zeit (Benutzer/System): ';

// Video embedding
$txt['preview_image'] = 'Videovorschaubild';
$txt['ctp_video'] = 'Click to play video';
$txt['hide_video'] = 'Video anzeigen/verstecken';
$txt['youtube'] = 'YouTube:';
$txt['vimeo'] = 'Vimeo:';
$txt['dailymotion'] = 'Dailymotion:';
$txt['tiktok'] = 'TikTok:';
$txt['twitter'] = 'X/Twitter:';
$txt['facebook'] = 'Facebook:';
$txt['instagram'] = 'Instagram:';

// Spoiler BBC
$txt['spoiler'] = 'Spoiler (klicken zum Umschalten)';

$txt['ok_uppercase'] = 'OK';

// Title of box for warnings that admins should see
$txt['admin_warning_title'] = 'Warnung';

$txt['via'] = 'via';

$txt['like_post_stats'] = 'Like stats';

$txt['otp_token'] = 'One-time Password';
$txt['otp_enabled'] = 'Enable two factor authentication';
$txt['invalid_otptoken'] = 'Time-based One-time Password is invalid';
$txt['otp_used'] = 'Time-based One-time Password already used.<br /> Please wait a moment and use the next code.';
$txt['otp_generate'] = 'Generate';
$txt['otp_show_qr'] = 'Show QR-Code';

$txt['other'] = 'Andere';

$txt['offline'] = 'Offline';
$txt['retry'] = 'RETRY';
$txt['check_connection'] = 'Please check your internet connection';
