<?php
// Version: 2.0; MaillistTemplates

// Do not translate anything that is between {}, they are used as replacement variables and MUST
// remain exactly how they are.
// Additionally do not translate the @additional_params: line or the variable names in the lines that follow it.  You may
// translate the description of the variable.
// Do not translate @description:, however you may translate the rest of that line.

/*
	@additional_params: pbe_notify_boards_once_body
		FORUMURL: The url to the forum
		FORUMNAMESHORT: Short or nickname for the forum
		BOARDNAME: Name of the board the post was made in
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		SIGNATURE: The signature of the member who made the post
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
		EMAILREGARDS: The site name signature
	@description: A member wants to be notified of new topics on a board they are watching
*/
$txt['pbe_notify_boards_once_body_subject'] = '[{FORUMNAMESHORT}] {TOPICSUBJECT}';
$txt['pbe_notify_boards_once_body_body'] = 'Ein neues Thema, \'{TOPICSUBJECT}\', wurde in \'{BOARDNAME}\' gestartet.

{MESSAGE}

{SIGNATURE}


------------------------------------
Posting-Information:
Es können weitere Themen gepostet werden, aber Sie erhalten keine weiteren E-Mail-Benachrichtigungen (zu diesem Thema), bis Sie zum Forum zurückkehren und einige davon lesen.
Sie können auf diese E-Mail antworten und sie als Themenantwort posten.

{FORUMNAMESHORT} Links:

<*> Um {FORUMNAMESHORT} zu besuchen, gehen Sie zu:
    {FORUMURL}

<*> Sie können diese Nachricht sehen, indem Sie diesen Link verwenden:
    {TOPICLINK}

<*> Abmelden von diesem {SUBSCRIPTION} können Sie über diesen Link:
    {UNSUBSCRIBELINK}

{EMAILREGARDS}';

/*
	@additional_params: pbe_notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
		FORUMURL: The url to the forum
		FORUMNAMESHORT: Short or nickname for the forum
		BOARDNAME: Name of the board the post was made in
		SIGNATURE: The signature of the member who made the post
		EMAILREGARDS: The site name signature
	@description: A new topic has been started in a subscribed board, includes the topic body
*/
$txt['pbe_notify_boards_body_subject'] = '[{FORUMNAMESHORT}] {TOPICSUBJECT}';
$txt['pbe_notify_boards_body_body'] = '
{MESSAGE}

{SIGNATURE}


------------------------------------
Posting-Information:
{POSTERNAME} hat ein neues Thema \'{TOPICSUBJECT}\' im \'{BOARDNAME}\' Forum gestartet.
Sie können auf diese E-Mail antworten und sie als Antwort posten.

{FORUMNAMESHORT} Links:

<*> Um {FORUMNAMESHORT} zu besuchen, gehen Sie zu:
    {FORUMURL}

<*> Sie können diese Nachricht sehen, indem Sie diesen Link verwenden:
    {TOPICLINK}

<*> Sie können zu Ihrer ersten ungelesenen Nachricht gehen, indem Sie diesen Link verwenden:
    {TOPICLINKNEW}

<*> Abmelden von diesem {SUBSCRIPTION} können Sie über diesen Link:
    {UNSUBSCRIBELINK}

{EMAILREGARDS}';

/*
	@additional_params: pbe_notification_reply_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
		FORUMURL: The url to the forum
		FORUMNAMESHORT: Short or nickname for the forum
		BOARDNAME: Name of the board the post was made in
		SIGNATURE: The signature of the member who made the post
		EMAILREGARDS: The site name signature
	@description: A reply has been made to a topic in a subscribed board, includes the reply body
*/
$txt['pbe_notification_reply_body_subject'] = 'Aw: [{FORUMNAMESHORT}] {TOPICSUBJECT}';
$txt['pbe_notification_reply_body_body'] = '
{MESSAGE}

{SIGNATURE}


------------------------------------
Posting-Information:
{POSTERNAME} hat auf das Thema \'{TOPICSUBJECT}\' im \'{BOARDNAME}\' Forum geantwortet.
Sie können auf diese E-Mail antworten und sie als Themenantwort posten.

{FORUMNAMESHORT} Links:

<*> Um {FORUMNAMESHORT} zu besuchen, gehen Sie zu:
    {FORUMURL}

<*> Sie können diese Nachricht sehen, indem Sie diesen Link verwenden:
    {TOPICLINK}

<*> Sie können zu Ihrer ersten ungelesenen Nachricht gehen, indem Sie diesen Link verwenden:
    {TOPICLINKNEW}

<*> Abmelden von diesem {SUBSCRIPTION} können Sie über diesen Link:
    {UNSUBSCRIBELINK}

{EMAILREGARDS}';

/**
	@additional_params: pbe_notification_reply
	@description: when a topic reply gets approved
 */
$txt['pbe_notification_reply_once_subject'] = $txt['pbe_notification_reply_body_subject'];
$txt['pbe_notification_reply_once_body'] = $txt['pbe_notification_reply_body_body'];

/*
	@additional_params: pbe_notification_reply_body_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
		FORUMURL: The url to the forum
		FORUMNAMESHORT: Short or nickname for the forum
		BOARDNAME: Name of the board the post was made in
		SIGNATURE: The signature of the member who made the post
		EMAILREGARDS: The site name signature
	@description: Full body email notification for the first new reply in a topic
*/
$txt['pbe_notification_reply_body_once_subject'] = 'Aw: [{FORUMNAMESHORT}] {TOPICSUBJECT}';
$txt['pbe_notification_reply_body_once_body'] = '
{MESSAGE}

{SIGNATURE}


------------------------------------
Posting-Information:
{POSTERNAME} hat auf das Thema \'{TOPICSUBJECT}\' im \'{BOARDNAME}\' Forum geantwortet.
Es können weitere Antworten gepostet werden, aber Sie erhalten keine weiteren Benachrichtigungen, bis Sie das Thema gelesen haben.
Sie können auf diese E-Mail antworten und sie als Antwort posten.

{FORUMNAMESHORT} Links:

<*> Um {FORUMNAMESHORT} zu besuchen, gehen Sie zu:
    {FORUMURL}

<*> Sie können diese Nachricht sehen, indem Sie diesen Link verwenden:
    {TOPICLINK}

<*> Sie können zu Ihrer ersten ungelesenen Nachricht gehen, indem Sie diesen Link verwenden:
    {TOPICLINKNEW}

<*> Abmelden von diesem {SUBSCRIPTION} können Sie über diesen Link:
    {UNSUBSCRIBELINK}

{EMAILREGARDS}';

/**
	@additional_params: pbe_notification_reply_once
	@description: New reply due to it being approved
 */
$txt['pbe_notification_reply_once_subject'] = $txt['pbe_notification_reply_body_once_subject'];
$txt['pbe_notification_reply_once_body'] = $txt['pbe_notification_reply_body_once_body'];

/*
	@additional_params: pbe_new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The username for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		FORUMNAMESHORT: Short or nickname for the forum
	@description: A notification email sent to the receivers of a personal message
*/
$txt['pbe_new_pm_body_subject'] = 'Neue Private Mitteilung: {SUBJECT}';
$txt['pbe_new_pm_body_body'] = 'Du hast eine Private Mitteilung von {SENDER} im Forum {FORUMNAMESHORT} erhalten.

Die Nachricht lautet:

{MESSAGE}

------------------------------------
Hinweis:
Du kannst auf diese E-Mail direkt antworten und {SENDER} so eine Antwort schicken.

{FORUMNAMESHORT} Links:

<*> Um {FORUMNAMESHORT} zu besuchen, klicke auf:
    {FORUMURL}

<*> Um zu antworten, klicke auf:
    {REPLYLINK}

{EMAILREGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['pbe_new_pm_body_tolist_subject'] = 'Neue Private Mitteilung: {SUBJECT}';
$txt['pbe_new_pm_body_tolist_body'] = '{TOLIST} wurde eine Private Mitteilung von {SENDER} im Forum {FORUMNAME} gesendet.

Die Nachricht lautet:

{MESSAGE}

------------------------------------
{FORUMNAMESHORT} Links:

<*> Um {FORUMNAMESHORT} zu besuchen, klicke auf:
    {FORUMURL}

<*> Um zu antworten, klicke auf:
    {REPLYLINK}

{EMAILREGARDS}';
