<?php
// Version: 2.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
// Additionally do not translate the @additional_params: line or the variable names in the lines that follow it.  You may
// translate the description of the variable.  Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

$txt['scheduled_approval_email_topic'] = 'The following topics are awaiting approval:';
$txt['scheduled_approval_email_msg'] = 'The following posts are awaiting approval:';
$txt['scheduled_approval_email_attach'] = 'The following attachments are awaiting approval:';
$txt['scheduled_approval_email_event'] = 'The following events are awaiting approval:';

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Benvenuti su {FORUMNAME}';
$txt['resend_activate_message_body'] = ' Grazie per esserti registrato a {FORUMNAME}. Il tuo Nome Utente è {USERNAME}. Se hai dimenticato la password, puoi cambiarla visitando {FORGOTPASSWORDLINK}

Prima di eseguire il login, devi attivare l\'account seguendo il seguente link:

{ACTIVATIONLINK}

Se hai qualsiasi problema con l\'attivazione, visita {ACTIVATIONLINKWITHOUTCODE}e inserisci il codice "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Benvenuti su {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Salve {REALNAME}, la tua richiesta di registrazione su {FORUMNAME} è stata ricevuta.
Ti sei registrato con l\'username {USERNAME}.

Prima di effettuare il login ed usare il forum, la tua richiesta dovrà essere approvata. Quando ciò accadrà, riceverai una e-mail da questo indirizzo.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Gruppo di Appartenenza Approvato';
$txt['mc_group_approve_body'] = '{USERNAME},

Vogliamo notificarti che la tua richiesta per iscriverti al gruppo "{GROUPNAME}" del forum {FORUMANE} è stata accettata e il tuo account è stato spostato nel nuovo gruppo.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Gruppo di Appartenenza: Respinti';
$txt['mc_group_reject_body'] = '{USERNAME},

siamo spiacenti di notificarti che la tua richiesta per iscriverti al gruppo "{GROUPNAME}" del forum {FORUMNAME} è stata rifiutata.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Gruppo di Appartenenza: Respinti';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

siamo spiacenti di notificarti che la tua richiesta per iscriverti al gruppo "{GROUPNAME}" del forum {FORUMNAME} è stata rifiutata per il seguente motivo:
{REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Benvenuti su {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Benvenuto, {NAME}

Il tuo account è stato attivato dall\'amministratore e ora puoi accedere e postare. Il tuo Nome Utente è: {USERNAME}. I Se hai dimenticato la password, puoi cambiarla visitando {FORGOTPASSWORDLINK}

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Benvenuti su {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Benvenuto, {USERNAME}!

Il tuo account su {FORUMNAME} è stato approvato dall\'amministratore. Prima di effettuare il login, devi attivare l\'account visitando il seguente link:
{ACTIVATIONLINK}

Se hai qualsiasi problema con l\'attivazione, visita {ACTIVATIONLINKWITHOUTCODE} e inserisci il codice "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Registrazione rifiutata';
$txt['admin_approve_reject_body'] = '{USERNAME},⏎
⏎
Purtroppo, la tua richesta di iscrizione a {FORUMNAME} è stata respinta.⏎
⏎
{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Account eliminato';
$txt['admin_approve_delete_body'] = '
{USERNAME},⏎
⏎
Il tuo account su {FORUMNAME} è stato cancellato. Probabilmente non hai mai completato l\'attivazione, in tal caso puoi effettuare nuovamente la registrazione.⏎
⏎
{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Promemoria di Registrazione';
$txt['admin_approve_remind_body'] = '{USERNAME},⏎
Il tuo account su {FORUMNAME} non è stato ancora attivato.⏎
⏎
Termina l\'attivazione cliccando sul seguente link:⏎
{ACTIVATIONLINK}⏎
⏎
Se avessi problemi a terminare l\'attivazione, puoi usare il seguente metodo alternativo {ACTIVATIONLINKWITHOUTCODE} ed inserire di seguito il codice "{ACTIVATIONCODE}".⏎
⏎
{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Benvenuti su {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Grazie per esserti registrato su {FORUMNAME}. Il tuo Nome Utente è {USERNAME} e la tua password è {PASSWORD}.

Prima di effettuare il login, devi attivare l\'account visitando il seguente link:
{ACTIVATIONLINK}

Se hai qualsiasi problema con l\'attivazione, visita {ACTIVATIONLINKWITHOUTCODE} e inserisci il codice "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Benvenuti su {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Grazie per esserti registrato su {FORUMNAME}. Il tuo Nome Utente è: {USERNAME} mentre la tua password è: {PASSWORD}.⏎
⏎
{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
	@description:
*/
$txt['new_announcement_subject'] = 'Nuovo Annuncio: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}⏎
⏎
Per rimuovere l\'iscrizione da questi annunci, effettua il Login e spunta "Ricevi aggiornamenti dal forum e notifiche importanti via mail." nel tuo profilo.⏎
⏎
Puoi vedere l\'annuncio completo a questo link:⏎
{TOPICLINK}⏎
⏎
{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Nuovo Topic: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Un nuovo topic, \'{TOPICSUBJECT}\', è stato aperto nella sezione che stai visitando.⏎
⏎
Puoi vederlo al collegamento⏎
{TOPICLINK}⏎
⏎
Altri topic verranno aperti, ma non riceverai ulteriori notifiche email finchè non tornerai nella sezione e ne leggerai alcuni.⏎
⏎
Il testo dei topic è mostrato qui:⏎
{MESSAGE}⏎
⏎
Disattiva la notifica ai nuovi topic di questa sezione con il seguente collegamento:⏎
{UNSUBSCRIBELINK}⏎
⏎
{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Nuovo Topic: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Un nuovo topic, \'{TOPICSUBJECT}\', è stato creato nella sezione che osservi.

Puoi leggerlo al link:
{TOPICLINK}

Altri topic verranno creati, ma non sarai notificato riguardo ad essi finchè non tornerai sul forum a leggerne alcuni.

Puoi disattivare l\'iscrizione ai nuovi topic della sezione dal seguente link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Nuovo Topic: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Un nuovo topic, \'{TOPICSUBJECT}\', è stato creato nella sezione che osservi.

Puoi leggerlo al link:
{TOPICLINK}

Il testo del topic è riportato di seguito:
{MESSAGE}

Puoi disattivare l\'iscrizione ai nuovi topic della sezione dal seguente link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Nuovo Topic: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Un nuovo topic, \'{TOPICSUBJECT}\', è stato creato nella sezione che osservi.

Puoi lggerlo al link:
{TOPICLINK}

Puoi disattivare l\'iscrizione ai nuovi topic della sezione dal seguente link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Richiesta di iscrizione ad\'un gruppo';
$txt['request_membership_body'] = '{RECPNAME},

{APPYNAME} ha richiesto di essere membro del gruppo "{GROUPNAME}". L\'utente ha dato la seguente motivazione:

{REASON}

Puoi approvare o respingere la richiesta dal link seguente:

{MODLINK}

{REGARDS}';

/**
	@additional_params: scheduled_approval
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'L\'abbonamento sta per scadere su {FORUMNAME}';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Un\'iscrizione di {FORUMNAME} sta per scadere. Se quando ti sei scritto hai abilitato la re-iscrizione automatica, non hai bisogno di fare nulla - altrimenti pensa se vuoi effettuare nuovamente l\'iscrizione. Qui trovi i dettagli dell\'iscrizione:

Nome: {SUBSCRIPTION}
Scadenza: {END_DATE}

Per modificare le tue iscrizioni visita il tuo profilo:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The url link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Bentornato su {FORUMNAME}';
$txt['activate_reactivate_body'] = 'Per riconvalidare il tuo indirizzo email, il tuo account è stato temporaneamente disattivato. Clicca sul link seguente per riattivarlo:
{ACTIVATIONLINK}

In caso di problemi con l\'attivazione, per favore visita {ACTIVATIONLINKWITHOUTCODE} ed usa ul codice "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'La nuova password per {FORUMNAME}';
$txt['forgot_password_body'] = 'Gentile {REALNAME},

Questa email è stata inviata perché hai usato la funzione \'Password dimenticata\'. Per impostare una nuova password, clicca il seguente link:
{REMINDLINK}

IP: {IP}
Username: {MEMBERNAME}

Se non desideri reimpostare la password o se non hai richiesto tale modifica, puoi ignorare questa email. Nessun altro utente può modificare la tua password. La tua privacy e la sicurezza del tuo account non possono essere compromesse da questa email.

{REGARDS}';

/**
	@additional_params: scheduled_approval
		REALNAME: The real (display) name of the person receiving the email.
		BODY: The generated body of the mail.
	@description:
*/
$txt['scheduled_approval_subject'] = 'Summary of posts awaiting approval at {FORUMNAME}';
$txt['scheduled_approval_body'] = '{REALNAME},

This email contains a summary of all items awaiting approval at {FORUMNAME}.

{BODY}

Please log in to the forum to review these items.
{SCRIPTURL}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The report post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The url of the post that is being reported.
		REPORTLINK: The url of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Post segnalato: {TOPICSUBJECT} by {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Il seguente post, "{TOPICSUBJECT}" di {POSTERNAME} è stato segnalato da {REPORTERNAME} nella sezione che moderi:

Il topic: {TOPICLINK}
Centro moderazione: {REPORTLINK}

Chi ha segnalato ha fornito l seguente commento:
{COMMENT}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Dettagli della nuova password';
$txt['change_password_body'] = 'Caro {USERNAME},

I tuoi dettagli di Login su {FORUMNAME} sono stati modificati e la tua password resettata. Di seguito trovi i nuovi dettagli per il Login.

Il tuo nome utente è "{USERNAME}" e la tua Password è "{PASSWORD}".

Puoi modificarli dopo aver effettuato il Login dalla pagina del tuo profilo, oppure cliccando il seguente link:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The url link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Benvenuti su {FORUMNAME}';
$txt['register_activate_body'] = 'Grazie per esserti registrato su {FORUMNAME}. Il tuo Username è {USERNAME}. Se dimentichi la Password puoi resettarla cliccando il seguente link {FORGOTPASSWORDLINK}

Prima di poter effettuare il Login, devi attivare il tuo account. Per farlo clicca sul seguente link:

{ACTIVATIONLINK}

Se dovessi avere problemi con l\'attivazione, visita {ACTIVATIONLINKWITHOUTCODE} ued usa il codice: "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The url link to the coppa form.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Benvenuti su {FORUMNAME}';
$txt['register_coppa_body'] = 'Grazie per esserti registrato su {FORUMNAME}. Il tuo nome utente è {USERNAME}. Se dimenticherai la password puoi cambiarla cliccando {FORGOTPASSWORDLINK}

Prima di poter accedere, l\'amministratore richiede il consenso di un parente o tutore. Puoi saperne di più cliccando al seguente link:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Benvenuti su {FORUMNAME}';
$txt['register_immediate_body'] = ' Grazie per esserti registrato su {FORUMNAME}. Il tuo Nome Utente è {USERNAME}.Se hai dimenticato la password, puoi cambiarla visitando {FORGOTPASSWORDLINK}

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Benvenuti su {FORUMNAME}';
$txt['register_pending_body'] = 'Ciao {REALNAME}, la tua richiesta di registrazione su {FORUMNAME} è stata ricevuta.

Sei registrato con il nome utente {USERNAME}. Se dimentichi la password, puoi cambiarla visitando {FORGOTPASSWORDLINK}

Prima di collegarti e navigare nel forum, la tua richiesta deve essere approvata. Quando ciò avverrà verrai avvisato con un\'altra mail a questo indirizzo

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Risposta al topic: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Una risposta è stata aggiunta al topic che stavi consultando da {POSTERNAME}.

Leggi la risposta cliccando: {TOPICLINK}

Disattiva le notifiche di questo topic cliccando: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Risposta al topic: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'Una risposta è stata inserita da {POSTERNAME} nel topic che stai seguendo.

Visualizza la risposta: {TOPICLINK}

Puoi disattivare le notifiche per questo topic cliccando sul seguente collegamento: {UNSUBSCRIBELINK}

Il testo del messaggio è riportato qui sotto:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Risposta al topic: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'Una risposta è stata inserita da {POSTERNAME} nel topic che stai seguendo.

Visualizza la risposta: {TOPICLINK}

Disattiva le notifiche di questo topic cliccando: {UNSUBSCRIBELINK}

Altri messaggi potrebbero essere inseriti, ma non riceverai ulteriori notifiche finché non leggerai il topic.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Risposta al topic: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'Una risposta è stata inserita da {POSTERNAME} nel topic che stai seguendo.

Visualizza la risposta: {TOPICLINK}

Puoi disattivare le notifiche per questo topic cliccando sul seguente collegamento: {UNSUBSCRIBELINK}

Il testo del messaggio è riportato qui sotto:
{MESSAGE}

Altri messaggi potrebbero essere inseriti, ma non riceverai ulteriori notifiche finché non leggerai il topic.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Topic evidenziato: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Un topic che stai seguendo è stato evidenziato da {POSTERNAME}.

Visualizza il topic: {TOPICLINK}

Puoi disattivare le notifiche per questo topic cliccando sul seguente collegamento: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Topic chiuso: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Un topic che stai seguendo è stato chiuso da {POSTERNAME}.

Visualizza il topic: {TOPICLINK}

Puoi disattivare le notifiche per questo topic cliccando sul seguente collegamento: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Topic riaperto: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Un topic che stai seguendo è stato riaperto da {POSTERNAME}.

Visualizza il topic: {TOPICLINK}

Puoi disattivare le notifiche per questo topic cliccando sul seguente collegamento: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Topic rimosso: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Un topic che stai seguendo è stato rimosso da {POSTERNAME}.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Topic spostato: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Un topic che stai seguendo è stato spostato da {POSTERNAME} in un altra sezione.

Visualizza il topic: {TOPICLINK}

Puoi disattivare le notifiche per questo topic cliccando sul seguente collegamento: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Topic unito: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Un topic che stai seguendo è stato unito ad\'un altro topic da {POSTERNAME}.

Visualizza il topic: {TOPICLINK}

Puoi disattivare le notifiche per questo topic cliccando sul seguente collegamento: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Topic diviso: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Un topic che stai seguendo è stato diviso in uno o più topic da {POSTERNAME}.

Visualizza quello che è rimasto di questo topic: {TOPICLINK}

Puoi disattivare le notifiche per questo topic cliccando sul seguente collegamento: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Un nuovo utente si è iscritto';
$txt['admin_notify_body'] = '{USERNAME} ha appena effettuato la registrazione nel tuo forum. Clicca sul collegamento seguente per visualizzare il suo profilo.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Un nuovo utente si è iscritto';
$txt['admin_notify_approval_body'] = '{USERNAME} ha appena effettuato la registrazione nel tuo forum. Clicca sul collegamento seguente per visualizzare il suo profilo.
{PROFILELINK}

Prima che questo utente possa inserire posts deve avere l\'account approvato. Clicca  sul collegamento seguente per visualizzare la pagina di approvazione.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Urgente! La cartella degli allegati è quasi piena';
$txt['admin_attachments_full_body'] = '{REALNAME},

La cartella degli allegati su {FORUMNAME} è quasi piena. Si prega di visitare il forum per risolvere il problema.

Quando la cartella degli allegati raggiunge la dimensione massima consentita gli utenti non potranno continuare a postare allegati o caricare avatars personali (se abilitati).

{REGARDS}';

/**
	@additional_params: admin_backup_database
		BAK_REALNAME: the name of the user doing the backup
	@description:
*/
$txt['admin_backup_database_subject'] = 'Un backup del database è stato creato';
$txt['admin_backup_database_body'] = '{REALNAME},

La presente email è per avvisarti che {BAK_REALNAME} ha appena scaricato un backup del database su {FORUMNAME}.

{REGARDS}';

/**
	@additional_params: editing_theme
		EDIT_REALNAME: the name of the user doing the backup
		FILE_EDITED: the name of the file being modified
		THEME_NAME: the name of the theme
	@description:
*/
$txt['editing_theme_subject'] = 'Modifica di un template';
$txt['editing_theme_body'] = '{REALNAME},

la presente email è per avvisarti che {EDIT_REALNAME} sta per modificare il file:
{FILE_EDITED}
del template {THEME_NAME} su {FORUMNAME}.

Se sai che questo non dovrebbe succedere ti consigliamo di indagare l\'evento.

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Rimborso Sottoscrizione Pagata';
$txt['paid_subscription_refund_body'] = '{REALNAME},

Un membro ha ricevuto il rimborso per una sottoscrizione pagata. Di seguito i dettagli della sottoscrizione:

	Sottoscrizione: {NAME}
	Nome utente: {REFUNDNAME} ({REFUNDUSER})
	Data: {DATE}

Puoi vedere il profilo di questo membro cliccando sul link seguente:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Nuova Sottoscrizione Pagata';
$txt['paid_subscription_new_body'] = '{REALNAME},

Un membro si è abbonato ad una nuova sottoscrizione pagata. Di seguito i dettagli della sottoscrizione:

	Sottoscrizione: {NAME}
	Nome Utente: {SUBNAME} ({SUBUSER})
	Email Utente: {SUBEMAIL}
	Prezzo: {PRICE}
	Data: {DATE}

Puoi vedere il profilo di questo membro clickando sul link seguente:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'È accaduto un Errore su una Sottoscrizione Pagata';
$txt['paid_subscription_error_body'] = 'Caro {REALNAME},

È accaduto il seguente errore elaborando una sottoscrizione pagata
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Nuovo messaggio personale: {SUBJECT}';
$txt['new_pm_body'] = 'Hai appena ricevuto un messaggio personale da {SENDER} su {FORUMNAME}

IMPORTANTE: Ricordati, questa è solo una notifica. Si prega di NON rispondere a questa email.

Per visualizzare questo messaggio clicca qui: {READLINK}

Per rispondere a questo messaggio clicca qui: {REPLYLINK}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Nuovo messaggio personale: {SUBJECT}';
$txt['new_pm_body_body'] = 'Hai appena ricevuto un messaggio personale da {SENDER} su {FORUMNAME}

IMPORTANTE: Ricordati, questa è solo una notifica. Si prega di NON rispondere a questa email.

Il messaggio ricevuto è:

{MESSAGE}

Per rispondere a questo messaggio privato clicca qui: {REPLYLINK}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Nuovo messaggio personale: {SUBJECT}';
$txt['new_pm_tolist_body'] = '{TOLIST} have just been sent a personal message by {SENDER} on {FORUMNAME}

IMPORTANT: Remember, this is just a notification. Please do not reply to this email.

Read this Personal Message here: {READLINK}

Reply to this Personal Message (to the sender only) here: {REPLYLINK}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Nuovo messaggio personale: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = '{TOLIST} hanno appena ricevuto un messaggio personale da {SENDER} su {FORUMNAME}

IMPORTANTE: Ricordati, questa è solo una notifica. Si prega di NON rispondere a questa email.

Il messaggio ricevuto è:

{MESSAGE}

Rispondi (solo al mittente) a questo messaggio privato qui: {REPLYLINK}';

/**
	@additional_params: notify_new_buddy
		ACTIONNAME:  The user name of the member adding as buddy.
	@description: A notification email sent to the members that are set as buddy by someone
*/
$txt['notify_new_buddy_subject'] = '{ACTIONNAME} ti ha aggiunto come amico';
$txt['notify_new_buddy_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} has just added you as a buddy 
at {FORUMNAME}.  

{REGARDS}


You can unsubscribe to further "new buddy" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_new_buddy_digest'] = 'Sei stato aggiunto come amico da:';
$txt['notify_new_buddy_snippet'] = '{ACTIONNAME}';

/**
	@additional_params: notify_new_likemsg
		ACTIONNAME:  The user name of the member that liked the message.
		MSGLINK:  The url to the message liked.
		SUBJECT: The subject of the message
	@description: A notification email sent to the members whose message has been liked
*/
$txt['notify_new_likemsg_subject'] = 'Un messaggio ha ricevuto un "mi piace"';
$txt['notify_new_likemsg_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} has just liked your message 
in the "{SUBJECT}" topic at {FORUMNAME}.  
You can view that message by following this link:
{MSGLINK}

{REGARDS}


You can unsubscribe to further "liked by" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_new_likemsg_digest'] = 'I seguenti messaggi hanno ricevuto un "mi piace"';
$txt['notify_new_likemsg_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_mentionmem
		ACTIONNAME:  The user name of the member that mentioned someone.
		MSGLINK:  The url to the message where someone has been mentioned.
		SUBJECT: The subject of the message
	@description: A notification email sent to the members mentioned by someone else in a message
*/
$txt['notify_mentionmem_subject'] = 'Sei stato menzionato';
$txt['notify_mentionmem_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} has just mentioned you in a message 
in the "{SUBJECT}" topic at {FORUMNAME}.  
You can view that message by following this link:
{MSGLINK}

{REGARDS}


You can unsubscribe to further "mentioned" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_mentionmem_digest'] = 'Sei stato menzionato nei seguenti messaggi:';
$txt['notify_mentionmem_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_quotedmem
		ACTIONNAME:  The user name of the member that quoted someone's message.
		MSGLINK:  The url to the message where someone has been quoted.
		SUBJECT: The subject of the message
  		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description: A notification email sent to the members quoted in someone else message
*/
$txt['notify_quotedmem_subject'] = 'Il tuo messaggio è stato citato';
$txt['notify_quotedmem_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} at {FORUMNAME} has just quoted
your messages in the "{SUBJECT}" topic.  You can view that message by 
following this link:
{MSGLINK}

{REGARDS}


You can unsubscribe to further "quoted message" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_quotedmem_digest'] = 'Your messages have been quoted in:';
$txt['notify_quotedmem_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_html_email
		FORUMNAMESHORT: Short or nickname for the forum
		TOPICSUBJECT: The subject of the message.
		MESSAGE: This is the body of the message.
		EMAILCSS: The location of the stylesheet.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description: A basic HTML wrapper to place around a prepared HTML email
 */
$txt['notify_html_email_subject'] = '';
$txt['notify_html_email_body'] = '<!DOCTYPE html>
<html>
<head>
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title>{TOPICSUBJECT}</title>
	<style>
		{EMAILCSS}
	</style>
</head>
<body>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="body">
	<tr>
		<td class="container">
			<div class="content">
				<table role="presentation" class="main">
					<tr>
						<td class="wrapper">
							<table role="presentation" border="0" cellpadding="0" cellspacing="0">
								<tr>
									<td>
										<p>{MESSAGE}</p>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<div class="footer">
					<table role="presentation" border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td class="content-block">
								<span class="apple-link">{FORUMNAMESHORT}</span>
								<br>
								Dont like these emails? <a href="{UNSUBSCRIBELINK}">Unsubscribe</a>.
							</td>
						</tr>
						<tr>
							<td>
								<span class="key-holder">[]</span>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</td>
	</tr>
</table>
</body>
</html>
';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/

$txtBirthdayEmails['happy_birthday_subject'] = 'Happy birthday from {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Dear {REALNAME},

We here at {FORUMNAME} would like to wish you a happy birthday.  May this day and the year to follow be full of joy.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'On your Birthday...';
$txtBirthdayEmails['karlbenson1_body'] = 'We could have sent you a birthday card.  We could have sent you some flowers or a cake.

But we didn\'t.

We could have even sent you one of those automatically generated messages to wish you happy birthday where we don\'t even have to replace INSERT NAME.

But we didn\'t

We wrote this birthday greeting just for you.

We would like to wish you a very special birthday.

{REGARDS}

//:: This message was automatically generated :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Happy Birthday!';
$txtBirthdayEmails['nite0859_body'] = 'Your friends at {FORUMNAME} would like to take a moment of your time to wish you a happy birthday, {REALNAME}. If you have not done so recently, please visit our community in order for others to have the opportunity to pass along their warm regards.

Even though today is your birthday, {REALNAME}, we would like to remind you that your membership in our community has been the best gift to us thus far.

Best Wishes,
The Staff of {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Birthday Wishes to {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Dear {REALNAME},

Another year in your life has passed.  We at {FORUMNAME} hope it has been filled with happiness, and wish you luck in the coming one.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Happy birthday, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Do you know who\'s having a birthday today, {REALNAME}?

We know... YOU!

Happy birthday!

You\'re now a year older but we hope you\'re a lot happier than last year.

Enjoy your day today, {REALNAME}!

- From your {FORUMNAME} family';
$txtBirthdayEmails['geezmo_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Your Birthday Greeting';
$txtBirthdayEmails['karlbenson2_body'] = 'We hope your birthday is the best ever cloudy, sunny or whatever the weather.
Have lots of birthday cake and fun, and tell us what you have done.

We hope this message brought you cheer, and make it last, until same time same place, next year.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';
