<?php
// Version: 2.0; index

global $forum_copyright;

// Locale (strftime, pspell_new) and spelling.
// For more information see:
//   - https://www.php.net/function.pspell-new
//   - https://www.php.net/function.setlocale
$txt['lang_locale'] = 'it_IT.utf8';
$txt['lang_dictionary'] = 'it';
$txt['lang_spelling'] = 'italian';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set and right to left?
$txt['lang_rtl'] = false;
// Capitalize day and month names?
$txt['lang_capitalize_dates'] = true;
// Number format.
$txt['number_format'] = '1.234,00';

$txt['sunday'] = 'Domenica';
$txt['monday'] = 'Lunedì';
$txt['tuesday'] = 'Martedì';
$txt['wednesday'] = 'Mercoledì';
$txt['thursday'] = 'Giovedì';
$txt['friday'] = 'Venerdì';
$txt['saturday'] = 'Sabato';

$txt['sunday_short'] = 'Dom';
$txt['monday_short'] = 'Lun';
$txt['tuesday_short'] = 'Mar';
$txt['wednesday_short'] = 'Mer';
$txt['thursday_short'] = 'Gio';
$txt['friday_short'] = 'Ven';
$txt['saturday_short'] = 'Sab';

$txt['january'] = 'Gennaio';
$txt['february'] = 'Febbraio';
$txt['march'] = 'Marzo';
$txt['april'] = 'Aprile';
$txt['may'] = 'Mag';
$txt['june'] = 'Giugno';
$txt['july'] = 'Luglio';
$txt['august'] = 'Agosto';
$txt['september'] = 'Settembre';
$txt['october'] = 'Ottobre';
$txt['november'] = 'Novembre';
$txt['december'] = 'Dicembre';

$txt['january_titles'] = 'Gennaio';
$txt['february_titles'] = 'Febbraio';
$txt['march_titles'] = 'Marzo';
$txt['april_titles'] = 'Aprile';
$txt['may_titles'] = 'Mag';
$txt['june_titles'] = 'Giugno';
$txt['july_titles'] = 'Luglio';
$txt['august_titles'] = 'Agosto';
$txt['september_titles'] = 'Settembre';
$txt['october_titles'] = 'Ottobre';
$txt['november_titles'] = 'Novembre';
$txt['december_titles'] = 'Dicembre';

$txt['january_short'] = 'Gen';
$txt['february_short'] = 'Feb';
$txt['march_short'] = 'Mar';
$txt['april_short'] = 'Apr';
$txt['may_short'] = 'Mag';
$txt['june_short'] = 'Giu';
$txt['july_short'] = 'Lug';
$txt['august_short'] = 'Ago';
$txt['september_short'] = 'Set';
$txt['october_short'] = 'Ott';
$txt['november_short'] = 'Nov';
$txt['december_short'] = 'Dic';

$txt['time_am'] = 'am';
$txt['time_pm'] = 'pm';

// Let's get all the main menu strings in one place.
$txt['main_menu'] = 'Menu Principale';
$txt['home'] = 'Indice';
$txt['community'] = 'Comunità';
$txt['forum'] = 'Forum';

// Sub menu labels
$txt['help'] = 'Aiuto';
$txt['search'] = 'Cerca';
$txt['calendar'] = 'Calendario';
$txt['members'] = 'Utenti';
$txt['recent_posts'] = 'Post recenti';
$txt['recent_topics'] = 'Topic recenti';

$txt['admin'] = 'Amministra';
// Sub menu labels
$txt['errlog'] = 'Registro errori';
$txt['package'] = 'Gestore Add-on';
$txt['edit_permissions'] = 'Permessi';
$txt['modSettings_title'] = 'Funzioni ed opzioni';
$txt['pwa_label'] = 'Applicazione Web';

$txt['moderate'] = 'Modera';
// Sub menu labels
$txt['modlog_view'] = 'Registro Moderazione';
$txt['mc_emailerror'] = 'Email non approvate';
$txt['mc_reported_posts'] = 'Post segnalati';
$txt['mc_reported_pms'] = 'Messaggi personali Segnalati';
$txt['mc_unapproved_attachments'] = 'Allegati non approvati';
$txt['mc_unapproved_poststopics'] = 'Post e topic non approvati';

$txt['pm_short'] = 'Messaggi personali';
// Sub menu labels
$txt['pm_menu_read'] = 'Leggi i tuoi messaggi';
$txt['pm_menu_send'] = 'Invia un messaggio personale';

$txt['account_short'] = 'Il mio account';
// Sub menu labels
$txt['profile'] = 'Profilo';
$txt['mydrafts'] = 'Le mie bozze';
$txt['summary'] = 'Sommario';
$txt['theme'] = 'Aspetto e visualizzazione';
$txt['account'] = 'Impostazioni account';
$txt['forumprofile'] = 'Profilo forum';

$txt['view_unread_category'] = 'Nuovi post';
$txt['view_replies_category'] = 'Nuove risposte';

$txt['login'] = 'Login';
$txt['register'] = 'Registrati';
$txt['logout'] = 'Logout';
// End main menu strings.

$txt['save'] = 'Salva';

$txt['modify'] = 'Modifica';
$txt['forum_index'] = '%1$s - Indice';
$txt['board_name'] = 'Nome sezione';
$txt['posts'] = 'Messaggi';

$txt['member_postcount'] = 'Messaggi';
$txt['no_subject'] = '(Nessun oggetto)';
$txt['view_profile'] = 'Mostra profilo';
$txt['guest_title'] = 'Visitatore';
$txt['author'] = 'Autore';
$txt['on'] = '-';
$txt['remove'] = 'Rimuovi';
$txt['start_new_topic'] = 'Apri nuovo topic';

// Use numeric entities in the below string.
$txt['username'] = 'Nome Utente';
$txt['password'] = 'Password';

$txt['username_no_exist'] = 'Questo nome utente non esiste.';
$txt['no_user_with_email'] = 'Non ci sono nomi utente associati a questa email.';

$txt['board_moderator'] = 'Moderatore della sezione';
$txt['remove_topic'] = 'Rimuovi';
$txt['topics'] = 'Topic';
$txt['modify_msg'] = 'Modifica post';
$txt['name'] = 'Nome';
$txt['email'] = 'E-mail';
$txt['user_email_address'] = 'Indirizzo e-mail';
$txt['subject'] = 'Oggetto';
$txt['message'] = 'Messaggio';
$txt['redirects'] = 'Reindirizzamenti';

$txt['choose_pass'] = 'Scegli password';
$txt['verify_pass'] = 'Verifica password';
$txt['position'] = 'Posizione';
$txt['notify_announcements'] = 'Iscriviti per ricevere notizie importanti via email';

$txt['profile_of'] = 'Mostra il profilo di';
$txt['total'] = 'Totale';
$txt['posts_made'] = 'Messaggi';
$txt['topics_made'] = 'Topic';
$txt['website'] = 'Sito web';
$txt['contact'] = 'Contattaci';
$txt['warning_status'] = 'Stato richiami';
$txt['user_warn_watch'] = 'L\'utente è presente nella lista controllata dai moderatori';
$txt['user_warn_moderate'] = 'I post dell\'utente si aggiungono alla coda di post da approvare';
$txt['user_warn_mute'] = 'L\'utente non può inviare post';
$txt['warn_watch'] = 'Controllato';
$txt['warn_moderate'] = 'Moderato';
$txt['warn_mute'] = 'Muto (no invio post)';
$txt['warning_issue'] = 'Ammonisci';

$txt['message_index'] = 'Indice dei post';
$txt['news'] = 'Notizie';
$txt['page'] = 'Pagina';
$txt['prev'] = 'precedente';
$txt['next'] = 'successiva';

$txt['post'] = 'Invia post';
$txt['error_occurred'] = 'Si è verificato un errore';
$txt['send_error_occurred'] = 'Si è verificato un errore, <a href="{href}">clicca qui per riprovare</a>.';
$txt['require_field'] = 'Questo campo è obbligatorio.';
$txt['started_by'] = 'Iniziato dall\'autore';
$txt['topic_started_by'] = 'Iniziato da %1$s';
$txt['topic_started_by_in'] = 'Iniziato da %1$s in %2$s';
$txt['replies'] = 'Risposte';
$txt['last_post'] = 'Ultimo post';
$txt['first_post'] = 'Primo messaggio';
$txt['last_poster'] = 'Autore dell\'ultimo post';

$txt['last_post_message'] = '<span class="lastpost_link">%2$s </span><span class="board_lastposter">di %1$s</span><span class="board_lasttime"><strong>Ultimo post: </strong>%3$s</span>';
$txt['boardindex_total_posts'] = '%1$s Post in %2$s Argomenti da %3$s Membri';
$txt['show'] = 'Mostra';
$txt['hide'] = 'Nascondi';
$txt['sort_by'] = 'Ordina per';
$txt['sort_asc'] = 'Ordina ascendente';
$txt['sort_desc'] = 'Ordina discendente';

$txt['admin_login'] = 'Login Amministratori';
// Use numeric entities in the below string.
$txt['topic'] = 'Argomento';
$txt['notify'] = 'Attiva notifiche';
$txt['unnotify'] = 'Disattiva notifiche';
$txt['notify_request'] = 'Desideri ricevere una notifica e-mail se questo topic riceve una risposta?';
// Use numeric entities in the below string.
$txt['regards_team'] = "Regards,\nThe {forum_name_html_unsafe} Team.";
$txt['notify_replies'] = 'Notifica delle risposte';
$txt['move_topic'] = 'Sposta';
$txt['move_to'] = 'Sposta in';
$txt['pages'] = 'Pagine';
$txt['users_active'] = 'Attivi negli ultimi %1$d minuti';
$txt['personal_messages'] = 'Messaggi Personali';
$txt['reply_quote'] = 'Rispondi citando';
$txt['reply'] = 'Rispondi';
$txt['reply_number'] = 'Risposta n.&nbsp;%1$s';
$txt['approve'] = 'Approva';
$txt['unapprove'] = 'Disapprova';
$txt['approve_all'] = 'approva tutti';
$txt['awaiting_approval'] = 'In Attesa di Approvazione';
$txt['attach_awaiting_approve'] = 'Allegati in attesa di approvazione';
$txt['post_awaiting_approval'] = 'Nota: Questo post è in attesa di approvazione da parte di un moderatore.';
$txt['there_are_unapproved_topics'] = 'Ci sono %1$s argomenti e %2$s post in attesa di approvazione in questo forum. <a href="%3$s">Clicca qui per visualizzarli</a>.';
$txt['send_message'] = 'Invia messaggio';

$txt['msg_alert_no_messages'] = 'non hai messaggi';
$txt['msg_alert_one_message'] = 'hai <a href="%1$s">1 messaggio</a>';
$txt['msg_alert_many_message'] = 'hai <a href="%1$s">%2$d messaggi</a>';
$txt['msg_alert_one_new'] = '1 è nuovo';
$txt['msg_alert_many_new'] = '%1$d sono nuovi';
$txt['remove_message'] = 'Rimuovi messaggio';

$txt['topic_alert_none'] = 'Nessun messaggio...';
$txt['pm_alert_none'] = 'Nessun messaggio...';

$txt['online_users'] = 'Utenti online'; //Deprecated
$txt['online_now'] = 'Online adesso';
$txt['personal_message'] = 'Messaggio personale';
$txt['jump_to'] = 'Salta a';
$txt['go'] = 'Vai!';
$txt['are_sure_remove_topic'] = 'Sei sicuro di voler eliminare questo topic?';
$txt['yes'] = 'Sì';
$txt['no'] = 'No';

// @todo this string seems a good candidate for deprecation
$txt['search_on'] = '-';

$txt['all'] = 'Tutto';
$txt['search_entireforum'] = 'Intero forum';
$txt['search_thisbrd'] = 'Questa board';
$txt['search_thistopic'] = 'Questo topic';
$txt['search_members'] = 'Utenti';

$txt['back'] = 'Indietro';
$txt['continue'] = 'Continua';
$txt['password_reminder'] = 'Promemoria password';
$txt['topic_started'] = 'Topic aperto da';
$txt['title'] = 'Titolo';
$txt['post_by'] = 'Inserito da';
$txt['welcome_newest_member'] = 'Per favore dai il benvenuto a %1$s, il nostro membro più recente.';
$txt['admin_center'] = 'Pannello di amministrazione';
$txt['admin_session_active'] = 'Hai una sessione di amministrazione attiva. Si raccomanda di <strong><a class="strong" href="%1$s">terminare questa sessione</a></strong> appena avrai finito di svolgere l\'attività nel pannello di amministrazione.';
$txt['admin_maintenance_active'] = 'Il tuo forum è in modalità manutenzione, solo gli amministratori possono effettuare il login. Ricordati di <strong><a class="strong" href="%1$s">disabilitare la manutenzione</a></strong> quando avrai finito le attività amministrative.';
$txt['query_command_denied'] = 'Si sono verificati i seguenti errori MySQL, è consigliato verificare il setup:';
$txt['query_command_denied_guests'] = 'Sembra che qualcosa non funzioni troppo bene con il database. Il problema dovrebbe essere temporaneo, quindi riprova più tardi. Se continui a vedere questo messaggio, riporta il seguente errore all\'amministratore:';
$txt['query_command_denied_guests_msg'] = 'il comando %1$s è negato sul database';
$txt['last_edit_by'] = '<span class="lastedit">Ultima modifica</span>: %1$s da %2$s';
$txt['notify_deactivate'] = 'Desideri disattivare le notifiche per questo topic?';

$txt['date_registered'] = 'Data di registrazione';
$txt['date_joined'] = 'Iscritto';
$txt['date_joined_format'] = '%b %d, %Y';
$txt['last_seen'] = 'Ultima Visita';

$txt['recent_view'] = 'Vedi tutti i messaggi recenti.';
$txt['is_recent_updated'] = '%1$s è il topic aggiornato più di recente';

$txt['male'] = 'Maschio';
$txt['female'] = 'Femmina';

$txt['error_invalid_characters_username'] = 'Uno dei caratteri che hai usato nel nome utente non è valido.';

$txt['welcome_guest'] = 'Benvenuto, <strong>Ospite</strong>. Per favore <a href="{login_url}" rel="nofollow">accedi</a>.';
$txt['welcome_guest_register'] = 'Benvenuto in <strong>{forum_name}</strong>. Per favore <a href="{login_url}" rel="nofollow">accedi</a> o <a href="{register_url}" rel="nofollow">registrati</a>.';
$txt['welcome_guest_activate'] = '<br />Hai perso la tua <a href="{activate_url}" rel="nofollow">email di attivazione</a>?';
$txt['welcome_register'] = 'Non hai un account?';

// @todo the following to sprintf
$txt['hello_member'] = 'Ciao,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Benvenuto,';
$txt['select_destination'] = 'Scegliere una destinazione';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Inserito da';

$txt['icon_smiley'] = 'Sorriso';
$txt['icon_angry'] = 'Adirato';
$txt['icon_cheesy'] = 'Felice';
$txt['icon_laugh'] = 'Risata';
$txt['icon_sad'] = 'Triste';
$txt['icon_wink'] = 'Occhiolino';
$txt['icon_grin'] = 'Ghigno';
$txt['icon_shocked'] = 'Scioccato';
$txt['icon_cool'] = 'Fico';
$txt['icon_huh'] = 'Attonito';
$txt['icon_rolleyes'] = 'Occhi al cielo';
$txt['icon_tongue'] = 'Linguaccia';
$txt['icon_embarrassed'] = 'Imbarazzato';
$txt['icon_lips'] = 'Bocca cucita';
$txt['icon_undecided'] = 'Indeciso';
$txt['icon_kiss'] = 'Bacio';
$txt['icon_cry'] = 'Pianto';
$txt['icon_angel'] = 'Innocente';

$txt['moderator'] = 'Moderatore';
$txt['moderators'] = 'Moderatori';

$txt['views'] = 'Visite';
$txt['new'] = 'Nuovo';
$txt['no_redir'] = 'Reindirizzato qui da %1$s';

$txt['view_all_members'] = 'Visualizza tutti gli utenti';
$txt['view'] = 'Visualizza';

$txt['viewing_members'] = 'Visualizzazione Membri %1$s a %2$s';
$txt['of_total_members'] = 'di %1$s utenti totali';

$txt['forgot_your_password'] = 'Smarrito la password?';

$txt['date'] = 'Data';
// Use numeric entities in the below string.
$txt['from'] = 'Da';
$txt['to'] = 'A';

$txt['board_topics'] = 'Topic';
$txt['members_title'] = 'Utenti';
$txt['members_list'] = 'Elenco utenti';
$txt['new_posts'] = 'Nuovi post';
$txt['old_posts'] = 'Nessun nuovo post';
$txt['redirect_board'] = 'Redirezionamento';
$txt['redirect_board_to'] = 'Reindirizzamento a %1$s';

$txt['sendtopic_send'] = 'Invia';
$txt['report_sent'] = 'Il tuo report è stato inviato con successo';
$txt['topic_sent'] = 'L\'email ti è stata inviata con successo.';

$txt['time_offset'] = 'Ore di differenza';
$txt['or'] = 'o';

$txt['mention'] = 'Notifiche';
$txt['notifications'] = 'Notifiche ed email';
$txt['unread_notifications'] = 'Hai %1$snotifiche non lette dall\'ultima visita.';
$txt['new_from_last_notifications'] = 'Hai %1$s nuove notifiche.';
$txt['forum_notification'] = 'Notifiche da %1$s.';

$txt['your_ban'] = '%1$s, sei stato escluso da questo forum!';
$txt['your_ban_expires'] = 'Questa esclusione dal forum terminerà il %1$s.';
$txt['your_ban_expires_never'] = 'Questa esclusione dal forum non ha scadenza.';
$txt['ban_continue_browse'] = 'Puoi continuare a navigare nel forum come ospite.';

$txt['mark_as_read'] = 'Marca tutti i post come letti';
$txt['mark_as_read_confirm'] = 'Vuoi veramente segnare TUTTI i messaggi come letti?';
$txt['mark_these_as_read'] = 'Marca QUESTI messaggi come letti';
$txt['mark_these_as_read_confirm'] = 'Vuoi veramente segnare QUESTI messaggi come letti?';

$txt['locked_topic'] = 'Topic chiuso';
$txt['normal_topic'] = 'Topic normale';
$txt['participation_caption'] = 'Argomento in cui hai postato';

$txt['print'] = 'Stampa';
$txt['topic_summary'] = 'Sommario del topic';
$txt['not_applicable'] = 'N/D';
$txt['name_in_use'] = 'Il nome %1$s è già utilizzato da un altro utente.';

$txt['total_members'] = 'Totale Membri';
$txt['total_posts'] = 'Post totali';
$txt['total_topics'] = 'Totale Argomenti';

$txt['mins_logged_in'] = 'Minuti per rimanere connesso';

$txt['preview'] = 'Anteprima';
$txt['always_logged_in'] = 'Rimani sempre connesso';

$txt['logged'] = 'Connesso';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';

$txt['www'] = 'WWW';
$txt['link'] = 'Link';

$txt['by'] = 'da'; //Deprecated

$txt['hours'] = 'ore';
$txt['minutes'] = 'minuti';
$txt['seconds'] = 'secondi';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Ora';
$txt['days_word'] = 'giorni';

$txt['newest_member'] = ', il nostro ultimo iscritto.'; //Deprecated

$txt['search_for'] = 'Cerca per';
$txt['search_match'] = 'Trova';

$txt['maintain_mode_on'] = 'Ricorda, questo forum è in \'Modalità Manutenzione\'.';

$txt['read'] = 'Letto'; //Deprecated
$txt['times'] = 'volte'; //Deprecated
$txt['read_one_time'] = 'Letto 1 volta';
$txt['read_many_times'] = 'Letto %1$d volte';

$txt['forum_stats'] = 'Statistiche forum';
$txt['latest_member'] = 'Ultimo utente';
$txt['total_cats'] = 'Totale Categorie';
$txt['latest_post'] = 'Ultimo post';

$txt['here'] = 'per visualizzarlo';
$txt['you_have_no_msg'] = 'Non hai messaggi...';
$txt['you_have_one_msg'] = 'Hai 1 messaggio...<a href="%1$s">Clicca qui per visualizzarlo</a>';
$txt['you_have_many_msgs'] = 'Hai %2$d messaggi...<a href="%1$s">Clicca qui per visualizzarli</a>';

$txt['total_boards'] = 'Sezioni totali';

$txt['print_page'] = 'Pagina di stampa';
$txt['print_page_text'] = 'Solo testo';
$txt['print_page_images'] = 'Testo e immagini';

$txt['valid_email'] = 'È necessario inserire un indirizzo e-mail valido.';

$txt['info_center_title'] = '%1$s - Centro Informazioni';

$txt['send_topic'] = 'Condividi';
$txt['unwatch'] = 'Non seguire';
$txt['watch'] = 'Segui';

$txt['allow_user_email'] = 'Consenti agli utenti di inviarti e-mail';

$txt['check_all'] = 'Spunta tutto';

// Use numeric entities in the below string.
$txt['database_error'] = 'Errore del Database';
$txt['try_again'] = 'Ritenta! Se riappare questa schermata, segnala il problema ad un amministratore.';
$txt['file'] = 'File';
$txt['line'] = 'Riga';

// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'ElkArte ha individuato e tentato di riparare automaticamente un errore nel tuo database. Se continui ad avere problemi, o continui a ricevere queste email, ti suggeriamo di contattare il tuo host.';
$txt['database_error_versions'] = '<strong>Nota:</strong> la versione del tuo database è %1$s.';
$txt['template_parse_error'] = 'Errore nella scansione del template!';
$txt['template_parse_error_message'] = 'Sembra che qualcosa si sia bloccato nel sistema di gestione dei modelli del forum.  Il problema dovrebbe essere temporaneo: riprovare in un secondo momento. Se questo messaggio non scompare contattare un amministratore.<br /><br />è anche possibile provare a <a href="javascript:location.reload();">ricaricare la pagina</a>.';
$txt['template_parse_error_details'] = 'C\'è stato un problema caricando il template o il file di lingua <span class="tt"><strong>%1$s</strong></span>. Controlla la sintassi e prova ancora - Ricorda che gli apici semplici (<span class="tt">\'</span>) spesso devono essere preceduti da un <em>backslash</em> (<span class="tt">\</span>). Per visualizzare informazioni più specifiche sull\'errore PHP, prova ad <a href="%2$s%1$s">accedere al file direttamente</a>.<br /><br />Potresti tentare anche <a href="javascript:location.reload();">ricaricando la pagina</a> oppure <a href="%3$s">ad usare il tema di default</a>.';
$txt['template_parse_undefined'] = 'Si è verificato un\'errore sconosciuto durante l\'analisi di questo template.';

$txt['today'] = 'Oggi alle %1$s';
$txt['yesterday'] = 'Ieri alle %1$s';

// Relative times
$txt['rt_now'] = 'adesso';
$txt['rt_minute'] = 'Un minuto fa';
$txt['rt_minutes'] = '%s minuti fa';
$txt['rt_hour'] = 'Un\'ora fa';
$txt['rt_hours'] = '%s ore fa';
$txt['rt_day'] = 'Un giorno fa';
$txt['rt_days'] = '%s giorni fa';
$txt['rt_week'] = 'Una settimana fa';
$txt['rt_weeks'] = '%s settimane fa';
$txt['rt_month'] = 'Un mese fa';
$txt['rt_months'] = '%s mesi fa';
$txt['rt_year'] = 'Un anno fa';
$txt['rt_years'] = '%s anni fa';

$txt['new_poll'] = 'Nuovo sondaggio';
$txt['poll_question'] = 'Domanda';
$txt['poll_question_options'] = 'Domande ed opzioni';
$txt['poll_vote'] = 'Invia voto';
$txt['poll_total_voters'] = 'Totale votanti';
$txt['draft_saved_on'] = 'Ultima modifica';
$txt['poll_results'] = 'Visualizza risultati';
$txt['poll_lock'] = 'Chiudi votazioni';
$txt['poll_unlock'] = 'Riapri votazioni';
$txt['poll_edit'] = 'Modifica sondaggio';
$txt['poll'] = 'Sondaggio';
$txt['one_day'] = '1 giorno';
$txt['one_week'] = '1 settimana';
$txt['two_weeks'] = '2 settimane';
$txt['one_month'] = '1 mese';
$txt['two_months'] = '2 mesi';
$txt['forever'] = 'Sempre';
$txt['quick_login_dec'] = 'Inserisci il nome utente, la password e la durata della sessione.';
$txt['one_hour'] = '1 ora';
$txt['moved'] = 'SPOSTATO';
$txt['moved_why'] = 'Inserire una breve spiegazione sul perché<br />questo topic è stato spostato.';
$txt['board'] = 'Sezione';
$txt['in'] = 'in';
$txt['sticky_topic'] = 'Topic importanti';
$txt['split'] = 'DIVISO';

$txt['delete'] = 'Cancella';

$txt['byte'] = 'B';
$txt['kilobyte'] = 'KB';
$txt['megabyte'] = 'MB';
$txt['gigabyte'] = 'GB';

$txt['more_stats'] = '[Altre statistiche]';

$txt['code'] = 'Codice';
$txt['code_select'] = '[Seleziona]';
$txt['quote_from'] = 'Citazione da';
$txt['quote'] = 'Citazione';
$txt['quick_quote'] = 'Citazione Selezionata';
$txt['quote_new'] = 'Nuovo topic';
$txt['follow_ups'] = 'Segui';
$txt['topic_derived_from'] = 'Topic derivato da %1$s';
$txt['edit'] = 'Modifica';
$txt['quick_edit'] = 'Modifica rapida';
$txt['post_options'] = 'Altre Opzioni';
$txt['quote_expand'] = 'Mostra Citazione';

$txt['set_sticky'] = 'Importante';
$txt['set_nonsticky'] = 'Rimuovi importante';
$txt['set_lock'] = 'Chiudi';
$txt['set_unlock'] = 'Apri';

$txt['search_advanced'] = 'Mostra opzioni avanzate';
$txt['search_simple'] = 'Nascondi opzioni avanzate';

$txt['security_risk'] = 'GRAVE RISCHIO DI SICUREZZA:';
$txt['not_removed'] = 'Non hai rimosso %1$s';
$txt['not_removed_extra'] = '%1$s è un backup di %2$s che non è stato generato da ElkArte. Può essere usato per ottenere l\'accesso non autorizzato al tuo forum. Si consiglia di eliminarlo immediatamente.';
$txt['generic_warning'] = 'Avviso';
$txt['agreement_missing'] = 'Stai richiedendo ai nuovi utenti di accettare un accordo di registrazione, tuttavia il file (in sources/ElkArte/Languages/Agreement/) non esiste.';
$txt['agreement_accepted'] = 'Hai appena accettato i termini della registrazione.';
$txt['privacypolicy_accepted'] = 'Hai appena accettato l\'informativa sulla privacy del forum.';

$txt['new_version_updates'] = 'Hai appena aggiornato!';
$txt['new_version_updates_text'] = '<a href="{admin_url};area=credits#latest_updates">Clicca qui per vedere le novità in questa versione di ElkArte!</a>!';

$txt['cache_writable'] = 'La cartella dedicata alla cache non dispone di adeguati permessi di scrittura, questo inciderà pesantemente sulle prestazioni del tuo forum.';

$txt['page_created_full'] = 'Pagina creata in %1$.3f secondi con %2$d query.';

$txt['report_to_mod_func'] = 'Usa questa funzione per informare i moderatori e gli amministratori di un messaggio abusivo o pubblicato erroneamente.';

$txt['online'] = 'Online';
$txt['member_is_online'] = '%1$s è collegato';
$txt['offline'] = 'Offline';
$txt['member_is_offline'] = '%1$s è disconnesso';
$txt['pm_online'] = 'Messaggio personale (Online)';
$txt['pm_offline'] = 'Messaggio personale (Offline)';
$txt['status'] = 'Stato';

$txt['skip_nav'] = 'Passa al contenuto principale';
$txt['go_up'] = 'Vai su';
$txt['go_down'] = 'Vai giù';

$forum_copyright = '<a href="https://www.elkarte.net" title="ElkArte Forum" target="_blank" class="new_win">Powered by %1$s</a> | <a href="{credits_url}" title="Credits" target="_blank" class="new_win" rel="nofollow">Credits</a>';

$txt['birthdays'] = 'Compleanni:';
$txt['events'] = 'Eventi:';
$txt['birthdays_upcoming'] = 'Prossimi compleanni:';
$txt['events_upcoming'] = 'Prossimi eventi:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Festività:';
$txt['calendar_month'] = 'Mese:';
$txt['calendar_year'] = 'Anno:';
$txt['calendar_day'] = 'Giorno:';
$txt['calendar_event_title'] = 'Titolo evento';
$txt['calendar_event_options'] = 'Opzioni evento';
$txt['calendar_post_in'] = 'Pubblica in:';
$txt['calendar_edit'] = 'Modifica evento';
$txt['event_delete_confirm'] = 'Eliminare questo evento?';
$txt['event_delete'] = 'Elimina evento';
$txt['calendar_post_event'] = 'Inserisci evento';
$txt['calendar_link'] = 'Link al calendario';
$txt['calendar_upcoming'] = 'Prossimi eventi';
$txt['calendar_today'] = 'Calendario di oggi';
$txt['calendar_week'] = 'Settimana';
$txt['calendar_week_title'] = 'Settimana %1$d di %2$d ';
$txt['calendar_numb_days'] = 'Numero di giorni:';
$txt['calendar_how_edit'] = 'come modificare questi eventi?';
$txt['calendar_link_event'] = 'Collegamento all\'evento da inserire:';
$txt['calendar_confirm_delete'] = 'Sei sicuro di voler eliminare questo evento?';
$txt['calendar_linked_events'] = 'Eventi collegati';
$txt['calendar_click_all'] = 'Vai qui per vedere tutti %1$s';

$txt['moveTopic1'] = 'Inserisci un topic di reindirizzamento';
$txt['moveTopic2'] = 'Modifica l\'oggetto del topic';
$txt['moveTopic3'] = 'Nuovo oggetto';
$txt['moveTopic4'] = 'Modifica l\'oggetto di ciascun post';
$txt['move_topic_unapproved_js'] = 'Attenzione! Questo topic ancora non è stato approvato.\n\nNon è consigliato creare un topic di reindirizzamento, a meno che tu non voglia approvare il post immediatamente dopo.';
$txt['movetopic_auto_board'] = '[TAVOLO]';
$txt['movetopic_auto_topic'] = '[COLLEGAMENTO TOPIC]';
$txt['movetopic_default'] = 'Questo topic è stato spostato in [TAVOLO] - [COLLEGAMENTO TOPIC]';
$txt['movetopic_redirect'] = 'Porta direttamente al topic spostato';
$txt['movetopic_expires'] = 'Rimuovi automaticamente l\'inoltro al topic';

$txt['merge_to_topic_id'] = 'ID del topic di destinazione';
$txt['split_topic'] = 'Dividi';
$txt['merge'] = 'Unisci';
$txt['subject_new_topic'] = 'Titolo del nuovo topic';
$txt['split_this_post'] = 'Dividi solamente questo post.';
$txt['split_after_and_this_post'] = 'Dividi il topic da questo post.';
$txt['select_split_posts'] = 'Scegliere i post da dividere.';

$txt['splittopic_notification'] = 'Posta un messaggio quando vengono divisi i topic';
$txt['splittopic_default'] = 'Uno o più messaggi di questo topic sono stati spostati in [BOARD] - [TOPIC LINK]';
$txt['splittopic_move'] = 'Sposta il nuovo topic in un altro tavolo';

$txt['new_topic'] = 'Nuovo topic';
$txt['split_successful'] = 'Topic suddiviso con successo in due topic.';
$txt['origin_topic'] = 'Topic di origine';
$txt['please_select_split'] = 'Seleziona i post da dividere.';
$txt['merge_successful'] = 'I topic sono stati uniti correttamente.';
$txt['new_merged_topic'] = 'Nuovo topic unito';
$txt['topic_to_merge'] = 'Topic da unire';
$txt['target_board'] = 'Sezione di destinazione';
$txt['target_topic'] = 'Topic di destinazione';
$txt['merge_confirm'] = 'Sei sicuro di voler unire';
$txt['with'] = 'con';
$txt['merge_desc'] = 'Questa funzionalità unirà i post di due topic diversi in uno solo. I post verranno ordinati secondo la data di inserimento, quindi il post più vecchio diventerà il primo del topic unito.';

$txt['theme_template_error'] = 'Impossibile caricare il template \'%1$s\'.';
$txt['theme_language_error'] = 'Impossibile caricare il file di traduzione \'%1$s\'.';

$txt['parent_boards'] = 'Sottosezioni';

$txt['smtp_no_connect'] = 'Impossibile collegarsi al server SMTP';
$txt['smtp_port_ssl'] = 'Impostazione porta SMTP errata; dovrebbe essere 465 per i server SSL.';
$txt['smtp_bad_response'] = 'Impossibile ottenere una risposta dal server di posta elettronica';
$txt['smtp_error'] = 'Si sono verificati dei problemi nell\'invio dell\'e-mail. Errore: ';
$txt['mail_send_unable'] = 'Impossibile inviare una mail all\'indirizzo \'%1$s\'';

$txt['mlist_search'] = 'Cerca utente';
$txt['mlist_search_email'] = 'Cerca per email';
$txt['mlist_search_group'] = 'Cerca per posizione';
$txt['mlist_search_name'] = 'Cerca per nome';
$txt['mlist_search_website'] = 'Cerca per sito';
$txt['mlist_search_results'] = 'Cerca nei risultati per';
$txt['mlist_search_by'] = 'Cerca per %1$s';

$txt['attach_downloaded'] = 'Scaricato %1$d volte';
$txt['attach_viewed'] = 'visto %1$d volte';

$txt['settings'] = 'Impostazioni';
$txt['never'] = 'Mai';
$txt['more'] = 'altri';

$txt['hostname'] = 'Nome host';
$txt['you_are_post_banned'] = 'Spiacente %1$s, sei stato escluso da questo forum, non puoi più aggiungere post o inviare messaggi personali.';
$txt['ban_reason'] = 'Motivo';

$txt['add_poll'] = 'Aggiungi sondaggio';
$txt['poll_options6'] = 'Puoi selezionare un massimo di %1$s opzioni.';
$txt['poll_remove'] = 'Rimuovi sondaggio';
$txt['poll_remove_warn'] = 'Sei sicuro di voler rimuovere questo sondaggio dal topic?';
$txt['poll_results_expire'] = 'I risultati verranno mostrati quando la votazione sarà chiusa';
$txt['poll_expires_on'] = 'Le votazioni chiudono';
$txt['poll_expired_on'] = 'Le votazioni sono chiuse';
$txt['poll_change_vote'] = 'Rimuovi voto';
$txt['poll_return_vote'] = 'Opzioni di voto';
$txt['poll_cannot_see'] = 'Al momento, non è possibile vedere i risultati di questo sondaggio.';

$txt['quick_mod_approve'] = 'Approva i selezionati';
$txt['quick_mod_remove'] = 'Rimuovi selezionati';
$txt['quick_mod_lock'] = 'Chiudi/Apri selezionate';
$txt['quick_mod_sticky'] = 'Fissa/Sblocca selezionati';
$txt['quick_mod_move'] = 'Sposta selezionati in';
$txt['quick_mod_merge'] = 'Unisci selezionati';
$txt['quick_mod_markread'] = 'Marca selezionati come letti';
$txt['quick_mod_go'] = 'Cerca';
$txt['quickmod_confirm'] = 'Sicuro di voler procedere?';

$txt['quick_reply'] = 'Risposta rapida';
$txt['quick_reply_warning'] = 'Attenzione! Il topic è bloccato, solo amministratori e moderatori possono aggiungere risposte.';
$txt['quick_reply_verification'] = 'Dopo l\'invio sarai reindirizzato alla pagina del post per verificarlo %1$s.';
$txt['quick_reply_verification_guests'] = '(richiesta per tutti i visitatori)';
$txt['quick_reply_verification_posts'] = '(richiesta per tutti gli utenti con meno di %1$d post)';
$txt['wait_for_approval'] = 'Nota: questo post verrà visualizzato solamente dopo essere stato approvato da un moderatore.';

$txt['notification_enable_board'] = 'Sei sicuro di voler attivare le notifiche per i nuovi topic aperti in questa sezione?';
$txt['notification_disable_board'] = 'Sei sicuro di voler disattivare le notifiche per i nuovi topic aperti in questa sezione?';
$txt['notification_enable_topic'] = 'Sei sicuro di voler attivare le notifiche per i nuovi post aggiunti a questo topic?';
$txt['notification_disable_topic'] = 'Sei sicuro di voler disattivare le notifiche per i nuovi post aggiunti a questo topic?';

$txt['report_to_mod'] = 'Segnala post';
$txt['issue_warning'] = 'Emetti un avviso';
$txt['issue_warning_post'] = 'Notifica un richiamo per questo post';

$txt['like_post'] = 'Mi Piace';
$txt['unlike_post'] = 'Non Mi piace';
$txt['likes'] = 'Mi Piace';
$txt['liked_by'] = 'Apprezzato da:';
$txt['liked_you'] = 'Te';
$txt['liked_more'] = 'altri';
$txt['likemsg_are_you_sure'] = 'Ti piace questo messaggio, sei sicuro di voler rimuovere il tuo mi piace?';

$txt['unread_topics_visit'] = 'Topic recenti non letti';
$txt['unread_topics_visit_none'] = 'Nessun topic non letto dalla tua ultima visita. <a href="{unread_all_url}" class="linkbutton">Clicca qui per vedere i topic non letti</a>';
$txt['unread_topics_all'] = 'Tutti i topic non letti';
$txt['unread_replies'] = 'Topic aggiornati';

$txt['who_title'] = 'Chi è collegato';
$txt['who_and'] = ' e ';
$txt['who_viewing_topic'] = ' stanno visualizzando questo topic.';
$txt['who_viewing_board'] = ' stanno visualizzando questa sezione.';
$txt['who_member'] = 'Utente';

// Current footer strings
$txt['valid_html'] = 'HTML 5 Valido';
$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Visitatore';
$txt['guests'] = 'Visitatori';
$txt['user'] = 'Utente';
$txt['users'] = 'Utenti';
$txt['hidden'] = 'Nascosto';
// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Nascosto';
$txt['buddy'] = 'Amico';
$txt['buddies'] = 'Amici';
$txt['most_online_ever'] = 'Record assoluto di presenze';
$txt['most_online_today'] = 'Record odierno di presenze';

$txt['merge_select_target_board'] = 'Scegliere la sezione di destinazione per il topic unito';
$txt['merge_select_poll'] = 'Scegliere quale sondaggio dovrà avere il topic unito';
$txt['merge_topic_list'] = 'Scegliere i topic da unire';
$txt['merge_select_subject'] = 'Scegliere l\'oggetto per il topic unito';
$txt['merge_custom_subject'] = 'Oggetto personalizzato';
$txt['merge_enforce_subject'] = 'Modifica l\'oggetto di tutti i post';
$txt['merge_include_notifications'] = 'Includi le notifiche?';
$txt['merge_check'] = 'Unisci?';
$txt['merge_no_poll'] = 'Nessun sondaggio';

$txt['response_prefix'] = 'Re:';
$txt['current_icon'] = 'Icona attuale';
$txt['message_icon'] = 'Icona del post';

$txt['smileys_current'] = 'Pacchetto di emoticon corrente';
$txt['smileys_none'] = 'Nessuna emoticon';
$txt['smileys_forum_board_default'] = 'Predefinito del forum/sezione';

$txt['search_results'] = 'Risultati ricerca';

$txt['totalTimeLogged2'] = ' giorni, ';
$txt['totalTimeLogged3'] = ' ore e ';
$txt['totalTimeLogged4'] = ' minuti.';
$txt['totalTimeLogged5'] = 'g ';
$txt['totalTimeLogged6'] = 'ore';
$txt['totalTimeLogged7'] = 'minuti';

$txt['approve_thereis'] = 'C\'è'; //Deprecated
$txt['approve_thereare'] = 'Ci sono'; //Deprecated
$txt['approve_member'] = 'un utente'; //Deprecated
$txt['approve_members'] = 'utenti'; //Deprecated
$txt['approve_members_waiting'] = 'in attesa di approvazione.'; //Deprecated
$txt['approve_one_member_waiting'] = 'C\'è <a href="%1$s">un membro</a> in attesa di approvazione.';
$txt['approve_many_members_waiting'] = 'Ci sono <a href="%1$s">%2$d membri</a> in attesa di approvazione.';

$txt['notifyboard_turnon'] = 'Sei sicuro di voler ricevere una notifica quando viene aperto un nuovo topic in questa sezione?';
$txt['notifyboard_turnoff'] = 'Sei sicuro di non voler ricevere le notifiche per i nuovi topic aperti in questa sezione?';

$txt['notify_unsubscribed_generic'] = 'specificato';
$txt['notify_board_unsubscribed'] = 'L\'email, %2$s, è stata disiscritta con successo e non riceverà più notifiche dal tavolo %1$s.';
$txt['notify_topic_unsubscribed'] = 'L\'email, %2$s, è stata disiscritta con successo e non riceverà più notifiche sul topic %1$s.';
$txt['notify_mention_unsubscribed'] = 'L\'email, %2$s, è stata disiscritta con successo e non riceverà più notifiche "%1$s".';
$txt['notify_default_unsubscribed'] = 'La tua richiesta è stata elaborata con successo.';

$txt['find_members'] = 'Cerca un utente';
$txt['find_username'] = 'Nome, nome utente o indirizzo e-mail';
$txt['find_buddies'] = 'Mostrare solo gli amici?';
$txt['find_wildcards'] = 'Caratteri jolly consentiti: *, ?';
$txt['find_no_results'] = 'Nessuna corrispondenza trovata';
$txt['all_caught_up'] = 'Sei a posto!';
$txt['find_results'] = 'Risultati';
$txt['find_close'] = 'Chiudi';

$txt['quickmod_delete_selected'] = 'Elimina selezionati';
$txt['quickmod_split_selected'] = 'Dividi selezione';

$txt['show_personal_messages_heading'] = 'Nuovi messaggi';
$txt['show_personal_messages'] = 'Hai <strong>%1$s</strong> messaggi personali non letti nella tua casella di posta.<br /><br /><a href="%2$s">Vai alla tua casella di posta</a>';

$txt['help_popup'] = 'Ti sei perso? Permettimi di spiegare:';

$txt['previous_next_back'] = 'Topic precedente';
$txt['previous_next_forward'] = 'Topic seguente';

$txt['upshrink_description'] = 'Riduce o espande la testata.';

$txt['mark_unread'] = 'Marca come non letto';

$txt['ssi_not_direct'] = 'Non accedere al file SSI.php tramite URL diretto; utilizzare il percorso(%1$s) o aggiungere ?ssi_function=qualcosa.';
$txt['ssi_session_broken'] = 'SSI.php non è riuscito a caricare la sessione! Questo potrebbe provocare lcuni problemi nella disconnessione e in altre funzioni - assicurarsi che SSI.php sia incluso prima di *qualsiasi* altra cosa negli script!';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Anteprima post';
$txt['preview_fetch'] = 'Recupero anteprima...';
$txt['pm_error_while_submitting'] = 'I seguenti errori sono avvenuti durante l\'invio dell\'MP.';
$txt['warning_while_submitting'] = 'È successo qualcosa, controlla qui:';
$txt['error_while_submitting'] = 'Il messaggio ha il/i seguenti errore/i che devono essere corretti prima di continuare:';
$txt['error_old_topic'] = 'Attenzione: questo argomento non è stato pubblicato per almeno %1$d giorni.<br />A meno che tu non sia sicuro di voler rispondere, ti preghiamo di considerare di iniziare un nuovo argomento.';

$txt['split_selected_posts'] = 'Post selezionati';
$txt['split_selected_posts_desc'] = 'I post qui sotto formeranno un nuovo topic dopo la divisione.';
$txt['split_reset_selection'] = 'azzera selezione';

$txt['modify_cancel'] = 'Annulla';
$txt['mark_read_short'] = 'Marca come letti';

$txt['hello_member_ndt'] = 'Salve';

$txt['unapproved_posts'] = 'Post non approvati (Topic: %1$d, Post: %2$d) ';

$txt['ajax_in_progress'] = 'Caricamento...';
$txt['ajax_bad_response'] = 'Risposta non valida';

$txt['mod_reports_waiting'] = 'Sono presenti attualmente %1$d segnalazioni aperte.';
$txt['pm_reports_waiting'] = 'Attualmente ci sono %1$d segnalazioni di messaggi personali aperte.';

$txt['new_posts_in_category'] = 'Clicca per vedere i nuovi post in %1$s';
$txt['verification'] = 'Verifica';
$txt['visual_verification_hidden'] = 'Lascia questa casella vuota';
$txt['visual_verification_description'] = 'Digita le lettere visualizzate nell\'immagine';
$txt['visual_verification_request_new'] = 'Carica una nuova immagine';

// @todo Send email strings - should move?
$txt['send_email'] = 'Spedisci email';
$txt['send_email_disclosed'] = 'Nota: sarà visibile al destinatario.';
$txt['send_email_subject'] = 'Oggetto e-mail';

$txt['ignoring_user'] = 'Stai ignorando questo utente.';
$txt['show_ignore_user_post'] = '<em>[Mostrami il post.]</em>';

$txt['spider'] = 'Crawler';
$txt['spiders'] = 'Crawler';

$txt['downloads'] = 'Download';
$txt['filesize'] = 'Dimensione file';

// Restore topic
$txt['restore_topic'] = 'Ripristina topic';
$txt['restore_message'] = 'Ripristina';
$txt['quick_mod_restore'] = 'Ripristina selezionati';

// Editor prompt.
$txt['prompt_text_email'] = 'Inserisci l\'indirizzo e-mail.';
$txt['prompt_text_ftp'] = 'Inserisci l\'indirizzo FTP.';
$txt['prompt_text_url'] = 'Inserisci il collegamento da aggiungere.';
$txt['prompt_text_img'] = 'Inserisci il percorso dell\'immagine';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Rimuovi elemento';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Template:';
$txt['debug_sub_templates'] = 'Sotto-template:';
$txt['debug_language_files'] = 'File di traduzione:';
$txt['debug_sheets'] = 'Fogli di stile:';
$txt['debug_javascript'] = 'Script: ';
$txt['debug_files_included'] = 'File inclusi:';
$txt['debug_kb'] = 'KB.';
$txt['debug_show'] = 'mostra';
$txt['debug_cache_hits'] = 'Accessi alla cache:';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s byte';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss per %2$s byte';
$txt['debug_queries_used'] = 'Interrogazioni utilizzate: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Interrogazioni utilizzate: %1$d, %2$d avvisi.';
$txt['debug_query_in_line'] = 'in <em>%1$s</em> riga <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'che ha impiegato %1$s secondi.';
$txt['debug_query_which_took_at'] = 'che ha impiegato %1$s secondi a %2$s nella richiesta.';
$txt['debug_show_queries'] = '[Visualizza Interrogazioni] ';
$txt['debug_hide_queries'] = '[Nascondi Interrogazioni] ';
$txt['debug_tokens'] = 'Token: ';
$txt['debug_browser'] = 'ID Browser';
$txt['debug_hooks'] = 'Chiamate Hooks:';
$txt['debug_system_type'] = 'Sistema:';
$txt['debug_server_load'] = 'Carico server:';
$txt['debug_script_mem_load'] = 'Utilizzo memoria degli script:';
$txt['debug_script_cpu_load'] = 'Velocità script CPU (utente/sistema):';

// Video embedding
$txt['preview_image'] = 'Anteprima fotogramma del video';
$txt['ctp_video'] = 'Clicca per riprodurre il video';
$txt['hide_video'] = 'Mostra/Nascondi video';
$txt['youtube'] = 'YouTube:';
$txt['vimeo'] = 'Vimeo:';
$txt['dailymotion'] = 'Dailymotion:';
$txt['tiktok'] = 'TikTok:';
$txt['twitter'] = 'X/Twitter:';
$txt['facebook'] = 'Facebook:';
$txt['instagram'] = 'Instagram:';

// Spoiler BBC
$txt['spoiler'] = 'Spoiler (clicca per mostrare/nascondere)';

$txt['ok_uppercase'] = 'OK';

// Title of box for warnings that admins should see
$txt['admin_warning_title'] = 'Avviso';

$txt['via'] = 'tramite';

$txt['like_post_stats'] = 'Statistiche "Mi Piace"';

$txt['otp_token'] = 'Password usa e getta';
$txt['otp_enabled'] = 'Abilita l\'autenticazione a due fattori';
$txt['invalid_otptoken'] = 'La Password usa e getta basata sul tempo non è valida';
$txt['otp_used'] = 'La Password usa e getta basata sul tempo è già stata utilizzata.<br /> Per favore, aspetta un momento e usa il codice successivo.';
$txt['otp_generate'] = 'Genera';
$txt['otp_show_qr'] = 'Visualizza QR-Code';

$txt['other'] = 'Altro';

$txt['retry'] = 'RIPROVA';
$txt['check_connection'] = 'Per favore, controlla la tua connessione internet';
