<?php
// Version: 2.0; index

global $forum_copyright;

// Locale (strftime, pspell_new) and spelling.
// For more information see:
//   - https://www.php.net/function.pspell-new
//   - https://www.php.net/function.setlocale
$txt['lang_locale'] = 'pl_PL.utf8';
$txt['lang_dictionary'] = 'pl';
$txt['lang_spelling'] = 'polish';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set and right to left?
$txt['lang_rtl'] = false;
// Capitalize day and month names?
$txt['lang_capitalize_dates'] = true;
// Number format.
$txt['number_format'] = '1 234,00';

$txt['sunday'] = 'Niedziela';
$txt['monday'] = 'Poniedziałek';
$txt['tuesday'] = 'Wtorek';
$txt['wednesday'] = 'Środa';
$txt['thursday'] = 'Czwartek';
$txt['friday'] = 'Piątek';
$txt['saturday'] = 'Sobota';

$txt['sunday_short'] = 'Niedz.';
$txt['monday_short'] = 'Pon.';
$txt['tuesday_short'] = 'Wt.';
$txt['wednesday_short'] = 'Śr.';
$txt['thursday_short'] = 'Czw.';
$txt['friday_short'] = 'Pt.';
$txt['saturday_short'] = 'Sob.';

$txt['january'] = 'Styczeń';
$txt['february'] = 'Luty';
$txt['march'] = 'Marzec';
$txt['april'] = 'Kwiecień';
$txt['may'] = 'Maj';
$txt['june'] = 'Czerwiec';
$txt['july'] = 'Lipiec';
$txt['august'] = 'Sierpień';
$txt['september'] = 'Wrzesień';
$txt['october'] = 'Październik';
$txt['november'] = 'Listopad';
$txt['december'] = 'Grudzień';

$txt['january_titles'] = 'Styczeń';
$txt['february_titles'] = 'Luty';
$txt['march_titles'] = 'Marzec';
$txt['april_titles'] = 'Kwiecień';
$txt['may_titles'] = 'Maj';
$txt['june_titles'] = 'Czerwiec';
$txt['july_titles'] = 'Lipiec';
$txt['august_titles'] = 'Sierpień';
$txt['september_titles'] = 'Wrzesień';
$txt['october_titles'] = 'Październik';
$txt['november_titles'] = 'Listopad';
$txt['december_titles'] = 'Grudzień';

$txt['january_short'] = 'Sty';
$txt['february_short'] = 'Lut';
$txt['march_short'] = 'Mar';
$txt['april_short'] = 'Kwi';
$txt['may_short'] = 'Maj';
$txt['june_short'] = 'Cze';
$txt['july_short'] = 'Lip';
$txt['august_short'] = 'Sie';
$txt['september_short'] = 'Wrz';
$txt['october_short'] = 'Paź';
$txt['november_short'] = 'Lis';
$txt['december_short'] = 'Gru';

$txt['time_am'] = 'rano';
$txt['time_pm'] = 'wieczorem';

// Let's get all the main menu strings in one place.
$txt['main_menu'] = 'Menu główne';
$txt['home'] = 'Strona główna';
$txt['community'] = 'Forum';
$txt['forum'] = 'Forum';

// Sub menu labels
$txt['help'] = 'Pomoc';
$txt['search'] = 'Szukaj';
$txt['calendar'] = 'Kalendarz';
$txt['members'] = 'Użytkownicy';
$txt['recent_posts'] = 'Najnowsze wiadomości';
$txt['recent_topics'] = 'Najnowsze tematy';

$txt['admin'] = 'Administracja';
// Sub menu labels
$txt['errlog'] = 'Log błędów';
$txt['package'] = 'Menedżer dodatków';
$txt['edit_permissions'] = 'Zezwolenia';
$txt['modSettings_title'] = 'Właściwości i opcje';
$txt['pwa_label'] = 'Aplikacja internetowa';

$txt['moderate'] = 'Moderuj';
// Sub menu labels
$txt['modlog_view'] = 'Raport moderacji';
$txt['mc_emailerror'] = 'Niezatwierdzone wiadomości email';
$txt['mc_reported_posts'] = 'Raportowane wiadomości';
$txt['mc_reported_pms'] = 'Zgłoszone wiadomości prywatne';
$txt['mc_unapproved_attachments'] = 'Niezatwierdzone załączniki';
$txt['mc_unapproved_poststopics'] = 'Niezatwierdzone wiadomości i tematy';

$txt['pm_short'] = 'Moje wiadomości';
// Sub menu labels
$txt['pm_menu_read'] = 'Przeczytaj wiadomości';
$txt['pm_menu_send'] = 'Wyślij wiadomość';

$txt['account_short'] = 'Moje konto';
// Sub menu labels
$txt['profile'] = 'Profil';
$txt['mydrafts'] = 'Moje szkice';
$txt['summary'] = 'Podsumowanie';
$txt['theme'] = 'Opcje wyglądu';
$txt['account'] = 'Ustawienia konta';
$txt['forumprofile'] = 'Profil forum';

$txt['view_unread_category'] = 'Nowe wiadomości';
$txt['view_replies_category'] = 'Nowe odpowiedzi';

$txt['login'] = 'Zaloguj się';
$txt['register'] = 'Rejestracja';
$txt['logout'] = 'Wyloguj się';
// End main menu strings.

$txt['save'] = 'Zapisz';

$txt['modify'] = 'Edytuj';
$txt['forum_index'] = '%1$s - Strona główna';
$txt['board_name'] = 'Nazwa działu';
$txt['posts'] = 'Wiadomości';

$txt['member_postcount'] = 'Wiadomości';
$txt['no_subject'] = '(Bez tematu)';
$txt['view_profile'] = 'Zobacz profil';
$txt['guest_title'] = 'Gość';
$txt['author'] = 'Autor';
$txt['on'] = 'w';
$txt['remove'] = 'Usuń';
$txt['start_new_topic'] = 'Rozpocznij nowy temat';

// Use numeric entities in the below string.
$txt['username'] = 'Nazwa użytkownika';
$txt['password'] = 'Hasło';

$txt['username_no_exist'] = 'Nazwa użytkownika nie istnieje.';
$txt['no_user_with_email'] = 'Brak użytkowników powiązanych z tym adresem email.';

$txt['board_moderator'] = 'Moderator działu';
$txt['remove_topic'] = 'Usuń';
$txt['topics'] = 'Tematy';
$txt['modify_msg'] = 'Edytuj wiadomość';
$txt['name'] = 'Nazwa';
$txt['email'] = 'Email';
$txt['user_email_address'] = 'Adres email';
$txt['subject'] = 'Tytuł';
$txt['message'] = 'Wiadomość';
$txt['redirects'] = 'Przekierowań';

$txt['choose_pass'] = 'Wybierz hasło';
$txt['verify_pass'] = 'Potwierdź hasło';
$txt['position'] = 'Pozycja';
$txt['notify_announcements'] = 'Zapisz się, aby otrzymywać ważne wiadomości ze strony na email';

$txt['profile_of'] = 'Zobacz profil';
$txt['total'] = 'W sumie';
$txt['posts_made'] = 'Wiadomości';
$txt['topics_made'] = 'Tematy';
$txt['website'] = 'Strona internetowa';
$txt['contact'] = 'Kontakt';
$txt['warning_status'] = 'Status ostrzeżenia';
$txt['user_warn_watch'] = 'Użytkownik jest na liście obserwowanych';
$txt['user_warn_moderate'] = 'Wiadomości użytkownika wymagają zatwierdzenia';
$txt['user_warn_mute'] = 'Użytkownik jest zbanowany i nie może wysyłać wiadomości';
$txt['warn_watch'] = 'Obserwowany';
$txt['warn_moderate'] = 'Moderowany';
$txt['warn_mute'] = 'Wyciszony';
$txt['warning_issue'] = 'Dodaj ostrzeżenie';

$txt['message_index'] = 'Indeks wiadomości';
$txt['news'] = 'Aktualności';
$txt['page'] = 'Strona';
$txt['prev'] = 'poprzedni';
$txt['next'] = 'następny';

$txt['post'] = 'Wyślij';
$txt['error_occurred'] = 'Wystąpił błąd';
$txt['send_error_occurred'] = 'Wystąpił błąd, <a href="{href}">kliknij tutaj, aby spróbować ponownie</a>.';
$txt['require_field'] = 'To pole jest wymagane.';
$txt['started_by'] = 'Rozpoczęty przez';
$txt['topic_started_by'] = 'Rozpoczęty przez %1$s';
$txt['topic_started_by_in'] = 'Rozpoczęty przez %1$s w %2$s';
$txt['replies'] = 'Odpowiedzi';
$txt['last_post'] = 'Ostatnia wiadomość';
$txt['first_post'] = 'Pierwsza wiadomość';
$txt['last_poster'] = 'Autor ostatniej wiadomości';

$txt['last_post_message'] = '<span class="lastpost_link">%2$s </span><span class="board_lastposter">przez %1$s</span><span class="board_lasttime"><strong>Ostatnia wiadomość: </strong>%3$s</span>';
$txt['boardindex_total_posts'] = 'Wiadomości: %1$s, Tematów: %2$s, Użytkowników: %3$s';
$txt['show'] = 'Pokaż';
$txt['hide'] = 'Ukryj';
$txt['sort_by'] = 'Sortuj według';
$txt['sort_asc'] = 'Sortuj rosnąco';
$txt['sort_desc'] = 'Sortuj malejąco';

$txt['admin_login'] = 'Logowanie do administracji';
// Use numeric entities in the below string.
$txt['topic'] = 'Temat';
$txt['notify'] = 'Powiadamiaj';
$txt['unnotify'] = 'Przestań śledzić';
$txt['notify_request'] = 'Chcesz otrzymywać powiadomienia o nowych odpowiedziach w tym temacie?';
// Use numeric entities in the below string.
$txt['regards_team'] = "Regards,\nThe {forum_name_html_unsafe} Team.";
$txt['notify_replies'] = 'Powiadamiaj o odpowiedziach';
$txt['move_topic'] = 'Przenieś';
$txt['move_to'] = 'Przenieś do';
$txt['pages'] = 'Strony';
$txt['users_active'] = 'Aktywni w ciągu ostatnich %1$d minut';
$txt['personal_messages'] = 'Prywatne wiadomości';
$txt['reply_quote'] = 'Odpowiedz z cytatem';
$txt['reply'] = 'Odpowiedź';
$txt['reply_number'] = 'Odpowiedź #%1$s';
$txt['approve'] = 'Zatwierdź';
$txt['unapprove'] = 'Odrzuć';
$txt['approve_all'] = 'zatwierdź wszystko';
$txt['awaiting_approval'] = 'Oczekujące na zatwierdzenie';
$txt['attach_awaiting_approve'] = 'Załączniki oczekujące na zatwierdzenie';
$txt['post_awaiting_approval'] = 'Informacja: Ta wiadomość oczekuje na zatwierdzenie przez moderatora.';
$txt['there_are_unapproved_topics'] = '%1$s tematy i %2$s wiadomości oczekują na zatwierdzenie w tym dziale. Aby je wyświetlić kliknij <a href="%3$s">tutaj</a>.';
$txt['send_message'] = 'Wyślij wiadomość';

$txt['msg_alert_no_messages'] = 'nie masz żadnych wiadomości';
$txt['msg_alert_one_message'] = 'masz <a href="%1$s">1 wiadomość</a>';
$txt['msg_alert_many_message'] = 'masz <a href="%1$s">%2$d wiadomości</a>';
$txt['msg_alert_one_new'] = '1 jest nowa';
$txt['msg_alert_many_new'] = '%1$d są nowe';
$txt['remove_message'] = 'Usuń tą wiadomość';

$txt['topic_alert_none'] = 'Brak wiadomości...';
$txt['pm_alert_none'] = 'Brak wiadomości...';

$txt['online_users'] = 'Zalogowani użytkownicy'; //Deprecated
$txt['online_now'] = 'Teraz na forum';
$txt['personal_message'] = 'Prywatne wiadomości';
$txt['jump_to'] = 'Przejdź do';
$txt['go'] = 'Idź';
$txt['are_sure_remove_topic'] = 'Na pewno chcesz usunąć ten temat?';
$txt['yes'] = 'Tak';
$txt['no'] = 'Nie';

// @todo this string seems a good candidate for deprecation
$txt['search_on'] = 'w';

$txt['all'] = 'Wszystkie';
$txt['search_entireforum'] = 'Całe forum';
$txt['search_thisbrd'] = 'Ten dział';
$txt['search_thistopic'] = 'Ten temat';
$txt['search_members'] = 'Użytkownicy';

$txt['back'] = 'Wróć';
$txt['continue'] = 'Kontynuuj';
$txt['password_reminder'] = 'Przypomnienie hasła';
$txt['topic_started'] = 'Temat zaczęty przez';
$txt['title'] = 'Tytuł';
$txt['post_by'] = 'Wysłane przez';
$txt['welcome_newest_member'] = 'Przywitajmy %1$s, naszego najnowszego użytkownika.';
$txt['admin_center'] = 'Centrum administracji';
$txt['admin_session_active'] = 'Aktywna jest sesja administracyjna. Zalecamy <strong><a class="strong" href="%1$s">wyłączenie</a></strong> jej po zakończeniu czynności administracyjnych.';
$txt['admin_maintenance_active'] = 'Forum znajduje się w trybie konserwacji, jedynie administratorzy mogą się zalogować. Pamiętaj, aby <strong><a class="strong" href="%1$s">wyłączyć</a></strong> ten tryb po zakończeniu czynności administracyjnych.';
$txt['query_command_denied'] = 'Wystąpiły następujące błędy MySQL, sprawdź swoje ustawienia:';
$txt['query_command_denied_guests'] = 'Wygląda na to, że coś poszło nie tak w bazie danych. Ten problem powinien być tylko tymczasowy. Jeśli nadal będzie się pojawiał ten komunikat, skontaktuj się z administratorem.';
$txt['query_command_denied_guests_msg'] = 'nie można wykonać komendy %1$s w bazie danych';
$txt['last_edit_by'] = '<span class="lastedit">Ostatnia zmiana</span>: %1$s przez %2$s';
$txt['notify_deactivate'] = 'Chcesz wyłączyć powiadomienia z tego tematu?';

$txt['date_registered'] = 'Data rejestracji';
$txt['date_joined'] = 'Dołączył';
$txt['date_joined_format'] = '%b %d, %Y';
$txt['last_seen'] = 'Ostatnio widziany';

$txt['recent_view'] = 'Pokaż wszystkie najnowsze wiadomości';
$txt['is_recent_updated'] = '%1$s jest najbardziej aktualnym tematem';

$txt['male'] = 'Mężczyzna';
$txt['female'] = 'Kobieta';

$txt['error_invalid_characters_username'] = 'W nazwie użytkownika użyto niedozwolonego znaku.';

$txt['welcome_guest'] = 'Witamy, <strong>Gościu</strong>. Proszę <a href="{login_url}" rel="nofollow">zalogować się</a>.';
$txt['welcome_guest_register'] = 'Witamy w <strong>{forum_name}</strong>. Proszę <a href="{login_url}" rel="nofollow">zalogować się</a> lub <a href="{register_url}" rel="nofollow">zarejestrować</a>.';
$txt['welcome_guest_activate'] = '<br />Czy przegapiłeś swój <a href="{activate_url}" rel="nofollow">email aktywacyjny</a>?';
$txt['welcome_register'] = 'Nie masz konta?';

// @todo the following to sprintf
$txt['hello_member'] = 'Hej,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Witamy,';
$txt['select_destination'] = 'Wybierz cel';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Wysłany przez';

$txt['icon_smiley'] = 'Uśmiech';
$txt['icon_angry'] = 'Zły';
$txt['icon_cheesy'] = 'Chichot';
$txt['icon_laugh'] = 'Śmiech';
$txt['icon_sad'] = 'Smutny';
$txt['icon_wink'] = 'Mrugnięcie';
$txt['icon_grin'] = 'Duży uśmiech';
$txt['icon_shocked'] = 'Szok';
$txt['icon_cool'] = 'Spoko';
$txt['icon_huh'] = 'Co?';
$txt['icon_rolleyes'] = 'Z politowaniem';
$txt['icon_tongue'] = 'Język';
$txt['icon_embarrassed'] = 'Zawstydzony';
$txt['icon_lips'] = 'Buzia na kłódkę';
$txt['icon_undecided'] = 'Niezdecydowany';
$txt['icon_kiss'] = 'Buziak';
$txt['icon_cry'] = 'Płacz';
$txt['icon_angel'] = 'Niewinny';

$txt['moderator'] = 'Moderatorskie';
$txt['moderators'] = 'Moderatorzy';

$txt['views'] = 'Wyświetleń';
$txt['new'] = 'Nowy';
$txt['no_redir'] = 'Przekierowano z %1$s';

$txt['view_all_members'] = 'Zobacz wszystkich użytkowników';
$txt['view'] = 'Zobacz';

$txt['viewing_members'] = 'Przeglądanie użytkowników %1$s do %2$s';
$txt['of_total_members'] = 'z %1$s wszystkich użytkowników';

$txt['forgot_your_password'] = 'Zapomniałeś hasła?';

$txt['date'] = 'Data';
// Use numeric entities in the below string.
$txt['from'] = 'Od';
$txt['to'] = 'Do';

$txt['board_topics'] = 'Tematy';
$txt['members_title'] = 'Użytkownicy';
$txt['members_list'] = 'Lista użytkowników';
$txt['new_posts'] = 'Nowe wiadomości';
$txt['old_posts'] = 'Brak nowych wiadomości';
$txt['redirect_board'] = 'Przekierowanie';
$txt['redirect_board_to'] = 'Przekierowywanie do %1$s';

$txt['sendtopic_send'] = 'Wyślij';
$txt['report_sent'] = 'Twój raport został wysłany pomyślnie.';
$txt['topic_sent'] = 'Twój email został wysłany pomyślnie.';

$txt['time_offset'] = 'Przesunięcie czasu';
$txt['or'] = 'lub';

$txt['mention'] = 'Oznaczenia';
$txt['notifications'] = 'Powiadomienia';
$txt['unread_notifications'] = 'Masz %1$s nieprzeczytanych powiadomień od ostatniej wizyty.';
$txt['new_from_last_notifications'] = 'Masz %1$s nowych powiadomień.';
$txt['forum_notification'] = 'Powiadomienia od %1$s.';

$txt['your_ban'] = 'Przepraszamy %1$s, zostałeś zbanowany na tym forum!';
$txt['your_ban_expires'] = 'Twój ban wygaśnie %1$s.';
$txt['your_ban_expires_never'] = 'Twój ban nie wygaśnie.';
$txt['ban_continue_browse'] = 'Możesz kontynuować przeglądanie forum jako gość.';

$txt['mark_as_read'] = 'Oznacz tematy jako przeczytane';
$txt['mark_as_read_confirm'] = 'Czy na pewno chcesz oznaczyć WSZYSTKIE wiadomości jako przeczytane?';
$txt['mark_these_as_read'] = 'Oznacz tematy jako przeczytane';
$txt['mark_these_as_read_confirm'] = 'Czy na pewno chcesz oznaczyć TE wiadomości jako przeczytane?';

$txt['locked_topic'] = 'Zamknięty temat';
$txt['normal_topic'] = 'Normalny temat';
$txt['participation_caption'] = 'Temat w którym uczestniczyłeś';

$txt['print'] = 'Drukuj';
$txt['topic_summary'] = 'Podgląd tematu';
$txt['not_applicable'] = 'brak';
$txt['name_in_use'] = 'Nazwa %1$s jest już zajęta przez innego użytkownika.';

$txt['total_members'] = 'Ilość użytkowników';
$txt['total_posts'] = 'Ilość wiadomości';
$txt['total_topics'] = 'Ilość tematów';

$txt['mins_logged_in'] = 'Czas zalogowania (w minutach)';

$txt['preview'] = 'Podgląd';
$txt['always_logged_in'] = 'Bądź zawsze zalogowany';

$txt['logged'] = 'Zapisane';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';

$txt['www'] = 'WWW';
$txt['link'] = 'Link';

$txt['by'] = 'przez'; //Deprecated

$txt['hours'] = 'godzin';
$txt['minutes'] = 'minut';
$txt['seconds'] = 'sekund';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Godzina';
$txt['days_word'] = 'dni';

$txt['newest_member'] = ', nasz najnowszy użytkownik.'; //Deprecated

$txt['search_for'] = 'Szukaj';
$txt['search_match'] = 'Dopasuj';

$txt['maintain_mode_on'] = 'Pamiętaj, forum znajduje się w trybie obsługi.';

$txt['read'] = 'Przeczytany'; //Deprecated
$txt['times'] = 'razy'; //Deprecated
$txt['read_one_time'] = 'Przeczytany 1 raz';
$txt['read_many_times'] = 'Przeczytany %1$d razy';

$txt['forum_stats'] = 'Statystyki forum';
$txt['latest_member'] = 'Najnowszy użytkownik';
$txt['total_cats'] = 'Ilość kategorii';
$txt['latest_post'] = 'Ostatnio wysłane';

$txt['here'] = 'tutaj';
$txt['you_have_no_msg'] = 'Nie masz żadnych wiadomości';
$txt['you_have_one_msg'] = 'Masz 1 wiadomość...<a href="%1$s">Kliknij tutaj, aby ją zobaczyć</a>';
$txt['you_have_many_msgs'] = 'Masz %2$d wiadomości...<a href="%1$s">Kliknij tutaj, aby je zobaczyć</a>';

$txt['total_boards'] = 'Ilość działów';

$txt['print_page'] = 'Drukuj stronę';
$txt['print_page_text'] = 'Tylko tekst';
$txt['print_page_images'] = 'Tekst z obrazkami';

$txt['valid_email'] = 'Podaj prawidłowy adres email.';

$txt['info_center_title'] = '%1$s - Centrum informacji';

$txt['send_topic'] = 'Podziel się';
$txt['unwatch'] = 'Przestań obserwować';
$txt['watch'] = 'Obserwuj';

$txt['allow_user_email'] = 'Zezwól użytkownikom na wysyłanie emaili';

$txt['check_all'] = 'Zaznacz wszystko';

// Use numeric entities in the below string.
$txt['database_error'] = 'Błąd bazy danych';
$txt['try_again'] = 'Spróbuj ponownie. Jeśli powrócisz do tego komunikatu, zgłoś błąd administratorowi.';
$txt['file'] = 'Plik';
$txt['line'] = 'Linia';

// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'ElkArte wykryło i spróbowało automatycznie naprawić błąd w bazie danych. Jeśli nadal będziesz napotykał problemy lub otrzymywał te wiadomości skontaktuj się z właścicielem serwera.';
$txt['database_error_versions'] = '<strong>Uwaga:</strong> Twoja wersja bazy danych to %1$s.';
$txt['template_parse_error'] = 'Błąd parsowania stylu!';
$txt['template_parse_error_message'] = 'Wygląda na to, że coś poszło nie tak w systemie stylów. Ten problem powinien być tylko tymczasowy. Jeśli nadal będzie się pojawiał ten komunikat, skontaktuj się z administratorem.<br /><br />Możesz również spróbować <a href="javascript:location.reload();">odświeżyć tę stronę</a>.';
$txt['template_parse_error_details'] = 'Wystąpił błąd podczas ładowania szablonu <span class="tt"><strong>%1$s</strong></span> lub pliku języka. Sprawdź składnię pliku i spróbuj ponownie - pamiętaj, że znak pojedynczego cytatu(<span class="tt">\'</span>) zazwyczaj musi być poprzedzony ukośnikiem (<span class="tt">\</span>). Jeśli chcesz zobaczyć bardziej szczegółowe informacje na temat błędu spróbuj <a href="%2$s%1$s">otworzyć plik bezpośrednio</a>.<br /><br />Możesz również spróbować <a href="javascript:location.reload();">odświeżyć tą stronę</a> lub <a href="%3$s">użyć domyślnego stylu</a>.';
$txt['template_parse_undefined'] = 'Wystąpił niezidentyfikowany błąd podczas parsowania szablonu';

$txt['today'] = 'Dzisiaj o %1$s';
$txt['yesterday'] = 'Wczoraj o %1$s';

// Relative times
$txt['rt_now'] = 'przed chwilą';
$txt['rt_minute'] = 'Minutę temu';
$txt['rt_minutes'] = '%s minut temu';
$txt['rt_hour'] = 'Godzinę temu';
$txt['rt_hours'] = '%s godzin temu';
$txt['rt_day'] = 'Dzień temu';
$txt['rt_days'] = '%s dni temu';
$txt['rt_week'] = 'Tydzień temu';
$txt['rt_weeks'] = '%s tygodni(e) temu';
$txt['rt_month'] = 'Miesiąc temu';
$txt['rt_months'] = '%s miesięcy temu';
$txt['rt_year'] = 'Rok temu';
$txt['rt_years'] = '%s lat temu';

$txt['new_poll'] = 'Nowa ankieta';
$txt['poll_question'] = 'Pytanie';
$txt['poll_question_options'] = 'Pytania i opcje';
$txt['poll_vote'] = 'Zagłosuj';
$txt['poll_total_voters'] = 'Ilość głosów';
$txt['draft_saved_on'] = 'Szkic ostatnio zapisany';
$txt['poll_results'] = 'Zobacz wyniki';
$txt['poll_lock'] = 'Zamknij głosowanie';
$txt['poll_unlock'] = 'Otwórz głosowanie';
$txt['poll_edit'] = 'Edytuj ankietę';
$txt['poll'] = 'Ankieta';
$txt['one_day'] = '1 dzień';
$txt['one_week'] = '1 tydzień';
$txt['two_weeks'] = '2 tygodnie';
$txt['one_month'] = '1 miesiąc';
$txt['two_months'] = '2 miesiące';
$txt['forever'] = 'Zawsze';
$txt['quick_login_dec'] = 'Zaloguj się podając nazwę użytkownika, hasło i długość sesji';
$txt['one_hour'] = '1 godzina';
$txt['moved'] = 'PRZENIESIONY';
$txt['moved_why'] = 'Wprowadź krótki opis, tłumaczący<br />powód przeniesienia tematu.';
$txt['board'] = 'Dział';
$txt['in'] = 'w';
$txt['sticky_topic'] = 'Przypięty temat';
$txt['split'] = 'PODZIEL';

$txt['delete'] = 'Usuń';

$txt['byte'] = 'B';
$txt['kilobyte'] = 'KB';
$txt['megabyte'] = 'MB';
$txt['gigabyte'] = 'GB';

$txt['more_stats'] = '[Więcej statystyk]';

$txt['code'] = 'Kod';
$txt['code_select'] = '[Zaznacz]';
$txt['quote_from'] = 'Cytat';
$txt['quote'] = 'Cytuj';
$txt['quick_quote'] = 'Cytuj zaznaczone';
$txt['quote_new'] = 'Nowy temat';
$txt['follow_ups'] = 'Powiązania';
$txt['topic_derived_from'] = 'Temat wydzielony z %1$s';
$txt['edit'] = 'Edytuj';
$txt['quick_edit'] = 'Szybka edycja';
$txt['post_options'] = 'Więcej opcji';
$txt['quote_expand'] = 'Pokaż cytat';

$txt['set_sticky'] = 'Przypnij';
$txt['set_nonsticky'] = 'Odepnij';
$txt['set_lock'] = 'Zablokuj';
$txt['set_unlock'] = 'Odblokuj';

$txt['search_advanced'] = 'Pokaż zaawansowane opcje';
$txt['search_simple'] = 'Ukryj zaawansowane opcje';

$txt['security_risk'] = 'POWAŻNE RYZYKO BEZPIECZEŃSTWA:';
$txt['not_removed'] = 'Nie usunąłeś %1$s';
$txt['not_removed_extra'] = '%1$s jest kopią zapasową %2$s która nie została utworzona przez ElkArte. Można uzyskać do niej bezpośredni dostęp, żeby uzyskać nieautoryzowany dostęp do forum. Powinna natychmiast zostać usunięta.';
$txt['generic_warning'] = 'Ostrzeżenie';
$txt['agreement_missing'] = 'Wymagasz od nowych użytkowników zaakceptowania umowy rejestracyjnej, jednak plik (w sources/ElkArte/Languages/Agreement/) nie istnieje.';
$txt['agreement_accepted'] = 'Właśnie zaakceptowałeś umowę.';
$txt['privacypolicy_accepted'] = 'Właśnie zaakceptowałeś politykę prywatności forum.';

$txt['new_version_updates'] = 'Właśnie zaktualizowałeś!';
$txt['new_version_updates_text'] = '<a href="{admin_url};area=credits#latest_updates">Kliknij tutaj, aby zobaczyć, co nowego w tej wersji ElkArte!</a>!';

$txt['cache_writable'] = 'Nie można zapisywać w katalogu cache - wpływa to niekorzystnie na działanie Twojego forum.';

$txt['page_created_full'] = 'Strona wygenerowana w %1$.3f sekund z %2$d zapytaniami.';

$txt['report_to_mod_func'] = 'Użyj tej funkcji, aby poinformować moderatorów i administratorów o obraźliwym lub błędnie opublikowanym wiadomości.';

$txt['online'] = 'Zalogowany';
$txt['member_is_online'] = '%1$s jest zalogowany';
$txt['offline'] = 'Wylogowany';
$txt['member_is_offline'] = '%1$s nie jest zalogowany';
$txt['pm_online'] = 'Prywatna wiadomość (zalogowany)';
$txt['pm_offline'] = 'Prywatna wiadomość (wylogowany)';
$txt['status'] = 'Status';

$txt['skip_nav'] = 'Przejdź do głównej treści';
$txt['go_up'] = 'Do góry';
$txt['go_down'] = 'Do dołu';

$forum_copyright = '<a href="https://www.elkarte.net" title="ElkArte Forum" target="_blank" class="new_win">Powered by %1$s</a> | <a href="{credits_url}" title="Credits" target="_blank" class="new_win" rel="nofollow">Credits</a>';

$txt['birthdays'] = 'Urodziny:';
$txt['events'] = 'Wydarzenia:';
$txt['birthdays_upcoming'] = 'Nadchodzące urodziny:';
$txt['events_upcoming'] = 'Nadchodzące wydarzenia:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Święta:';
$txt['calendar_month'] = 'Miesiąc:';
$txt['calendar_year'] = 'Rok:';
$txt['calendar_day'] = 'Dzień:';
$txt['calendar_event_title'] = 'Nazwa wydarzenia:';
$txt['calendar_event_options'] = 'Opcje wydarzenia';
$txt['calendar_post_in'] = 'Wyślij w:';
$txt['calendar_edit'] = 'Edytuj wydarzenie';
$txt['event_delete_confirm'] = 'Usunąć to wydarzenie?';
$txt['event_delete'] = 'Usuń wydarzenie';
$txt['calendar_post_event'] = 'Dodaj wydarzenie';
$txt['calendar_link'] = 'Odnośnik do kalendarza';
$txt['calendar_upcoming'] = 'Nadchodzące wydarzenia';
$txt['calendar_today'] = 'Kalendarz na dziś';
$txt['calendar_week'] = 'Tydzień';
$txt['calendar_week_title'] = 'Tydzień %1$d z %2$d ';
$txt['calendar_numb_days'] = 'Liczba dni:';
$txt['calendar_how_edit'] = 'jak edytować wydarzenia?';
$txt['calendar_link_event'] = 'Połącz wydarzenie z wiadomością:';
$txt['calendar_confirm_delete'] = 'Czy na pewno chcesz usunąć to wydarzenie?';
$txt['calendar_linked_events'] = 'Połączone wydarzenia';
$txt['calendar_click_all'] = 'Kliknij, aby zobaczyć wszystkie %1$s';

$txt['moveTopic1'] = 'Wyślij temat przekierowujący';
$txt['moveTopic2'] = 'Zmień tytuł tematu';
$txt['moveTopic3'] = 'Nowy tytuł';
$txt['moveTopic4'] = 'Zmień tytuł każdej wiadomości';
$txt['move_topic_unapproved_js'] = 'Uwaga! Ten temat nie został jeszcze zatwierdzony.\n\nNie jest zalecane abyś przenosił temat, chyba że zamierzasz zaakceptować wiadomości natychmiast po tej czynności.';
$txt['movetopic_auto_board'] = '[DZIAŁ]';
$txt['movetopic_auto_topic'] = '[LINK DO TEMATU]';
$txt['movetopic_default'] = 'Temat został przeniesiony do [DZIAŁ]

[LINK DO TEMATU]';
$txt['movetopic_redirect'] = 'Przekieruj do przeniesionego tematu';
$txt['movetopic_expires'] = 'Automatycznie usuń temat przekierowujący';

$txt['merge_to_topic_id'] = 'ID docelowego tematu';
$txt['split_topic'] = 'Podziel';
$txt['merge'] = 'Połącz';
$txt['subject_new_topic'] = 'Tytuł nowego tematu';
$txt['split_this_post'] = 'Wydziel tylko tą wiadomość.';
$txt['split_after_and_this_post'] = 'Wydziel tą wiadomość i wszystkie nowsze od niej.';
$txt['select_split_posts'] = 'Wybierz wiadomości do wydzielenia.';

$txt['splittopic_notification'] = 'Wyślij wiadomość po podzieleniu tematu';
$txt['splittopic_default'] = 'Przeniesiono jedną lub więcej wiadomości z tego tematu do [DZIAŁ]

[LINK DO TEMATU]';
$txt['splittopic_move'] = 'Przenieś nowy temat do innego działu';

$txt['new_topic'] = 'Nowy temat';
$txt['split_successful'] = 'Temat pomyślnie został podzielony na dwa tematy.';
$txt['origin_topic'] = 'Oryginalny temat';
$txt['please_select_split'] = 'Wybierz, które wiadomości chcesz wydzielić.';
$txt['merge_successful'] = 'Tematy zostały scalone.';
$txt['new_merged_topic'] = 'Nowo scalony temat';
$txt['topic_to_merge'] = 'Temat do scalenia';
$txt['target_board'] = 'Dział docelowy';
$txt['target_topic'] = 'Temat docelowy';
$txt['merge_confirm'] = 'Na pewno chcesz połączyć';
$txt['with'] = 'z';
$txt['merge_desc'] = 'Ta funkcja scali wiadomości z dwóch tematów w jeden. Wiadomości będą posortowane według daty wysłania. Najwcześniej wysłana wiadomość będzie pierwszą wiadomością tematu.';

$txt['theme_template_error'] = 'Nie można załadować szablonu \'%1$s\'.';
$txt['theme_language_error'] = 'Nie można załadować pliku języka \'%1$s\'.';

$txt['parent_boards'] = 'Dział podrzędny';

$txt['smtp_no_connect'] = 'Nie można połączyć się z hostem SMTP';
$txt['smtp_port_ssl'] = 'Błędne ustawienie portu SMTP, powinno być 465 dla serwerów SSL.';
$txt['smtp_bad_response'] = 'Nie można uzyskać odpowiedzi z serwera poczty';
$txt['smtp_error'] = 'Wystąpiły błędy podczas wysyłania poczty. Błąd: ';
$txt['mail_send_unable'] = 'Nie można wysłać wiadomości email na adres \'%1$s\'';

$txt['mlist_search'] = 'Szukaj użytkowników';
$txt['mlist_search_email'] = 'Szukaj według adresu e-mail';
$txt['mlist_search_group'] = 'Szukaj wg pozycji';
$txt['mlist_search_name'] = 'Szukaj wg nazwy';
$txt['mlist_search_website'] = 'Szukaj wg strony WWW';
$txt['mlist_search_results'] = 'Wyniki wyszukiwania';
$txt['mlist_search_by'] = 'Szukaj w %1$s';

$txt['attach_downloaded'] = 'pobrano %1$d razy';
$txt['attach_viewed'] = 'wyświetlono %1$d razy';

$txt['settings'] = 'Ustawienia';
$txt['never'] = 'Nigdy';
$txt['more'] = 'więcej';

$txt['hostname'] = 'Nazwa hosta';
$txt['you_are_post_banned'] = 'Przykro nam %1$s, nie możesz wysyłać nowych wiadomości na tym forum.';
$txt['ban_reason'] = 'Powód';

$txt['add_poll'] = 'Dodaj ankietę';
$txt['poll_options6'] = 'Możesz wybrać maksymalnie %1$s opcji.';
$txt['poll_remove'] = 'Usuń ankietę';
$txt['poll_remove_warn'] = 'Na pewno chcesz usunąć ankietę z tego tematu?';
$txt['poll_results_expire'] = 'Wyniki będą pokazane po zakończeniu głosowania.';
$txt['poll_expires_on'] = 'Głosowanie kończy się';
$txt['poll_expired_on'] = 'Głosowanie skończone';
$txt['poll_change_vote'] = 'Usuń głos';
$txt['poll_return_vote'] = 'Opcje głosowania';
$txt['poll_cannot_see'] = 'Nie możesz obejrzeć wyników głosowania w tej chwili.';

$txt['quick_mod_approve'] = 'Akceptuj zaznaczone';
$txt['quick_mod_remove'] = 'Usuń zaznaczone';
$txt['quick_mod_lock'] = 'Zamknij/otwórz zaznaczone';
$txt['quick_mod_sticky'] = 'Przypnij/odepnij zaznaczone';
$txt['quick_mod_move'] = 'Przenieś zaznaczone do';
$txt['quick_mod_merge'] = 'Połącz zaznaczone';
$txt['quick_mod_markread'] = 'Ustaw zaznaczone jako przeczytane';
$txt['quick_mod_go'] = 'Idź';
$txt['quickmod_confirm'] = 'Czy na pewno chcesz to zrobić?';

$txt['quick_reply'] = 'Szybka odpowiedź';
$txt['quick_reply_warning'] = 'Uwaga: ten temat jest obecnie zamknięty!<br />Tylko administratorzy i moderatorzy mogą wysyłać do niego odpowiedzi.';
$txt['quick_reply_verification'] = 'Po wysłaniu wiadomości zostaniesz przekierowany do regularnej strony wiadomości, aby ją zweryfikować %1$s.';
$txt['quick_reply_verification_guests'] = '(wymagany dla wszystkich gości)';
$txt['quick_reply_verification_posts'] = '(wymagany dla wszystkich użytkowników, który mają mniej niż %1$d postów)';
$txt['wait_for_approval'] = 'Uwaga: ta wiadomość nie zostanie pokazana dopóki nie będzie zaakceptowana przez moderatora.';

$txt['notification_enable_board'] = 'Na pewno chcesz włączyć powiadamianie o nowych tematach w tym dziale?';
$txt['notification_disable_board'] = 'Na pewno chcesz wyłączyć powiadamianie o nowych tematach w tym dziale?';
$txt['notification_enable_topic'] = 'Na pewno chcesz włączyć powiadamianie o nowych odpowiedziach w tym temacie?';
$txt['notification_disable_topic'] = 'Na pewno chcesz wyłączyć powiadamianie o nowych odpowiedziach w tym temacie?';

$txt['report_to_mod'] = 'Raportuj wiadomość';
$txt['issue_warning'] = 'Wydaj ostrzeżenie';
$txt['issue_warning_post'] = 'Daj ostrzeżenie z powodu tej wiadomości';

$txt['like_post'] = 'Lubię to';
$txt['unlike_post'] = 'Nie lubię';
$txt['likes'] = 'Polubienia';
$txt['liked_by'] = 'Lubiane przez:';
$txt['liked_you'] = 'Ciebie';
$txt['liked_more'] = 'więcej';
$txt['likemsg_are_you_sure'] = 'Już polubiłeś tą wiadomość, chcesz przestać ją lubić?';

$txt['unread_topics_visit'] = 'Ostatnie nieprzeczytane tematy';
$txt['unread_topics_visit_none'] = 'Nie masz nieprzeczytanych tematów od ostatniej wizyty. <a href="{unread_all_url}" class="linkbutton">Zobacz listę wszystkich nieprzeczytanych tematów</a>';
$txt['unread_topics_all'] = 'Wszystkie nieprzeczytane tematy';
$txt['unread_replies'] = 'Tematy z nowymi odpowiedziami';

$txt['who_title'] = 'Kto jest zalogowany';
$txt['who_and'] = ' i ';
$txt['who_viewing_topic'] = ' przegląda ten temat.';
$txt['who_viewing_board'] = ' przeglądają ten dział.';
$txt['who_member'] = 'Użytkownik';

// Current footer strings
$txt['valid_html'] = 'Poprawny HTML5';
$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Gość';
$txt['guests'] = 'Goście';
$txt['user'] = 'Użytkownik';
$txt['users'] = 'Użytkowników';
$txt['hidden'] = 'Ukrytych';
// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Ukrytych';
$txt['buddy'] = 'Znajomy';
$txt['buddies'] = 'Znajomi';
$txt['most_online_ever'] = 'Najwięcej na forum';
$txt['most_online_today'] = 'Dziś na forum';

$txt['merge_select_target_board'] = 'Wybierz dział docelowy dla scalonego tematu';
$txt['merge_select_poll'] = 'Wybierz, którą ankietę powinien mieć scalony temat';
$txt['merge_topic_list'] = 'Wybierz tematy do scalenia';
$txt['merge_select_subject'] = 'Wybierz tytuł scalonego tematu';
$txt['merge_custom_subject'] = 'Nowy temat';
$txt['merge_enforce_subject'] = 'Zmień tytuł wszystkich wiadomości';
$txt['merge_include_notifications'] = 'Dołącz powiadomienia?';
$txt['merge_check'] = 'Scalić?';
$txt['merge_no_poll'] = 'Bez ankiety';

$txt['response_prefix'] = 'Odp: ';
$txt['current_icon'] = 'Obecna ikona';
$txt['message_icon'] = 'Ikona wiadomości';

$txt['smileys_current'] = 'Obecny zestaw emotikon';
$txt['smileys_none'] = 'Bez emotikon';
$txt['smileys_forum_board_default'] = 'Domyślne dla tego forum bądź działu';

$txt['search_results'] = 'Wyniki wyszukiwania';

$txt['totalTimeLogged2'] = ' dni, ';
$txt['totalTimeLogged3'] = ' godz. ';
$txt['totalTimeLogged4'] = ' min.';
$txt['totalTimeLogged5'] = 'd';
$txt['totalTimeLogged6'] = 'g ';
$txt['totalTimeLogged7'] = 'm';

$txt['approve_thereis'] = 'Jest'; //Deprecated
$txt['approve_thereare'] = 'Jest'; //Deprecated
$txt['approve_member'] = 'użytkownik'; //Deprecated
$txt['approve_members'] = 'użytkowników'; //Deprecated
$txt['approve_members_waiting'] = 'do zatwierdzenia.'; //Deprecated
$txt['approve_one_member_waiting'] = 'Czeka <a href="%1$s">jeden członek</a> na zatwierdzenie.';
$txt['approve_many_members_waiting'] = 'Czeka <a href="%1$s">%2$d członków</a> na zatwierdzenie.';

$txt['notifyboard_turnon'] = 'Czy chcesz być powiadamianym przez email o nowych tematach w tym dziale?';
$txt['notifyboard_turnoff'] = 'Na pewno nie chcesz być już powiadamianym o nowych tematach w tym dziale?';

$txt['notify_unsubscribed_generic'] = 'określony';
$txt['notify_board_unsubscribed'] = 'Adres e-mail, %2$s, został pomyślnie wypisany i nie będzie już otrzymywał powiadomień z tablicy %1$s.';
$txt['notify_topic_unsubscribed'] = 'Adres e-mail, %2$s, został pomyślnie wypisany i nie będzie już otrzymywał powiadomień na temat %1$s.';
$txt['notify_mention_unsubscribed'] = 'Adres e-mail, %2$s, został pomyślnie wypisany i nie będzie już otrzymywał powiadomień "%1$s".';
$txt['notify_default_unsubscribed'] = 'Twoja prośba została pomyślnie przetworzona.';

$txt['find_members'] = 'Znajdź użytkowników';
$txt['find_username'] = 'Nazwa użytkownika lub adres email';
$txt['find_buddies'] = 'Pokaż tylko znajomych?';
$txt['find_wildcards'] = 'Dozwolone znaki: *, ?';
$txt['find_no_results'] = 'Nic nie znaleziono';
$txt['all_caught_up'] = 'Masz wszystko za sobą!';
$txt['find_results'] = 'Wyniki';
$txt['find_close'] = 'Zamknij';

$txt['quickmod_delete_selected'] = 'Usuń zaznaczone';
$txt['quickmod_split_selected'] = 'Podziel zaznaczone';

$txt['show_personal_messages_heading'] = 'Nowe wiadomości';
$txt['show_personal_messages'] = 'Masz <strong>%1$s</strong> nieprzeczytanych wiadomości prywatnych w swojej skrzynce odbiorczej.<br /><br /><a href="%2$s">Przejdź do swojej skrzynki odbiorczej</a>';

$txt['help_popup'] = 'Zagubiony? Pozwól mi wyjaśnić:';

$txt['previous_next_back'] = 'poprzedni temat';
$txt['previous_next_forward'] = 'następny temat';

$txt['upshrink_description'] = 'Zmniejsz lub zwiększ nagłówek.';

$txt['mark_unread'] = 'Zaznacz jako nieprzeczytane';

$txt['ssi_not_direct'] = 'Nie łącz się z SSI.php bezpośrednio; powinieneś użyć ścieżki (%1$s) lub dodać ?ssi_function=cokolwiek.';
$txt['ssi_session_broken'] = 'SSI.php nie mogło załadować sesji!  Może to powodować problemy z wylogowaniem i innymi funkcjami - upewnij się, że SSI.php jest wstawione w kodzie przed *czymkolwiek* innym we wszystkich skryptach!';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Podgląd wiadomości';
$txt['preview_fetch'] = 'Generowanie podglądu...';
$txt['pm_error_while_submitting'] = 'Następujący błąd lub błędy wystąpiły przy wysyłaniu prywatnej wiadomości:';
$txt['warning_while_submitting'] = 'Wystąpił błąd, sprawdź go tutaj:';
$txt['error_while_submitting'] = 'W wiadomości wykryto błędy, które muszą zostać poprawione przed kontynuowaniem:';
$txt['error_old_topic'] = 'Uwaga: W tym temacie nie pisano od %1$d dni.<br />Jeżeli nie masz pewności, że chcesz tu odpowiedzieć, rozważ rozpoczęcie nowego tematu.';

$txt['split_selected_posts'] = 'Zaznaczone wiadomości';
$txt['split_selected_posts_desc'] = 'Poniższe wiadomości utworzą nowy temat po podziale.';
$txt['split_reset_selection'] = 'anuluj zaznaczenie';

$txt['modify_cancel'] = 'Anuluj';
$txt['mark_read_short'] = 'Zaznacz jako przeczytane';

$txt['hello_member_ndt'] = 'Witaj';

$txt['unapproved_posts'] = 'Niezatwierdzone wiadomości (Tematy: %1$d, Wiadomości: %2$d)';

$txt['ajax_in_progress'] = 'Ładowanie...';
$txt['ajax_bad_response'] = 'Nieprawidłowa odpowiedź.';

$txt['mod_reports_waiting'] = 'Aktualnie otwarte są %1$d raporty moderatora.';
$txt['pm_reports_waiting'] = 'Obecnie jest %1$d otwartych zgłoszeń wiadomości prywatnych.';

$txt['new_posts_in_category'] = 'Kliknij aby zobaczyć nowe wiadomości w %1$s';
$txt['verification'] = 'Weryfikacja';
$txt['visual_verification_hidden'] = 'Proszę pozostawić to pole puste';
$txt['visual_verification_description'] = 'Wpisz litery widoczne na obrazku';
$txt['visual_verification_request_new'] = 'Prośba o inny obrazek';

// @todo Send email strings - should move?
$txt['send_email'] = 'Wyślij email';
$txt['send_email_disclosed'] = 'Ta treść będzie widoczna u odbiorcy.';
$txt['send_email_subject'] = 'Temat wiadomości email';

$txt['ignoring_user'] = 'Ignorujesz tego użytkownika.';
$txt['show_ignore_user_post'] = '<em>[Pokaż wiadomość.]</em>';

$txt['spider'] = 'Robot';
$txt['spiders'] = 'Roboty';

$txt['downloads'] = 'Pobieranie';
$txt['filesize'] = 'Rozmiar pliku';

// Restore topic
$txt['restore_topic'] = 'Przywróć temat';
$txt['restore_message'] = 'Przywróć';
$txt['quick_mod_restore'] = 'Przywróć zaznaczone';

// Editor prompt.
$txt['prompt_text_email'] = 'Wpisz adres email.';
$txt['prompt_text_ftp'] = 'Wpisz adres serwera FTP.';
$txt['prompt_text_url'] = 'Wpisz adres URL.';
$txt['prompt_text_img'] = 'Wpisz lokalizację obrazka';

// Escape any single quotes in here twice. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Usuń';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Szablony:';
$txt['debug_sub_templates'] = 'Pod-szablony:';
$txt['debug_language_files'] = 'Pliki językowe:';
$txt['debug_sheets'] = 'Arkusze stylów:';
$txt['debug_javascript'] = 'Skrypty:';
$txt['debug_files_included'] = 'Uwzględnione pliki:';
$txt['debug_kb'] = 'KB.';
$txt['debug_show'] = 'pokaż';
$txt['debug_cache_hits'] = 'Użycia cache:';
$txt['debug_cache_seconds_bytes'] = '%1$s - %2$s bajtów';
$txt['debug_cache_seconds_bytes_total'] = '%1$s dla %2$s bajtów';
$txt['debug_queries_used'] = 'Użytych zapytań: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Użytych zapytań: %1$d, %2$d ostrzeżeń';
$txt['debug_query_in_line'] = 'w <em>%1$s</em> linia <em>%2$s</em>,';
$txt['debug_query_which_took'] = 'co zajęło %1$s sekund.';
$txt['debug_query_which_took_at'] = 'które zajęło %1$s sekund w %2$s na żądanie.';
$txt['debug_show_queries'] = '[Pokaż zapytania]';
$txt['debug_hide_queries'] = '[Ukryj zapytania]';
$txt['debug_tokens'] = 'Tokeny:';
$txt['debug_browser'] = 'ID przeglądarki:';
$txt['debug_hooks'] = 'Wywołane haki:';
$txt['debug_system_type'] = 'System: ';
$txt['debug_server_load'] = 'Obciążenie serwera:';
$txt['debug_script_mem_load'] = 'Użycie pamięci:';
$txt['debug_script_cpu_load'] = 'Obciążenie procesora (użytkownik/system):';

// Video embedding
$txt['preview_image'] = 'Podgląd filmu';
$txt['ctp_video'] = 'Kliknij, aby odtworzyć wideo';
$txt['hide_video'] = 'Pokaż/ukryj film';
$txt['youtube'] = 'YouTube:';
$txt['vimeo'] = 'Vimeo:';
$txt['dailymotion'] = 'Dailymotion:';
$txt['tiktok'] = 'TikTok:';
$txt['twitter'] = 'X/Twitter:';
$txt['facebook'] = 'Facebook:';
$txt['instagram'] = 'Instagram:';

// Spoiler BBC
$txt['spoiler'] = 'Spoiler (pokaż/ukryj)';

$txt['ok_uppercase'] = 'OK';

// Title of box for warnings that admins should see
$txt['admin_warning_title'] = 'Ostrzeżenie';

$txt['via'] = 'przez';

$txt['like_post_stats'] = 'Like stats';

$txt['otp_token'] = 'Hasło jednorazowe';
$txt['otp_enabled'] = 'Włącz uwierzytelnianie dwuetapowe';
$txt['invalid_otptoken'] = 'Hasło jednorazowe oparte na czasie jest nieprawidłowe';
$txt['otp_used'] = 'Hasło jednorazowe oparte na czasie zostało już użyte.<br /> Proszę poczekać chwilę i użyć następnego kodu.';
$txt['otp_generate'] = 'Generuj';
$txt['otp_show_qr'] = 'Pokaż kod QR';

$txt['other'] = 'Inne';

$txt['retry'] = 'POWRÓT';
$txt['check_connection'] = 'Proszę sprawdzić połączenie z internetem';
