<?php
// Version: 2.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
// Additionally do not translate the @additional_params: line or the variable names in the lines that follow it.  You may
// translate the description of the variable.  Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

$txt['scheduled_approval_email_topic'] = 'Aşağıdaki konular onaylanmayı bekliyor:';
$txt['scheduled_approval_email_msg'] = 'Aşağıdaki iletiler onaylanmayı bekliyor:';
$txt['scheduled_approval_email_attach'] = 'Aşağıdaki eklentiler onaylanmayı bekliyor:';
$txt['scheduled_approval_email_event'] = 'Aşağıdaki etkinlikler onaylanmayı bekliyor:';

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Hoşgeldiniz {FORUMNAME}';
$txt['resend_activate_message_body'] = '{FORUMNAME}.  kayıt olduğunuz için teşekkür ederiz. Kullanıcı adınız  {USERNAME}. Şifrenizi unuttuysanız,  {FORGOTPASSWORDLINK}

sayfasını ziyaret ederek şifre sıfırlayabilirsiniz. Giriş yapabilmeniz için öncelikle şu bağlantıyı seçerek hesabınızı etkinleştirmeniz gerekir: 

{ACTIVATIONLINK}

Etkinleştirme ile ilgili herhangi bir sorun yaşarsınız, lütfen {ACTIVATIONLINKWITHOUTCODE} adresini ziyaret edin ve "{ACTIVATIONCODE}" kodunu giriniz. 

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Hoşgeldiniz {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Merhaba {REALNAME},  {FORUMNAME} forumuna  kayıt isteğiniz alındı
Kayıt olduğunuz kullanıcı adı  {USERNAME}.

Oturum açmadan ve foruma başlamadan önce, isteğiniz gözden geçirilecek ve onaylanacaktır. Bu olduğunda, bu adresden başka bir e-posta daha alacaksınız.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Grup Üyeliği Onayı';
$txt['mc_group_approve_body'] = '{USERNAME},

{FORUMNAME} - "{GROUPNAME}" grubuna katılmak için yapmış olduğunuz başvuru incelenmiş ve üyeliğiniz onaylanmıştır. Gruba katılmak olduğunu size bildirmekten mutluluk duyarız

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Grup Üyeliği Reddi';
$txt['mc_group_reject_body'] = '{USERNAME},

{FORUMNAME} - "{GROUPNAME}" grubuna katılmak için yapmış olduğunuz başvuru incelenmiş ve talebiniz reddedilmiştir.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Grup Üyeliği Reddi';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

{FORUMNAME} - "{GROUPNAME}" grubuna katılmak için yapmış olduğunuz başvuru incelenmiş ve talebiniz reddedilmiştir.

Reddedilme sebebiniz: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Hoşgeldiniz {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Hoş geldiniz,  {NAME} Hesabınız manuel olarak yönetici tarafından etkinleştirildi ve şimdi giriş yapıp mesaj gönderebilirsiniz. Kullanıcı adınız:  {USERNAME}. Şifrenizi unutursanız {FORGOTPASSWORDLINK} adresinden değiştirebilirsiniz. {REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Hoşgeldiniz {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Hoşgeldiniz, {USERNAME}!

{FORUMNAME} için yapmış olduğunuz üyelik talebi yöneticiler tarafından gözden geçirilmiş ve onaylanmıştır. Giriş yapmadan önce üyeliğinizi aktifleştirmeniz gerekmektedir.  Hesabınızı aktifleştirmek için lütfen aşağıdaki bağlantıya tıklayınız:
{ACTIVATIONLINK}

Eğer yukarıdaki adres ile ilgili sorunlar yaşarsanız, {ACTIVATIONLINKWITHOUTCODE} adresini ziyaret edebilir ve "{ACTIVATIONCODE}" kodunu kullanarak üyeliğinizi aktifleştirebilirsiniz.

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Kayıt Reddedildi';
$txt['admin_approve_reject_body'] = '{USERNAME},

Ne yazık ki {FORUMNAME} için yapmış olduğunuz üyelik başvurusu reddedilmiştir.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Hesap Silindi';
$txt['admin_approve_delete_body'] = '{USERNAME},

{FORUMNAME}  hesabınız silinmiştir.  Silinmenin sebebi üyeliğinizi aktifleştirmemiş olmanız olabilir.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Kayıt Hatırlatıcı';
$txt['admin_approve_remind_body'] = '{USERNAME},
{FORUMNAME} için yapmış olduğunuz üyelik kaydını hala aktifleştirleştirmeniz

Lütfen hesabınızı aktifleştirmek için aşağıdaki bağlantıya tıklayınız:
{ACTIVATIONLINK}

Eğer aktivasyon bağlantısıyla ilgili bir probleminiz olursa, lütfen {ACTIVATIONLINKWITHOUTCODE} adresine girin ve "{ACTIVATIONCODE}" kodunu girin.

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The url link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Hoşgeldiniz {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Kayıt olduğunuz için teşekkürler {FORUMNAME}. Kullanıcı adınız: {USERNAME} ve şifreniz: {PASSWORD} olarak belirlenmiştir.

Giriş yapmadan önce aşağıdaki bağlantıdan üyeliğinizi aktifleştirin:

{ACTIVATIONLINK}

Eğer aktivasyon bağlantısıyla ilgili bir probleminiz olursa, lütfen {ACTIVATIONLINKWITHOUTCODE} adresine girin ve "{ACTIVATIONCODE}" kodunu girin.

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Hoşgeldiniz {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Kayıt olduğunuz için teşekkürler {FORUMNAME}.  Kullanıcı adınız: {USERNAME} ve şifreniz: {PASSWORD} olarak belirlenmiştir.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
	@description:
*/
$txt['new_announcement_subject'] = 'Yeni Duyuru: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

Eğer gelecekte duyuru iletileri almak istemiyorsanız, bu seçeneği profilinizde bulunan "Forum duyuruları ve e-posta bildirimleri" bölümünü kullanarak kolayca yapabilirsiniz.

Duyurunun tümünü aşağıdaki bağlantıyı kullanarak görüntüleyebilirsiniz:
{TOPICLINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Yeni Konu: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Haberdar edilmeyi seçtiğiniz bir bölümde, \'{TOPICSUBJECT}\' başlıklı bir konu açılmıştır.

Konuyu görüntülemek için aşağıdaki bağlantıya tıklayınız:
{TOPICLINK}

Bu bölümde daha fazla konu açılsa bile bu konuyu görüntülemezseniz, bölümle ilgili yeni bir duyuru gelmeyecektir.

Konunun metni:
{MESSAGE}

Bu bölümden daha fazla duyuru almak istemiyorsanız, aşağıdaki bağlantıya tıklayınız:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Yeni Konu: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Haberdar edilmeyi seçtiğiniz bir bölümde, \'{TOPICSUBJECT}\' başlıklı bir konu açılmıştır.

Konuyu görüntülemek için aşağıdaki bağlantıya tıklayınız:
{TOPICLINK}

Bu konuyu okumadığınız takdirde bu bölüme gönderilen yeni konulardan haberdar edilmeyeceksiniz.

Bu bölümden daha fazla duyuru almak istemiyorsanız, aşağıdaki bağlantıya tıklayınız:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Yeni Konu: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Haberdar edilmeyi seçtiğiniz bir bölümde, \'{TOPICSUBJECT}\' başlıklı bir konu açılmıştır

Konuyu görüntülemek için aşağıdaki bağlantıya tıklayınız:
{TOPICLINK}

Konunun metni:
{MESSAGE}

Bu bölümden daha fazla duyuru almak istemiyorsanız, aşağıdaki bağlantıya tıklayınız:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Yeni Konu: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Haberdar edilmeyi seçtiğiniz bir bölümde, \'{TOPICSUBJECT}\' başlıklı bir konu açılmıştır.

Konuyu görüntülemek için aşağıdaki bağlantıya tıklayınız:
{TOPICLINK}

Bu bölümden daha fazla duyuru almak istemiyorsanız, aşağıdaki bağlantıya tıklayınız:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Yeni Grup Başvurusu';
$txt['request_membership_body'] = '{RECPNAME},
		
{APPYNAME}, "{GROUPNAME}" adlı gruba katılmak için başvuruda bulunmuştur. Üyenin katılmak için belirttiği sebep aşağıdadır:

{REASON}

Aşağıdaki bağlantıya tıklarayak başvuruyu reddedebilir veya kabul edebilirsiniz:

{MODLINK}

{REGARDS}';

/**
	@additional_params: scheduled_approval
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = '{FORUMNAME} Sitesindeki Aboneliğiniz Sona Erecektir';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

{FORUMNAME} sitesindeki aboneliğiniz sona ermek üzeredir. Eğer otomatik yenilemeyi aktif ettiyseniz herhangi bir işlem yapmanıza gerek yoktur fakat diğer durumlarda siteye girip ücretli abonelikler bölümünden aboneliğinizin süresini artırmanız gerekmektedir. Detaylı bilgi:

Abonelik Adı: {SUBSCRIPTION}
Süresinin Dolacağı Tarih: {END_DATE}

Ücretli aboneliklerinizi düzenlemek için şu adresi ziyaret ediniz:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The url link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = '{FORUMNAME}: Tekrar Hoşgeldiniz';
$txt['activate_reactivate_body'] = 'E-Posta adresinizin tekrar onaylanabilmesi için üyeliğiniz aktif değil.  Üyeliğinizi tekrar aktifleştirmek için aşağıdaki bağlantıya tıklayınız:
{ACTIVATIONLINK}

Eğer yukarıdaki adres ile ilgili sorunlar yaşarsanız, {ACTIVATIONLINKWITHOUTCODE} adresini ziyaret edebilir ve "{ACTIVATIONCODE}" kodunu kullanarak üyeliğinizi aktifleştirebilirsiniz.

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = '{FORUMNAME} için yeni şifre';
$txt['forgot_password_body'] = 'Sayın  {REALNAME},

Bu posta şifremi unuttum işlevi hesabınıza uygulanmış olduğundan gönderildi. Yeni bir şifre oluşturmak için aşağıdaki bağlantıyı tıklayın:
{REMINDLINK}

IP: {IP}
Kullanıcı adı: {MEMBERNAME}

Bu şifre yardımı e-postasını  talep etmediyseniz, muhtemelen Başka bir kullanıcının yanlışlıkla e-posta adresinizi girmiş olabilir. Talebi başlatmadıysanız endişelenmeyin; hesabınız güvenlidir ve başka işlem yapmanıza gerek yoktur. Bu e-postayla gizliliğinize ve güvenliğinize karşı hiçbir sorumluluk kabul edilmemektedir.

{REGARDS}';

/**
	@additional_params: scheduled_approval
		REALNAME: The real (display) name of the person receiving the email.
		BODY: The generated body of the mail.
	@description:
*/
$txt['scheduled_approval_subject'] = '{FORUMNAME}: Onay Bekleyen Konuların Özeti';
$txt['scheduled_approval_body'] = '{REALNAME},
		
Bu e-posta {FORUMNAME} de onay bekleyen tüm ileti ve konuları içermektedir.

{BODY}

İncelemek için lütfen giriş yapınız:
{SCRIPTURL}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The report post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The url of the post that is being reported.
		REPORTLINK: The url of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Rapor Edilen İleti: {TOPICSUBJECT} - {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Yöneticisi olduğunuz bir bölümde bulunan, {POSTERNAME} adlı kullanıcının göndermiş olduğu "{TOPICSUBJECT}" başlıklı konu, {REPORTERNAME} tarafından rapor edilmiştir:

Konu: {TOPICLINK}
Moderasyon Merkezi: {REPORTLINK}

Rapor Sebebi:
{COMMENT}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Yeni Şifre Ayrıntıları';
$txt['change_password_body'] = 'Sayın, {USERNAME}!

{FORUMNAME} da bulunan üyeliğiniz ile bilgiler değiştirilmiş ve şifreniz sıfırlanmıştır. Yeni kullanıcı detaylarınız aşağıdadır:

Kullanıcı adınız "{USERNAME}" ve şifreniz "{PASSWORD}" olarak değiştirilmiştir.

Şifrenizi giriş yaptıktan sonra profil sayfanıza giderek değiştirebilirsiniz:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The url link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The url to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Hoşgeldiniz {FORUMNAME}';
$txt['register_activate_body'] = '{FORUMNAME}. Kayıt olduğunuz için teşekkür ederiz. Kullanıcı adınız {USERNAME}. Şifrenizi unutursanız {FORGOTPASSWORDLINK} adresini ziyaret ederek şifrenizi sıfırlayabilirsiniz.

Giriş yapabilmeniz için öncelikle hesabınızı etkinleştirmeniz gerekir. Bunu yapmak için lütfen şu bağlantıyı takip edin:

{ACTIVATIONLINK}

Etkinleştirme ile ilgili herhangi bir sorununuz varsa, lütfen {ACTIVATIONLINKWITHOUTCODE} adresini ziyaret edin "{ACTIVATIONCODE}" kodunu kullanın.

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The url link to the coppa form.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Hoşgeldiniz {FORUMNAME}';
$txt['register_coppa_body'] = 'Kayıt olduğunuz için teşekkürler {FORUMNAME}.  Kullanıcı adınız {USERNAME} Eğer şifrenizi unuttuysanız, {FORGOTPASSWORDLINK} adresinden değiştirebilirsiniz.olarak belirlenmiştir.

Giriş yapmadan önce ve topluluğa katılmak için, önce veli onayı gerekmektedir. Aşağıdaki bağlantıdan daha fazla bilgi edinebilirsiniz:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Hoşgeldiniz {FORUMNAME}';
$txt['register_immediate_body'] = '{FORUMNAME}. Kayıt olduğunuz için teşekkür ederiz. Kullanıcı adınız {USERNAME}. Şifrenizi unutursanız  {FORGOTPASSWORDLINK} adresinden değiştirebilirsiniz.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The url to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Hoşgeldiniz {FORUMNAME}';
$txt['register_pending_body'] = 'Sayın {REALNAME}, {FORUMNAME}  kayıt isteğiniz alındı.

Kayıt yaptığınız kullanıcı adı {USERNAME}. Şifrenizi unutursanız {FORGOTPASSWORDLINK} adresinden değiştirebilirsiniz.

Oturum açmadan ve foruma başlamadan önce, isteğiniz gözden geçirilecek ve onaylanacaktır. Bu olduğunda, bu adresden başka bir e-posta alacaksınız.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Konu yanıtlandı: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Haberdar edilmeyi seçtiğiniz  konuya, {POSTERNAME} tarafından yanıt verilmiştir.

Yanıtı görüntüleyin: {TOPICLINK}

Bu bağlantıyı kullanarak aboneliğinizi iptal edin: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Konu yanıtlandı: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'Haberdar edilmeyi seçtiğiniz  konuya, {POSTERNAME} tarafından yanıt verilmiştir.

Yanıtı görüntüleyin: {TOPICLINK}

Bu bağlantıyı kullanarak aboneliğinizi iptal edin: {UNSUBSCRIBELINK}

Yanıtın metni:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Konu yanıtlandı: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'Haberdar edilmeyi seçtiğiniz konuya, {POSTERNAME} tarafından yanıt verilmiştir.

Yanıtı görüntüleyin: {TOPICLINK}

Bu bağlantıyı kullanarak aboneliğinizi iptal edin: {UNSUBSCRIBELINK}

Bu konuya daha fazla yanıt verilse bile, konuyu görüntülemezseniz, konuyla ilgili yeni bir duyuru gelmeyecektir.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Konu yanıtlandı: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'Haberdar edilmeyi seçtiğiniz  konuya, {POSTERNAME} tarafından yanıt verilmiştir.

Yanıtı görüntüleyin: {TOPICLINK}

Bu bağlantıyı kullanarak aboneliğinizi iptal edin: {UNSUBSCRIBELINK}

Yanıtın metni:
{MESSAGE}

Bu konuya daha fazla yanıt verilse bile, konuyu görüntülemezseniz, konuyla ilgili yeni bir duyuru gelmeyecektir.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Konu Sabitlenmiştir: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Haberdar edilmeyi seçtiğiniz konu, {POSTERNAME} tarafından sabitlenmiştir.

Konuyu görüntüleyin: {TOPICLINK}

Bu bağlantıyı kullanarak aboneliğinizi iptal edin: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Konu Kilitlenmiştir: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Haberdar edilmeyi seçtiğiniz konu, {POSTERNAME} tarafından kilitlenmiştir.

Konuyu görüntüleyin: {TOPICLINK}

Bu bağlantıyı kullanarak aboneliğinizi iptal edin: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Konu Kilidi Kaldırılmıştır: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Haberdar edilmeyi seçtiğiniz  konuya ait kilit, {POSTERNAME} tarafından kaldırılmıştır.

Konuyu görüntüleyin: {TOPICLINK}

Bu bağlantıyı kullanarak aboneliğinizi iptal edin: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Konu Kaldırılmıştır: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Haberdar edilmeyi seçtiğiniz konu, {POSTERNAME} tarafından kaldırılmıştır.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Konu Taşınmıştır: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Haberdar edilmeyi seçtiğiniz konu {POSTERNAME}. tarafından başka bir bölüme taşınmıştır.

Konuyu görüntüleyin: {TOPICLINK}

Bu bağlantıyı kullanarak aboneliğinizi iptal edin: {UNSUBSCRIBELINK}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Konu Birleştirildi: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Haberdar edilmeyi seçtiğiniz {TOPICSUBJECT} başlıklı konu, {POSTERNAME} tarafından başka bir konu ile birleştirilmiştir. Bu bağlantıyı kullanarak aboneliğinizi iptal edin: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Konu Bölündü: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Haberdar edilmeyi seçtiğiniz konu, {POSTERNAME} tarafından bölünmüştür.

Konudan kalanları görüntüleyin: {TOPICLINK}

Bu bağlantıyı kullanarak aboneliğinizi iptal edin: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Yeni bir üye katıldı';
$txt['admin_notify_body'] = '{USERNAME} adlı üye forum\'a kayıt olmuştur. Profilini görüntülemek için lütfen aşağıdaki bağlantıya tıklayınız:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Yeni bir üye katıldı';
$txt['admin_notify_approval_body'] = '{USERNAME} adlı üye forum\'a kayıt olmuştur. Profilini görüntülemek için lütfen aşağıdaki bağlantıya tıklayınız:
{PROFILELINK}

Bu üyenin ileti göndermeye başlamadan önce hesabının onaylanması gerekmektedir. Onay ekranına gitmek için lütfen aşağıdaki bağlantıya tıklayınız:
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Acil! Eklenti Klasörü Neredeyse Dolmuştur';
$txt['admin_attachments_full_body'] = '{REALNAME},

{FORUMNAME} adresindeki eklenti klasörü neredeyse dolmuştur.

Eklenti klasörü limitine yaklaştığında üyeler yeni dosya eklentileri veya kişisel avatarlar gönderemeyeceklerdir.

{REGARDS}';

/**
	@additional_params: admin_backup_database
		BAK_REALNAME: the name of the user doing the backup
	@description:
*/
$txt['admin_backup_database_subject'] = 'Bir veritabanı yedeklemesi alındı';
$txt['admin_backup_database_body'] = '{REALNAME},

This email is to inform you that {BAK_REALNAME} has just downloaded a backup of the database at {FORUMNAME}.

{REGARDS}';

/**
	@additional_params: editing_theme
		EDIT_REALNAME: the name of the user doing the backup
		FILE_EDITED: the name of the file being modified
		THEME_NAME: the name of the theme
	@description:
*/
$txt['editing_theme_subject'] = 'Bir tema düzenlendi';
$txt['editing_theme_body'] = '{REALNAME},

Bu e-posta {EDIT_REALNAME} tema dosyasını düzenleyeceğini size bildirmek içindir:

{FILE_EDITED}

{FORUMNAME} \'daki {THEME_NAME} temasının düzenlemesi hakkında şüpheniz varsa  lütfen olayı araştırın.

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Geri Ödenen Ücretli Abonelik';
$txt['paid_subscription_refund_body'] = '{REALNAME},

Bir üye, bir ücretli abonelik için geri ödeme almıştır. İlgili detaylar aşağıdadır:

	Abonelik: {NAME}
	Kullanıcı Adı: {REFUNDNAME} ({REFUNDUSER})
	Tarih: {DATE}

Bu üyenin profilini görüntülemek için aşağıdaki bağlantıya tıklayabilirsiniz:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Yeni Ücretli Abonelik';
$txt['paid_subscription_new_body'] = '{REALNAME},

Yeni bir ücretli abonelik satın alınmıştır, detayları aşağıdadır:

	Abonelik: {NAME}
	Kullanıcı Adı: {SUBNAME} ({SUBUSER})
	E-Posta Adresi: {SUBEMAIL}
	Ücret: {PRICE}
	Tarih: {DATE}

Bu üyenin profilini görüntülemek için aşağıdaki bağlantıya tıklayabilirsiniz:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Ücretli Abonelik Hatası';
$txt['paid_subscription_error_body'] = 'Sayın {REALNAME},

Ücretli abonelik işlemi sırasında aşağıdaki hata oluştu:
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Yeni Özel Mesaj: {SUBJECT}';
$txt['new_pm_body'] = '{FORUMNAME} sitesinde  {SENDER} tarafından size yeni bir kişisel ileti gönderilmiştir.

ÖNEMLİ: Bu sadece duyuru amaçlı bir iletidir. Lütfen bu e-postayı yanıtlamayınız.

Kişisel iletiyi oku: {READLINK}

Bu kişisel iletiyi yanıtla: {REPLYLINK}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Yeni Özel Mesaj: {SUBJECT}';
$txt['new_pm_body_body'] = '{FORUMNAME} sitesinde  {SENDER} tarafından size yeni bir kişisel ileti gönderilmiştir.

ÖNEMLİ: Bu sadece duyuru amaçlı bir iletidir. Lütfen bu epostayı yanıtlamayınız.

Gönderilen ileti:

{MESSAGE}

Bu kişisel iletiyi yanıtla:  {REPLYLINK}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Yeni Özel Mesaj: {SUBJECT}';
$txt['new_pm_tolist_body'] = '{TOLIST}, {SENDER} tarafından {FORUMNAME} e ait bir kişisel ileti gönderildi

ÖNEMLİ: Bu sadece bir bildirim. Lütfen bu e-postayı yanıtlamayın.

Kişisel iletiyi okuyun: {READLINK}

Bu Kişisel İletiyi yanıtla (yanlızca gönderene) link: {REPLYLINK} ';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Yeni Özel Mesaj: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = '{TOLIST}, {SENDER} tarafından {FORUMNAME} e ait bir kişisel ileti gönderildi

ÖNEMLİ: Bu sadece bir bildirim. Lütfen bu e-postayı yanıtlamayın.

Gönderilen kişisel ileti:

{MESSAGE}

Bu Kişisel İletiyi yanıtla (yanlızca gönderene) link: {REPLYLINK} ';

/**
	@additional_params: notify_new_buddy
		ACTIONNAME:  The user name of the member adding as buddy.
	@description: A notification email sent to the members that are set as buddy by someone
*/
$txt['notify_new_buddy_subject'] = '{ACTIONNAME} seni arkadaş olarak ekledi';
$txt['notify_new_buddy_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} has just added you as a buddy 
at {FORUMNAME}.  

{REGARDS}


You can unsubscribe to further "new buddy" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_new_buddy_digest'] = 'Arkadaşın  olarak ekledin:';
$txt['notify_new_buddy_snippet'] = '{ACTIONNAME}';

/**
	@additional_params: notify_new_likemsg
		ACTIONNAME:  The user name of the member that liked the message.
		MSGLINK:  The url to the message liked.
		SUBJECT: The subject of the message
	@description: A notification email sent to the members whose message has been liked
*/
$txt['notify_new_likemsg_subject'] = 'Bir mesaj beğenildi';
$txt['notify_new_likemsg_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} has just liked your message 
in the "{SUBJECT}" topic at {FORUMNAME}.  
You can view that message by following this link:
{MSGLINK}

{REGARDS}


You can unsubscribe to further "liked by" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_new_likemsg_digest'] = 'Aşağıdaki mesajlar beğenildi:';
$txt['notify_new_likemsg_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_mentionmem
		ACTIONNAME:  The user name of the member that mentioned someone.
		MSGLINK:  The url to the message where someone has been mentioned.
		SUBJECT: The subject of the message
	@description: A notification email sent to the members mentioned by someone else in a message
*/
$txt['notify_mentionmem_subject'] = 'Sizden bahsedildi';
$txt['notify_mentionmem_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} has just mentioned you in a message 
in the "{SUBJECT}" topic at {FORUMNAME}.  
You can view that message by following this link:
{MSGLINK}

{REGARDS}


You can unsubscribe to further "mentioned" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_mentionmem_digest'] = 'You have been mentioned in the following messages:';
$txt['notify_mentionmem_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_quotedmem
		ACTIONNAME:  The user name of the member that quoted someone's message.
		MSGLINK:  The url to the message where someone has been quoted.
		SUBJECT: The subject of the message
  		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description: A notification email sent to the members quoted in someone else message
*/
$txt['notify_quotedmem_subject'] = 'Your message has been quoted';
$txt['notify_quotedmem_body'] = '{REALNAME},

We wanted to let you know that {ACTIONNAME} at {FORUMNAME} has just quoted
your messages in the "{SUBJECT}" topic.  You can view that message by 
following this link:
{MSGLINK}

{REGARDS}


You can unsubscribe to further "quoted message" notifications by using this link:
{UNSUBSCRIBELINK}
';
$txt['notify_quotedmem_digest'] = 'Mesajlarınızın alıntı yapıldığı konu:';
$txt['notify_quotedmem_snippet'] = '{MSGLINK}';

/**
	@additional_params: notify_html_email
		FORUMNAMESHORT: Short or nickname for the forum
		TOPICSUBJECT: The subject of the message.
		MESSAGE: This is the body of the message.
		EMAILCSS: The location of the stylesheet.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description: A basic HTML wrapper to place around a prepared HTML email
 */
$txt['notify_html_email_subject'] = '';
$txt['notify_html_email_body'] = '<!DOCTYPE html>
<html>
<head>
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title>{TOPICSUBJECT}</title>
	<style>
		{EMAILCSS}
	</style>
</head>
<body>
<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="body">
	<tr>
		<td class="container">
			<div class="content">
				<table role="presentation" class="main">
					<tr>
						<td class="wrapper">
							<table role="presentation" border="0" cellpadding="0" cellspacing="0">
								<tr>
									<td>
										<p>{MESSAGE}</p>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<div class="footer">
					<table role="presentation" border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td class="content-block">
								<span class="apple-link">{FORUMNAMESHORT}</span>
								<br>
								Dont like these emails? <a href="{UNSUBSCRIBELINK}">Unsubscribe</a>.
							</td>
						</tr>
						<tr>
							<td>
								<span class="key-holder">[]</span>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</td>
	</tr>
</table>
</body>
</html>
';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/

$txtBirthdayEmails['happy_birthday_subject'] = 'Happy birthday from {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Dear {REALNAME},

We here at {FORUMNAME} would like to wish you a happy birthday.  May this day and the year to follow be full of joy.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'On your Birthday...';
$txtBirthdayEmails['karlbenson1_body'] = 'We could have sent you a birthday card.  We could have sent you some flowers or a cake.

But we didn\'t.

We could have even sent you one of those automatically generated messages to wish you happy birthday where we don\'t even have to replace INSERT NAME.

But we didn\'t

We wrote this birthday greeting just for you.

We would like to wish you a very special birthday.

{REGARDS}

//:: This message was automatically generated :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Happy Birthday!';
$txtBirthdayEmails['nite0859_body'] = 'Your friends at {FORUMNAME} would like to take a moment of your time to wish you a happy birthday, {REALNAME}. If you have not done so recently, please visit our community in order for others to have the opportunity to pass along their warm regards.

Even though today is your birthday, {REALNAME}, we would like to remind you that your membership in our community has been the best gift to us thus far.

Best Wishes,
The Staff of {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Birthday Wishes to {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Dear {REALNAME},

Another year in your life has passed.  We at {FORUMNAME} hope it has been filled with happiness, and wish you luck in the coming one.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Happy birthday, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Do you know who\'s having a birthday today, {REALNAME}?

We know... YOU!

Happy birthday!

You\'re now a year older but we hope you\'re a lot happier than last year.

Enjoy your day today, {REALNAME}!

- From your {FORUMNAME} family';
$txtBirthdayEmails['geezmo_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Your Birthday Greeting';
$txtBirthdayEmails['karlbenson2_body'] = 'We hope your birthday is the best ever cloudy, sunny or whatever the weather.
Have lots of birthday cake and fun, and tell us what you have done.

We hope this message brought you cheer, and make it last, until same time same place, next year.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="http://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';
