<?php
// Version: 2.0; index

global $forum_copyright;

// Locale (strftime, pspell_new) and spelling.
// For more information see:
//   - https://www.php.net/function.pspell-new
//   - https://www.php.net/function.setlocale
$txt['lang_locale'] = 'tr_TR.utf8';
$txt['lang_dictionary'] = 'tr';
$txt['lang_spelling'] = 'amerikan';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set and right to left?
$txt['lang_rtl'] = false;
// Capitalize day and month names?
$txt['lang_capitalize_dates'] = true;
// Number format.
$txt['number_format'] = '1,234.00';

$txt['sunday'] = 'Pazar';
$txt['monday'] = 'Pazartesi';
$txt['tuesday'] = 'Salı';
$txt['wednesday'] = 'Çarşamba';
$txt['thursday'] = 'Perşembe';
$txt['friday'] = 'Cuma';
$txt['saturday'] = 'Cumartesi';

$txt['sunday_short'] = 'Paz';
$txt['monday_short'] = 'Pzt';
$txt['tuesday_short'] = 'Sal';
$txt['wednesday_short'] = 'Çar';
$txt['thursday_short'] = 'Per';
$txt['friday_short'] = 'Cum';
$txt['saturday_short'] = 'Cmt';

$txt['january'] = 'Ocak';
$txt['february'] = 'Şubat';
$txt['march'] = 'Mart';
$txt['april'] = 'Nisan';
$txt['may'] = 'May';
$txt['june'] = 'Haziran';
$txt['july'] = 'Temmuz';
$txt['august'] = 'Ağustos';
$txt['september'] = 'Eylül';
$txt['october'] = 'Ekim';
$txt['november'] = 'Kasım';
$txt['december'] = 'Aralık';

$txt['january_titles'] = 'Ocak';
$txt['february_titles'] = 'Şubat';
$txt['march_titles'] = 'Mart';
$txt['april_titles'] = 'Nisan';
$txt['may_titles'] = 'May';
$txt['june_titles'] = 'Haziran';
$txt['july_titles'] = 'Temmuz';
$txt['august_titles'] = 'Ağustos';
$txt['september_titles'] = 'Eylül';
$txt['october_titles'] = 'Ekim';
$txt['november_titles'] = 'Kasım';
$txt['december_titles'] = 'Aralık';

$txt['january_short'] = 'Oca';
$txt['february_short'] = 'Şub';
$txt['march_short'] = 'Mar';
$txt['april_short'] = 'Nis';
$txt['may_short'] = 'May';
$txt['june_short'] = 'Haz';
$txt['july_short'] = 'Tem';
$txt['august_short'] = 'Ağu';
$txt['september_short'] = 'Eyl';
$txt['october_short'] = 'Ekm';
$txt['november_short'] = 'Ksm';
$txt['december_short'] = 'Ara';

$txt['time_am'] = 'öö';
$txt['time_pm'] = 'ös';

// Let's get all the main menu strings in one place.
$txt['main_menu'] = 'Main Menu';
$txt['home'] = 'Ana Sayfa';
$txt['community'] = 'Topluluk';
$txt['forum'] = 'Forum';

// Sub menu labels
$txt['help'] = 'Yardım';
$txt['search'] = 'Arama';
$txt['calendar'] = 'Takvim';
$txt['members'] = 'Üyeler';
$txt['recent_posts'] = 'Son İletiler';
$txt['recent_topics'] = 'Son Konular';

$txt['admin'] = 'Yönetim';
// Sub menu labels
$txt['errlog'] = 'Hata Günlüğü';
$txt['package'] = 'Add-on Manager';
$txt['edit_permissions'] = 'İzinler';
$txt['modSettings_title'] = 'Özellikler ve Seçenekler';
$txt['pwa_label'] = 'Web Application';

$txt['moderate'] = 'Moderasyon';
// Sub menu labels
$txt['modlog_view'] = 'Moderasyon Kaydı';
$txt['mc_emailerror'] = 'Onaylanmamış E-postalar';
$txt['mc_reported_posts'] = 'Rapor Edilmiş İletiler';
$txt['mc_reported_pms'] = 'Rapor Edilen Kişisel İletiler';
$txt['mc_unapproved_attachments'] = 'Onaylanmamış Eklentiler';
$txt['mc_unapproved_poststopics'] = 'Onaylanmamış Konu ve İletiler';

$txt['pm_short'] = 'İletilerim';
// Sub menu labels
$txt['pm_menu_read'] = 'İletilerinizi Okuyun';
$txt['pm_menu_send'] = 'İleti Gönder';

$txt['account_short'] = 'Hesabım';
// Sub menu labels
$txt['profile'] = 'Profil';
$txt['mydrafts'] = 'Taslaklarım';
$txt['summary'] = 'Özet';
$txt['theme'] = 'Görünüm ve Tasarım';
$txt['account'] = 'Hesap Ayarları';
$txt['forumprofile'] = 'Forum Profili';

$txt['view_unread_category'] = 'Yeni İletiler';
$txt['view_replies_category'] = 'Yeni Yanıtlar';

$txt['login'] = 'Giriş';
$txt['register'] = 'Kayıt Ol';
$txt['logout'] = 'Çıkış';
// End main menu strings.

$txt['save'] = 'Kaydet';

$txt['modify'] = 'Düzenle';
$txt['forum_index'] = '%1$s - Anasayfa';
$txt['board_name'] = 'Forum Adı';
$txt['posts'] = 'İleti';

$txt['member_postcount'] = 'İleti';
$txt['no_subject'] = '(Konu Yok)';
$txt['view_profile'] = 'Profili Görüntüle';
$txt['guest_title'] = 'Ziyaretçi';
$txt['author'] = 'Yazar';
$txt['on'] = 'öö';
$txt['remove'] = 'Kaldır';
$txt['start_new_topic'] = 'Yeni Konu Başlat';

// Use numeric entities in the below string.
$txt['username'] = 'Kullanıcı Adı';
$txt['password'] = 'Şifre';

$txt['username_no_exist'] = 'Kullanıcı adı bulunamadı.';
$txt['no_user_with_email'] = 'Bu e-posta ile bağlantılı bir kullanıcı adı bulunmamaktadır.';

$txt['board_moderator'] = 'Moderatör';
$txt['remove_topic'] = 'Kaldır';
$txt['topics'] = 'Konular';
$txt['modify_msg'] = 'İletiyi düzenle';
$txt['name'] = 'İsim';
$txt['email'] = 'E-Posta';
$txt['user_email_address'] = 'E-Posta Adresi';
$txt['subject'] = 'Konu';
$txt['message'] = 'İleti';
$txt['redirects'] = 'Yönlendirme';

$txt['choose_pass'] = 'Şifrenizi seçin';
$txt['verify_pass'] = 'Şifrenizi doğrulayın';
$txt['position'] = 'Pozisyon';
$txt['notify_announcements'] = 'Önemli site haberlerini e-postayla almak için kaydolun';

$txt['profile_of'] = 'Profilini görüntüle:';
$txt['total'] = 'Toplam:';
$txt['posts_made'] = 'İleti';
$txt['topics_made'] = 'Konular';
$txt['website'] = 'Web';
$txt['contact'] = 'İletişim';
$txt['warning_status'] = 'Uyarı Durumu';
$txt['user_warn_watch'] = 'Üye moderatör izleme listesindedir';
$txt['user_warn_moderate'] = 'Üyenin iletileri onaydan geçmektedir';
$txt['user_warn_mute'] = 'Üye ileti gönderememektedir';
$txt['warn_watch'] = 'İzlemede';
$txt['warn_moderate'] = 'Moderasyonda';
$txt['warn_mute'] = 'Susturulmuş';
$txt['warning_issue'] = 'Uyar';

$txt['message_index'] = 'Mesajlar';
$txt['news'] = 'Haberler';
$txt['page'] = 'Sayfa';
$txt['prev'] = 'geri';
$txt['next'] = 'ileri';

$txt['post'] = 'Gönder';
$txt['error_occurred'] = 'Bir Hata Meydana Geldi';
$txt['send_error_occurred'] = 'Bir Hata Meydana Geldi, <a href="{href}">tekrar denemek için lütfen buraya tıklayınız</a>.';
$txt['require_field'] = 'Bu gerekli bir alandır.';
$txt['started_by'] = 'Başlatan';
$txt['topic_started_by'] = 'Başlatan %1$s';
$txt['topic_started_by_in'] = 'Başlatan %1$s - %2$s';
$txt['replies'] = 'Yanıtlar';
$txt['last_post'] = 'Son İleti';
$txt['first_post'] = 'İlk İleti';
$txt['last_poster'] = 'Son İleti Gönderen';

$txt['last_post_message'] = '<strong>Son ileti: </strong> <span class="lastpost_link">%2$s </span><span class="board_lastposter">yazan %1$s</span><span class="board_lasttime"> %3$s</span>';
$txt['boardindex_total_posts'] = '%1$s İleti %2$s Konu Gönderen: %3$s Üye';
$txt['show'] = 'Göster';
$txt['hide'] = 'Gizle';
$txt['sort_by'] = 'Sıralama';
$txt['sort_asc'] = 'Sıralama artan';
$txt['sort_desc'] = 'Sıralama azalan';

$txt['admin_login'] = 'Yönetici Girişi';
// Use numeric entities in the below string.
$txt['topic'] = 'Konu';
$txt['help'] = 'Yardım';
$txt['notify'] = 'Haberdar Et';
$txt['unnotify'] = 'İptal et';
$txt['notify_request'] = 'Bu konuya yanıt verildiğinde, e-posta ile haberdar edilmek ister misiniz?';
// Use numeric entities in the below string.
$txt['regards_team'] = "Regards,\nThe {forum_name_html_unsafe} Team.";
$txt['notify_replies'] = 'Yanıtlardan haberdar et';
$txt['move_topic'] = 'Taşı';
$txt['move_to'] = 'Şuraya taşı';
$txt['pages'] = 'Sayfa';
$txt['users_active'] = 'Son %1$d dakika içinde aktif olan üyeler';
$txt['personal_messages'] = 'Özel İletiler';
$txt['reply_quote'] = 'Alıntı yaparak yanıtla';
$txt['reply'] = 'Yanıtla';
$txt['reply_number'] = 'Yanıt #%1$s';
$txt['approve'] = 'Onayla';
$txt['unapprove'] = 'Onaylama';
$txt['approve_all'] = 'hepsini onayla';
$txt['awaiting_approval'] = 'Onay Bekliyor';
$txt['attach_awaiting_approve'] = 'Onay bekleyen ekler';
$txt['post_awaiting_approval'] = 'Not: Bu ileti bir moderatörden onay beklemektedir.';
$txt['there_are_unapproved_topics'] = 'Bu bölüme ait onaylanmamış %1$s konu ve %2$s ileti bulunmaktadır. Tümünü görüntülemek için <a href="%3$s">buraya</a> tıklayınız.';
$txt['send_message'] = 'İleti Gönder';

$txt['msg_alert_no_messages'] = 'herhangi bir ileti yok';
$txt['msg_alert_one_message'] = 'you have <a href="%1$s">1 message</a>';
$txt['msg_alert_many_message'] = 'you have <a href="%1$s">%2$d messages</a>';
$txt['msg_alert_one_new'] = '1 yeni';
$txt['msg_alert_many_new'] = '%1$d yeni';
$txt['remove_message'] = 'Bu iletiyi sil';

$txt['topic_alert_none'] = 'İleti Yok...';
$txt['pm_alert_none'] = 'İleti Yok...';

$txt['online_users'] = 'Çevrimiçi Kullanıcılar'; //Deprecated
$txt['online_now'] = 'Şu anda Çevrimiçi';
$txt['personal_message'] = 'Kişisel İleti';
$txt['jump_to'] = 'Gitmek istediğiniz yer';
$txt['go'] = 'Başla';
$txt['are_sure_remove_topic'] = 'Bu konuyu kaldırmak istediğinden emin misin?';
$txt['yes'] = 'Evet';
$txt['no'] = 'Hayır';

// @todo this string seems a good candidate for deprecation
$txt['search_on'] = 'öö';

$txt['search'] = 'Arama';
$txt['all'] = 'Hepsi';
$txt['search_entireforum'] = 'Forum';
$txt['search_thisbrd'] = 'Bölüm';
$txt['search_thistopic'] = 'Konu';
$txt['search_members'] = 'Üyeler';

$txt['back'] = 'Geri';
$txt['continue'] = 'Devam Et';
$txt['password_reminder'] = 'Şifre Hatırlatması';
$txt['topic_started'] = 'Konuyu başlatan';
$txt['title'] = 'Başlık';
$txt['post_by'] = 'Gönderen';
$txt['welcome_newest_member'] = 'Yeni üyemiz %1$s, aramıza hoşgeldin.';
$txt['admin_center'] = 'Yönetim Merkezi';
$txt['admin_session_active'] = 'Aktif bir admin oturumunuz var. Yönetimle ilgili işlerinizi bitirdikten sonra <strong><a class="strong" href="%1$s">oturumu sonlandırmanızı</a></strong> öneririz.';
$txt['admin_maintenance_active'] = 'Forumunuz şu anda Bakım Modundadır. Sadece yöneticiler giriş yapabilir.  Yönetimsel görevleri bitirdikten sonra <a class="strong" href="%1$s">bakımdan çıkış</a> yapabilirsiniz.';
$txt['query_command_denied'] = 'Aşağıda ki MySQL hataları yaşanıyor, lütfen ayarları doğrulayın:';
$txt['query_command_denied_guests'] = 'Forum veritaanında bir şeyler ters gitti gibi görünüyor Bu problem geçici olabilir, Lütfen daha sonra tekrar deneyin. Eğer sürekli bu iletiyle karşılaşıyorsanız yönetici ile iletişime geçiniz:';
$txt['query_command_denied_guests_msg'] = '%1$s komutu veritabanı üzerinde engellendi';
$txt['last_edit_by'] = '<span class="lastedit">Son Düzenleme</span>: %1$s - %2$s';
$txt['notify_deactivate'] = 'Bu konu\'ya gönderilen yanıtlardan haberdar olmamak istediğinize emin misiniz?';

$txt['date_registered'] = 'Kayıt Tarihi';
$txt['date_joined'] = 'Joined';
$txt['date_joined_format'] = '%b %d, %Y';
$txt['last_seen'] = 'Last Seen';

$txt['recent_view'] = 'En son gönderilen tüm iletileri göster.';
$txt['is_recent_updated'] = 'En son güncellenen konu %1$s';

$txt['male'] = 'Bay';
$txt['female'] = 'Bayan';

$txt['error_invalid_characters_username'] = 'Kullanıcı adında geçersiz karakter kullanılmıştır.';

$txt['welcome_guest'] = 'Welcome, <strong>Guest</strong>. Please <a href="{login_url}" rel="nofollow">login</a>.';
$txt['welcome_guest_register'] = 'Welcome to <strong>{forum_name}</strong>. Please <a href="{login_url}" rel="nofollow">login</a> or <a href="{register_url}" rel="nofollow">register</a>.';
$txt['welcome_guest_activate'] = '<br />Did you miss your <a href="{activate_url}" rel="nofollow">activation email</a>?';
$txt['welcome_register'] = 'Don\'t have an account?';

// @todo the following to sprintf
$txt['hello_member'] = 'Merhaba,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Hoş Geldiniz,';
$txt['select_destination'] = 'Gitmek istediğiniz yer';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Gönderen';

$txt['icon_smiley'] = 'Gülümseme';
$txt['icon_angry'] = 'Sinirli';
$txt['icon_cheesy'] = 'Peynir';
$txt['icon_laugh'] = 'Kahkaha';
$txt['icon_sad'] = 'Üzgün';
$txt['icon_wink'] = 'Göz Kırp';
$txt['icon_grin'] = 'Sırıt';
$txt['icon_shocked'] = 'Şokta';
$txt['icon_cool'] = 'Cool';
$txt['icon_huh'] = 'Kafası karışmış';
$txt['icon_rolleyes'] = 'Gözleri Dönüyor';
$txt['icon_tongue'] = 'Dil Çıkart';
$txt['icon_embarrassed'] = 'Utangaç';
$txt['icon_lips'] = 'Suskun';
$txt['icon_undecided'] = 'Kararsız';
$txt['icon_kiss'] = 'Öpücük';
$txt['icon_cry'] = 'Ağla';
$txt['icon_angel'] = 'Masum';

$txt['moderator'] = 'Moderatör';
$txt['moderators'] = 'Moderatörler';

$txt['views'] = 'Gösterim';
$txt['new'] = 'Yeni';
$txt['no_redir'] = '%1$s Yönlendirme';

$txt['view_all_members'] = 'Tüm Üyeler';
$txt['view'] = 'Göster';

$txt['viewing_members'] = 'Üyeleri Görüntülüyor %1$s - %2$s';
$txt['of_total_members'] = 'Toplam üye: %1$s';

$txt['forgot_your_password'] = 'Şifreni mi unuttun ?';

$txt['date'] = 'Tarih';
// Use numeric entities in the below string.
$txt['from'] = 'Kimden';
$txt['to'] = 'Kime';

$txt['board_topics'] = 'Konular';
$txt['members_title'] = 'Üyeler';
$txt['members_list'] = 'Üye Listesi';
$txt['new_posts'] = 'Yeni İletiler';
$txt['old_posts'] = 'Yeni ileti yok';
$txt['redirect_board'] = 'Yönlendirmeler';
$txt['redirect_board_to'] = '%1$s yeniden yönlendirme';

$txt['sendtopic_send'] = 'Gönder';
$txt['report_sent'] = 'Raporunuz başarılı bir şekilde gönderilmiştir.';
$txt['topic_sent'] = 'E-postanız başarılı bir şekilde gönderilmiştir.';

$txt['time_offset'] = 'Zaman dengesi';
$txt['or'] = 'veya';

$txt['mention'] = 'Bildirimler';
$txt['notifications'] = 'Bildirimler';
$txt['unread_notifications'] = 'Son ziyaretinizden bu yana %1$s  okunmamış bildiriminiz var.';
$txt['new_from_last_notifications'] = '%1$s Yeni bildirim var.';
$txt['forum_notification'] = '%1$sTarafından gönderilen bildirimler ';

$txt['your_ban'] = 'Üzgünüz %1$s, bu forum\'dan yasaklandınız!.';
$txt['your_ban_expires'] = 'Yasağınızın bitiş süresi %1$s.';
$txt['your_ban_expires_never'] = 'Yasağınızın bitiş süresi bulunmamaktadır.';
$txt['ban_continue_browse'] = 'Bu forumu ziyaretçi olarak görüntülemeye devam edebilirsiniz.';

$txt['mark_as_read'] = 'TÜMÜNÜ Okunmuş Say';
$txt['mark_as_read_confirm'] = 'Tüm mesajları okundu olarak işaretlemek istediğinizden emin misiniz?';
$txt['mark_these_as_read'] = 'TÜMÜNÜ Okunmuş Say';
$txt['mark_these_as_read_confirm'] = 'Bu iletileri okundu olarak işaretlemek istediğinize emin misiniz?';

$txt['locked_topic'] = 'Kilitli Konu';
$txt['normal_topic'] = 'Normal Konu';
$txt['participation_caption'] = 'İletinizin bulunduğu konu';

$txt['print'] = 'Yazdır';
$txt['topic_summary'] = 'Konu Özeti';
$txt['not_applicable'] = 'YOK';
$txt['name_in_use'] = '%1$s kullanıcı adı başka bir üye tarafından kullanılmaktadır.';

$txt['total_members'] = 'Toplam Üye';
$txt['total_posts'] = 'Toplam İleti';
$txt['total_topics'] = 'Toplam Konu';

$txt['mins_logged_in'] = 'Bağlı kalmak istediğiniz süre';

$txt['preview'] = 'Önizleme';
$txt['always_logged_in'] = 'Sürekli bağlı kal';

$txt['logged'] = 'Kayıtlı';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';

$txt['www'] = 'Web';
$txt['link'] = 'Bağlantı';

$txt['by'] = 'gönderen'; //Deprecated

$txt['hours'] = 'saat';
$txt['minutes'] = 'dakika';
$txt['seconds'] = 'saniye';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Saat';
$txt['days_word'] = 'gün arasında';

$txt['newest_member'] = ', en yeni üyemiz.'; //Deprecated

$txt['search_for'] = 'Aranılacak Kelime(ler)';
$txt['search_match'] = 'Eşleştir';

$txt['maintain_mode_on'] = 'Unutmayın, site şuan bakım modundadır.';

$txt['read'] = 'Oku'; //Deprecated
$txt['times'] = 'kez'; //Deprecated
$txt['read_one_time'] = '1 Kez okunmuş';
$txt['read_many_times'] = '%1$d Kez okunmuş';

$txt['forum_stats'] = 'Forum İstatistikleri';
$txt['latest_member'] = 'Son Üye';
$txt['total_cats'] = 'Toplam Kategori';
$txt['latest_post'] = 'Son İleti';

$txt['here'] = 'buraya';
$txt['you_have_no_msg'] = 'Herhangi bir ileti yok..';
$txt['you_have_one_msg'] = 'You\'ve 1 message...<a href="%1$s">Click here to view it</a>';
$txt['you_have_many_msgs'] = 'You\'ve %2$d messages...<a href="%1$s">Click here to view them</a>';

$txt['total_boards'] = 'Toplam Bölüm';

$txt['print_page'] = 'Sayfayı Yazdır';
$txt['print_page_text'] = 'Sadece Metin';
$txt['print_page_images'] = 'Görüntüler ve Metin';

$txt['valid_email'] = 'Geçerli bir e-posta adresi olmalıdır.';

$txt['info_center_title'] = '%1$s - Bilgi Merkezi';

$txt['send_topic'] = 'Paylaş';
$txt['unwatch'] = 'İzlemeyi Durdur';
$txt['watch'] = 'İzle';

$txt['allow_user_email'] = 'Üyelerin bana e-posta göndermesine izin ver';

$txt['check_all'] = 'Tümünü seç';

// Use numeric entities in the below string.
$txt['database_error'] = 'Veritabanı Hatası';
$txt['try_again'] = 'Lütfen kısa bir süre sonra tekrar deneyiniz. Eğer hata iletisini tekrar alırsanız, yönetici ile iletişime geçiniz.';
$txt['file'] = 'Dosya';
$txt['line'] = 'Satır';

// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'Veritabanınızda bir hata saptandı ve otomatik olarak onarım işlemi denendi. Eğer sorun devam eder veya bu iletiyi tekrar alırsanız, lütfen sunucu yöneticinizle temas kurun.';
$txt['database_error_versions'] = '<strong>Not:</strong> Veritabanın sürümü %1$s.';
$txt['template_parse_error'] = 'Tema Ayrıştırma Hatası!';
$txt['template_parse_error_message'] = 'Tema içerisinde hatalı bir kod bulundu. Bu problem geçicidir, Lütfen daha sonra tekrar deneyin. Eğer sürekli bu iletiyle karşılaşıyorsanız yönetici ile iletişime geçiniz.<br /><br />Hatayı düzeltildikten sonra sayfayı <a href="javascript:location.reload();">yenileyiniz</a>.';
$txt['template_parse_error_details'] = '<span class="tt"><strong>%1$s</strong></span> adındaki terma veya dil dosyasının yüklenmesinde sorun var. Lütfen söz dizimini denetleyin ve tekrar deneyin, tek tire işaretleri önünde tek yatık çizgiler olmalı (<span class="tt">\'</span>) ve tek yatık çizgi kullanacaksanız iki tane yazmalısınız (<span class="tt">\</span>). PHP kodlarında hatayı daha belirgin görmek istiyorsanız, <a href="%2$s%1$s">doğrudan dosyaya erişmeyi</a> deneyin.<br /><br />Tekrar denemek istiyorsanız <a href="javascript:location.reload();">sayfayı yenileyin</a> veya <a href="%3$s">varsayılan temayı kullanın</a>.';
$txt['template_parse_undefined'] = 'Bu şablonun ayrıştırılması sırasında tanımlanmayan bir hata oluştu';

$txt['today'] = 'Bugün %1$s';
$txt['yesterday'] = 'Dün %1$s';

// Relative times
$txt['rt_now'] = 'az önce';
$txt['rt_minute'] = 'Bir dakika önce';
$txt['rt_minutes'] = '%s dakika önce';
$txt['rt_hour'] = 'Bir saat önce';
$txt['rt_hours'] = '%s saat önce';
$txt['rt_day'] = 'Bir gün önce';
$txt['rt_days'] = '%s gün önce';
$txt['rt_week'] = 'Bir hafta önce';
$txt['rt_weeks'] = '%s hafta önce';
$txt['rt_month'] = 'Bir ay önce';
$txt['rt_months'] = '%s ay önce';
$txt['rt_year'] = 'Bir yıl önce';
$txt['rt_years'] = '%s yıl önce';

$txt['new_poll'] = 'Yeni Anket';
$txt['poll_question'] = 'Soru';
$txt['poll_question_options'] = 'Soru ve Seçenekleri';
$txt['poll_vote'] = 'Oyla';
$txt['poll_total_voters'] = 'Toplam Oy Verenler';
$txt['draft_saved_on'] = 'Son kaydedilen taslak';
$txt['poll_results'] = 'Sonuçları görüntüle';
$txt['poll_lock'] = 'Oylamayı Kilitle';
$txt['poll_unlock'] = 'Oylamanın Kilidini Kaldır';
$txt['poll_edit'] = 'Anketi Düzenle';
$txt['poll'] = 'Anket';
$txt['one_day'] = '1 Gün';
$txt['one_week'] = '1 Hafta';
$txt['two_weeks'] = '2 Hafta';
$txt['one_month'] = '1 Ay';
$txt['two_months'] = '2 Ay';
$txt['forever'] = 'Her zaman';
$txt['quick_login_dec'] = 'Kullanıcı adınızı, şifrenizi ve aktif kalma süresini giriniz';
$txt['one_hour'] = '1 Saat';
$txt['moved'] = 'TAŞINDI';
$txt['moved_why'] = 'Lütfen konuyu taşıma sebebinize dair<br />bir açıklama yazın.';
$txt['board'] = 'Bölüm';
$txt['in'] = 'tr';
$txt['sticky_topic'] = 'Sabitlenmiş Konu';
$txt['split'] = 'BÖL';

$txt['delete'] = 'Sil';

$txt['byte'] = 'B';
$txt['kilobyte'] = 'KB';
$txt['megabyte'] = 'MB';
$txt['gigabyte'] = 'GB';

$txt['more_stats'] = '[Daha fazla istatistik]';

$txt['code'] = 'Kod';
$txt['code_select'] = '[Seç]';
$txt['quote_from'] = 'Alıntı yapılan';
$txt['quote'] = 'Alıntı';
$txt['quick_quote'] = 'Quote Selected';
$txt['quote_new'] = 'Yeni Konu';
$txt['follow_ups'] = 'Takipler';
$txt['topic_derived_from'] = '%1$s konusundan türetilen';
$txt['edit'] = 'Düzenle';
$txt['quick_edit'] = 'Hızlı Düzenle';
$txt['post_options'] = 'More Options';
$txt['quote_expand'] = 'Show Quote';

$txt['set_sticky'] = 'Sabitle';
$txt['set_nonsticky'] = 'Sabitlemeyi kaldır';
$txt['set_lock'] = 'Kilitle';
$txt['set_unlock'] = 'Unlock';

$txt['search_advanced'] = 'Gelişmiş seçenekleri göster';
$txt['search_simple'] = 'Gelişmiş seçenekleri gizle';

$txt['security_risk'] = 'BÜYÜK GÜVENLİK TEHLİKESİ:';
$txt['not_removed'] = '%1$s kaldırmadınız';
$txt['not_removed_extra'] = '%1$s dosyası, %2$s dosyasının bir yedeğidir ve ElkArte tarafından oluşturulmamıştır. Bu dosya forumunuzda izinsiz yetki kazanabilmek için kullanılabilir. Dosyayı hemen silmelisiniz.';
$txt['generic_warning'] = 'Uyarı';
$txt['agreement_missing'] = 'You are requiring new users to accept a registration agreement, however the file (in sources/ElkArte/Languages/Agreement/) doesn\'t exist.';
$txt['agreement_accepted'] = 'You have just accepted the agreement.';
$txt['privacypolicy_accepted'] = 'You have just accepted the forum privacy policy.';

$txt['new_version_updates'] = 'Yeni güncellendiniz!';
$txt['new_version_updates_text'] = '<a href="{admin_url};area=credits#latest_updates">Bu sürümünde neler yeni görmek için buraya tıklayın ElkArte!</a>! ';

$txt['cache_writable'] = 'Önbellek dizini yazılabilir değildir - bu durum forum\'unuzun performansını kötü yönde etkileyeektir.';

$txt['page_created_full'] = 'Bu sayfa  %1$.3f saniyede %2$d sorgu ile oluşturulmuştur.';

$txt['report_to_mod_func'] = 'Use this function to inform the moderators and administrators of an abusive or wrongly posted message.';

$txt['online'] = 'Çevrimiçi';
$txt['member_is_online'] = '%1$s Çevrimiçi';
$txt['offline'] = 'Çevrimdışı';
$txt['member_is_offline'] = '%1$s Çevrimdışı';
$txt['pm_online'] = 'Kişisel İleti Gönder (Çevrimiçi)';
$txt['pm_offline'] = 'Kişisel İleti Gönder (Çevrimdışı)';
$txt['status'] = 'Durumu';

$txt['skip_nav'] = 'Ana içeriğe git';
$txt['go_up'] = 'Yukarı git';
$txt['go_down'] = 'Aşağı git';

$forum_copyright = '<a href="https://www.elkarte.net" title="ElkArte Forum" target="_blank" class="new_win">Powered by %1$s</a> | <a href="{credits_url}" title="Credits" target="_blank" class="new_win" rel="nofollow">Credits</a>';

$txt['birthdays'] = 'Doğum Günleri:';
$txt['events'] = 'Etkinlikler:';
$txt['birthdays_upcoming'] = 'Yaklaşan Doğum Günleri:';
$txt['events_upcoming'] = 'Yaklaşan Etkinlikler:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Tatiller:';
$txt['calendar_month'] = 'Ay:';
$txt['calendar_year'] = 'Yıl:';
$txt['calendar_day'] = 'Gün:';
$txt['calendar_event_title'] = 'Etkinlik Başlığı';
$txt['calendar_event_options'] = 'Olay Ayarları';
$txt['calendar_post_in'] = 'Ekleneceği Bölüm:';
$txt['calendar_edit'] = 'Etkinliği Düzenle';
$txt['event_delete_confirm'] = 'Bu Etkinlik Silinsin mi?';
$txt['event_delete'] = 'Etkinliği Sil';
$txt['calendar_post_event'] = 'Etkinlik Gönder';
$txt['calendar'] = 'Takvim';
$txt['calendar_link'] = 'Takvime ekle';
$txt['calendar_upcoming'] = 'Takvim';
$txt['calendar_today'] = 'Takvimde Bugün';
$txt['calendar_week'] = 'Hafta';
$txt['calendar_week_title'] = '%2$d senesinin %1$d. haftası ';
$txt['calendar_numb_days'] = 'Süreceği Gün:';
$txt['calendar_how_edit'] = 'Etkinlikleri nasıl düzenleyeceksin?';
$txt['calendar_link_event'] = 'İletiye Hatırlatma Bağla:';
$txt['calendar_confirm_delete'] = 'Bu hatırlatmayı silmek istediğinizden eminmisiniz ?';
$txt['calendar_linked_events'] = 'Bağlanılan Hatırlatmalar';
$txt['calendar_click_all'] = 'Tümünü görüntüle: %1$s';

$txt['moveTopic1'] = 'Post a redirection topic';
$txt['moveTopic2'] = 'Konunun başlığını değiştir';
$txt['moveTopic3'] = 'Yeni konu';
$txt['moveTopic4'] = 'Tüm iletilerin konu başlığını değiştir';
$txt['move_topic_unapproved_js'] = 'Uyarı! Bu konu henüz onaylanmamıştır.\n\nTaşıma işleminden hemen sonra konuyu onaylamayı planlamıyorsanız, konuyu taşımamanız önerilir.';
$txt['movetopic_auto_board'] = '[BÖLÜM]';
$txt['movetopic_auto_topic'] = '[KONU ADRESİ]';
$txt['movetopic_default'] = 'Bu konu [KONU ADRESİ]  -  [BÖLÜM] bölümüne taşındı';
$txt['movetopic_redirect'] = 'Taşınan konuya yönlendir';
$txt['movetopic_expires'] = 'Taşıma konusunu otomatik sil';

$txt['merge_to_topic_id'] = 'Hedef konunun ID\'si';
$txt['split_topic'] = 'Böl';
$txt['merge'] = 'Birleştir';
$txt['subject_new_topic'] = 'Konunun Yeni Başlığı';
$txt['split_this_post'] = 'Sadece bu iletiyi böl.';
$txt['split_after_and_this_post'] = 'Bu ileti ve sonrasından itibaren böl.';
$txt['select_split_posts'] = 'Bölünecek iletileri seçin.';

$txt['splittopic_notification'] = 'Konu bölündüğünde mesaj gönder';
$txt['splittopic_default'] = 'Bu konudaki mesajlardan bir veya daha fazlası [BÖLÜM] - [KONU ADRESİ] içine taşındı.';
$txt['splittopic_move'] = 'Yeni konuyu başka bir bölüme taşı';

$txt['new_topic'] = 'Yeni Konu';
$txt['split_successful'] = 'Konu başarılı bir şekilde bölünmüştür.';
$txt['origin_topic'] = 'Orjinal Konu';
$txt['please_select_split'] = 'Lütfen hangi iletileri bölmek istediğinizi seçin';
$txt['merge_successful'] = 'Konuların birleştirilmesi tamamlandı.';
$txt['new_merged_topic'] = 'Yeni birleştirilen konu';
$txt['topic_to_merge'] = 'Birleştirilecek Konu';
$txt['target_board'] = 'Hedef Bölüm';
$txt['target_topic'] = 'Hedef Konu';
$txt['merge_confirm'] = 'Birleştirmek istediğinize emin misiniz';
$txt['with'] = 'ile';
$txt['merge_desc'] = 'Bu fonksiyon iki konunun birleştirilmesini sağlar. Tarihe göre sınıflandırılma yapılacaktır.';

$txt['theme_template_error'] = '\'%1$s\' adlı tema yüklenemiyor.';
$txt['theme_language_error'] = '\'%1$s\' adlı dil dosyası yüklenemiyor.';

$txt['parent_boards'] = 'Alt-Bölümler';

$txt['smtp_no_connect'] = 'SMTP sunucusuna bağlanılamadı';
$txt['smtp_port_ssl'] = 'SMTP bağlantı noktası yanlış; eğer sunucu SSL ise 465 olarak girin.';
$txt['smtp_bad_response'] = 'E-Posta sunucusundan yanıt alınamadı';
$txt['smtp_error'] = 'E-Posta yollanırken hata oluştu: ';
$txt['mail_send_unable'] = '\'%1$s\' adresine e-posta gönderilemedi.';

$txt['mlist_search'] = 'Üyelerde ara';
$txt['mlist_search_email'] = 'Search by email';
$txt['mlist_search_group'] = 'Pozisyona göre ara';
$txt['mlist_search_name'] = 'İsme Göre Ara';
$txt['mlist_search_website'] = 'Web sitesine göre ara';
$txt['mlist_search_results'] = 'Arama sonuçları:';
$txt['mlist_search_by'] = '%1$s göre ara';

$txt['attach_downloaded'] = 'Yükleme: %1$d';
$txt['attach_viewed'] = 'Gösterim: %1$d';

$txt['settings'] = 'Ayarlar';
$txt['never'] = 'Hiç';
$txt['more'] = 'daha';

$txt['hostname'] = 'Sunucu adı';
$txt['you_are_post_banned'] = 'Üzgünüz %1$s, yasaklı olduğunuz için normal veya kişisel ileti gönderemezsiniz.';
$txt['ban_reason'] = 'Sebep';

$txt['add_poll'] = 'Anket ekle';
$txt['poll_options6'] = 'Sadece %1$s adet seçim yapabilirsiniz.';
$txt['poll_remove'] = 'Anketi Kaldır';
$txt['poll_remove_warn'] = 'Konudan anketi kaldırmak istediğinizden emin misiniz?';
$txt['poll_results_expire'] = 'Sonuçlar oylama sona erdiğinde gösterilecektir';
$txt['poll_expires_on'] = 'Oylamanın kapancağı tarih:';
$txt['poll_expired_on'] = 'Oylama kapandı';
$txt['poll_change_vote'] = 'Oyu Kaldır';
$txt['poll_return_vote'] = 'Oylama seçenekleri';
$txt['poll_cannot_see'] = 'Bu anketin sonuçlarını şu anda görüntüleyemezsiniz.';

$txt['quick_mod_approve'] = 'Seçilenleri onayla';
$txt['quick_mod_remove'] = 'Seçilenleri kaldır';
$txt['quick_mod_lock'] = 'Seçilenleri Kilitle/Aç';
$txt['quick_mod_sticky'] = 'Seçilenleri Sabitle/Normalleştir';
$txt['quick_mod_move'] = 'Seçilenleri taşı';
$txt['quick_mod_merge'] = 'Seçilenleri birleştir';
$txt['quick_mod_markread'] = 'Seçilenleri okundu say';
$txt['quick_mod_go'] = 'Başla';
$txt['quickmod_confirm'] = 'Bunu yapmak istediğinize emin misiniz?';

$txt['quick_reply'] = 'Hızlı Yanıt';
$txt['quick_reply_warning'] = 'UYARI: Bu konu Kilitlenmiştir. Sadece yöneticiler ve moderatörler yanıt yazabilir.';
$txt['quick_reply_verification'] = 'İletinizi gönderdikten sonra iletinizi doğrulamak için geri gönderileceksiniz: %1$s. ';
$txt['quick_reply_verification_guests'] = '(ziyaretçiler için zorunlu)';
$txt['quick_reply_verification_posts'] = '(%1$d iletiden daha az sayıda ileti göndermiş üyeler için zorunlu) ';
$txt['wait_for_approval'] = 'Not: Bu konu bir moderatör tarafından onaylanmadan görüntülenmeyecektir.';

$txt['notification_enable_board'] = 'Bu bölümde açılacak yeni konulardan haberdar edilmek istediğinize emin misiniz?';
$txt['notification_disable_board'] = 'Bu bölümde açılacak yeni konulardan haberdar edilmeyi iptal etmek istediğinize emin misiniz?';
$txt['notification_enable_topic'] = 'Bu konuya gönderilecek yeni iletilerden haberdar edilmek istediğinize emin misiniz?';
$txt['notification_disable_topic'] = 'Bu konuya gönderilecek yeni iletilerden haberdar edilmeyi iptal etmek istediğinize emin misiniz?';

$txt['report_to_mod'] = 'İletiyi rapor et';
$txt['issue_warning'] = 'Issue a Warning';
$txt['issue_warning_post'] = 'Bu ileti sebebiyle uyarı gönder';

$txt['like_post'] = 'Beğen';
$txt['unlike_post'] = 'Beğeniyi geri al';
$txt['likes'] = 'Beğeni';
$txt['liked_by'] = 'Beğenenler:';
$txt['liked_you'] = 'Sen';
$txt['liked_more'] = 'daha';
$txt['likemsg_are_you_sure'] = 'Bu mesajı  beğendiniz, beğeniyi geri almak istediğinize emin misiniz?';

$txt['unread_topics_visit'] = 'Okunmamış son konular';
$txt['unread_topics_visit_none'] = 'Son ziyaretinizden beri yeni ileti gönderilmemiştir. <a href="{unread_all_url}" class="linkbutton">Tüm yeni iletileri görüntülemek için tıklayın.</a>';
$txt['unread_topics_all'] = 'Okumadığım tüm konular';
$txt['unread_replies'] = 'Değişiklik Olmuş Konular';

$txt['who_title'] = 'Kimler Çevrimiçi';
$txt['who_and'] = ' ve ';
$txt['who_viewing_topic'] = ' konuyu incelemekte.';
$txt['who_viewing_board'] = ' bölümü incelemekte.';
$txt['who_member'] = 'Üye';

// Current footer strings
$txt['valid_html'] = 'Geçerli HTML 5';
$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Ziyaretçi';
$txt['guests'] = 'Ziyaretçiler';
$txt['user'] = 'Kullanıcı';
$txt['users'] = 'Kullanıcılar';
$txt['hidden'] = 'Gizli';
// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Gizli';
$txt['buddy'] = 'Arkadaş';
$txt['buddies'] = 'Arkadaşlar';
$txt['most_online_ever'] = 'En Çok Çevrimiçi';
$txt['most_online_today'] = 'Bugün En Çok Çevrimiçi';

$txt['merge_select_target_board'] = 'Birleştirilmiş konunun oluşturulacağı bölüm';
$txt['merge_select_poll'] = 'Birleştirilecek konudaki anketi seçin';
$txt['merge_topic_list'] = 'Birleştirilecek konular';
$txt['merge_select_subject'] = 'Birleştirilmiş konunun başlığı';
$txt['merge_custom_subject'] = 'Özel başlık';
$txt['merge_enforce_subject'] = 'Tüm iletilerin başlığın değiştir';
$txt['merge_include_notifications'] = 'Haberdar edilme saklansın?';
$txt['merge_check'] = 'Birleştir?';
$txt['merge_no_poll'] = 'Anket yok';

$txt['response_prefix'] = 'Ynt: ';
$txt['current_icon'] = 'İleti İkonu';
$txt['message_icon'] = 'İleti Simgesi';

$txt['smileys_current'] = 'Kullanılan gülümseme seti';
$txt['smileys_none'] = 'Gülümseme yok';
$txt['smileys_forum_board_default'] = 'Forum/Bölüm Standartı';

$txt['search_results'] = 'Arama Sonuçları';

$txt['totalTimeLogged2'] = ' gün, ';
$txt['totalTimeLogged3'] = ' saat ve ';
$txt['totalTimeLogged4'] = ' dakika.';
$txt['totalTimeLogged5'] = 'gün ';
$txt['totalTimeLogged6'] = 'saat ';
$txt['totalTimeLogged7'] = 'dk';

$txt['approve_thereis'] = 'Şu anda'; //Deprecated
$txt['approve_thereare'] = 'Şu anda'; //Deprecated
$txt['approve_member'] = 'bir üye'; //Deprecated
$txt['approve_members'] = 'üye'; //Deprecated
$txt['approve_members_waiting'] = 'onay beklemektedir.'; //Deprecated
$txt['approve_one_member_waiting'] = 'There is <a href="%1$s">one member</a> awaiting approval.';
$txt['approve_many_members_waiting'] = 'There are <a href="%1$s">%2$d members</a> awaiting approval.';

$txt['notifyboard_turnon'] = 'Bu bölümde yeni bir konu açıldığında e-posta ile uyarı alacaksınız.\n\nDevam etmek istiyor musunuz?';
$txt['notifyboard_turnoff'] = 'Artık bu bölüme yeni konular eklendiğinde e-posta ile uyarı almayacaksınız.\n\nDevam etmek istiyor musunuz?';

$txt['notify_unsubscribed_generic'] = 'specified';
$txt['notify_board_unsubscribed'] = 'The email, %2$s, has been successfully unsubscribed and will no longer be sent notifications from the %1$s board.';
$txt['notify_topic_unsubscribed'] = 'The email, %2$s, has been successfully unsubscribed and will no longer be sent notifications on the %1$s topic.';
$txt['notify_mention_unsubscribed'] = 'The email, %2$s, has been successfully unsubscribed and will no longer be sent "%1$s" notifications.';
$txt['notify_default_unsubscribed'] = 'Your request has been successfully processed.';

$txt['find_members'] = 'Üye Ara';
$txt['find_username'] = 'Adı, kullanıcı adı, veya e-posta adresi';
$txt['find_buddies'] = 'Sadece Arkadaşları Göster?';
$txt['find_wildcards'] = 'Joker Karakterleri: * ve ?';
$txt['find_no_results'] = 'Hiç sonuç bulunamadı';
$txt['all_caught_up'] = 'Your all caught up!';
$txt['find_results'] = 'Sonuçlar';
$txt['find_close'] = 'Kapalı';

$txt['quickmod_delete_selected'] = 'Seçilenleri sil';
$txt['quickmod_split_selected'] = 'Seçilenleri Ayır';

$txt['show_personal_messages_heading'] = 'Yeni İletiler';
$txt['show_personal_messages'] = 'Gelen kutunuzda <strong>%1$s</strong> adet okunmamış kişisel mesaj bulunmaktadır.<br /><br /><a href="%2$s">Gelen kutusuna git</a>';

$txt['help_popup'] = 'Kayboldunuz? Açıklamayım:';

$txt['previous_next_back'] = 'önceki konu';
$txt['previous_next_forward'] = 'sonraki konu';

$txt['upshrink_description'] = 'Alanı gizle/göster';

$txt['mark_unread'] = 'Okunmadı say';

$txt['ssi_not_direct'] = 'Lüften SSI.php dosyasına doğrudan URL olarak erişmeyin; SSI fonksiyonuna erişmek istiyorsanız \'?ssi_function=birsey\' yolunu kullanın.';
$txt['ssi_session_broken'] = 'SSI.php oturumu yükleyemedi!  Bu çıkış fonksiyonu veya diğer birkaç fonksiyonların işleyişinde sorunlara sebep olabilir - lütfen SSI.php\'yi içerten kodun sayfanın en başında olduğuna emin olun!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'İletiyi önizle';
$txt['preview_fetch'] = 'Önizleme oluşturuluyor...';
$txt['pm_error_while_submitting'] = 'Kişiel ileti gönderme sırasında aşağıdaki hatalar oluştu:';
$txt['warning_while_submitting'] = 'Bir şey oldu, burada inceleyin:';
$txt['error_while_submitting'] = 'İleti gönderilirken şu hatalar oluştu:';
$txt['error_old_topic'] = 'Uyarı: bu konuya en az %1$d gündür yanıt gönderilmemiş.<br />Yanıt vermek yerine yeni bir konu açmanız önerilir.';

$txt['split_selected_posts'] = 'Seçili iletiler';
$txt['split_selected_posts_desc'] = 'Aşağıdaki iletiler bölme işlemi tamamlandıktan sonra yeni bir konu oluşturacaklar.';
$txt['split_reset_selection'] = 'seçimi sıfırla';

$txt['modify_cancel'] = 'İptal';
$txt['mark_read_short'] = 'Okunmuş Say';

$txt['hello_member_ndt'] = 'Merhaba';

$txt['unapproved_posts'] = 'Onaylanmamış İletiler (Konular: %1$d, İletiler: %2$d)';

$txt['ajax_in_progress'] = 'Yükleniyor...';
$txt['ajax_bad_response'] = 'Geçersiz cevap';

$txt['mod_reports_waiting'] = 'Şu anda %1$d sayıda moderatör raporu bulunmaktadır.';
$txt['pm_reports_waiting'] = 'Şu anda %1$dkişisel ileti raporu açık';

$txt['new_posts_in_category'] = '%1$s kategorisindeki yeni iletileri görmek için tıkla';
$txt['verification'] = 'Doğrulama';
$txt['visual_verification_hidden'] = 'Lütfen bu kutuyu boş bırakın';
$txt['visual_verification_description'] = 'Resimde gördüğünüz harfleri giriniz';
$txt['visual_verification_request_new'] = 'Farklı bir resim göster';

// @todo Send email strings - should move?
$txt['send_email'] = 'E-Posta Gönder';
$txt['send_email_disclosed'] = 'Alıcıya görünür olacaktır.';
$txt['send_email_subject'] = 'E-Posta Başlığı';

$txt['ignoring_user'] = 'Bu kullanıcıyı yoksayıyorsunuz.';
$txt['show_ignore_user_post'] = '<em>[İletiyi göster.]</em>';

$txt['spider'] = 'Örümcek';
$txt['spiders'] = 'Örümcek';

$txt['downloads'] = 'İndirilme';
$txt['filesize'] = 'Dosya Boyutu';

// Restore topic
$txt['restore_topic'] = 'Konuyu Geri Yükle';
$txt['restore_message'] = 'Geri Yükle';
$txt['quick_mod_restore'] = 'Seçilileri Geri Yükle';

// Editor prompt.
$txt['prompt_text_email'] = 'Lütfen e-posta adresini giriniz.';
$txt['prompt_text_ftp'] = 'Lütfen ftp adresini giriniz.';
$txt['prompt_text_url'] = 'Lütfen bağlantı oluşturmak istediğiniz adresi giriniz.';
$txt['prompt_text_img'] = 'Resim konumunu giriniz';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Öğeyi Sil';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Temalar: ';
$txt['debug_sub_templates'] = 'Alt Temalar: ';
$txt['debug_language_files'] = 'Dil Dosyaları: ';
$txt['debug_sheets'] = 'Sitil Tabloları: ';
$txt['debug_javascript'] = 'Script dosyaları:';
$txt['debug_files_included'] = 'Eklenmiş dosyalar: ';
$txt['debug_kb'] = 'KB.';
$txt['debug_show'] = 'Göster';
$txt['debug_cache_hits'] = 'Önbellek Hiti';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s byte';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss e rağmen %2$s byte';
$txt['debug_queries_used'] = '%1$d sorgu kullanıldı.';
$txt['debug_queries_used_and_warnings'] = 'Kullanılan sorgu: %1$d, %2$d uyarı.';
$txt['debug_query_in_line'] = 'dosya: <em>%1$s</em>, satır: <em>%2$s</em> - ';
$txt['debug_query_which_took'] = '%1$s saniye sürdü.';
$txt['debug_query_which_took_at'] = 'toplam %2$s saniyede %1$s saniye sürdü.';
$txt['debug_show_queries'] = 'Sorguları Göster';
$txt['debug_hide_queries'] = 'Sorguları Gizle';
$txt['debug_tokens'] = 'Anahtarlar:';
$txt['debug_browser'] = 'Tarayıcı ID:';
$txt['debug_hooks'] = 'Aranan kancalar:';
$txt['debug_system_type'] = 'Sistem';
$txt['debug_server_load'] = 'Sunucu Yükü:';
$txt['debug_script_mem_load'] = 'Script Bellek Kullanımı:';
$txt['debug_script_cpu_load'] = 'Script CPU Süresi (kullanıcı/sistem):';

// Video embedding
$txt['preview_image'] = 'Video Önizleme Resmi';
$txt['ctp_video'] = 'Click to play video';
$txt['hide_video'] = 'Video Göster/Gizle';
$txt['youtube'] = 'YouTube:';
$txt['vimeo'] = 'Vimeo:';
$txt['dailymotion'] = 'Dailymotion:';
$txt['tiktok'] = 'TikTok:';
$txt['twitter'] = 'X/Twitter:';
$txt['facebook'] = 'Facebook:';
$txt['instagram'] = 'Instagram:';

// Spoiler BBC
$txt['spoiler'] = 'Spoiler (göster/gizle için tıklayın)';

$txt['ok_uppercase'] = 'TAMAM';

// Title of box for warnings that admins should see
$txt['admin_warning_title'] = 'Uyarı';

$txt['via'] = 'tarafından';

$txt['like_post_stats'] = 'Beğeni istatistikleri';

$txt['otp_token'] = 'One-time Password';
$txt['otp_enabled'] = 'İki faktörlü kimlik doğrulamayı etkinleştir';
$txt['invalid_otptoken'] = 'Zaman Esaslı Tek seferlik şifre geçersiz';
$txt['otp_used'] = 'Zaman Esaslı Tek Kullanımlık Şifre zaten kullanılmış. <br /> Lütfen bir dakika bekleyin ve bir sonraki kodu kullanın.';
$txt['otp_generate'] = 'Oluştur';
$txt['otp_show_qr'] = 'QR-Kod Göster';

$txt['other'] = 'Diğer';

$txt['offline'] = 'Çevrimdışı';
$txt['retry'] = 'RETRY';
$txt['check_connection'] = 'Please check your internet connection';
